////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2009.
// -------------------------------------------------------------------------
//  File name:   aescryptography.h
//  Version:     v1.00
//  Created:     06/08/2009 by Younggi Lim
//  Compilers:   Visual Studio.NET
//  Description: encrypt/decrypt file or buffer using rijndael algorithm
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////
#ifndef __aescryptography_h__
#define __aescryptography_h__

#pragma once

#ifdef USING_LICENSE_PROTECTION

const int CryptBlockSize = 16;
const int KeyValueSize = 32;

enum ECryptDirection
{
	eCD_Encrypt,
	eCD_Decrypt
};

class CAesCryptography
{
public:
	CAesCryptography();
	CAesCryptography(const uint8* key, int keyLen);
	virtual ~CAesCryptography();

	///////////////////////////////////////////////////////
	// Description:
	//   Setup key value 
	// Arguments:
	//   key : unsigned char array
	//   keyLen : less than KeyValueSize
	///////////////////////////////////////////////////////
	void SetKeyValue(const uint8* key, int keyLen);

	///////////////////////////////////////////////////////////////////////////////////
	// Arguments:
	//   outputBuffer : must be CryptBlockSize bytes long than inputBufferSize.
	///////////////////////////////////////////////////////////////////////////////////
	bool EncryptBuffer(const uint8* inputBuffer, uint32 inputBufferSize, uint8* outputBuffer);
	bool DecryptBuffer(const uint8* inputBuffer, uint32 inputBufferSize, uint8* outputBuffer);

	bool DoSuccessTest(const char* filename);
	bool DoFailTest(const char* filename);

protected:
	bool CryptBufferImpl( ECryptDirection dir, const uint8* inputBuffer, uint32 inputBufferSize, uint8* outputBuffer );

private:
	uint8 m_keyValue[KeyValueSize];
};

#endif // __cryptfile_h__

#endif // USING_LICENSE_PROTECTION