////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2009.
// -------------------------------------------------------------------------
//  File name:   licenseconnection.h
//  Version:     v1.00
//  Created:     27/08/2009 by Younggi Lim
//  Compilers:   Visual Studio.NET
//  Description: Manage communication with License Server
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////
#ifndef __licenseconnection_h__
#define __licenseconnection_h__

#pragma once

#ifdef USING_LICENSE_PROTECTION

#if !defined(XENON) && !defined(PS3)

#include "IProtectionManager.h"

class CTinyClientSocket;
class CProtocolBuilder;
class CProtocolAssembler;

class CLicenseConnection
{
	enum EProgressStep
	{
		ePS_None,
		ePS_InitSocket,
		ePS_ConnectServer,
		ePS_LoginServer,
	};

public:
	CLicenseConnection(void);
	~CLicenseConnection(void);

	TAGES_EXPORT	EPMErrorCode	Authenticate(const char* key);
	TAGES_EXPORT	void					SetConnectionInfo(const char* ip, int port);
	TAGES_EXPORT	void					SetDefaultConnectionInfo();
	TAGES_EXPORT	void					GetLicenseKey(string& key);
	TAGES_EXPORT	void					GetEncryptKey(string& key);
	uint32				GetRemainSecond();
	uint32				GetDisconnectedPeriod();
	uint32				GetFloatLicenses();
	void					SetProxy(string& ip, int port, string& authInfo);
	TAGES_EXPORT	void					ResetLogin();
	TAGES_EXPORT	void					GetLocalIp(string& ip);
	TAGES_EXPORT	void					GetMacAddress(string& mac);
	ECreateAccountResult RequestCreateAccount(const SCreateAccountParam& param, EPMErrorCode& subErrorCode);
	ELoginAccountResult RequestLoginAccount(const string& username, const string& password, bool& agreeLicenseFlag, EPMErrorCode& subErrorCode);
	bool RequestPasswordRemind(const string& username, const string& email);
	void SendLicenseAgree(const string& username) const;
	void SetVersion(const string& version);
	void SetAppName(const string& appName);
	void SetImmediateReturn(bool immediateFlag);
		
protected:
	bool					VerifyLocalNetworkDeviceInfo();
	TAGES_EXPORT	EPMErrorCode	RemoteAuthenticate(const string& key);
	bool					SendLogin( const string& key ) const;
	bool					SendLoginAccount( const string& username, const string& password ) const;
	bool					SendAuth( const string& key) const;
	bool					SendCreateAccount(const SCreateAccountParam& param) const;
	bool					SendPasswordRemind(const string& username, const string& email) const;
	TAGES_EXPORT	void					ResetConnection();
	EPMErrorCode	ReceiveLoginResult();
	bool ReceivePasswordRemindResult();
	TAGES_EXPORT	ELoginAccountResult ReceiveLoginAccountResult(bool& agreeLicenseFlag, EPMErrorCode& subErrorCode);
	TAGES_EXPORT	EPMErrorCode	ReceiveAuthResult() const;
	TAGES_EXPORT	ECreateAccountResult ReceiveCreateAccount(EPMErrorCode& subErrorCode) const;
	TAGES_EXPORT	EPMErrorCode	LoginProcess(const string& key);
	TAGES_EXPORT	EPMErrorCode	AuthProcess(const string& key);
	TAGES_EXPORT	void					UpdateLastAuthenticatedTick();
	bool					InitSocket();
	bool					ConnectServer();

private:
	CTinyClientSocket*	m_clientSocket;
	CProtocolBuilder*		m_builder;
	CProtocolAssembler*	m_assembler;
	string m_serverIp;
	int m_serverPort;
	string m_localIp;
	string m_localMac;
	string m_key;
	uint32 m_remainSecond;
	uint32 m_lastAutheticatedTick;
	string m_encryptKey;
	string m_proxyIp;
	int m_proxyPort;
	string m_proxyAuthInfo;
	uint32 m_floatLicenses;
	EProgressStep m_progressStep;
	string m_sessionKey;
	string m_sVersion;
	string m_appName;
	string m_sessionId;
};

#endif // !defined(XENON) && !defined(PS3)

#endif // USING_LICENSE_PROTECTION

#endif // __licenseconnection_h__

