////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek.
// -------------------------------------------------------------------------
//  File name:   IPlatformOS_PC.h
//  Created:     18/12/2009 by Alex Weighell.
//  Description: Interface to the Platform OS
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __PLATFORMOS_PC_H_
#define __PLATFORMOS_PC_H_

#if !defined(XENON) && !defined(PS3)

#include "IPlatformOS.h"
#include <CryListenerSet.h>

class CPlatformOS_PC : public IPlatformOS
{
public:

	CPlatformOS_PC();

	// Called each frame to update the platform listener
	VIRTUAL void Tick(float realFrameTime) {}

	// Local user profile functions to check/initiate user sign in:
	// See IPlatformOS.h for documentation.
	VIRTUAL unsigned int	UserGetMaximumSignedInUsers() const;
	VIRTUAL bool					UserIsSignedIn(unsigned int userIndex) const;
	VIRTUAL bool 					UserIsSignedIn(const IPlatformOS::TUserName& userName, unsigned int& outUserIndex) const { outUserIndex = 0; return true; }
	VIRTUAL bool					UserDoSignIn(unsigned int numUsersRequested);
	VIRTUAL unsigned int	UserGetPlayerIndex(const char* userName) const { return 0; }
	VIRTUAL bool					UserGetName(unsigned int userIndex, IPlatformOS::TUserName& outName) const;
	VIRTUAL bool					UserSelectStorageDevice(unsigned int userIndex) { return true; } // always hard drive
	VIRTUAL bool					GetUserProfilePreference(unsigned int user, IPlatformOS::EUserProfilePreference ePreference, SUserProfileVariant& outResult) const;
	VIRTUAL bool					MountSaveFile(unsigned int userIndex) { return true; }
	VIRTUAL IFileFinderPtr GetFileFinder() { return IFileFinderPtr(new CFileFinderCryPak()); }

	VIRTUAL bool												UsePlatformSavingAPI() const { return false; }
	VIRTUAL IPlatformOS::ISaveReaderPtr SaveGetReader(const char* fileName, unsigned int user);
	VIRTUAL IPlatformOS::ISaveWriterPtr SaveGetWriter(const char* fileName, unsigned int user);

	VIRTUAL void AddListener(IPlatformListener* pListener, const char* szName);
	VIRTUAL void RemoveListener(IPlatformListener* pListener);
	VIRTUAL void NotifyListeners(SPlatformEvent& event);

	VIRTUAL IPlatformOS::EMsgBoxResult DebugMessageBox(const char* body, const char* title, unsigned int flags=0) const;

private:
	CListenerSet<IPlatformOS::IPlatformListener*> m_listeners;
	bool m_bSignedIn;
};

#endif
#endif
