////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek.
// -------------------------------------------------------------------------
//  File name:   PlatformOS_PS3.h
//  Created:     18/12/2009 by Alex Weighell.
//  Description: Interface to the Platform OS
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __PLATFORMOS_PS3_H_
#define __PLATFORMOS_PS3_H_

#ifdef PS3

#include "IPlatformOS.h"
#include <CryListenerSet.h>
#include <cell/sync2.h>
#include "SaveReaderWriter_PS3.h"

class CPlatformOS_PS3 : public IPlatformOS, IPlatformOS::IPlatformListener
{
	enum { FILE_MAX_NAME = CELL_SAVEDATA_PREFIX_SIZE };
	typedef CryFixedStringT<FILE_MAX_NAME> TFileName;

public:

	CPlatformOS_PS3();
	~CPlatformOS_PS3();

	// Called each frame to update the platform listener
	VIRTUAL void Tick(float realFrameTime);

	// Local user profile functions to check/initiate user sign in:
	// See IPlatformOS.h for documentation.
	VIRTUAL unsigned int	UserGetMaximumSignedInUsers() const { return 1; }
	VIRTUAL bool					UserIsSignedIn(unsigned int userIndex) const { return m_bSignedIn; }
	VIRTUAL bool 					UserIsSignedIn(const IPlatformOS::TUserName& userName, unsigned int& outUserIndex) const { outUserIndex = 0; return true; }
	VIRTUAL bool					UserDoSignIn(unsigned int numUsersRequested);
	VIRTUAL unsigned int	UserGetPlayerIndex(const char* userName) const { return 0; }
	VIRTUAL bool					UserGetName(unsigned int userIndex, IPlatformOS::TUserName& outName) const;
	VIRTUAL bool					UserSelectStorageDevice(unsigned int userIndex) { return true; } // always hard drive
	VIRTUAL bool					GetUserProfilePreference(unsigned int user, IPlatformOS::EUserProfilePreference ePreference, SUserProfileVariant& outResult) const { return false; }
	VIRTUAL bool					MountSaveFile(unsigned int userIndex) { return false; }
	VIRTUAL bool					FileExists(unsigned int user, const char* path);

	VIRTUAL bool					UsePlatformSavingAPI() const;
	VIRTUAL IPlatformOS::ISaveReaderPtr SaveGetReader(const char* fileName, unsigned int user);
	VIRTUAL IPlatformOS::ISaveWriterPtr SaveGetWriter(const char* fileName, unsigned int user);
	VIRTUAL IPlatformOS::IFileFinderPtr GetFileFinder();

	VIRTUAL void AddListener(IPlatformOS::IPlatformListener* pListener, const char* szName);
	VIRTUAL void RemoveListener(IPlatformOS::IPlatformListener* pListener);
	VIRTUAL void NotifyListeners(IPlatformOS::SPlatformEvent& event);
	
	VIRTUAL IPlatformOS::EMsgBoxResult DebugMessageBox(const char* body, const char* title, unsigned int flags=0) const;

	virtual void OnPlatformEvent(const IPlatformOS::SPlatformEvent& event);

	static void SaveDataThreadFunc(uint64_t arg);
	int PerformSave(IPlatformOS::ISaveWriterPtr saveWriter);
	void PerformLoad();

	CListenerSet<IPlatformOS::IPlatformListener*> m_listeners;
	bool m_bSignedIn;

	sys_ppu_thread_t m_threadID;
	CellSync2Queue* m_saveDataEventQueue;
	void* m_eventQueueBuffer;

private:
	volatile bool m_bIsSaving;	//True if currently saving, false if not. Volatile as it will be set and checked from two threads
	bool m_bIsQuitting;					//Have received a quit event while saving, defer calling gEnv->pSystem->Quit() as long as possible
};

#endif
#endif
