////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek.
// -------------------------------------------------------------------------
//  File name:   SaveReaderWriter_CryPak.h
//  Created:     15/02/2010 by Alex McCarthy.
//  Description: Implementation of the ISaveReader and ISaveWriter
//               interfaces using CryPak
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __SAVE_READER_WRITER_CRYPAK_H__
#define __SAVE_READER_WRITER_CRYPAK_H__

#include <IPlatformOS.h>

class CCryPakFile
{
protected:
	CCryPakFile(const char* fileName, const char* szMode);
	virtual ~CCryPakFile();

	IPlatformOS::EFileOperationCode CloseImpl();

	FILE* m_pFile;
	IPlatformOS::EFileOperationCode m_eLastError;
};

class CSaveReader_CryPak : public IPlatformOS::ISaveReader, public CCryPakFile
{
public:
	CSaveReader_CryPak(const char* fileName);

	// ISaveReader
	virtual IPlatformOS::EFileOperationCode Seek(long seek, ESeekMode mode);
	virtual IPlatformOS::EFileOperationCode GetFileCursor(long& fileCursor);
	virtual IPlatformOS::EFileOperationCode ReadBytes(void* data, size_t numBytes);
	virtual IPlatformOS::EFileOperationCode GetNumBytes(size_t& numBytes);
	virtual IPlatformOS::EFileOperationCode Close() { return CloseImpl(); }
	virtual IPlatformOS::EFileOperationCode LastError() const { return m_eLastError; }
	//~ISaveReader
};

typedef cryshared_ptr<CSaveReader_CryPak> CSaveReader_CryPakPtr;

class CSaveWriter_CryPak : public IPlatformOS::ISaveWriter, public CCryPakFile
{
public:
	CSaveWriter_CryPak(const char* fileName);

	// ISaveWriter
	virtual IPlatformOS::EFileOperationCode AppendBytes(const void* data, size_t length);
	virtual IPlatformOS::EFileOperationCode Close() { return CloseImpl(); }
	virtual IPlatformOS::EFileOperationCode LastError() const { return m_eLastError; }
	//~ISaveWriter
};

typedef cryshared_ptr<CSaveWriter_CryPak> CSaveWriter_CryPakPtr;

#endif //__SAVE_READER_WRITER_CRYPAK_H__
