////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 2010.
// -------------------------------------------------------------------------
//  File name:   SaveReaderWriter_Memory.h
//  Created:     30/4/2010 by Ian Masters.
//  Description: 
// -------------------------------------------------------------------------
//  History:
//  
////////////////////////////////////////////////////////////////////////////

#ifndef __SaveReaderWriter_Memory_h__
#define __SaveReaderWriter_Memory_h__

#include <IPlatformOS.h>



class CMemoryFile;
typedef cryshared_ptr<CMemoryFile> MemoryFilePtr;



struct IMemoryFileSystem
{
	static IMemoryFileSystem* CreateFileSystem();

	// LinkFile
	// Description:
	//     Links a file to the file system. If the file already exists for the specified filename and user index it is replaced by the new one.
	virtual void LinkFile(MemoryFilePtr file) = 0;

	// UnlinkFile
	// Description:
	//     Unlinks a file to the file system. If the file no longer has any references it will be destroyed.
	virtual bool UnlinkFile(MemoryFilePtr file) = 0;

	// GetFile
	// Description:
	//     Find a file by filename and user index.
	virtual MemoryFilePtr GetFile(const char* fileName, unsigned int user) const = 0;

	virtual intptr_t FindFirst(unsigned int userIndex, const char* filePattern, _finddata_t* fd) = 0;
	virtual int FindNext(intptr_t handle, _finddata_t* fd) = 0;
	virtual int FindClose(intptr_t handle) = 0;
};

typedef cryshared_ptr<IMemoryFileSystem> MemoryFileSystemPtr;


class CSaveReader_Memory : public IPlatformOS::ISaveReader
{
public:
	CSaveReader_Memory(const MemoryFileSystemPtr& pFileSystem, const char* fileName, unsigned int userIndex);

	// ISaveReader
	VIRTUAL IPlatformOS::EFileOperationCode Seek(long seek, ESeekMode mode);
	VIRTUAL IPlatformOS::EFileOperationCode GetFileCursor(long& fileCursor);
	VIRTUAL IPlatformOS::EFileOperationCode ReadBytes(void* data, size_t numBytes);
	VIRTUAL IPlatformOS::EFileOperationCode GetNumBytes(size_t& numBytes);
	VIRTUAL IPlatformOS::EFileOperationCode Close() { return IPlatformOS::eFOC_Success; }
	VIRTUAL IPlatformOS::EFileOperationCode LastError() const { return m_eLastError; }
	//~ISaveReader

private:
	MemoryFileSystemPtr m_pFileSystem;
	MemoryFilePtr m_file;
	IPlatformOS::EFileOperationCode m_eLastError;
};


class CSaveWriter_Memory : public IPlatformOS::ISaveWriter
{
public:
	CSaveWriter_Memory(const MemoryFileSystemPtr& pFileSystem, const char* fileName, unsigned int userIndex);
	~CSaveWriter_Memory();

	// ISaveWriter
	VIRTUAL IPlatformOS::EFileOperationCode AppendBytes(const void* data, size_t length);
	VIRTUAL IPlatformOS::EFileOperationCode Close() { return IPlatformOS::eFOC_Success; }
	VIRTUAL IPlatformOS::EFileOperationCode LastError() const { return m_eLastError; }
	//~ISaveWriter

private:
	MemoryFileSystemPtr m_pFileSystem;
	MemoryFilePtr m_file;
	IPlatformOS::EFileOperationCode m_eLastError;
};


class CFileFinderMemory : public IPlatformOS::IFileFinder
{
public:
	CFileFinderMemory(const MemoryFileSystemPtr& pFileSystem) : m_pFileSystem(pFileSystem) {}
	~CFileFinderMemory() { }

	VIRTUAL EFileState		FileExists(unsigned int user, const char* path);
	VIRTUAL intptr_t			FindFirst(unsigned int userIndex, const char* filePattern, _finddata_t* fd);
	VIRTUAL int						FindNext(intptr_t handle, _finddata_t* fd);
	VIRTUAL int						FindClose(intptr_t handle);

private:
	MemoryFileSystemPtr m_pFileSystem;
};


#endif // __SaveReaderWriter_Memory_h__
