////////////////////////////////////////////////////////////////////////////w
//
//  CryEngine Source File.
//  Copyright (C), Crytek.
// -------------------------------------------------------------------------
//  File name:   SaveReaderWriter_PS3.h
//  Created:     19/03/2010 by Stuart Merry.
//  Description: Implementation of the ISaveReader and ISaveWriter
//               interfaces using the PS3 savedata API.
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __SAVE_READER_WRITER_PS3_H__
#define __SAVE_READER_WRITER_PS3_H__

#ifdef PS3

#include <IPlatformOS.h>
#include <cell/sync2.h>

class CPS3File
{
public:

	const char* getFileName() const
	{
		return(m_szRootName);
	}

protected:
	enum EFileMode { eFM_Read, eFM_Write };

	CPS3File(const char* fileName, EFileMode eFileMode);
	virtual ~CPS3File() { CloseImpl(); }

	IPlatformOS::EFileOperationCode CloseImpl();

	bool IsOpen() const
	{
		return(m_fileOpen);
	}

	const char* m_szRootName;
	IPlatformOS::EFileOperationCode m_eLastError;

private:

	bool m_fileOpen;
};

class CSaveReader_PS3 : public IPlatformOS::ISaveReader, public CPS3File
{
public:
	CSaveReader_PS3(const char* fileName, DWORD userIndex);
	virtual ~CSaveReader_PS3();

	// ISaveReader
	virtual IPlatformOS::EFileOperationCode Seek(long seek, ESeekMode mode) { return(IPlatformOS::eFOC_Failure); }
	virtual IPlatformOS::EFileOperationCode GetFileCursor(long& fileCursor) { return(IPlatformOS::eFOC_Failure); }
	virtual IPlatformOS::EFileOperationCode ReadBytes(void* data, size_t numBytes){ return(IPlatformOS::eFOC_Failure); }
	virtual IPlatformOS::EFileOperationCode GetNumBytes(size_t& numBytes){ return(IPlatformOS::eFOC_Failure); }
	virtual IPlatformOS::EFileOperationCode Close() { return CloseImpl(); }
	virtual IPlatformOS::EFileOperationCode LastError() const { return m_eLastError; }
	//~ISaveReader

private:

	CellSync2Semaphore* m_saveDataReadSemaphore;
};

class CSaveWriter_PS3: public IPlatformOS::ISaveWriter, public CPS3File
{
public:
	CSaveWriter_PS3(const char* fileName);
	virtual ~CSaveWriter_PS3();

	// ISaveWriter
	virtual IPlatformOS::EFileOperationCode AppendBytes(const void* data, size_t length);
	virtual IPlatformOS::EFileOperationCode Close() { return CloseImpl(); }
	virtual IPlatformOS::EFileOperationCode LastError() const { return m_eLastError; }
	//~ISaveWriter

	bool IsComplete() const
	{
		return(!IsOpen() && m_validDataSize == 0);
	}

	enum EDataStatus { eDS_Readable, eDS_Writable, eDS_Finished };

	IPlatformOS::EFileOperationCode WriteData(const byte* dataPtr, const int dataLength, int& lengthWritten);
	IPlatformOS::EFileOperationCode ReadData(byte* dataPtr, const int dataLength, int& lengthRead);

private:

	byte *m_dataBuffer;
	int m_dataStart;
	int m_dataEnd;
	int m_dataSize;
	int m_validDataSize;

	//256 kb buffer
	static const int DATA_BUFFER_MAX_SIZE = 256*1024;	

	CellSync2Semaphore* m_saveDataWriteSemaphore;
};

#endif

#endif //__SAVE_READER_WRITER_PS3_H__
