////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek.
// -------------------------------------------------------------------------
//  File name:   SaveReaderWriter_Xenon.h
//  Created:     17/02/2010 by Alex McCarthy.
//  Description: Implementation of the ISaveReader and ISaveWriter
//               interfaces using Xenon API calls
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __SAVE_READER_WRITER_XENON_H__
#define __SAVE_READER_WRITER_XENON_H__

#ifdef XENON

#include <IPlatformOS.h>

class CXenonFile
{
protected:
	enum EFileMode { eFM_Read, eFM_Write };

	CXenonFile(const char* fileName, DWORD userIndex, EFileMode eFileMode);
	virtual ~CXenonFile();

	IPlatformOS::EFileOperationCode CloseImpl();

	HANDLE m_hFile;
	DWORD m_contentOpenUser;
	IPlatformOS::EFileOperationCode m_eLastError;
};

class CSaveReader_Xenon : public IPlatformOS::ISaveReader, public CXenonFile
{
public:
	CSaveReader_Xenon(const char* fileName, DWORD userIndex);

	// ISaveReader
	virtual IPlatformOS::EFileOperationCode Seek(long seek, ESeekMode mode);
	virtual IPlatformOS::EFileOperationCode GetFileCursor(long& fileCursor);
	virtual IPlatformOS::EFileOperationCode ReadBytes(void* data, size_t numBytes);
	virtual IPlatformOS::EFileOperationCode GetNumBytes(size_t& numBytes);
	virtual IPlatformOS::EFileOperationCode Close() { return CloseImpl(); }
	virtual IPlatformOS::EFileOperationCode LastError() const { return m_eLastError; }
	//~ISaveReader
};

class CSaveWriter_Xenon : public IPlatformOS::ISaveWriter, public CXenonFile
{
public:
	CSaveWriter_Xenon(const char* fileName, DWORD userIndex);

	// ISaveWriter
	virtual IPlatformOS::EFileOperationCode AppendBytes(const void* data, size_t length);
	virtual IPlatformOS::EFileOperationCode Close() { return CloseImpl(); }
	virtual IPlatformOS::EFileOperationCode LastError() const { return m_eLastError; }
	//~ISaveWriter
};

#endif //XENON

#endif //__SAVE_READER_WRITER_XENON_H__
