
#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

PROJECT_TYPE := module
PROJECT_VCPROJ := CrySystem.vcproj

-include $(PROJECT_CODE)/Project_override.mk
-include $(PROJECT_CODE)/build_ver.mk

PROJECT_CPPFLAGS += \
	-I$(CODE_ROOT)/CryEngine/CryCommon \
#	-I$(CODE_ROOT)/SDKs/Scaleform/Include \
	-I$(CODE_ROOT)/SDKs \
	-I$(PROJECT_CODE)/XML/Expat \
	-I$(PROJECT_CODE)/zlib

ifeq ($(OPTION_PROFILE),1)
	ifneq ($(MKOPTION_SNC),1)
		ifeq ($(findstring Linux,$(ARCH)),Linux)
			PROJECT_XFLAGS += $(ARCH_XFLAGS)
		else
			PROJECT_XFLAGS += -O2 $(PS3_MATHOPT)
		endif
	else
		PROJECT_XFLAGS += -O3 -Xrelaxalias=3 --diag_suppress=227 --diag_suppress=1628 $(PS3_MATHOPT)
	endif
endif

PROJECT_CPPFLAGS_COMMON += \
	-I$(CODE_ROOT)/CryEngine/CryCommon\
	-I$(CODE_ROOT)/Tools/PS3JobManager

ifeq ($(MKOPTION_UNITYBUILD),1)
PROJECT_SOURCES_CPP_REMOVE := StdAfx.cpp \
	../CryCommon/EngineSettingsManager.cpp \
	../CryCommon/ResourceCompilerHelper.cpp \
	AVI_Reader.cpp \
	AutoDetectCPUTestSuit.cpp \
	AutoDetectSpec.cpp \
	BudgetingSystem.cpp \
	CPUDetect.cpp \
	CmdLine.cpp \
	CmdLineArg.cpp \
	CompressedFile.cpp \
	ConsoleBatchFile.cpp \
	CryMemoryManager.cpp \
	CryPak.cpp \
	CrySizerImpl.cpp \
	ConsoleHelpGen.cpp\
	CrySizerStats.cpp \
	DataProbe.cpp \
	DebugCallStack.cpp \
	DiskProfiler.cpp \
	DllMain.cpp \
	DownloadManager.cpp \
	EnginePropertyBlending.cpp \
	ExcelExport.cpp \
	ExtensionSystem/CryFactoryRegistryImpl.cpp \
	ExtensionSystem/TestCases/TestExtensions.cpp \
	FrameProfileRender.cpp \
	FrameProfileSystem.cpp \
	HTTPDownloader.cpp \
	HardwareMouse.cpp \
	IDebugCallStack.cpp \
	LoadingProfiler.cpp \
	LocalizedStringManager.cpp \
	Log.cpp \
	MTSafeAllocator.cpp \
	Mailer.cpp \
	MemoryManager.cpp \
	MemReplay.cpp \
	MemoryUtils.cpp \
	CryMTrace.cpp \
	NotificationNetwork.cpp \
	PerfHUD.cpp \
	ProfileLogSystem.cpp \
	PhysRenderer.cpp \
	RandGen.cpp \
	PlatformOS/SaveReaderWriter_CryPak.cpp \
	PlatformOS/PlatformOS_PS3.cpp \
	PlatformOS/PlatformOS_PC.cpp \
	PlatformOS/PlatformOS_Xenon.cpp \
	PlatformOS/SaveReaderWriter_PS3.cpp \
	PlatformOS/SaveReaderWriter_Xenon.cpp \
	PlatformOS/SysCallThread_PS3.cpp \
	CodeCoverage/CodeCheckpointMgr.cpp \
	ResourceManager.cpp \
	RefReadStream.cpp \
	RefReadStreamProxy.cpp \
	RefStreamEngine.cpp \
	Sampler.cpp \
	ServerThrottle.cpp \
	Statistics.cpp \
	StreamEngine.cpp \
	System.cpp \
	SystemCFG.cpp \
	SystemEventDispatcher.cpp \
	SystemInit.cpp \
	SystemRender.cpp \
	SystemWin32.cpp \
	TestSystem.cpp \
	TestSystemLegacy.cpp \
	ThreadProfiler.cpp \
	ThreadTask.cpp \
	Timer.cpp \
	UnitTestExcelReporter.cpp \
	UnitTestSystem.cpp \
	UnixConsole.cpp \
	WindowsErrorReporting.cpp \
	XConsole.cpp \
	XConsoleVariable.cpp \
	crc32system.cpp \
	getdxver.cpp \
	MiniGUI/DrawContext.cpp \
	MiniGUI/MiniGUI.cpp \
	MiniGUI/MiniInfoBox.cpp \
	MiniGUI/MiniButton.cpp \
	MiniGUI/MiniMenu.cpp \
	MiniGUI/MiniTable.cpp \
	XML/ReadXMLSink.cpp \
	XML/SerializeXMLReader.cpp \
	XML/SerializeXMLWriter.cpp \
	XML/WriteXMLSource.cpp \
	XML/XMLBinaryNode.cpp \
	XML/XMLBinaryReader.cpp \
	XML/XMLBinaryWriter.cpp \
	XML/XmlUtils.cpp \
	XML/xml.cpp \
	ZipDirCache.cpp \
	ZipDirCacheFactory.cpp \
	ZipDirCacheRW.cpp \
	ZipDirFind.cpp \
	ZipDirFindRW.cpp \
	ZipDirList.cpp \
	ZipDirStructures.cpp \
	ZipDirTree.cpp \
	zlib/zlib_spu.cpp \
	Scaleform/ConfigScaleform.cpp \
	Scaleform/FlashPlayerInstance.cpp \
	Scaleform/GAllocatorCryMem.cpp \
	Scaleform/GFileCryPak.cpp \
	Scaleform/GImageInfoXRender.cpp \
	Scaleform/GRendererXRender.cpp \
	Scaleform/GTextureXRender.cpp \
	Scaleform/SharedResources.cpp \
	Scaleform/SharedStates.cpp \
	Statistics/LocalMemoryUsage.cpp \
	XenonDebugCallStack.cpp \
	XenonThreadSampler.cpp \
	TestSystem.cpp \
	JiraClient.cpp 

  PROJECT_SOURCES_C_REMOVE += md5.c\
    XML/Expat/%

PROJECT_SOURCES_CPP_ADD += CrySystem_main_uber.cpp\
	CrySystem_main2_uber.cpp\
	CrySystem_xml_uber.cpp\
	CrySystem_zlib_uber.cpp
endif

ifeq ($(ARCH),PS3-cell)
  PROJECT_SOURCES_C_REMOVE += zlib/%
endif

ifeq ($(findstring Linux,$(ARCH)),Linux)
 # used to syncronize Win32 host with consoles
 PROJECT_SOURCES_CPP_REMOVE := NotificationNetwork.cpp
endif

PROJECT_SCAN_CPP := zlib/zlib_spu.cpp

PROJECT_XFLAGS := -O0 -g 

# vim:ts=8:sw=8
