#include <stdafx.h>

#include "ProtectionManager.h"
#ifdef USING_LICENSE_PROTECTION

#if !defined(XENON) && !defined(PS3)

#include "ISystem.h"
#include "IConsole.h"
#include "EngineSettingsManager.h"
#include <Iphlpapi.h>
#include "Log.h"
#include "TinyClientSocket.h"
#include "LicenseConnection.h"
#include "CachedLicense.h"
#include <ISystem.h>
#include <ICryPak.h>

#ifdef USING_UNIKEY_SECURITY
#include "UniKeySecurity/IUniKeyManager.h"
#endif // USING_UNIKEY_SECURITY


#pragma comment ( lib, "Iphlpapi.lib" )

#define LICENSE_SERVER_IP "80.237.158.14"
const char* CachedLicenseFile = "SandboxCachedLicense.dat";
const uint32	CachedLicenseFileMakeTerm = 10*60*1000;	// 10 minute

static const string base64_chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";


string Base64Encode(const char* pBytesToEncode) 
{
	unsigned int in_len = strlen(pBytesToEncode);

	string ret;
	int i = 0;
	int j = 0;
	unsigned char char_array_3[3];
	unsigned char char_array_4[4];

	while (in_len--) 
	{
		char_array_3[i++] = (unsigned char)*(pBytesToEncode++);
		if (i == 3) {
			char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
			char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
			char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
			char_array_4[3] = char_array_3[2] & 0x3f;

			for(i = 0; (i <4) ; i++)
				ret += base64_chars[char_array_4[i]];
			i = 0;
		}
	}

	if (i)
	{
		for(j = i; j < 3; j++)
			char_array_3[j] = '\0';

		char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
		char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
		char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
		char_array_4[3] = char_array_3[2] & 0x3f;

		for (j = 0; (j < i + 1); j++)
			ret += base64_chars[char_array_4[j]];

		while((i++ < 3))
			ret += '=';

	}

	return ret;
}


//////////////////////////////////////////////////////////////////////////
CProtectionManager::CProtectionManager() : m_clientSocket(NULL), m_licenseConnection(new CLicenseConnection())
{
	InitNetwork();
	RegisterConsoleVariable();
}


//////////////////////////////////////////////////////////////////////////
CProtectionManager::~CProtectionManager()
{
	CloseLicenseServerConnection();
	FiniNetwork();
	if (NULL != m_licenseConnection)
	{
		delete m_licenseConnection;
		m_licenseConnection = NULL;
	}
}


//////////////////////////////////////////////////////////////////////////
bool CProtectionManager::GetKeyFromRegistry(string& sKey)
{
	const char* LicenseKeyKeyName = "EDT_InstanceKey";
	CEngineSettingsManager esm;
	if (!esm.HasKey(LicenseKeyKeyName))
		return false;

	esm.GetValueByRef(LicenseKeyKeyName, sKey);
	return true;
}

//////////////////////////////////////////////////////////////////////////
bool CProtectionManager::SetupConnectionInfoFromRegistry()
{
	const char* ManualConfigKeyName = "EDT_LicenseManualConfig";
	const char* ServerIpKeyName = "EDT_LicenseIp";
	const char* ServerPortKeyName = "EDT_LicensePort";
	CEngineSettingsManager esm;
	if (false == esm.HasKey(ServerIpKeyName))
		return false;
	if (false == esm.HasKey(ServerPortKeyName))
		return false;
	if (false == esm.HasKey(ManualConfigKeyName))
		return false;

	string serverIp;
	int serverPort = 0;
	esm.GetValueByRef(ServerIpKeyName, serverIp);
	string strPort;
	esm.GetValueByRef(ServerPortKeyName, strPort);
	serverPort = atoi(strPort.c_str());

	bool manualConfig = false;
	string manualConfigStr;
	esm.GetValueByRef(ManualConfigKeyName, manualConfigStr);
	if ("true" == manualConfigStr)
		manualConfig = true;

	if (manualConfig)
		m_licenseConnection->SetConnectionInfo(serverIp, serverPort);
	else
		m_licenseConnection->SetDefaultConnectionInfo();

	ICVar* pITestVar = gEnv->pConsole->GetCVar("sys_game_folder");
	 
	ICVar* pIPCVar = gEnv->pConsole->GetCVar("net_proxy_ip");
	if (pIPCVar && strlen(pIPCVar->GetString())>0) // user proxy
	{
		string sAuthUser, sAuthPass;
		ICVar* pUserCVar = gEnv->pConsole->GetCVar("net_proxy_user");
		if (pUserCVar && strlen(pUserCVar->GetString())>0)
			sAuthUser = pUserCVar->GetString();
		ICVar* pPassCVar = gEnv->pConsole->GetCVar("net_proxy_pass");
		if (pPassCVar && strlen(pPassCVar->GetString())>0)
			sAuthPass = pPassCVar->GetString();

		string sAuthInfo;
		if (false == sAuthUser.empty())
			sAuthInfo = Base64Encode(sAuthUser+":"+sAuthPass);
		string sProxyIp = pIPCVar->GetString();
		string sProxyPort;
		ICVar* pProxyPortVar = gEnv->pConsole->GetCVar("net_proxy_port");
		if (pProxyPortVar && strlen(pProxyPortVar->GetString())>0)
			sProxyPort = pProxyPortVar->GetString();
		int proxyPort = atoi(sProxyPort.c_str());
		m_licenseConnection->SetProxy(sProxyIp, proxyPort, sAuthInfo);
	}
	return true;
}

//////////////////////////////////////////////////////////////////////////
void CProtectionManager::WriteLicenseKeyToRegistry( const string& key )
{
	CEngineSettingsManager esm;
	if (esm.HasKey("EDT_InstanceKey") )
	{
		string prevKey;
		esm.GetValueByRef("EDT_InstanceKey",prevKey);
		if (false == prevKey.empty())
			return;
	}
	esm.SetModuleSpecificEntry("EDT_InstanceKey", key);
}

//////////////////////////////////////////////////////////////////////////
int CProtectionManager::ConnectToLicenseServer()
{
	string ip = LICENSE_SERVER_IP;
	int port = 80;

	ICVar* pIPCVar = gEnv->pConsole->GetCVar("net_proxy_ip");
	if (pIPCVar && strlen(pIPCVar->GetString())>0)
		ip = pIPCVar->GetString();
	ICVar* pPortCVar = gEnv->pConsole->GetCVar("net_proxy_port");
	if (pPortCVar && pPortCVar->GetIVal())
		port = pPortCVar->GetIVal();

	if (false == m_clientSocket->InitSocket())
		return 2;
	if (false == m_clientSocket->Connect(ip.c_str(), port))
		return 3;

	return 0;
}


//////////////////////////////////////////////////////////////////////////
void CProtectionManager::CloseLicenseServerConnection()
{
	m_clientSocket->FiniSocket();
}


//////////////////////////////////////////////////////////////////////////
EPMErrorCode CProtectionManager::RetrieveClientDataNew( SClientData &data )
{
	if (false == SetupConnectionInfoFromRegistry())
		return PMEC_REGISTRY_NOT_FOUND;
	GetKeyFromRegistry(data.sKey);
	EPMErrorCode retCode = PMEC_NO_ERROR;
	retCode = ServerAuthenticate(data.sKey, data.sVersion, data.sAppName);
	if (PMEC_NO_ERROR == retCode)
	{
		m_licenseConnection->GetEncryptKey(data.sEncryptKey);
		return retCode;
	}

#ifdef USING_CACHED_LICENSE
	bool cachedResule = CachedAuthenticate(data.sKey);
	if (cachedResule)
		return PMEC_NO_ERROR;
#endif
	return retCode;
}

//////////////////////////////////////////////////////////////////////////
bool CProtectionManager::GetLocalIPAddress(string& ip)
{
	char ac[80];
	if (gethostname(ac, sizeof(ac)) == SOCKET_ERROR)
		return false;

	struct hostent *phe = gethostbyname(ac);
	if (phe == 0)
		return false;

	for (int i = 0; phe->h_addr_list[i] != 0; ++i) 
	{
		struct in_addr addr;
		memcpy(&addr, phe->h_addr_list[i], sizeof(struct in_addr));
		ip = inet_ntoa(addr);
		if (ip!="127.0.0.1")
			return true;
	}

	return false;
}


//////////////////////////////////////////////////////////////////////////
bool CProtectionManager::GetLocalMacAddress(string& mac)
{
	PIP_ADAPTER_INFO pAdapterInfo = new IP_ADAPTER_INFO;
	PIP_ADAPTER_INFO pAdapter = NULL;
	DWORD dwBufLen = sizeof(IP_ADAPTER_INFO);

	if (GetAdaptersInfo(pAdapterInfo, &dwBufLen)==ERROR_BUFFER_OVERFLOW)
	{
		delete pAdapterInfo;
		pAdapterInfo = (IP_ADAPTER_INFO*)new char[dwBufLen];
	}

	bool result = false;
	if (GetAdaptersInfo(pAdapterInfo, &dwBufLen)==NO_ERROR) 
	{
		pAdapter = pAdapterInfo;				
		while (pAdapter)
		{
			mac = "";
			for (int i=0;i<pAdapter->AddressLength;i++)
				mac += DecHex(pAdapter->Address[i]) + (i+1<pAdapter->AddressLength?":":"");
			pAdapter = pAdapter->Next;
		}
		if (mac.length()>0)
			result = true;
	}
	delete pAdapterInfo;
	pAdapterInfo = NULL;
	return result;
}


//////////////////////////////////////////////////////////////////////////
TAGES_EXPORT unsigned long ThreadStart(LPVOID data)
{
	TProtectionCallback pProtectionCallback = ((TProtectionCallback)data);

	while(true)
	{
		pProtectionCallback();
		Sleep(1000*60);
	}
	return 0;
}


//////////////////////////////////////////////////////////////////////////
void CProtectionManager::StartLicenseVerificationThread(TProtectionCallback cb)
{
	DWORD dwThreadID;
	CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)&ThreadStart, cb, 0, &dwThreadID);
}


//////////////////////////////////////////////////////////////////////////
int CProtectionManager::HexDec(unsigned char val)
{
	return val<'a'?val-'0':val-'a'+10;
}


//////////////////////////////////////////////////////////////////////////
string CProtectionManager::DecHex(int val)
{
	int lo = val%16;
	int hi = val/16;
	return string(hi<10?hi+'0':hi-10+'a')+string(lo<10?lo+'0':lo-10+'a');
}


//////////////////////////////////////////////////////////////////////////
string CProtectionManager::Decrypt(const string &str)
{
	string resultString = "";

	for(int i=0;i<strlen(str);i+=4)
	{
		int seed = HexDec(str[i])*16+HexDec(str[i+1]);
		unsigned char dec = ((HexDec(str[i+2])*16+HexDec(str[i+3])) + (256-seed)) % 256;
		resultString += dec;
	}
	return resultString;
}


//////////////////////////////////////////////////////////////////////////
string CProtectionManager::Encrypt(const string &str)
{
	srand(GetCurrentTime());		
	string resultString = "";

	for(int i=0;i<strlen(str);i++)
	{
		int seed = rand()%256;
		resultString += DecHex(seed);
		int dec = (str[i]+seed) % 256;
		resultString += DecHex(dec);
	}
	return resultString;
}



//////////////////////////////////////////////////////////////////////////
string CProtectionManager::GetValue(const string& source, const string& key)
{
	string subSource = source;

	int tagBegin = source.find(key);
	if (tagBegin<0)
		return "";

	subSource = source.substr(tagBegin);
	int tagMiddle = subSource.find("=");
	if (tagMiddle<0)
		return "";	

	subSource = subSource.substr(tagMiddle+1);
	int tagEnd = subSource.find(";");
	if (tagEnd<0)
		return "";

	return subSource.substr(0, tagEnd);
}

void CProtectionManager::InitNetwork()
{
	m_clientSocket = new CTinyClientSocket();
	m_clientSocket->InitNetwork();
	m_clientSocket->InitSocket();
}

void CProtectionManager::FiniNetwork()
{
	m_clientSocket->FiniSocket();
	m_clientSocket->FiniNetwork();
	SAFE_DELETE(m_clientSocket);
}

EPMErrorCode CProtectionManager::ServerAuthenticate( const string& key, const string& version, const string& appName)
{
	if (false == version.empty())
		m_licenseConnection->SetVersion(version);
	if (false == appName.empty())
		m_licenseConnection->SetAppName(appName);
	m_privateIdentityKey = key;
	EPMErrorCode retCode = m_licenseConnection->Authenticate(key.c_str());
	if (PMEC_NO_ERROR == retCode)
	{
		string key;
		m_licenseConnection->GetLicenseKey(key);
		WriteLicenseKeyToRegistry(key);
#ifdef USING_CACHED_LICENSE
		MakeCachedLicenseFile(key, m_licenseConnection->GetRemainSecond());
#endif
	}
	return retCode;
}

bool CProtectionManager::CachedAuthenticate( const string& key )
{
	string localIp, localMac;
	GetLocalIPAddress(localIp);
	GetLocalMacAddress(localMac);
	char szAdjustedPath[ICryPak::g_nMaxPath] = {0,};
	MakeUserPath(CachedLicenseFile, szAdjustedPath);

	CCachedLicense cachedLicense;
	if (false == cachedLicense.LoadFile(szAdjustedPath))
		return false;
	return cachedLicense.ValidLicense(key.c_str(), localIp.c_str(), localMac.c_str());
}

void CProtectionManager::MakeUserPath( const char* filename, char* newPath )
{
	string destPath = "%USER%/Sandbox/";
	destPath += filename;
	gEnv->pCryPak->AdjustFileName(destPath.c_str(), newPath, ICryPak::FLAGS_PATH_REAL | ICryPak::FLAGS_FOR_WRITING);

}

void CProtectionManager::MakeCachedLicenseFile( const string& key, uint32 remainSecond )
{
	if (0 == remainSecond)
		return;
	uint32 currentTick = GetTickCount();
	if (0 == m_lastCachedLicenseFileMakeTick)
		m_lastCachedLicenseFileMakeTick = currentTick-CachedLicenseFileMakeTerm;
	if ((currentTick-m_lastCachedLicenseFileMakeTick) < CachedLicenseFileMakeTerm)
		return;

	m_lastCachedLicenseFileMakeTick = currentTick;

	string localIp, localMac;
	GetLocalIPAddress(localIp);
	GetLocalMacAddress(localMac);

	CCachedLicense cachedLicense;
	char szAdjustedPath[ICryPak::g_nMaxPath] = {0,};
	MakeUserPath(CachedLicenseFile, szAdjustedPath);
	cachedLicense.MakeFile(
										szAdjustedPath, 
										remainSecond, 
										key.c_str(), 
										localIp.c_str(), 
										localMac.c_str());
}


unsigned int CProtectionManager::GetDisconnectedPeriod()
{
	return m_licenseConnection->GetDisconnectedPeriod();
}

void CProtectionManager::GetSpecificErrorMessage( EPMErrorCode errorCode, char* titleMsg, char* captionMsg )
{
	const char* ValidationErrorMsg = "Your License could not be validated.\nIn order to help you solving any connectivity issues, please provide the error code in the title of this dialog.";
	if (PMEC_CONNECT_FAILED == errorCode)
	{
		strcpy(captionMsg, "Could not connect to the License Server. Please establish an internet connection.\nIf you still cannot connect, check your firewall or contact Crytek to resolve this issue.");
		strcpy(titleMsg, "Connection Error 0x100");
	}
	else if (PMEC_PROXY_CONNECT_FAILED == errorCode)
	{
		strcpy(captionMsg, "Could not authenticate at proxy. Please verify your proxy settings.\nIf you still cannot connect, check your firewall or contact Crytek to resolve this issue.");
		strcpy(titleMsg, "Connection Error 0x110");
	}	
	else if (PMEC_CANT_WRITE_TO_SOCKET == errorCode)
	{
		strcpy(captionMsg, "Could not write to the License Server. Please check your firewall or contact Crytek to resolve this issue.");
		strcpy(titleMsg, "Connection Error 0x200");
	}
	else if (PMEC_CANT_READ_FROM_SOCKET == errorCode)
	{
		strcpy(captionMsg, "Could not read from the License Server. Please check your firewall or contact Crytek to resolve this issue.");
		strcpy(titleMsg, "Connection Error 0x300");
	}
	else if (PMEC_NETWORK_DEVICE == errorCode)
	{
		strcpy(captionMsg, "Could not find your network device.\nPlease check your device or contact Crytek to resolve this issue.");
		strcpy(titleMsg, "Connection Error 0x400");
	}	
	else if (PMEC_KEY_EXPIRED == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x100");
	}
	else if (PMEC_KEY_INVALID == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x200");
	}
	else if (PMEC_INVALID_TIMEFRAME == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x300");
	}
	else if (PMEC_KEY_NOT_FOUND == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x400");
	}
	else if (PMEC_OVER_CONNECTION == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x500");
	}
	else if (PMEC_NO_DONGLE == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x600");
	}
	else if (PMEC_INVALID_ADDRESS == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x700");
	}
	else if (PMEC_REGISTRY_NOT_FOUND == errorCode)
	{
		strcpy(captionMsg, "Could not find a valid License Information. Please run SettingsMgr or Sandbox to validate your CryENGINE installation.");
		strcpy(titleMsg, "Validation Error 0x800");
	}
	else if (PMEC_DOUBLE_LOGIN == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x900");
	}
	else if (PMEC_INVALID_CONNECT_TYPE == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x110");
	}
	else if (PMEC_OLD_APP_VERSION == errorCode)
	{
		strcpy(captionMsg, "The version of this application is deprecated.\n");
		strcat(captionMsg, "Please download new version on mycryengine.com.\n");
		strcpy(titleMsg, "Validation Error 0x120");
	}
	else
	{
		char unknownErrorTitle[128] = {0,};
		sprintf(unknownErrorTitle, "Unknown Error 0x%d", (int)errorCode);
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, unknownErrorTitle);
	}
}

ECreateAccountResult CProtectionManager::RequestCreateAccount( const SCreateAccountParam& param, EPMErrorCode& subErrorCode )
{
	return m_licenseConnection->RequestCreateAccount(param, subErrorCode);
}


void CProtectionManager::RegisterConsoleVariable()
{
	REGISTER_STRING("net_proxy_ip", "", 0,  "Proxy server's ip");
	REGISTER_STRING("net_proxy_port", "", 0,  "Proxy server's port");
	REGISTER_STRING("net_proxy_user", "", 0,  "Proxy account");
	REGISTER_STRING("net_proxy_pass", "", 0,  "Proxy password");
}

ELoginAccountResult CProtectionManager::RequestLoginAccount( const string& username, const string& password, bool& agreeLicenseFlag, EPMErrorCode& subErrorCode)
{
	m_privateIdentityUsername = username;
	return m_licenseConnection->RequestLoginAccount(username, password, agreeLicenseFlag, subErrorCode);
}


bool CProtectionManager::RequestPasswordRemind( const string& username, const string& email )
{
	return m_licenseConnection->RequestPasswordRemind(username, email);
}

void CProtectionManager::SendLicenseAgree( const string& username )
{
	return m_licenseConnection->SendLicenseAgree(username);
}

void CProtectionManager::GetPrivateIdentityBuffer(char* bufferForOutput)
{
	// using Global license server : license key
	// educational : account
	// dongle : ?
	if (m_privateIdentityUsername.empty())
		strcpy(bufferForOutput, m_privateIdentityKey.c_str());
	else
		strcpy(bufferForOutput, m_privateIdentityUsername.c_str());
}

#endif // !defined(XENON) && !defined(PS3)

#endif // USING_LICENSE_PROTECTION
