#pragma once

#include "ProjectDefines.h"
#ifdef USING_LICENSE_PROTECTION

#if !defined(XENON) && !defined(PS3)

#include "IProtectionManager.h"

class CTinyClientSocket;
class CLicenseConnection;

// For interface description, see IProtectionManager
class CProtectionManager : IProtectionManager
{
public:
	CProtectionManager();
	~CProtectionManager();

	TAGES_EXPORT virtual EPMErrorCode	RetrieveClientDataNew(SClientData &data);
	TAGES_EXPORT virtual void					StartLicenseVerificationThread(TProtectionCallback cb);
	virtual unsigned int	GetDisconnectedPeriod();
	virtual void					GetSpecificErrorMessage(EPMErrorCode code, char* titleMsg, char* captionMsg);
	virtual	ECreateAccountResult RequestCreateAccount( const SCreateAccountParam& param, EPMErrorCode& subErrorCode);
	virtual	ELoginAccountResult RequestLoginAccount( const string& username, const string& password, bool& agreeLicenseFlag, EPMErrorCode& subErrorCode);
	virtual bool RequestPasswordRemind(const string& username, const string& email);
	virtual	void SendLicenseAgree(const string& username);
	virtual void GetPrivateIdentityBuffer(char* bufferForOutput);

private:

	// System information
	TAGES_EXPORT bool					GetKeyFromRegistry(string& sKey);
	TAGES_EXPORT bool					GetLocalIPAddress(string& ip);
	TAGES_EXPORT bool					GetLocalMacAddress(string& mac);
	TAGES_EXPORT bool					SetupConnectionInfoFromRegistry();
	void					WriteLicenseKeyToRegistry(const string& key);

	// Helpers for simple cyphering

	string					Decrypt(const string &str);
	string					Encrypt(const string &str);

	// extract value from a string of format 'key=value;'.
	string					GetValue(const string& source, const string& key);

	int					HexDec(unsigned char val);
	string					DecHex(int val);

	// Server communication

	TAGES_EXPORT int					ConnectToLicenseServer();
	TAGES_EXPORT void					CloseLicenseServerConnection();

	// Network
	void					InitNetwork();
	void					FiniNetwork();

	EPMErrorCode	ServerAuthenticate(const string& key, const string& version, const string& appName);
	bool					CachedAuthenticate(const string& key);
	void					MakeUserPath( const char* filename, char* newPath );
	void					MakeCachedLicenseFile(const string& key, uint32 remainSecond);
	void					RegisterConsoleVariable();

private:
	CTinyClientSocket*			m_clientSocket;
	CLicenseConnection*			m_licenseConnection;
	uint32									m_lastCachedLicenseFileMakeTick;
	string									m_privateIdentityKey;
	string									m_privateIdentityUsername;
};

#endif // !defined(XENON) && !defined(PS3)

#endif // USING_LICENSE_PROTECTION
