////////////////////////////////////////////////////////////////////////////
//
//  Crytek Source File.
//  Copyright (C), Crytek Studios, 2009.
// -------------------------------------------------------------------------
//  File name:   ProtocolAssembler.h
//  Version:     v1.00
//  Created:     24/08/2009 by Younggi Lim
//  Compilers:   Visual Studio.NET
//  Description: assemble protocolbuilder
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"

#ifdef USING_LICENSE_PROTECTION

#include "ProtocolAssembler.h"
#include "ProtocolBuilder.h"

const uint32	MaxAssemblBufferSize = 1024*4;

CProtocolAssembler::CProtocolAssembler(void) : m_bufferPtr(NULL), m_stackedOffset(0), m_processOffset(0)
{
	m_bufferPtr = new char[MaxAssemblBufferSize];
}

CProtocolAssembler::~CProtocolAssembler(void)
{
	if (NULL != m_bufferPtr)
	{
		delete [] m_bufferPtr;
		m_bufferPtr = NULL;
	}
}

void CProtocolAssembler::ApplyBuffer( const char* buffer, uint32 &offset, uint32 bufferLength )
{
	if (false == AddBuffer(buffer, offset, bufferLength))
	{
		// Todo : AllocBuffer
		// AddBuffer(buffer, offset, bufferLength);
	}
	offset += bufferLength;
}

bool CProtocolAssembler::AssembleBuilder( CProtocolBuilder& builder)
{
	bool buildResult = builder.Parse(m_bufferPtr, m_processOffset, m_stackedOffset);
	if (false == buildResult)
	{
		return false;
	}

	if (m_processOffset == m_stackedOffset)
	{
		m_processOffset = 0;
		m_stackedOffset = 0;
	}
	return true;
}

bool CProtocolAssembler::AddBuffer( const char* buffer, uint32 offset, uint32 bufferLength )
{
	if ((m_stackedOffset+bufferLength)>MaxAssemblBufferSize)
		return false;

	memcpy(&m_bufferPtr[m_stackedOffset], &buffer[offset], bufferLength);
	m_stackedOffset += bufferLength;
	return true;
}

#endif // USING_LICENSE_PROTECTION