////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2009.
// -------------------------------------------------------------------------
//  File name:   tinyclientsocket.h
//  Version:     v1.00
//  Created:     03/08/2009 by Younggi Lim
//  Compilers:   Visual Studio.NET
//  Description: Simple class for network communication
//               Use only connect case. Not thread safe.
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////
#ifndef __tinyclientsocket_h__
#define __tinyclientsocket_h__

#pragma once

#ifdef USING_LICENSE_PROTECTION

#if !defined(XENON) && !defined(PS3)

#include <WinSock2.h>

class CTinyClientSocket
{
public:
	CTinyClientSocket(void);
	virtual ~CTinyClientSocket(void);

	bool	InitNetwork();
	void	FiniNetwork();

	///////////////////////////////////////////////
	// Description:
	//   Create socket and event object
	//////////////////////////////////////////////
	bool	InitSocket();

	///////////////////////////////////////////////
	// Description:
	//   Cleanup socket and event object
	//////////////////////////////////////////////
	void	FiniSocket();

	bool	Connect(const char* ip, const int port);
	bool	Send(const char* buffer, const uint32 len);
	void	Disconnect();

	////////////////////////////////////////////////////////
	// Description:
	//   Receive certain length or certain time
	// Arguments:
	//   length - size of the buffer
	//   timeout - how much time(ms) wait for the packet
	// Return:
	//   How many bytes you receive.
	//   If it's zero, there are no packets or get an error.
	//////////////////////////////////////////////////////
	uint32	Receive(char* buffer, const uint32 length, const uint32 timeout);

	bool	IsConnected() const;
	bool	GetLocalIPAddress(string& ip) const;
	bool	GetLocalMacAddress(string& mac) const;
	void	SetImmediateReturn(bool immediateFlag);

protected:
	void		MakeEmptySocketBuffer() const;
	string	DecHex(int val) const;

private:
	SOCKET		m_socket;
	WSAEVENT	m_event;
	bool			m_isConnected;
	bool			m_immediateReturn;

};

#endif // !defined(XENON) && !defined(PS3)

#endif // USING_LICENSE_PROTECTION

#endif // __tinyclientsocket_h__

