////////////////////////////////////////////////////////////////////////////
//
//	Crytek Engine Source File.
//	Copyright (C), Crytek Studios, 2008.
// -------------------------------------------------------------------------
//	File name:	 XenonDebugCallStack.h
//	Version:		 v1.00
//	Created:		 1/07/2008 by Alexey.
//	Compilers:	 Visual C++ 2005
//	Description: 
// -------------------------------------------------------------------------
//	History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __XENON_DEBUG_CALLSTACK_H__
#define __XENON_DEBUG_CALLSTACK_H__

#include "IDebugCallStack.h"

#ifdef XENON

const int MAX_MODULES_ENTRIES = 50;

typedef struct _EXCEPTION_POINTERS EXCEPTION_POINTERS;

class DebugCallStack : public IDebugCallStack
{
public:
 
	DebugCallStack();

	virtual int handleException( EXCEPTION_POINTERS *exception_pointer );

	virtual void LogCallstack();
	void	CollectCurrentCallStack(int maxStackEntries = MAX_DEBUG_STACK_ENTRIES);

private:
	void CreateErrorLog(EXCEPTION_POINTERS* exception_pointer);
	void SaveDumpMode();

	void CollectModules();
	void FormatFunctions();

	std::vector<string> m_modules;
	std::vector<void*> m_rawFunctions;
};

#endif

#endif //__XENON_DEBUG_CALLSTACK_H__
