#include "CallStackBase.h"

namespace CryUnit
{
	ICallStackElement::~ICallStackElement()
	{

	}

	ICallStack::~ICallStack()
	{

	}

	const ICallStack& ICallStack::CreateEmpty()
	{
		return * new CallStackBase();
	}

	const String CallStackElement::m_unknown("Unknown");

	CallStackElement::CallStackElement()
		: m_functionName(m_unknown)
		, m_moduleName(m_unknown)
		, m_fileName(m_unknown)
		, m_fileLineNumber(0)
	{
		
	}

	const char* CallStackElement::GetFunctionName() const
	{
		return m_functionName.GetInternalData();
	}

	const char* CallStackElement::GetModuleName() const
	{
		return m_moduleName.GetInternalData();
	}

	const char* CallStackElement::GetFileName() const
	{
		return m_fileName.GetInternalData();
	}

	int CallStackElement::GetFileLineNumber() const
	{
		return m_fileLineNumber;
	}

	void CallStackElement::SetFunctionName(const char* functionName)
	{
		m_functionName.Assign(functionName);
	}

	void CallStackElement::SetModuleName(const char* moduleName)
	{
		m_moduleName.Assign(moduleName);
	}

	void CallStackElement::SetFileName(const char* fileName)
	{
		m_fileName.Assign(fileName);
	}

	void CallStackElement::SetFileLineNumber(int fileLineNumber)
	{
		m_fileLineNumber = fileLineNumber;
	}

	bool CallStackElement::IsUnknown() const
	{
		return m_functionName == m_unknown || m_fileName == m_unknown;
	}

	void CallStackBase::Release() const
	{
		delete this;
	}

	int CallStackBase::GetSize() const
	{
		return int(m_elementContainer.size());
	}

	const ICallStackElement& CallStackBase::GetElementByIndex(int index) const
	{
		return m_elementContainer.at(ElementContainer::size_type(index));
	}

	void CallStackBase::Add(const CallStackElement& element)
	{
		if (element.IsUnknown())
		{
			return;
		}

		m_elementContainer.push_back(element);
	}

	void CallStackBase::FilterTopElements(size_t elementsToRemove)
	{
		ElementContainer::size_type toRemove = std::min(elementsToRemove, m_elementContainer.size());
		m_elementContainer.erase(m_elementContainer.begin(), m_elementContainer.begin() + toRemove);
	}

	void CallStackBase::FilterBottomElements(size_t elementsToRemove)
	{
		ElementContainer::size_type toRemove = std::min(elementsToRemove, m_elementContainer.size());
		m_elementContainer.erase(m_elementContainer.end() - toRemove, m_elementContainer.end());
	}
}
