#ifndef CRY_UNIT_CALL_STACK_BASE_H
#define CRY_UNIT_CALL_STACK_BASE_H

#include "ICallStack.h"
#include "CryUnitString.h"

#include <vector>

namespace CryUnit
{
	class CallStackElement : public ICallStackElement
	{
	public:
		CallStackElement();

		virtual const char* GetFunctionName() const;
		virtual const char* GetModuleName() const;
		virtual const char* GetFileName() const;
		virtual int GetFileLineNumber() const;

		void SetFunctionName(const char* functionName);
		void SetModuleName(const char* moduleName);
		void SetFileName(const char* fileName);
		void SetFileLineNumber(int fileLineNumber);

		bool IsUnknown() const;

	private:
		String m_functionName;
		String m_moduleName;
		String m_fileName;
		int m_fileLineNumber;

		static const String m_unknown;
	};

	class CallStackBase : public ICallStack
	{
		typedef std::vector<CallStackElement> ElementContainer;
	public:
		virtual void Release() const;
		virtual int GetSize() const;
		virtual const ICallStackElement& GetElementByIndex(int index) const;
		void Add(const CallStackElement& element);
		void FilterTopElements(size_t elementsToRemove);
		void FilterBottomElements(size_t elementsToRemove);
	private:
		ElementContainer m_elementContainer;
	};
}

#endif
