#ifndef CRY_UNIT_CALL_STACK_WIN32_H
#define CRY_UNIT_CALL_STACK_WIN32_H

#include "CallStackBase.h"

#include <Windows.h>
#include <DbgHelp.h>

namespace CryUnit
{ 
	class CallStackElementFactory
	{
	public:
		static const CallStackElement Create(HANDLE process, DWORD64 programCounter);

	private:
		static void ExtractFunctionName(CallStackElement& element, HANDLE process, DWORD64 programCounter);
		static void ExtractModuleName(CallStackElement& element, HANDLE process, DWORD64 programCounter);
		static void ExtractFileNameAndLine(CallStackElement& element, HANDLE process, DWORD64 programCounter);
	};

	class CallStack : public CallStackBase
	{
	public:
		CallStack();
		virtual ~CallStack();

		void Retrieve(EXCEPTION_POINTERS* exceptionPointers);

	private:
		void FillStackInfo(STACKFRAME64& stackFrame, DWORD& machineType, PCONTEXT context) const;
		void NavigateStack(STACKFRAME64& stackFrame, DWORD machineType, PCONTEXT context);
		void InitSymbols();
		void CleanupSymbols();

		HANDLE m_process;
	};
}

#endif
