#ifndef CRY_UNIT_H
#define CRY_UNIT_H

#include "CryUnitInterfaces.h"
#include "CryUnitAsserts.h"

#if EXCLUDE_UNIT_TESTS == 1
#define CRY_UNIT_NO_TESTING
#endif

#define CRY_STRINGIZE(text) #text

#ifdef CRY_UNIT_NO_TESTING

#define CRY_TEST_WITH_FIXTURE_EX(test_name, test_fixture, enabled) \
    class test_fixture##test_name: public test_fixture	\
    {	\
    virtual void TestBody();	\
    };	\
    void test_fixture##test_name::TestBody()

#else

#define CRY_TEST_WITH_FIXTURE_EX(test_name, test_fixture, enabled) \
class test_fixture##test_name: public test_fixture	\
    {	\
    public:	\
        static const CryUnit::STestInfo Info()	\
        {	\
            return CryUnit::STestInfo(CRY_STRINGIZE(test_name), CRY_STRINGIZE(test_fixture), CreateTestCase, enabled, __FILE__, __LINE__); \
        }	\
        static ITestCase* CreateTestCase() { return new test_fixture##test_name(); } \
        virtual const CryUnit::STestInfo GetTestInfo() const { return Info(); } \
        protected:	\
            virtual void TestBody();	\
        };	\
    namespace \
    { \
        static int dummy_##test_fixture##test_name = (test_fixture::GetTestSuite()->RegisterTestCase(test_fixture##test_name::Info()), 0);	\
    }\
    void test_fixture##test_name::TestBody()	\

#endif

#define CRY_TEST_WITH_FIXTURE(test_name, test_fixture) \
    CRY_TEST_WITH_FIXTURE_EX(test_name, test_fixture, true)

#define CRY_TEST_WITH_FIXTURE_SKIP(test_name, test_fixture) \
    CRY_TEST_WITH_FIXTURE_EX(test_name, test_fixture, false)

#define CRY_TEST_WITH_FIXTURE_BUG_REPORT(test_name, test_fixture) \
    CRY_TEST_WITH_FIXTURE_EX(test_name, test_fixture, false)

#define CRY_TEST(test_name) \
    CRY_TEST_WITH_FIXTURE(test_name, DefaultTestFixture)

#define DECLARE_TEST_SUITE_WITH_TYPE(test_suite, type_id) \
    class test_suite \
    { \
    public: \
        static CryUnit::ITestSuite* GetInstance() \
        { \
            static CryUnit::ITestSuite* testSuite = CryUnit::ITestSuite::Create(CRY_STRINGIZE(test_suite), CryUnit::ITestSuite::type_id); \
            return testSuite; \
        } \
    }

#define DECLARE_UNIT_TEST_SUITE(test_suite)	\
    DECLARE_TEST_SUITE_WITH_TYPE(test_suite, UNIT_TEST);

#define DECLARE_SMOKE_TEST_SUITE(test_suite)	\
    DECLARE_TEST_SUITE_WITH_TYPE(test_suite, SMOKE_TEST);

#define DECLARE_TEST_SUITE(test_suite) \
    DECLARE_UNIT_TEST_SUITE(test_suite);

#define CRY_TEST_FIXTURE(test_fixture, parent_fixture, test_suite) \
class test_fixture##_base: public parent_fixture	\
    {	\
    public:\
    typedef parent_fixture Base; \
        virtual ~test_fixture##_base() {} \
        static CryUnit::ITestSuite* GetTestSuite() { return test_suite::GetInstance(); } \
    }; \
    struct test_fixture: public test_fixture##_base	\

#define CRY_DEFAULT_TEST_FIXTURE(test_suite) CRY_TEST_FIXTURE(DefaultTestFixture, CryUnit::ITestCase, test_suite)

#endif
