#ifndef CRY_UNIT_STRING_H
#define CRY_UNIT_STRING_H

#include <string.h>

namespace CryUnit
{
	class String
	{
	public:
		String();
		explicit String(const char* data);

		~String();

		String(const String& str);
		String& operator=(const String& str);

		bool operator==(const String& str1) const;

		const char* GetInternalData() const;

		void Assign(const char* data);

		void Append(const char* data);


	private:
		char* Alloc();
		void FreeData();
		void Realloc();
		void ComputeCapacity(size_t len);

		static size_t Length(const char* str);
		static void Copy(char* dst, size_t capacity, const char* src);
		static void Append(char* dst, size_t capacity, const char* src);
		static bool Equal(const char* str1, const char* str2);

		static const size_t m_defaultCapacity = 1;
		size_t m_capacity;
		char* m_data;
	};
}

#endif
