#ifndef TEST_SUITE_TEST_FIXTURE_H
#define TEST_SUITE_TEST_FIXTURE_H

#include "CryUnitTest.h"
#include "../TestSuite.h"
#include "../CryUnitString.h"

// -----------------------------------------------------------------------------

CRY_TEST_FIXTURE(CTestSuiteTestFixtureBase, TestCryUnitFixture, TestCryUnitSuite)
{
public:
    CTestSuiteTestFixtureBase()
        :	m_TestSuite("CTestSuiteTestFixtureBase")
    {

    }

    void RunTests() 
    { 
        m_TestSuite.Run(GetListener()); 
    }

    virtual CryUnit::ITestListener& GetListener() = 0;

    void RegisterTestCase(const char* testName)
    {
        m_TestSuite.RegisterTestCase(CryUnit::STestInfo(testName, "", NULL, true, "", 0));
    }

protected:
    CryUnit::TestSuite m_TestSuite;
};

// -----------------------------------------------------------------------------

CRY_TEST_FIXTURE(CTestSuiteTestFixture, CTestSuiteTestFixtureBase, TestCryUnitSuite)
{

    class FakeTestListener: public CryUnit::ITestListener
    {
    public:
        FakeTestListener()
            : numberOfTestsRun(0)
            , numberOfTestsFailed(0)
            , numberOfTestsPassed(0)
            , numberOfTestsSkipped(0)
        {
        }

        virtual void TestSuiteRun(const CryUnit::ITestSuite& testSuite)
        {

        }

        virtual void TestSuiteEnd(const CryUnit::ITestSuite& testSuite)
        {

        }

        virtual void StartTestRun(const CryUnit::STestInfo& testInfo)
        {

        }

        virtual void TestRun(const CryUnit::STestInfo& testInfo)
        {
            numberOfTestsRun++;
        }

        virtual void TestPassed(const CryUnit::STestInfo& testInfo)
        {
            numberOfTestsPassed++;
        }

        virtual void TestFailed(const CryUnit::STestInfo& testInfo, const CryUnit::SFailureInfo& failureInfo)
        {
            numberOfTestsFailed++;
            testFailedNames.push_back(CryUnit::String(testInfo.Name));
            testFailedErrorMessage.push_back(CryUnit::String(failureInfo.Message));
        }

        virtual void TestSkipped(const CryUnit::STestInfo& testInfo)
        {
            numberOfTestsSkipped++;
        }

        int numberOfTestsRun;
        int numberOfTestsFailed;
        int numberOfTestsPassed;
        int numberOfTestsSkipped;
		std::vector<CryUnit::String> testFailedNames;
        std::vector<CryUnit::String> testFailedErrorMessage;
    };
public:
    virtual void SetUp()
    {
        m_listener = new FakeTestListener();
    }

    virtual void TearDown()
    {			
        delete m_listener;
    }

    virtual FakeTestListener& GetListener()
    {
        return *m_listener;
    }

    FakeTestListener* m_listener;
};

// -----------------------------------------------------------------------------

template <typename Derived>
class TestCaseDummyBase : public CryUnit::ITestCase
{
public:
    static const CryUnit::STestInfo Info()
    {
        return CryUnit::STestInfo(Derived::GetTestName(), "", FactoryFunction, Derived::IsEnabled(), "", 0);
    }

    static CryUnit::ITestCase* FactoryFunction()
    {
        return new Derived();
    }

    virtual const CryUnit::STestInfo GetTestInfo() const
    {
        return Info();
    }

    static const char* GetTestName()
    {
        return "TestDummy";
    }

    static bool IsEnabled()
    {
        return true;
    }
};

class CPassingDummyTest: public TestCaseDummyBase<CPassingDummyTest>
{
public:
    virtual void TestBody() {}
};

class CFailingDummyTest: public TestCaseDummyBase<CFailingDummyTest>
{
public:
    static const char* GetTestName()
    {
        return "FailingDummyTest";
    }

    virtual void TestBody() 
    {
        CryUnit::AssertIsTrue(false, "", 0);
    }
};

class CFailingEqualityDummyTest: public TestCaseDummyBase<CFailingEqualityDummyTest>
{
public:
    static const char* GetTestName()
    {
        return "FailingDummyTest";
    }

    virtual void TestBody() 
    {
        CryUnit::AssertAreEqual(2, 3, "file", 10);
    }
};

class CPassingDummyDisabledTest: public TestCaseDummyBase<CPassingDummyDisabledTest>
{
public:
    static bool IsEnabled()
    {
        return false;
    }

    virtual void TestBody() {}
};

#endif
