#ifndef CRY_UNIT_I_CALL_STACK_H
#define CRY_UNIT_I_CALL_STACK_H

namespace CryUnit
{
	class ICallStackElement
	{
	public:
		virtual const char* GetFunctionName() const = 0;
		virtual const char* GetModuleName() const = 0;
		virtual const char* GetFileName() const = 0;
		virtual int GetFileLineNumber() const = 0;

	protected:
		virtual ~ICallStackElement();
	};

	class ICallStack
	{
	public:
		virtual void Release() const = 0;

		virtual int GetSize() const = 0;
		virtual const ICallStackElement& GetElementByIndex(int index) const = 0;

		static const ICallStack& CreateEmpty();

	protected:
		virtual ~ICallStack();
	};
}

#endif
