#ifndef CRY_UNIT_I_SYSTEM_EXCEPTION_H
#define CRY_UNIT_I_SYSTEM_EXCEPTION_H

namespace CryUnit
{
	class ICallStack;
	class AttachSystemExceptionTranslatorImpl;

	class AttachSystemExceptionTranslator
	{
	public:
		AttachSystemExceptionTranslator();
		~AttachSystemExceptionTranslator();

		void ResetStack() const;
		void ThrowSystemException() const;

	private:
		AttachSystemExceptionTranslatorImpl* m_pImpl;
	};

	class ISystemException
	{
	public:  
		virtual const ICallStack& GetCallStack() const = 0;

	protected:
		virtual ~ISystemException();
	};

	class IStackOverflowException : public ISystemException
	{

	};
}

#endif
