#ifndef CRY_UNIT_I_TEST_CASE_H
#define CRY_UNIT_I_TEST_CASE_H

namespace CryUnit
{
    class ITestCase;

    typedef ITestCase* (*TestFactoryFunction)();

    struct STestInfo
    {
        STestInfo(const char* name, const char* fixture, TestFactoryFunction testFactory, bool enabled, const char* fileName, int line);

        const char* Name;
		const char* Fixture;
        TestFactoryFunction TestFactory;
        bool Enabled;
        const char* FileName;
        int FileLineNumber;
    };

    class ITestCase
    {
    public:
        virtual ~ITestCase();

        virtual const STestInfo GetTestInfo() const = 0;

        virtual void SetUp();
        virtual void TearDown();

        void Run();

    protected:
        virtual void TestBody() = 0;
    };

    class ITestFixture : public ITestCase
    {

    };

}

#endif
