#ifndef CRY_UNIT_I_TEST_ENUMERATOR_H
#define CRY_UNIT_I_TEST_ENUMERATOR_H

#include "ITestSuite.h"

namespace CryUnit
{
    class ITestEnumerator;

    typedef ITestEnumerator* (*GetTestEnumerator)(const ITestSuite::Type type);

    class ITestEnumerator
    {
    public:
        virtual ~ITestEnumerator();
        virtual int NumberOfTestSuites() const = 0;
        virtual void EnumerateTestSuites(ITestSuite** testSuites) const = 0;

        virtual void Initialise() = 0;
        virtual void Shutdown() = 0;
    };
}

#endif
