#ifndef CRY_UNIT_I_TEST_LISTENER_H
#define CRY_UNIT_I_TEST_LISTENER_H

namespace CryUnit
{
    struct STestInfo;
    class ITestSuite;
    class ICallStack;

    class SFailureInfo
    {
    public:
        SFailureInfo(const char* condition, const char* message, const char* fileName, int line, const ICallStack& callStack);

        const char* Condition;
        const char* Message;
        const char* FileName;
        int FileLineNumber;
        const ICallStack& CallStack;
    };

    class ITestListener
    {
    public:
        virtual ~ITestListener();
        virtual void TestSuiteRun(const ITestSuite& testSuite) = 0;
        virtual void TestSuiteEnd(const ITestSuite& testSuite) = 0;

        virtual void StartTestRun(const STestInfo& testInfo) = 0;
        virtual void TestRun(const STestInfo& testInfo) = 0;
        virtual void TestPassed(const STestInfo& testInfo) = 0;
        virtual void TestFailed(const STestInfo& testInfo, const SFailureInfo& failureInfo) = 0;
        virtual void TestSkipped(const STestInfo& testInfo) = 0;
    };

}

#endif
