#ifndef CRY_UNIT_I_TEST_SUITE_H
#define CRY_UNIT_I_TEST_SUITE_H

namespace CryUnit
{
	class ITestCase;
	class ITestListener;
	struct STestInfo;

	class ITestSuite
	{
	public:
		enum Type
		{
			NO_TYPE = 0,
			UNIT_TEST,
			SMOKE_TEST
		};

		static ITestSuite* Create(const char* name, Type type);
		virtual void Release() = 0;

		virtual const char* GetName() const = 0;
		virtual Type GetType() const = 0;

		virtual void RegisterTestCase(const STestInfo& testInfo) = 0;

		virtual void Run(ITestListener& listener) const = 0;
		virtual void RunTestCase(ITestCase& testCase, ITestListener& listener) const = 0;
		virtual void RunTestCase(const STestInfo& testInfo, ITestListener& listener) const = 0;

		virtual unsigned int GetNumberOfTests() const = 0;
		virtual const STestInfo& GetTestInfoByIndex(unsigned int index) const = 0;
		virtual const STestInfo* GetTestInfoByName(const char* name) const = 0;

		virtual void DisableProtector() = 0;

	protected:
		virtual ~ITestSuite();
	};
}

#endif

