#include "StringStream.h"
#include "StringHelpers.h"

namespace CryUnit
{
    StringStream::StringStream()
        :   m_stringBuffer(new StringHelpers::StringBuffer())
    {

    }

    StringStream::~StringStream()
    {
        delete m_stringBuffer;
    }

    const char* StringStream::ToString() const
    {
        return m_stringBuffer->ToString();
    }

    StringStream& StringStream::operator << (int arg)
    {
        m_stringBuffer->Append(arg);
        return *this;
    }

    StringStream& StringStream::operator << (unsigned int arg)
    {
        m_stringBuffer->Append(arg);
        return *this;
    }

    StringStream& StringStream::operator << (unsigned short arg)
    {
        m_stringBuffer->Append(arg);
        return *this;
    }

	StringStream& StringStream::operator << (unsigned char arg)
	{
		m_stringBuffer->Append(arg);
		return *this;
	}

    StringStream& StringStream::operator << (const char* arg)
    {
        m_stringBuffer->Append(arg);
        return *this;
    }

    StringStream& StringStream::operator << (float arg)
    {
        m_stringBuffer->Append(arg);
        return *this;
    }

    StringStream& StringStream::operator << (const void* arg)
    {
        m_stringBuffer->Append(arg);
        return *this;
    }
}
