#ifndef CRY_UNIT_STRING_STREAM_H
#define CRY_UNIT_STRING_STREAM_H

namespace CryUnit
{
	namespace StringHelpers
	{
		class StringBuffer;
	}

	class StringStream
	{
	public:
		StringStream();
		~StringStream();

		const char* ToString() const;

		StringStream& operator << (int arg);
		StringStream& operator << (unsigned int arg);
		StringStream& operator << (unsigned short arg);
		StringStream& operator << (unsigned char arg);
		StringStream& operator << (const char* arg);
		StringStream& operator << (float arg);
		StringStream& operator << (const void* arg);

	private:
		StringHelpers::StringBuffer* m_stringBuffer;
	};

	template <typename T>
	StringStream& operator << (StringStream& stringStream, const T& unknownValue)
	{
		stringStream << "Unknown";
		return stringStream;
	}
}

#endif
