#include "ISystemException.h"

#ifdef WIN32
#	include "SystemExceptionWin32.h"
#else
#	include "SystemExceptionNull.h"
#endif

namespace CryUnit
{
	ISystemException::~ISystemException()
	{

	}

	AttachSystemExceptionTranslator::AttachSystemExceptionTranslator()
		: m_pImpl(new AttachSystemExceptionTranslatorImpl())
	{

	}

	AttachSystemExceptionTranslator::~AttachSystemExceptionTranslator()
	{
		delete m_pImpl;
	}

	void AttachSystemExceptionTranslator::ResetStack() const
	{
		m_pImpl->ResetStack();
	}

	void AttachSystemExceptionTranslator::ThrowSystemException() const
	{
		m_pImpl->ThrowSystemException();
	}
}
