#ifdef WIN32

#include "CallStackWin32.h"
#include "SystemExceptionWin32.h"
#include <malloc.h>

namespace CryUnit
{

#pragma warning(push)
#pragma warning(disable: 4535)

	AttachSystemExceptionTranslatorImpl::AttachSystemExceptionTranslatorImpl()
		: m_oldTranslator(_set_se_translator(Translator))
	{

	}

	AttachSystemExceptionTranslatorImpl::~AttachSystemExceptionTranslatorImpl()
	{
		_set_se_translator(m_oldTranslator);
	}

#pragma warning(pop)

	void AttachSystemExceptionTranslatorImpl::ResetStack() const
	{
		_resetstkoflw();
	}

	void AttachSystemExceptionTranslatorImpl::ThrowSystemException() const
	{
		RaiseException(0, 0, 0, 0);
	}

	void AttachSystemExceptionTranslatorImpl::Translator(unsigned int code, EXCEPTION_POINTERS* exceptionPointers)
	{
		if (code == EXCEPTION_STACK_OVERFLOW)
		{
			throw SehStackOverflowException();
		}
		else
		{
			throw SehException(exceptionPointers);
		}
	}

	SehException::SehException(EXCEPTION_POINTERS* exceptionPointers)
		: m_exceptionPointers(exceptionPointers)
	{

	}

	const ICallStack& SehException::GetCallStack() const
	{
		CallStack* callStack = new CallStack();
		callStack->Retrieve(m_exceptionPointers);
		return *callStack;
	}

	const ICallStack& SehException::GetFilteredCallStack(size_t topElementsToRemove, size_t bottomElementsToRemove) const
	{
		CallStack* callStack = new CallStack();
		callStack->Retrieve(m_exceptionPointers);
		callStack->FilterTopElements(topElementsToRemove);
		callStack->FilterBottomElements(bottomElementsToRemove);
		return *callStack;
	}

	const ICallStack& SehStackOverflowException::GetCallStack() const
	{
		CallStack* callStack = new CallStack();
		return *callStack;
	}
}

#endif
