#ifndef CRY_UNIT_SYSTEM_EXCEPTION_WIN32_H
#define CRY_UNIT_SYSTEM_EXCEPTION_WIN32_H

#include "ISystemException.h"
#include <Windows.h>
#include <eh.h>

namespace CryUnit
{
	class SehException : public ISystemException
	{
	public:
		SehException(EXCEPTION_POINTERS* exceptionPointers);
		virtual const ICallStack& GetCallStack() const;
		virtual const ICallStack& GetFilteredCallStack(size_t topElementsToRemove, size_t bottomElementsToRemove) const;

	private:
		EXCEPTION_POINTERS* m_exceptionPointers;
	};

	class SehStackOverflowException : public IStackOverflowException
	{
	public:
		virtual const ICallStack& GetCallStack() const;
	};

	class AttachSystemExceptionTranslatorImpl
	{
	public:
		AttachSystemExceptionTranslatorImpl();
		~AttachSystemExceptionTranslatorImpl();

		void ResetStack() const;
		void ThrowSystemException() const;

	private:
		static void Translator(unsigned int code, EXCEPTION_POINTERS* exceptionPointers);
		_se_translator_function m_oldTranslator;
	};
}

#endif
