#include "TestFailedException.h"
#include "ICallStack.h"

namespace CryUnit 
{
	ITestFailedException::~ITestFailedException()
	{

	}

	TestFailedException::TestFailedException(const char* condition, const char* message, const char* file, int line)
		: m_Condition(condition)
		, m_Message(message)
		, m_File(file)
		, m_Line(line)
	{

	}

	const char* TestFailedException::GetCondition() const
	{
		return m_Condition.GetInternalData();
	}

	const char* TestFailedException::GetMessage() const
	{
		return m_Message.GetInternalData();
	}

	const char* TestFailedException::GetFilePath() const
	{
		return m_File.GetInternalData();
	}

	int TestFailedException::GetFileLine() const
	{
		return m_Line;
	}
}
