#ifndef CRY_UNIT_TEST_FAILED_EXCEPTION_H
#define CRY_UNIT_TEST_FAILED_EXCEPTION_H

#include "ITestFailedException.h"
#include "CryUnitString.h"

namespace CryUnit
{
	class ICallStack;

	class TestFailedException : public ITestFailedException
	{
	public:
		TestFailedException(const char* condition, const char* message, const char* file, int line);

		virtual const char* GetCondition() const;
		virtual const char* GetMessage() const;
		virtual const char* GetFilePath() const;
		virtual int GetFileLine() const;

	private:
		String m_Condition;
		String m_Message;
		String m_File;
		int m_Line;
	};
}

#endif
