#ifndef CRY_UNIT_TEST_SUITE_H
#define CRY_UNIT_TEST_SUITE_H

#include "ITestSuite.h"
#include "UnhandledExceptionProtector.h"
#include <vector>

namespace CryUnit
{
    class TestSuite : public ITestSuite
    {
        typedef std::vector<STestInfo> TestInfoList;
    public:
        TestSuite(const char* name, Type type = UNIT_TEST);
        virtual ~TestSuite();

        virtual void Release();

        virtual void Run(ITestListener& listener) const;
        virtual void RegisterTestCase(const STestInfo& testInfo);

        virtual const char* GetName() const;

        virtual Type GetType() const;

        virtual unsigned int GetNumberOfTests() const;
		virtual const STestInfo& GetTestInfoByIndex(unsigned int index) const;
        virtual const STestInfo* GetTestInfoByName(const char* name) const;

        virtual void RunTestCase(ITestCase& testCase, ITestListener& listener) const;
		virtual void RunTestCase(const STestInfo& testInfo, ITestListener& listener) const;

        virtual void DisableProtector();

    private:
        const char* m_Name;
        Type m_Type;

        TestInfoList m_ListOfTests;
        bool m_protectorEnabled;
    };

    // -----------------------------------------------------------------------------

    class CreateAndRunTestCase : public UnhandledExceptionProtector
    {
    public:
        CreateAndRunTestCase(const ITestSuite& testSuite, const STestInfo& testInfo, ITestListener& listener, const char* message);
        virtual void Protected();

    private:
        const ITestSuite& m_testSuite;
    };

    // -----------------------------------------------------------------------------

    class RunTestWithDefaultProtector : public UnhandledExceptionProtector
    {
    public:
        RunTestWithDefaultProtector(ITestCase& testCase, ITestListener& listener, const char* message);
        virtual void Protected();

    private:
        ITestCase& m_testCase;
    };

    // -----------------------------------------------------------------------------

    class TearDownProtector : public UnhandledExceptionProtector
    {
    public:
        TearDownProtector(ITestCase& testCase, ITestListener& listener, const char* message);
        virtual void Protected();

    private:
        ITestCase& m_testCase;
    };

    // -----------------------------------------------------------------------------
}

#endif
