#ifndef CRY_UNIT_UNHANDLED_EXCEPTION_PROTECTOR_H
#define CRY_UNIT_UNHANDLED_EXCEPTION_PROTECTOR_H

#include "ITestCase.h"

namespace CryUnit
{
    class ITestListener;
	class ISystemException;

    class UnhandledExceptionProtector
    {
    public:
        UnhandledExceptionProtector(const STestInfo& testInfo, ITestListener& listener, const char* message);
        virtual ~UnhandledExceptionProtector();

        virtual void Protected() = 0;

        void Execute(bool runProtected = true);

		void RunCatchingAll();

	private:
		void NotifyTestFailed(const char* condition);
		void NotifyTestCrashed(const ISystemException& systemException);
    protected:
        const STestInfo m_testInfo;
        ITestListener& m_listener;

    private:
        const char* m_message;
    };
}

#endif
