#include "StdAfx.h"
#include "CREWaterOcean.h"
#include "I3DEngine.h"

CREWaterOcean::CREWaterOcean(): CRendElementBase()
{
	mfSetType( eDATA_WaterOcean );
	mfUpdateFlags( FCEF_TRANSFORM );

  m_nVerticesCount = 0;
  m_nIndicesCount = 0;

  m_pVertDecl = 0;  
  m_pVertices = 0;
  m_pIndices = 0; 

  m_pWaterSim = 0;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

CREWaterOcean::~CREWaterOcean()
{
  ReleaseOcean();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

void CREWaterOcean::mfGetPlane(Plane& pl)
{
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

void CREWaterOcean::mfPrepare()
{
  gRenDev->FX_CheckOverflow( 0, 0, this );
  gRenDev->m_RP.m_pRE = this;
  gRenDev->m_RP.m_RendNumIndices = 0;
  gRenDev->m_RP.m_RendNumVerts = 0;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

Vec3 CREWaterOcean ::GetPositionAt( float x, float y ) const
{ 
  //assert( m_pWaterSim );
  if( m_pWaterSim  )
    return m_pWaterSim->GetPositionAt( (int)x, (int)y );

  return Vec3(0,0,0);
}

Vec4 *CREWaterOcean::GetDisplaceGrid( ) const
{
  //assert( m_pWaterSim );
  if( m_pWaterSim  )
    return m_pWaterSim->GetDisplaceGrid();

  return 0;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

void CREWaterOcean::UpdateFFT( )
{
  CWater *pSimulator = m_pWaterSim;
  //static CWaterSim pSimulator = CWaterSim::GetInstance();

  static bool bInitialize = true;

  //if( bInitialize )
  {
   // pSimulator.Create( 1.0, 0.0f, 1.0f, 1.0f);
   // bInitialize = false;
  }

  //pSimulator.Update(  0.125*gEnv->pTimer->GetCurrTime() );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

