#include "ResFile.h"

STRUCT_INFO_BEGIN(SFileResHeader)
	STRUCT_VAR_INFO(hid, TYPE_INFO(uint32))
	STRUCT_VAR_INFO(ver, TYPE_INFO(int))
	STRUCT_VAR_INFO(num_files, TYPE_INFO(int))
	STRUCT_VAR_INFO(ofs_dir, TYPE_INFO(int))
  STRUCT_VAR_INFO(size_dir, TYPE_INFO(int))
STRUCT_INFO_END(SFileResHeader)

STRUCT_INFO_BEGIN(CCryNameTSCRC)
	STRUCT_VAR_INFO(m_nID, TYPE_INFO(int))
STRUCT_INFO_END(CCryNameTSCRC)

STRUCT_INFO_BEGIN(SDirEntry)
  STRUCT_VAR_INFO(Name, TYPE_INFO(CCryNameTSCRC))
  STRUCT_BITFIELD_INFO(size, TYPE_INFO(uint32), 24)
  STRUCT_BITFIELD_INFO(flags, TYPE_INFO(uint32), 8)
  STRUCT_VAR_INFO(offset, TYPE_INFO(int32))
STRUCT_INFO_END(SDirEntry)

STRUCT_INFO_BEGIN(SShaderBinHeader)
	STRUCT_VAR_INFO(m_Magic, TYPE_INFO(FOURCC))
	STRUCT_VAR_INFO(m_CRC32, TYPE_INFO(uint32))
	STRUCT_VAR_INFO(m_VersionLow, TYPE_INFO(uint16))
	STRUCT_VAR_INFO(m_VersionHigh, TYPE_INFO(uint16))
	STRUCT_VAR_INFO(m_nOffsetStringTable, TYPE_INFO(uint32))
  STRUCT_VAR_INFO(m_nOffsetParamsLocal, TYPE_INFO(uint32))
	STRUCT_VAR_INFO(m_nTokens, TYPE_INFO(uint32))
STRUCT_INFO_END(SShaderBinHeader)

STRUCT_INFO_BEGIN(SShaderBinParamsHeader)
  STRUCT_VAR_INFO(nMask, TYPE_INFO(uint32))
  STRUCT_VAR_INFO(nName, TYPE_INFO(uint32))
	STRUCT_VAR_INFO(nParams, TYPE_INFO(int32))
	STRUCT_VAR_INFO(nFuncs, TYPE_INFO(int32))
STRUCT_INFO_END(SShaderBinParamsHeader)

STRUCT_INFO_BEGIN(SShaderCacheHeader)
	STRUCT_VAR_INFO(m_SizeOf, TYPE_INFO(int))
	STRUCT_VAR_INFO(m_MajorVer, TYPE_INFO(uint16))
	STRUCT_VAR_INFO(m_MinorVer, TYPE_INFO(uint16))
	STRUCT_VAR_INFO(m_szVer, TYPE_ARRAY(16, TYPE_INFO(char)))
	STRUCT_VAR_INFO(m_CRC32, TYPE_INFO(uint32))
	STRUCT_VAR_INFO(m_bOptimised, TYPE_INFO(bool))
  STRUCT_VAR_INFO(m_bReserved1, TYPE_INFO(bool))
  STRUCT_VAR_INFO(m_bReserved2, TYPE_INFO(bool))
  STRUCT_VAR_INFO(m_bReserved3, TYPE_INFO(bool))
STRUCT_INFO_END(SShaderCacheHeader)

STRUCT_INFO_BEGIN(SSShaderCacheHeader)
	STRUCT_VAR_INFO(m_SizeOf, TYPE_INFO(int))
  STRUCT_VAR_INFO(m_szVer, TYPE_ARRAY(16, TYPE_INFO(char)))
	STRUCT_VAR_INFO(m_MajorVer, TYPE_INFO(uint16))
	STRUCT_VAR_INFO(m_MinorVer, TYPE_INFO(uint16))
	STRUCT_VAR_INFO(m_CRC32, TYPE_INFO(uint32))
STRUCT_INFO_END(SSShaderCacheHeader)

STRUCT_INFO_BEGIN(SShaderCacheHeaderItem)
	STRUCT_VAR_INFO(m_nVertexFormat, TYPE_INFO(byte))
	STRUCT_VAR_INFO(m_Class, TYPE_INFO(byte))
	STRUCT_VAR_INFO(m_nInstBinds, TYPE_INFO(byte))
	STRUCT_VAR_INFO(m_StreamMask_Stream, TYPE_INFO(byte))
	STRUCT_VAR_INFO(m_StreamMask_Decl, TYPE_INFO(uint16))
	STRUCT_VAR_INFO(m_nInstructions, TYPE_INFO(short))
  STRUCT_VAR_INFO(m_CRC32, TYPE_INFO(uint32))
  //STRUCT_VAR_INFO(m_DeviceObjectID, TYPE_INFO(int))
STRUCT_INFO_END(SShaderCacheHeaderItem)
