/*=============================================================================
  RemoteCompiler.h : socket wrapper for shader compile server connections
  Copyright (c) 2008 Crytek Studios. All Rights Reserved.

  Revision history:
    * Created by Michael Kopietz

=============================================================================*/

#ifndef REMOTECOMPILER_H
#define REMOTECOMPILER_H

namespace NRemoteCompiler
{
#if defined(PS3)
typedef int SOCKET;
#define WSAGetLastError()	static_cast<int>(sys_net_errno)
#define closesocket socketclose
#endif

typedef std::vector<string>						tdEntryVec;

enum EServerError
{
	ESOK,
	ESFailed,
	ESNetworkError,
	ESSendFailed,
	ESRecvFailed,
};

class CShaderSrv
{
protected:
	static	uint32			m_LastWorkingServer;
											CShaderSrv();

	bool								Send(SOCKET Socket, const char* pBuffer,uint32 Size)	const;
	bool								Send(SOCKET Socket,std::vector<uint8>& rCompileData)	const;
	EServerError				Recv(SOCKET Socket,std::vector<uint8>& rCompileData)	const;
	EServerError	      Send(std::vector<uint8>&	rCompileData)	const;

	void								Tokenize(tdEntryVec& rRet,const string& Tokens,const string& Separator)	const;
	string							TransformToXML(const string& rIn)	const;
	string							CreateXMLNode(const string& rTag,const string& rValue)	const;
//	string							CreateXMLDataNode(const string& rTag,const string& rValue)	const;

	void								RequestLine(const SCacheCombination& cmb,
																	const string& rLine) const;
	bool								CreateRequest(std::vector<uint8>&	rVec,
																		std::vector<std::pair<string,string> >& rNodes)	const;

	void								Init();
public:
	EServerError        Compile(		std::vector<uint8>&	rVec,
																	const char* 				pProfile,
																	const char* 				pProgram,
																	const char* 				pEntry,
																	const char* 				pCompileFlags)	const;
  bool								CommitPLCombinations(std::vector<SCacheCombination>&	rVec);
	void								RequestLine(const string&				rList,
																	const string&				rString)	const;

	static CShaderSrv&	Instance();

};
}

#endif

