#ifndef D3D_COLOR_GRADING_CONTROLLER_H
#define D3D_COLOR_GRADING_CONTROLLER_H

#pragma once


#include "../Common/IColorGradingControllerInt.h"


class CD3D9Renderer;

struct SColorGradingMergeParams
{
  Vec4 pColorMatrix[3];
  Vec4 pLevels[2];
  Vec4 pFilterColor;
  Vec4 pSelectiveColor[2];
  uint64 nFlagsShaderRT;
};

class CColorGradingControllerD3D : public IColorGradingControllerInt
{
public:
	// IColorGradingController interface
	virtual int LoadColorChart(const char* pChartFilePath) const;
	virtual int LoadDefaultColorChart() const;
	virtual void UnloadColorChart(int texID) const;

	virtual void SetLayers(const SColorChartLayer* pLayers, uint32 numLayers);

public:
	// IColorGradingController internal interface
	VIRTUAL void RT_SetLayers(const SColorChartLayer* pLayers, uint32 numLayers);

public:
	CColorGradingControllerD3D(CD3D9Renderer* pRenderer);
	virtual ~CColorGradingControllerD3D();

	bool Update(const SColorGradingMergeParams *pMergeParams = 0);
	CTexture* GetColorChart() const;
	void DrawDebugInfo() const;

	bool LoadStaticColorChart(const char* pChartFilePath);
	const CTexture* GetStaticColorChart() const;

private:
	typedef std::vector<SColorChartLayer> Layers;

private:
	bool ValidateColorChart(const CTexture* pChart) const;
	CTexture* LoadColorChartInt(const char* pChartFilePath) const;
	bool InitResources();
	void DrawLayer(float x, float y, float w, float h, CTexture* pChart, float blendAmount, const char* pLayerName) const;

	void Init3DTexture();
	void ResolveTo3DTexture(CTexture* pRT);
private:
	Layers m_layers;
	CD3D9Renderer* m_pRenderer;
	CVertexBuffer* m_pSlicesVB;
	std::vector<SVF_P3F_C4B_T2F> m_vecSlicesData;
	CTexture* m_pChartIdentity;
	CTexture* m_pChartStatic;
	CTexture* m_pChartToUse;
	CTexture* m_pMergeLayers[2];
	CTexture* m_p3DColorChart;

#ifdef XENON	// work-around
	D3DVolumeTexture* m_p3DColorChartAux[16];
#endif
};


#endif // #ifndef D3D_COLOR_GRADING_CONTROLLER_H
