/*=============================================================================
Copyright (c) 2010 Crytek Studios. All Rights Reserved.

Revision history:
* Created by Nicolas Schulz

=============================================================================*/

#pragma once 

#ifndef STEREORENDERER_H
#define STEREORENDERER_H

class CD3D9Renderer;

enum StereoMode
{
	STEREO_MODE_NO_STEREO = 0,	// stereo disabled
	STEREO_MODE_DUAL_RENDERING = 1,
	STEREO_MODE_POST_STEREO = 2,  // extract from depth
	STEREO_MODE_COUNT,
};

enum StereoOutput
{
	STEREO_OUTPUT_NONE = 0,		// emulation mode
	STEREO_OUTPUT_GENERIC_DUAL_HEAD = 1,
	STEREO_OUTPUT_IZ3D = 2,
	STEREO_OUTPUT_ABOVE_AND_BELOW = 3,
	STEREO_OUTPUT_SIDE_BY_SIDE = 4,
	STEREO_OUTPUT_INTERLACED = 5,
	STEREO_OUTPUT_ANAGLYPH = 6,
	STEREO_OUTPUT_COUNT,
};

enum Eye
{
	LEFT_EYE = 0,
	RIGHT_EYE = 1
};

class CD3DStereoRenderer
{
public:
	CD3DStereoRenderer(CD3D9Renderer& renderer);
	~CD3DStereoRenderer();

	bool NeedsToCreateResources() const;
	void RecreateResources();

	bool IsStereoEnabled() const { return m_mode != STEREO_MODE_NO_STEREO; }

	void PrepareStereo(StereoMode mode, StereoOutput output);

	StereoMode GetStereoMode() const { return m_mode; }
	StereoOutput GetStereoOutput() const { return m_output; }

	CTexture* GetLeftEye() { return CTexture::s_ptexStereoL; }
	CTexture* GetRightEye() { return CTexture::s_ptexStereoR; }
	CTexture *GetHighResFrontBuffer() { return m_pHighResFrontBuffer; }

	void Update();
	void ProcessScene(int sceneFlags);

	void CopyToStereo(int channel);
	void DisplayStereo();

	void BeginRenderingMRT();
	void EndRenderingMRT(bool bResolve = true);

  void ResolveStereoBuffers();

	void BeginRenderingTo(Eye eye);
	void EndRenderingTo(Eye eye);

private:
	CD3D9Renderer& m_renderer;

	StereoMode m_mode;
	StereoOutput m_output;

	CTexture *m_pHighResFrontBuffer;

	void CreateResources();
	void DestroyResources();
	void CreateHighResFrontBuffer();

	void RenderScene(int sceneFlags);

	void SelectShaderTechnique();

	bool IsRenderThread() const;
	void CopyToStereoFromMainThread(int channel);

  void PushRenderTargets();
  void PopRenderTargets(bool bResolve);
};

#endif
