#ifndef __CRYDXPSRDRASTMATH__
#define __CRYDXPSRDRASTMATH__


/*
#define SWIZZLEMASK5(X,Y,Z,W){0x00+X*4,0x01+X*4,0x02+X*4,0x03+X*4,\
															0x00+Y*4,0x01+Y*4,0x02+Y*4,0x03+Y*4,\
															0x10+Z*4,0x11+Z*4,0x12+Z*4,0x13+Z*4,\
															0x10+W*4,0x11+W*4,0x12+W*4,0x13+W*4};
#define SWIZZLEMASK4(N,X,Y,Z)	const qword	N##x	=	SWIZZLEMASK5(X,Y,Z,0);\
															const qword	N##y	=	SWIZZLEMASK5(X,Y,Z,1);\
															const qword	N##z	=	SWIZZLEMASK5(X,Y,Z,2);\
															const qword	N##w	=	SWIZZLEMASK5(X,Y,Z,3);
#define SWIZZLEMASK3(N,X,Y)												SWIZZLEMASK4(N##x,X,Y,0)\
																									SWIZZLEMASK4(N##y,X,Y,1)\
																									SWIZZLEMASK4(N##z,X,Y,2)\
																									SWIZZLEMASK4(N##w,X,Y,3)
#define SWIZZLEMASK2(N,X)													SWIZZLEMASK3(N##x,X,0)\
																									SWIZZLEMASK3(N##y,X,1)\
																									SWIZZLEMASK3(N##z,X,2)\
																									SWIZZLEMASK3(N##w,X,3)
#define SWIZZLEMASK1															SWIZZLEMASK2(x,0)\
																									SWIZZLEMASK2(y,1)\
																									SWIZZLEMASK2(z,2)\
																									SWIZZLEMASK2(w,3)
*/
#define SWIZZLEMASK1\
	const qword xxxx = (qword){0, 1, 2, 3, 0, 1, 2, 3, 16, 17, 18, 19, 16, 17, 18, 19};\
	const qword yyyy = (qword){4, 5, 6, 7, 4, 5, 6, 7, 20, 21, 22, 23, 20, 21, 22, 23};\
	const qword zzzz = (qword){8, 9, 10, 11, 8, 9, 10, 11, 24, 25, 26, 27, 24, 25, 26, 27};\
	const qword wwww = (qword){12, 13, 14, 15, 12, 13, 14, 15, 28, 29, 30, 31, 28, 29, 30, 31};\
	const qword zwzw = (qword){8, 9, 10, 11, 12, 13, 14, 15, 24, 25, 26, 27, 28, 29, 30, 31};\
	const qword xzww = (qword){0, 1, 2, 3, 8, 9, 10, 11, 28, 29, 30, 31, 28, 29, 30, 31};

	RILNM qword		qwordZero()
								{
									return (qword)(vec_float4){0.f,0.f,0.f,0.f};
								}
	RILNM qword		qword0123()
								{
									return (qword)(vec_float4){0.f,1.f,2.f,3.f};
								}
	RILNM qword		qword4567()
								{
									return (qword)(vec_float4){4.f,5.f,6.f,7.f};
								}

	RILNM qword		qwordZeroHomogenous()
								{
									return (qword)(vec_float4){0.f,0.f,0.f,1.f};
								}

	RILNM qword		qwordNear1()
								{
									return (qword)(vec_float4){1.f-FLT_EPSILON,1.f-FLT_EPSILON,1.f-FLT_EPSILON,1.f-FLT_EPSILON};
								}
	RILNM qword		qword1()
								{
									return (qword)(vec_float4){1.f,1.f,1.f,1.f};
								}
	RILNM qword		qword2()
								{
									return (qword)(vec_float4){2.f,2.f,2.f,2.f};
								}
	RILNM qword		qword3()
								{
									return (qword)(vec_float4){3.f,3.f,3.f,3.f};
								}
	RILNM qword		qword4()
								{
									return (qword)(vec_float4){4.f,4.f,4.f,4.f};
								}
	RILNM qword		qword5()
								{
									return (qword)(vec_float4){5.f,5.f,5.f,5.f};
								}
	RILNM qword		qword6()
								{
									return (qword)(vec_float4){6.f,6.f,6.f,6.f};
								}
	RILNM qword		qword7()
								{
									return (qword)(vec_float4){7.f,7.f,7.f,7.f};
								}
	RILNM qword		qword512()
								{
									return (qword)(vec_float4){512.f,512.f,512.f,512.f};
								}

	RILNM qword		qwordFFFFFFFF()
								{
									return (qword){0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff};
								}

	RILNM qword		qwordEpsilon()
								{
									return (qword)(vec_float4){FLT_EPSILON,FLT_EPSILON,FLT_EPSILON,FLT_EPSILON};
								}

	RILNM qword		qwordEpsilonNeg()
								{
									return (qword)(vec_float4){-FLT_EPSILON,-FLT_EPSILON,-FLT_EPSILON,-FLT_EPSILON};
								}
	RILNM qword		qwordRange()
								{
									const float RANGE		=	static_cast<float>((1<<24)-1);
									return (qword)(vec_float4){RANGE,RANGE,RANGE,RANGE};
								}
	RILNM qword		qwordSplat()
								{
									const	qword qSPLAT	=	{0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03};
									return qSPLAT;
								}


	typedef qword	ESwizzleMask;//can be an enum for SSE

	RILNM qword		V_Swizzle(qword V,ESwizzleMask M)
								{
									return si_shufb(V,V,M);
								}
	RILNM qword		V_Shuffle(qword V1,qword V2,ESwizzleMask M)
								{
									return si_shufb(V1,V2,M);
								}
	RILNM qword		V_Abs(qword V)
								{
									const qword Mask	=	(qword){0x7f,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0x7f,0xff,0xff,0xff};
									return si_and(V,Mask);
								}
	RILNM qword		V_Add(qword V1,qword V2)
								{
									return si_fa(V1,V2);
								}
	RILNM qword		V_Sub(qword V1,qword V2)
								{
									return si_fs(V1,V2);
								}
	RILNM qword		V_Mul(qword V1,qword V2)
								{
									return si_fm(V1,V2);
								}
	RILNM qword		V_Rcp(qword V)
								{
									return si_fi(V,si_frest(V));
								}
	RILNM qword		V_RcpFAST(qword V)
								{
									return si_frest(V);
								}	
	RILNM qword		V_Div(qword V1,qword V2)
								{
									return V_Mul(V1,V_Rcp(V2));
								}
	RILNM qword		V_DivFAST(qword V1,qword V2)
								{
									return V_Mul(V1,V_RcpFAST(V2));
								}

	RILNM qword		V_Madd(qword V0,qword V1,qword V2)
								{
									return si_fma(V0,V1,V2);
								}
	RILNM qword		V_Msub(qword V0,qword V1,qword V2)
								{
									return si_fms(V0,V1,V2);
								}
	RILNM qword		V_NMsub(qword V0,qword V1,qword V2)
								{
									return si_fnms(V0,V1,V2);
								}


	RILNM qword		V_CmpEq(qword V0,qword V1)
								{
									return si_fceq(V0,V1);
								}
	RILNM qword		V_CmpGt(qword V0,qword V1)
								{
									return si_fcgt(V0,V1);
								}
	RILNM qword		V_CmpLE(qword V0,qword V1)
								{
									return V_CmpGt(V1,V0);
								}
	RILNM uint32	V_SignMaskF32(qword V)
								{
									return si_to_int(si_gb(V_CmpGt(qwordZero(),V)));
								}
	RILNM uint32	V_SignMaskS32(qword V)
								{
									return si_to_int(si_gb(V));
								}
	RILNM qword		V_And(qword V1,qword V2)
								{
									return si_and(V1,V2);
								}
	RILNM qword		V_Or(qword V1,qword V2)
								{
									return si_or(V1,V2);
								}
	RILNM qword		V_Xor(qword V1,qword V2)
								{
									return si_xor(V1,V2);
								}
	RILNM qword		V_Select(qword V1,qword V2,qword M)
								{
									return si_selb(V1,V2,M);
								}

	RILNM qword		V_Min(qword V0,qword V1)
								{
									return 	V_Select(V0,V1,V_CmpGt(V0,V1));
								}
	RILNM qword		V_Max(qword V0,qword V1)
								{
									return 	V_Select(V0,V1,V_CmpGt(V1,V0));
								}
	RILNM qword		V_F32ToQ(float V)
								{
									return si_from_float(V);
								}
	RILNM qword		V_F32Splat(float V)
								{
									return V_Swizzle(V_F32ToQ(V),qwordSplat());
								}
	RILNM float		V_QToF32(qword V)
								{
									return si_to_float(V);
								}
	RILNM int32		V_QToS32(qword V)
								{
									return si_to_int(V);
								}
	RILNM qword		V_F32ToS32(qword V)
								{
									return si_cflts(V,0);
								}
	RILNM qword		V_S32ToF32(qword V)
								{
									return si_csflt(V,0);
								}

	RILNM qword		V_F32ToU32Sat(qword V)
								{
								#if !defined(__SPU__)
									//a lot of funky stuff, just cause a 32bit shift does not work on ppu side, like on spu
									const	qword qONE		=	(qword)(vec_float4){0.99999f,0.99999f,0.99999f,0.99999f};
									const	qword qZERO		=	(qword)(vec_float4){0.f,0.f,0.f,0.f};
									const	qword qHALF		=	(qword)(vec_float4){0.5f,0.5f,0.5f,0.5f};
//									V	=	V_Max(qZERO,V);
									V	=	V_Min(qONE,V);
									V	=	si_fm(qHALF,V);
									V	=	si_cfltu(V,31);
									V	=	si_a(V,V);
								#else
									V	=	 si_cfltu(V,32u);
								#endif
									return V;
								}


#endif

