#ifndef __CCRYALLOCPOOL__
#define __CCRYALLOCPOOL__

namespace NGCMPoolAlloc
{

//////////////////////////////////////////////////////////
//	Items
//////////////////////////////////////////////////////////

//basic item for pool allocation used in-place
template<class T>
class CItemInPlace;

template<class T>
class CItemInPlace
{
	T*										m_pPrev;
	T*										m_pNext;
	size_t								m_FreeMem;
#if defined(CRY_MM_VALIDATE_DYN_ALLOC)
	size_t								m_Sign;
	size_t								m_Backup[3];
#endif
public:

#if defined(CRY_MM_VALIDATE_DYN_ALLOC)
	void									Sign()
												{
													const size_t* pData	=	reinterpret_cast<size_t*>(this);
													m_Sign	=	pData[0]^pData[1]^pData[2];
													m_Backup[0]	=	pData[0];
													m_Backup[1]	=	pData[1];
													m_Backup[2]	=	pData[2];
												}

	void									CheckSign()
												{
													const size_t* pData	=	reinterpret_cast<size_t*>(this);
													if(m_Sign^pData[0]^pData[1]^pData[2])
													{
														snPause();
													}
													if(m_Backup[0]	!=	pData[0])
													{
														snPause();
													}
													if(m_Backup[1]	!=	pData[1])
													{
														snPause();
													}
													if(m_Backup[2]	!=	pData[2])
													{
														snPause();
													}
												}
#endif

	void									Init(size_t Size)
												{
													m_pPrev		=
													m_pNext		=	0;
													m_FreeMem	=	1;
												}
	T*										Prev(){return m_pPrev;}
	T*										Next(){return m_pNext;}
	const T*							Prev()const{return m_pPrev;}
	const T*							Next()const{return m_pNext;}
	void									Prev(T*	pPrev){	m_pPrev=pPrev;	}
	void 									Next(T*	pNext){	m_pNext=pNext;	}
	size_t								MemSize()const{return reinterpret_cast<const uint8*>(m_pNext)-reinterpret_cast<const uint8*>(this)-sizeof(T);}//m_MemSize;}
	
	uint8*								Data(){return reinterpret_cast<uint8*>(this)+sizeof(T);}

	bool									IsFree()const{return m_FreeMem;}
	void									Free(){m_FreeMem=1;}
	void									InUse(){m_FreeMem=0;}

	bool									Available(size_t Size,size_t Align)
												{
													size_t Offset	=	reinterpret_cast<size_t>(Data());
													if(Offset&(Align-1))	//not aligned?
														Size	+=	sizeof(T)+Align-1;	//then an intermedian node needs to fit
													return Size<=MemSize()	&&	IsFree();
												}

	//need first/last checks?
	T*										Split(size_t Size,size_t Align)
												{
													size_t Offset	=	reinterpret_cast<size_t>(Data());
													Offset+=MemSize();	//ptr to end
													Offset-=Size;				//minus size
													Size	+=Offset&(Align-1);	//adjust size to fit required alignment
													Offset-=Offset&(Align-1);
													size_t TSize	=	sizeof(T);
													Offset-=TSize;	//header

													if(Offset<=reinterpret_cast<size_t>(this)+sizeof(T))
														return reinterpret_cast<T*>(this);

													T* pNextItem	=	reinterpret_cast<T*>(Offset);

													const size_t Offset2	=	reinterpret_cast<size_t>(pNextItem->Data());
													if(Offset2&(Align-1))
													{
														snPause();
													}													
													pNextItem->Prev(reinterpret_cast<T*>(this));
													pNextItem->Next(Next());

													if(Next())
														Next()->Prev(pNextItem);

													Next(pNextItem);
													return pNextItem;
												}
};

//free-list item
class CItemInPlaceFL;
class CItemInPlaceFL	:	public	CItemInPlace<CItemInPlaceFL>
{
	CItemInPlaceFL*				m_pNextFree;
public:
	void									Init(size_t Size)
												{
													CItemInPlace<CItemInPlaceFL>::Init(Size);
												}
	CItemInPlaceFL*				NextFree(){return m_pNextFree;}
	CItemInPlaceFL**			NextFreePtr(){return &m_pNextFree;}
	const CItemInPlaceFL*	NextFree()const{return m_pNextFree;}
	void 									NextFree(CItemInPlaceFL*	pNext){	m_pNextFree=pNext;	}

};

class CItemInPlaceDirect;
class CItemInPlaceDirect	:	public	CItemInPlace<CItemInPlaceDirect>
{
public:
	void									Init(size_t Size)
												{
													CItemInPlace<CItemInPlaceDirect>::Init(Size);
												}

};

//////////////////////////////////////////////////////////
//	Pool
//////////////////////////////////////////////////////////

template<size_t HEADER_POOL_SIZE>
class CPool
{
protected:
	uint8*								m_pData;
	uint8*								m_pAllocated;
	size_t								m_Size;

	void									Init(size_t Size,uint8* pData)
												{
													for(size_t a=0;a<Size;a++)
														pData[a]=~0;
													m_pData	=	pData;
													m_Size	=	Size;
												}
	void									Beat(){}

	uint8*								Raw(){return m_pData;}

public:
												CPool(size_t Size,uint32 Align)
												{
													assert(Align>=1);
													m_pAllocated		=	new uint8[Size+Align-1];
													size_t	Offset	=	reinterpret_cast<size_t>(m_pAllocated);
													Offset	=	(Offset+Align-1)&~(Align-1);
													Init(Size,reinterpret_cast<uint8*>(Offset));
												}
												CPool(size_t Size,uint8* pData):
												m_pAllocated(0)
												{
													Init(Size,pData);
												}
												~CPool()
												{
													delete[]	m_pAllocated;
												}
};

template<class TItem,class TBasePool>
class CPoolBestFit	:	public	TBasePool
{
protected:
	TItem*								m_pFreeListLast  _ALIGN(128);
	TItem*								m_pFreeListFirst;
	TItem*								m_pFirst;
	TItem*								m_pLast;

	TItem*								m_pEmpty;

#if defined(CRY_MM_VALIDATE_DYN_ALLOC)
	size_t								m_DynSize;
	size_t								m_TransactionID;
	size_t								m_Allocs;
	size_t								m_Frees;
	size_t								m_FreeLists;
#endif

	void									Init(size_t Size,uint8* pData)
												{
#if defined(CRY_MM_VALIDATE_DYN_ALLOC)
#endif

													m_pEmpty					=	0;

													m_pFirst					=	reinterpret_cast<TItem*>(pData);
													TItem* pItem			=	m_pFirst+1;
													m_pLast						=	reinterpret_cast<TItem*>(pData+Size)-1;

													m_pFirst->Prev(0);
													m_pFirst->Next(pItem);
													pItem->Prev(m_pFirst);
													pItem->Next(m_pLast);
													m_pLast->Prev(pItem);
													m_pLast->Next(0);

													m_pFirst->InUse();	//static first item
													pItem->Free();
													m_pLast->InUse();	//static last item

													m_pFreeListFirst	=
													m_pFreeListLast		=	pItem->Split(0,1);
													m_pFreeListFirst->NextFree(0);
													m_pFreeListFirst->InUse();
													m_pFreeListFirst->NextFree(0);

#if defined(CRY_MM_VALIDATE_DYN_ALLOC)
													m_DynSize					=	0;
													m_TransactionID		=	0;
													m_Allocs					=
													m_Frees						=	
													m_FreeLists				=	0;
													Validate(true);
													Validate(false);
#endif
												}

	TItem*								Merge(TItem* pItem)
												{
													//merge with next if possible
													TItem* pItemNext	=	pItem->Next();
													if(pItemNext->IsFree())
													{
														pItem->Next(pItemNext->Next());
														pItem->Next()->Prev(pItem);
													}
													//merge with prev if possible
													TItem* pItemPrev	=	pItem->Prev();
													if(pItemPrev->IsFree())
													{
														pItemPrev->Next(pItem->Next());
														pItem->Next()->Prev(pItemPrev);
														pItem	=	 pItemPrev;
													}
													return pItem;
												}
	void									Free(TItem* pItem)
												{
#if defined(CRY_MM_VALIDATE_DYN_ALLOC)
													m_Frees++;
													size_t S	=		pItem->Next()?(((size_t)pItem->Next())-(size_t)pItem):pItem->MemSize();
													m_DynSize	-=	S;


//													printf("f(%d) Dyn alloca: 0x%x %d %d\n",++m_TransactionID,(int)pItem->Data(),m_DynSize,S);
													asm volatile("nop");
													Validate(false);
													asm volatile("nop");
#endif
													pItem->Free();
													pItem	=	Merge(pItem);
#if defined(CRY_MM_VALIDATE_DYN_ALLOC)
													uint8* pBuffer	=	pItem->Data();
													for(size_t a=0,S=pItem->MemSize();a<S;a++)
														pBuffer[a]	=	0xff;

													asm volatile("nop");
													Validate(true);
													Validate(false);
													asm volatile("nop");
#endif
												}
	void									Beat()
												{
													while(m_pFreeListFirst->NextFree())
													{
														TItem* pItem	=	m_pFreeListFirst;
														m_pFreeListFirst	=	m_pFreeListFirst->NextFree();
														Free(pItem);
													}
												}
public:
	template<class T>
												CPoolBestFit(size_t Size,T Param2):
												TBasePool(Size,Param2)
												{
													Init(Size,TBasePool::Raw());
#if defined(CRY_MM_VALIDATE_DYN_ALLOC)
													asm volatile("nop");
													Validate(true);
													Validate(false);
													asm volatile("nop");
#endif
												}

	uint8*								Alloc(size_t Size,size_t Align=1)
												{
#if defined(CRY_MM_VALIDATE_DYN_ALLOC)
													m_Allocs++;
													++m_TransactionID;
//													if((m_TransactionID&((1<<14)-1))==0)
														printf("--%d--%d %d %f a:%d fl:%d f:%d\n",m_TransactionID,m_DynSize,TBasePool::m_Size,(float)m_DynSize/(float)TBasePool::m_Size*100.f,m_Allocs,m_FreeLists,m_Frees);
													asm volatile("nop");
													Validate(false);
													asm volatile("nop");
#endif
													//fastpath?
													if(m_pEmpty &&	m_pEmpty->Available(Size,Align))
													{
														TItem* pItem	=	m_pEmpty->Split(Size,Align);
														pItem->InUse();
														pItem->NextFree(0);

														//not fully occupied empty space?
														m_pEmpty	=	pItem!=m_pEmpty?m_pEmpty:0;
#if defined(CRY_MM_VALIDATE_DYN_ALLOC)
														size_t S	=	pItem->Next()?(((size_t)pItem->Next())-(size_t)pItem):pItem->MemSize();
														m_DynSize+=S;
														asm volatile("nop");
														Validate(true);
														Validate(false);
														asm volatile("nop");
#endif
														return pItem->Data();
													}

													TItem* pBestItem	=	0;
													do
													{
														Beat();
														for(TItem* pItem=m_pFirst;pItem;pItem=pItem->Next())
														{
															if(pItem->Available(Size,Align))// && (!pBestItem || pItem->MemSize()<pBestItem->MemSize()))
															{
																pBestItem	=	pItem;
																break;
															}
														}
													}while(!pBestItem);

													TItem* pItem	=	pBestItem->Split(Size,Align);
													pItem->InUse();
													pItem->NextFree(0);

													//not fully occupied empty space?
													m_pEmpty	=	pItem!=pBestItem?pBestItem:0;

#if defined(CRY_MM_VALIDATE_DYN_ALLOC)
													size_t S	=	pItem->Next()?(((size_t)pItem->Next())-(size_t)pItem):pItem->MemSize();
													m_DynSize+=S;
													asm volatile("nop");
													Validate(true);
													Validate(false);
													asm volatile("nop");

//													printf("a(%d) Dyn alloca: 0x%x %d %d %d\n",++m_TransactionID,(int)pItem->Data(),m_DynSize,S,Size);
													const size_t Offset	=	reinterpret_cast<size_t>(pItem->Data());
													if(Offset&(Align-1))
													{
														snPause();
													}
#endif
													return pItem->Data();
												}
	template<class T>
	void									Free(T* pData)
												{
													TItem* _ALIGN(16) pItem	=	reinterpret_cast<TItem*>(pData)-1;
#if defined(CRY_MM_VALIDATE_DYN_ALLOC)
//													__spu_flush_cache();
													m_FreeLists++;
													size_t S	=	pItem->Next()?(((size_t)pItem->Next())-(size_t)pItem):pItem->MemSize();
//													printf("l(%d) Dyn alloca: 0x%x %d %d\n",++m_TransactionID,(int)pData,m_DynSize,S);
#endif
#if defined(__SPU__)
//													__spu_zero_mem_no_cache_no_sync(SPU_MAIN_PTR(pItem->NextFreePtr()),sizeof(pItem->NextFreePtr()),true/*fenced*/,0);
//													memtransfer_to_main_fenced(m_pFreeListLast->NextFreePtr(),&pItem,4,0);
													//TItem Item	_ALIGN(16);
													//Item.NextFree(pItem);
													//memtransfer_to_main(SPU_MAIN_PTR(m_pFreeListLast->NextFreePtr()),Item.NextFreePtr(),sizeof(Item),0);
													//memtransfer_sync(0);
#endif
													m_pFreeListLast->NextFree(pItem);
													m_pFreeListLast		=	pItem;
												}

#if defined(CRY_MM_VALIDATE_DYN_ALLOC)
	void									Validate(bool Sign)
												{
													TItem* pItem =	m_pFirst;
													size_t SIZE	=	sizeof(TItem);
													uint32 Count=	0;
													uint32 Size	=	0;
													while(pItem->Next())
													{
														if(Sign)
															pItem->Sign();
														else
															pItem->CheckSign();
														if(pItem->Next()->Prev()!=pItem)
														{
															snPause();
														}
														Size+=pItem->MemSize()+sizeof(TItem);
														const size_t ISize0	=	pItem->MemSize();
														const size_t ISize1	=	reinterpret_cast<uint8*>(pItem->Next())-pItem->Data();
														if(ISize0!=ISize1)
														{
															snPause();
														}
														pItem	=	pItem->Next();
														Count++;
													}
													//Size+=pItem->MemSize()+sizeof(TItem);
													//if(Size!=TBasePool::m_Size)
													//{
													//	snPause();
													//}
												}
#endif
};
/*
template<class TBasePool>
class CPoolFreeList	:	public	TBasePool
{
	TBasePool::CItem*			m_pFreeItems;
public:
	template<class T>
												CPoolFreeList(size_t Size,T Param2):
												TBasePool(Size,Param2),
												m_pFreeItems(0)
												{
												}

	template<bool FailAssert>
	uint8*								Alloc(size_t Size,size_t Align=1)
												{
													ClearFrees();
													TBasePool::Alloc(Size,Align);
												}
	template<class T>
	void									Free(T* pData)
												{
													TBasePool::Item* pItem	=	reinterpret_cast<TBasePool::Item*>(pData)-1;

												}
};


template<class TBasePool>
class CPoolFreeDirect	:	public	TBasePool
{
public:
	template<class T>
												CPoolFreeDirect(size_t Size,T Param2):
												TBasePool(Size,Param2)
												{
												}
	template<class T>
	void									Free(T* pData)
												{
													TBasePool::Item* pItem;//	=	reinterpret_cast<TBasePool::CItem*>(pData)-1;
													//pItem->Free();
													//Merge(pItem);
												}
};
*/


}

#endif

