#ifndef __CRYDXPSGCM_CMBMAN__
#define __CRYDXPSGCM_CMBMAN__

#include "CCryDXPSGCM_SyncMan.hpp"

#define RSXINJECTION_LOCK AUTO_LOCK_T(CryCriticalSectionNonRecursive, tdLayer0::CMB().CopyLock())

class CCryDXPSGCMCMBMan
{
public:
	CryCriticalSectionNonRecursive& CopyLock(){return m_CopyLock;}
private:
	tdResHandle					m_SegmentHandle[GCM_CMD_SEGMENTCOUNT];
	uint32							m_CmdBufferOffset;
	uint32							m_LastUsedSegment;
	int									m_Initialized;	//for debugging
	void*								m_pTransferBuffer;
	uint32							m_TransferBufferOff;
	uint32							m_OffsetTransferCmdBuffer;
	CryCriticalSectionNonRecursive m_CopyLock;

	uint32							Segment(const uint32 Idx)const
											{
												return (Idx/GCM_CMD_SEGMENTSIZE)&GCM_CMD_SEGMENTMASK;
											}
public:
											CCryDXPSGCMCMBMan():
											m_Initialized(0){}

	void								Init();

	void								NextCMDs();
	void								FlushCMDs();
	uint32						  CmdBufferOffset() const{return m_CmdBufferOffset;}

	//void*								SyncMemory();

	void								Size(class ICrySizer* Sizer);
	bool								InjectCopy(void* pDst,const void* pSrc,size_t Size, CallbackFunc Callback=NULL, bool sleep = true);
};

#endif

