#ifndef __d3d10_h__
#define __d3d10_h__

#pragma once
#if defined(PS3) && defined(DO_RENDERLOG) && !defined(__SPU__)
#define eCryModule eCryM_Render
#include <CryModuleDefs.h>
#include <platform.h>
#include <DXPS/CCryDXPSGuid.hpp>
#include <DXPS/CCryDXPSMisc.hpp>
#include <DXPS/Device/Resource/Buffer/CCryDXPSBuffer.hpp>

typedef unsigned long		ULONG;
typedef long 						HRESULT;
typedef unsigned int		uint32;
typedef uint32					UINT;
#ifndef __in_range
	#define __in_range(from,to)
#endif
#ifndef __in_opt
	#define __in_opt
#endif
#ifndef __in_ecount
	#define __in_ecount(c)
#endif
#ifndef __in
	#define __in
#endif
#ifndef __out
	#define __out
#endif
#ifndef __out_ecount_opt
	#define __out_ecount_opt(c)
#endif
#ifndef __in_xcount_opt
	#define __in_xcount_opt(c)
#endif
#ifndef __in_ecount_opt
	#define __in_ecount_opt(c)
#endif
#ifndef __out_opt
	#define __out_opt
#endif
#ifndef __out_ecount
	#define __out_ecount(c)
#endif
#ifndef __inout
	#define __inout
#endif
#ifndef __out_bcount_opt
	#define __out_bcount_opt(c)
#endif
#ifndef __in_bcount_opt
	#define __in_bcount_opt(c)
#endif

//struct IID;
//typedef IID* REFIID;
/*
struct ID3D10Buffer;
struct ID3D10ShaderResourceView;
struct ID3D10PixelShader;
struct ID3D10SamplerState;
struct ID3D10VertexShader;
struct ID3D10InputLayout;
struct ID3D10GeometryShader;
struct D3D10_BLEND_DESC;
struct ID3D10BlendState;
struct ID3D10DepthStencilState;
struct D3D10_RASTERIZER_DESC;
struct ID3D10RasterizerState;
struct D3D10_QUERY_DESC;
struct ID3D10Query;
struct ID3D10Predicate;
struct D3D10_COUNTER_DESC;
struct ID3D10Counter;
struct D3D10_COUNTER_INFO;
struct D3D10_COUNTER_TYPE;
struct ID3D10RenderTargetView;
struct ID3D10DepthStencilView;
struct D3D10_RECT;
struct ID3D10Resource;
*/

struct IUnknown
{
	virtual HRESULT QueryInterface(REFIID riid, void **ppvObject) = 0;
	virtual ULONG AddRef(void) = 0;
  virtual ULONG Release(void) = 0;
};

struct ID3D10Device : public IUnknown
{
public:
    virtual void STDMETHODCALLTYPE VSSetConstantBuffers( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )  UINT NumBuffers,
        /*  */ 
        __in_ecount(NumBuffers)  ID3D10Buffer *const *ppConstantBuffers) = 0;
    
    virtual void STDMETHODCALLTYPE PSSetShaderResources( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )  UINT NumViews,
        /*  */ 
        __in_ecount(NumViews)  ID3D10ShaderResourceView *const *ppShaderResourceViews) = 0;
    
    virtual void STDMETHODCALLTYPE PSSetShader( 
        /*  */ 
        __in_opt  ID3D10PixelShader *pPixelShader) = 0;
    
    virtual void STDMETHODCALLTYPE PSSetSamplers( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )  UINT NumSamplers,
        /*  */ 
        __in_ecount(NumSamplers)  ID3D10SamplerState *const *ppSamplers,
				
				const float* pMin,const float* pMax,const float* pMipBias,uint16* psRGB = 0)
		{
			PSSetSamplers(StartSlot,NumSamplers,ppSamplers,pMipBias,psRGB);
		}
   
    virtual void STDMETHODCALLTYPE VSSetShader( 
        /*  */ 
        __in_opt  ID3D10VertexShader *pVertexShader) = 0;
    
    virtual void STDMETHODCALLTYPE DrawIndexed( 
        /*  */ 
        __in  UINT IndexCount,
        /*  */ 
        __in  UINT StartIndexLocation,
        /*  */ 
        __in  INT BaseVertexLocation) = 0;
    
    virtual void STDMETHODCALLTYPE Draw( 
        /*  */ 
        __in  UINT VertexCount,
        /*  */ 
        __in  UINT StartVertexLocation) = 0;
    
    virtual void STDMETHODCALLTYPE PSSetConstantBuffers( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )  UINT NumBuffers,
        /*  */ 
        __in_ecount(NumBuffers)  ID3D10Buffer *const *ppConstantBuffers) = 0;
    
    virtual void STDMETHODCALLTYPE IASetInputLayout( 
        /*  */ 
        __in_opt  ID3D10InputLayout *pInputLayout) = 0;
    
    virtual void STDMETHODCALLTYPE IASetVertexBuffers( 
        /*  */ 
        __in_range( 0, D3D10_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT - StartSlot )  UINT NumBuffers,
        /*  */ 
        __in_ecount(NumBuffers)  ID3D10Buffer *const *ppVertexBuffers,
        /*  */ 
        __in_ecount(NumBuffers)  const UINT *pStrides,
        /*  */ 
        __in_ecount(NumBuffers)  const UINT *pOffsets) = 0;
    
    virtual void STDMETHODCALLTYPE IASetIndexBuffer( 
        /*  */ 
        __in_opt  ID3D10Buffer *pIndexBuffer,
        /*  */ 
        __in  DXGI_FORMAT Format,
        /*  */ 
        __in  UINT Offset) = 0;
    
    virtual void STDMETHODCALLTYPE DrawIndexedInstanced( 
        /*  */ 
        __in  UINT IndexCountPerInstance,
        /*  */ 
        __in  UINT InstanceCount,
        /*  */ 
        __in  UINT StartIndexLocation,
        /*  */ 
        __in  INT BaseVertexLocation,
        /*  */ 
        __in  UINT StartInstanceLocation) = 0;
    
    virtual void STDMETHODCALLTYPE DrawInstanced( 
        /*  */ 
        __in  UINT VertexCountPerInstance,
        /*  */ 
        __in  UINT InstanceCount,
        /*  */ 
        __in  UINT StartVertexLocation,
        /*  */ 
        __in  UINT StartInstanceLocation) = 0;
    
    virtual void STDMETHODCALLTYPE GSSetConstantBuffers( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )  UINT NumBuffers,
        /*  */ 
        __in_ecount(NumBuffers)  ID3D10Buffer *const *ppConstantBuffers) = 0;
    
    virtual void STDMETHODCALLTYPE GSSetShader( 
        /*  */ 
        __in_opt  ID3D10GeometryShader *pShader) = 0;
    
    virtual void STDMETHODCALLTYPE IASetPrimitiveTopology( 
        /*  */ 
        __in  D3D10_PRIMITIVE_TOPOLOGY Topology) = 0;
    
    virtual void STDMETHODCALLTYPE VSSetShaderResources( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )  UINT NumViews,
        /*  */ 
        __in_ecount(NumViews)  ID3D10ShaderResourceView *const *ppShaderResourceViews) = 0;
    
    virtual void STDMETHODCALLTYPE VSSetSamplers( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )  UINT NumSamplers,
        /*  */ 
        __in_ecount(NumSamplers)  ID3D10SamplerState *const *ppSamplers) = 0;
    
    virtual void STDMETHODCALLTYPE SetPredication( 
        /*  */ 
        __in_opt  ID3D10Predicate *pPredicate,
        /*  */ 
        __in  BOOL PredicateValue) = 0;
    
    virtual void STDMETHODCALLTYPE GSSetShaderResources( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )  UINT NumViews,
        /*  */ 
        __in_ecount(NumViews)  ID3D10ShaderResourceView *const *ppShaderResourceViews) = 0;
    
    virtual void STDMETHODCALLTYPE GSSetSamplers( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )  UINT NumSamplers,
        /*  */ 
        __in_ecount(NumSamplers)  ID3D10SamplerState *const *ppSamplers) = 0;
    
    virtual void STDMETHODCALLTYPE OMSetRenderTargets( 
        /*  */ 
        __in_range( 0, D3D10_SIMULTANEOUS_RENDER_TARGET_COUNT )  UINT NumViews,
        /*  */ 
        __in_ecount_opt(NumViews)  ID3D10RenderTargetView *const *ppRenderTargetViews,
        /*  */ 
        __in_opt  ID3D10DepthStencilView *pDepthStencilView) = 0;
    
    virtual void STDMETHODCALLTYPE OMSetBlendState( 
        /*  */ 
        __in_opt  ID3D10BlendState *pBlendState,
        /*  */ 
        __in  const FLOAT BlendFactor[ 4 ],
        /*  */ 
        __in  UINT SampleMask) = 0;
    
    virtual void STDMETHODCALLTYPE OMSetDepthStencilState( 
        /*  */ 
        __in_opt  ID3D10DepthStencilState *pDepthStencilState,
        /*  */ 
        __in  UINT StencilRef) = 0;
    
    virtual void STDMETHODCALLTYPE SOSetTargets( 
        /*  */ 
        __in_range( 0, D3D10_SO_BUFFER_SLOT_COUNT)  UINT NumBuffers,
        /*  */ 
        __in_ecount_opt(NumBuffers)  ID3D10Buffer *const *ppSOTargets,
        /*  */ 
        __in_ecount_opt(NumBuffers)  const UINT *pOffsets) = 0;
    
    virtual void STDMETHODCALLTYPE DrawAuto( void) = 0;
    
    virtual void STDMETHODCALLTYPE RSSetState( 
        /*  */ 
        __in_opt  ID3D10RasterizerState *pRasterizerState ) = 0;
    
    virtual void STDMETHODCALLTYPE RSSetViewports( 
        /*  */ 
        __in_range(0, D3D10_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE)  UINT NumViewports,
        /*  */ 
        __in_ecount_opt(NumViewports)  const D3D10_VIEWPORT *pViewports) = 0;
    
    virtual void STDMETHODCALLTYPE RSSetScissorRects( 
        /*  */ 
        __in_range(0, D3D10_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE)  UINT NumRects,
        /*  */ 
        __in_ecount_opt(NumRects)  const D3D10_RECT *pRects) = 0;
    
    virtual void STDMETHODCALLTYPE CopySubresourceRegion( 
        /*  */ 
        __in  ID3D10Resource *pDstResource,
        /*  */ 
        __in  UINT DstSubresource,
        /*  */ 
        __in  UINT DstX,
        /*  */ 
        __in  UINT DstY,
        /*  */ 
        __in  UINT DstZ,
        /*  */ 
        __in  ID3D10Resource *pSrcResource,
        /*  */ 
        __in  UINT SrcSubresource,
        /*  */ 
        __in_opt  const D3D10_BOX *pSrcBox) = 0;
    
    virtual void STDMETHODCALLTYPE CopyResource( 
        /*  */ 
        __in  ID3D10Resource *pDstResource,
        /*  */ 
        __in  ID3D10Resource *pSrcResource) = 0;
    
    virtual void STDMETHODCALLTYPE UpdateSubresource( 
        /*  */ 
        __in  ID3D10Resource *pDstResource,
        /*  */ 
        __in  UINT DstSubresource,
        /*  */ 
        __in_opt  const D3D10_BOX *pDstBox,
        /*  */ 
        __in  const void *pSrcData,
        /*  */ 
        __in  UINT SrcRowPitch,
        /*  */ 
        __in  UINT SrcDepthPitch) = 0;
    
    virtual void STDMETHODCALLTYPE ClearRenderTargetView( 
        /*  */ 
        __in  ID3D10RenderTargetView *pRenderTargetView,
        /*  */ 
        __in  const FLOAT ColorRGBA[ 4 ]) = 0;
    
    virtual void STDMETHODCALLTYPE ClearDepthStencilView( 
        /*  */ 
        __in  ID3D10DepthStencilView *pDepthStencilView,
        /*  */ 
        __in  UINT ClearFlags,
        /*  */ 
        __in  FLOAT Depth,
        /*  */ 
        __in  UINT8 Stencil) = 0;
    
    virtual void STDMETHODCALLTYPE GenerateMips( 
        /*  */ 
        __in  ID3D10ShaderResourceView *pShaderResourceView) = 0;
    
    virtual void STDMETHODCALLTYPE ResolveSubresource( 
        /*  */ 
        __in  ID3D10Resource *pDstResource,
        /*  */ 
        __in  UINT DstSubresource,
        /*  */ 
        __in  ID3D10Resource *pSrcResource,
        /*  */ 
        __in  UINT SrcSubresource,
        /*  */ 
        __in  DXGI_FORMAT Format) = 0;
    
    virtual void STDMETHODCALLTYPE VSGetConstantBuffers( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )  UINT NumBuffers,
        /*  */ 
        __out_ecount(NumBuffers)  ID3D10Buffer **ppConstantBuffers) = 0;
    
    virtual void STDMETHODCALLTYPE PSGetShaderResources( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )  UINT NumViews,
        /*  */ 
        __out_ecount(NumViews)  ID3D10ShaderResourceView **ppShaderResourceViews) = 0;
    
    virtual void STDMETHODCALLTYPE PSGetShader( 
        /*  */ 
        __out  ID3D10PixelShader **ppPixelShader) = 0;
    
    virtual void STDMETHODCALLTYPE PSGetSamplers( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )  UINT NumSamplers,
        /*  */ 
        __out_ecount(NumSamplers)  ID3D10SamplerState **ppSamplers) = 0;
    
    virtual void STDMETHODCALLTYPE VSGetShader( 
        /*  */ 
        __out  ID3D10VertexShader **ppVertexShader) = 0;
    
    virtual void STDMETHODCALLTYPE PSGetConstantBuffers( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )  UINT NumBuffers,
        /*  */ 
        __out_ecount(NumBuffers)  ID3D10Buffer **ppConstantBuffers) = 0;
    
    virtual void STDMETHODCALLTYPE IAGetInputLayout( 
        /*  */ 
        __out  ID3D10InputLayout **ppInputLayout) = 0;
    
    virtual void STDMETHODCALLTYPE IAGetVertexBuffers( 
        /*  */ 
        __in_range( 0, D3D10_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT - StartSlot )  UINT NumBuffers,
        /*  */ 
        __out_ecount_opt(NumBuffers)  ID3D10Buffer **ppVertexBuffers,
        /*  */ 
        __out_ecount_opt(NumBuffers)  UINT *pStrides,
        /*  */ 
        __out_ecount_opt(NumBuffers)  UINT *pOffsets) = 0;
    
    virtual void STDMETHODCALLTYPE IAGetIndexBuffer( 
        /*  */ 
        __out_opt  ID3D10Buffer **pIndexBuffer,
        /*  */ 
        __out_opt  DXGI_FORMAT *Format,
        /*  */ 
        __out_opt  UINT *Offset) = 0;
    
    virtual void STDMETHODCALLTYPE GSGetConstantBuffers( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )  UINT NumBuffers,
        /*  */ 
        __out_ecount(NumBuffers)  ID3D10Buffer **ppConstantBuffers) = 0;
    
    virtual void STDMETHODCALLTYPE GSGetShader( 
        /*  */ 
        __out  ID3D10GeometryShader **ppGeometryShader) = 0;
    
    virtual void STDMETHODCALLTYPE IAGetPrimitiveTopology( 
        /*  */ 
        __out  D3D10_PRIMITIVE_TOPOLOGY *pTopology) = 0;
    
    virtual void STDMETHODCALLTYPE VSGetShaderResources( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )  UINT NumViews,
        /*  */ 
        __out_ecount(NumViews)  ID3D10ShaderResourceView **ppShaderResourceViews) = 0;
    
    virtual void STDMETHODCALLTYPE VSGetSamplers( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )  UINT NumSamplers,
        /*  */ 
        __out_ecount(NumSamplers)  ID3D10SamplerState **ppSamplers) = 0;
    
    virtual void STDMETHODCALLTYPE GetPredication( 
        /*  */ 
        __out_opt  ID3D10Predicate **ppPredicate,
        /*  */ 
        __out_opt  BOOL *pPredicateValue) = 0;
    
    virtual void STDMETHODCALLTYPE GSGetShaderResources( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )  UINT NumViews,
        /*  */ 
        __out_ecount(NumViews)  ID3D10ShaderResourceView **ppShaderResourceViews) = 0;
    
    virtual void STDMETHODCALLTYPE GSGetSamplers( 
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )  UINT StartSlot,
        /*  */ 
        __in_range( 0, D3D10_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )  UINT NumSamplers,
        /*  */ 
        __out_ecount(NumSamplers)  ID3D10SamplerState **ppSamplers) = 0;
    
    virtual void STDMETHODCALLTYPE OMGetRenderTargets( 
        /*  */ 
        __in_range( 0, D3D10_SIMULTANEOUS_RENDER_TARGET_COUNT )  UINT NumViews,
        /*  */ 
        __out_ecount_opt(NumViews)  ID3D10RenderTargetView **ppRenderTargetViews,
        /*  */ 
        __out_opt  ID3D10DepthStencilView **ppDepthStencilView) = 0;
    
    virtual void STDMETHODCALLTYPE OMGetBlendState( 
        /*  */ 
        __out_opt  ID3D10BlendState **ppBlendState,
        /*  */ 
        __out_opt  FLOAT BlendFactor[ 4 ],
        /*  */ 
        __out_opt  UINT *pSampleMask) = 0;
    
    virtual void STDMETHODCALLTYPE OMGetDepthStencilState( 
        /*  */ 
        __out_opt  ID3D10DepthStencilState **ppDepthStencilState,
        /*  */ 
        __out_opt  UINT *pStencilRef) = 0;
    
    virtual void STDMETHODCALLTYPE SOGetTargets( 
        /*  */ 
        __in_range( 0, D3D10_SO_BUFFER_SLOT_COUNT )  UINT NumBuffers,
        /*  */ 
        __out_ecount_opt(NumBuffers)  ID3D10Buffer **ppSOTargets,
        /*  */ 
        __out_ecount_opt(NumBuffers)  UINT *pOffsets) = 0;
    
    virtual void STDMETHODCALLTYPE RSGetState( 
        /*  */ 
        __out  ID3D10RasterizerState **ppRasterizerState) = 0;
    
    virtual void STDMETHODCALLTYPE RSGetViewports( 
        /*  */ 
        __inout /*_range(0, D3D10_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE )*/   UINT *NumViewports,
        /*  */ 
        __out_ecount_opt(NumViewports)  D3D10_VIEWPORT *pViewports) = 0;
    
    virtual void STDMETHODCALLTYPE RSGetScissorRects( 
        /*  */ 
        __inout /*_range(0, D3D10_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE )*/   UINT *NumRects,
        /*  */ 
        __out_ecount_opt(NumRects)  D3D10_RECT *pRects) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE GetDeviceRemovedReason( void) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE SetExceptionMode( 
        UINT RaiseFlags) = 0;
    
    virtual UINT STDMETHODCALLTYPE GetExceptionMode( void) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE GetPrivateData( 
        /*  */ 
        __in  REFGUID guid,
        /*  */ 
        __inout  UINT *pDataSize,
        /*  */ 
        __out_bcount_opt(*pDataSize)  void *pData) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE SetPrivateData( 
        /*  */ 
        __in  REFGUID guid,
        /*  */ 
        __in  UINT DataSize,
        /*  */ 
        __in_bcount_opt(DataSize)  const void *pData) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE SetPrivateDataInterface( 
        /*  */ 
        __in  REFGUID guid,
        /*  */ 
        __in_opt  const IUnknown *pData) = 0;
    
    virtual void STDMETHODCALLTYPE ClearState( void) = 0;
    
    virtual void STDMETHODCALLTYPE Flush( void) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateBuffer( 
        /*  */ 
        __in  const D3D10_BUFFER_DESC *pDesc,
        /*  */ 
        __in_opt  const D3D10_SUBRESOURCE_DATA *pInitialData,
        /*  */ 
        __out_opt  ID3D10Buffer **ppBuffer) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateTexture1D( 
        /*  */ 
        __in  const D3D10_TEXTURE1D_DESC *pDesc,
        /*  */ 
        __in_xcount_opt(pDesc->MipLevels * pDesc->ArraySize)  const D3D10_SUBRESOURCE_DATA *pInitialData,
        /*  */ 
        __out  ID3D10Texture1D **ppTexture1D) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateTexture2D( 
        /*  */ 
        __in  const D3D10_TEXTURE2D_DESC *pDesc,
        /*  */ 
        __in_xcount_opt(pDesc->MipLevels * pDesc->ArraySize)  const D3D10_SUBRESOURCE_DATA *pInitialData,
        /*  */ 
        __out  ID3D10Texture2D **ppTexture2D) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateTexture3D( 
        /*  */ 
        __in  const D3D10_TEXTURE3D_DESC *pDesc,
        /*  */ 
        __in_xcount_opt(pDesc->MipLevels)  const D3D10_SUBRESOURCE_DATA *pInitialData,
        /*  */ 
        __out  ID3D10Texture3D **ppTexture3D) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateShaderResourceView( 
        /*  */ 
        __in  ID3D10Resource *pResource,
        /*  */ 
        __in_opt  const D3D10_SHADER_RESOURCE_VIEW_DESC *pDesc,
        /*  */ 
        __out_opt  ID3D10ShaderResourceView **ppSRView) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateRenderTargetView( 
        /*  */ 
        __in  ID3D10Resource *pResource,
        /*  */ 
        __in_opt  const D3D10_RENDER_TARGET_VIEW_DESC *pDesc,
        /*  */ 
        __out_opt  ID3D10RenderTargetView **ppRTView) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateDepthStencilView( 
        /*  */ 
        __in  ID3D10Resource *pResource,
        /*  */ 
        __in_opt  const D3D10_DEPTH_STENCIL_VIEW_DESC *pDesc,
        /*  */ 
        __out_opt  ID3D10DepthStencilView **ppDepthStencilView) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateInputLayout( 
        /*  */ 
        __in_ecount(NumElements)  const D3D10_INPUT_ELEMENT_DESC *pInputElementDescs,
        /*  */ 
        __in_range( 0, D3D10_IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT )  UINT NumElements,
        /*  */ 
        __in  const void *pShaderBytecodeWithInputSignature,
        /*  */ 
        __in  SIZE_T BytecodeLength,
        /*  */ 
        __out_opt  ID3D10InputLayout **ppInputLayout) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateVertexShader( 
        /*  */ 
        __in  const void *pShaderBytecode,
        /*  */ 
        __in  SIZE_T BytecodeLength,
        /*  */ 
        __out_opt  ID3D10VertexShader **ppVertexShader) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateGeometryShader( 
        /*  */ 
        __in  const void *pShaderBytecode,
        /*  */ 
        __in  SIZE_T BytecodeLength,
        /*  */ 
				__out_opt  ID3D10GeometryShader **ppGeometryShader){}
    
    virtual HRESULT STDMETHODCALLTYPE CreateGeometryShaderWithStreamOutput( 
        /*  */ 
        __in  const void *pShaderBytecode,
        /*  */ 
        __in  SIZE_T BytecodeLength,
        /*  */ 
        __in_ecount_opt(NumEntries)  const D3D10_SO_DECLARATION_ENTRY *pSODeclaration,
        /*  */ 
        __in_range( 0, D3D10_SO_SINGLE_BUFFER_COMPONENT_LIMIT )  UINT NumEntries,
        /*  */ 
        __in  UINT OutputStreamStride,
        /*  */ 
				__out_opt  ID3D10GeometryShader **ppGeometryShader){}
    
    virtual HRESULT STDMETHODCALLTYPE CreatePixelShader( 
        /*  */ 
        __in  const void *pShaderBytecode,
        /*  */ 
        __in  SIZE_T BytecodeLength,
        /*  */ 
        __out_opt  ID3D10PixelShader **ppPixelShader) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateBlendState( 
        /*  */ 
        __in  const D3D10_BLEND_DESC *pBlendStateDesc,
        /*  */ 
        __out_opt  ID3D10BlendState **ppBlendState) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateDepthStencilState( 
        /*  */ 
        __in  const D3D10_DEPTH_STENCIL_DESC *pDepthStencilDesc,
        /*  */ 
        __out_opt  ID3D10DepthStencilState **ppDepthStencilState) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateRasterizerState( 
        /*  */ 
        __in  const D3D10_RASTERIZER_DESC *pRasterizerDesc,
        /*  */ 
        __out_opt  ID3D10RasterizerState **ppRasterizerState) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateSamplerState( 
        /*  */ 
        __in  const D3D10_SAMPLER_DESC *pSamplerDesc,
        /*  */ 
        __out_opt  ID3D10SamplerState **ppSamplerState) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateQuery( 
        /*  */ 
        __in  const D3D10_QUERY_DESC *pQueryDesc,
        /*  */ 
        __out_opt  ID3D10Query **ppQuery) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreatePredicate( 
        /*  */ 
        __in  const D3D10_QUERY_DESC *pPredicateDesc,
        /*  */ 
        __out_opt  ID3D10Predicate **ppPredicate) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CreateCounter( 
        /*  */ 
        __in  const D3D10_COUNTER_DESC *pCounterDesc,
        /*  */ 
        __out_opt  ID3D10Counter **ppCounter) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CheckFormatSupport( 
        /*  */ 
        __in  DXGI_FORMAT Format,
        /*  */ 
        __out  UINT *pFormatSupport) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CheckMultisampleQualityLevels( 
        /*  */ 
        __in  DXGI_FORMAT Format,
        /*  */ 
        __in  UINT SampleCount,
        /*  */ 
        __out  UINT *pNumQualityLevels) = 0;
    
    virtual void STDMETHODCALLTYPE CheckCounterInfo( 
        /*  */ 
        __out  D3D10_COUNTER_INFO *pCounterInfo) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE CheckCounter( 
        /*  */ 
        __in  const D3D10_COUNTER_DESC *pDesc,
        /*  */ 
        __out  D3D10_COUNTER_TYPE *pType,
        /*  */ 
        __out  UINT *pActiveCounters,
        /*  */ 
        __out_ecount_opt(*pNameLength)  LPSTR szName,
        /*  */ 
        __inout_opt  UINT *pNameLength,
        /*  */ 
        __out_ecount_opt(*pUnitsLength)  LPSTR szUnits,
        /*  */ 
        __inout_opt  UINT *pUnitsLength,
        /*  */ 
        __out_ecount_opt(*pDescriptionLength)  LPSTR szDescription,
        /*  */ 
        __inout_opt  UINT *pDescriptionLength) = 0;
    
    virtual UINT STDMETHODCALLTYPE GetCreationFlags( void) = 0;
    
    virtual HRESULT STDMETHODCALLTYPE OpenSharedResource( 
        /*  */ 
        __in  HANDLE hResource,
        /*  */ 
        __in  REFIID ReturnedInterface,
        /*  */ 
				__out_opt  void **ppResource){return S_OK;}
    
    virtual void STDMETHODCALLTYPE SetTextFilterSize( 
        /*  */ 
        __in  UINT Width,
        /*  */ 
        __in  UINT Height) = 0;
    
    virtual void STDMETHODCALLTYPE GetTextFilterSize( 
        /*  */ 
        __out_opt  UINT *pWidth,
        /*  */ 
        __out_opt  UINT *pHeight) = 0;

		//custom funcs to support compilation
		virtual void SetMarker(const char* pName){}
		virtual void RSSetDepthBounds(uint32 Enable,const float ZMin,const float ZMax){}
		virtual void HalfResolution(uint32 Mode,uint32 ATC=0){}
		virtual void PopMarker(const char* pName){}
		virtual void PushMarker(const char* pName){}
		virtual tdResHandle DrawCallHandleOffset(){return 0;}
		virtual uint32 ZWriteCountOffset(tdResHandle H,bool WaitForGPU){return 0;}
		virtual void RegisterZWriteCountForNextDrawCall(const uint32 cZWriteCount, tdResHandle H){}
		virtual uint32 ZWriteCount(tdResHandle H,bool WaitForGPU){return 0;}
		virtual void PreparePass(uint32 Pass){}
		virtual void PointSpriteControl(const uint32 Enable, const uint32 RMode, const uint32 Texcoord){}
		virtual tdResHandle	DrawCallHandle(){return 0;}
		virtual void CopySubresourceRegionSafe(ID3D10Resource *pDstResource,uint32 DstSubresource,uint32 DstX,uint32 DstY,uint32 DstZ,ID3D10Resource *pSrcResource,uint32 SrcSubresource,const D3D10_BOX *pSrcBox){}
		virtual void PSSetSamplers(uint32 Offset,uint32 NumSamplers,ID3D10SamplerState *const *ppSamplers,uint32* psRGB=0,float* pMipBias=NULL)
		{
			PSSetSamplers(Offset,NumSamplers,ppSamplers,NULL,NULL,pMipBias,psRGB);
		}
		virtual void RSSetState(ID3D10RasterizerState *pRasterizerState,uint32 sRGB,uint32 AlphaTestRef=0 )
		{
			RSSetState(pRasterizerState);
		}
};

#endif //PS3
#endif
