/*=============================================================================
  DriverD3D9.cpp : Direct3D Render interface implementation.
  Copyright (c) 2001 Crytek Studios. All Rights Reserved.

  Revision history:
    * Created by Khonich Andrey

=============================================================================*/

#include "StdAfx.h"
#include "DriverD3D.h"
#include "I3DEngine.h"
#include "ISound.h"
#include "IMusicSystem.h"
#include "IHardwareMouse.h"
#include "../Common/VideoPlayerInstance.h"

#include <IEngineModule.h>
#include <CryExtension/Impl/ClassWeaver.h>

#include "D3DStereo.h"
#include "Profiler/GPUProfiler.h"

#pragma warning(disable: 4244)

#ifdef WIN32
	#include "../common/NVAPI/nvapi.h"				// NVAPI
#endif

#if defined(DIRECT3D10) && (defined (WIN32) || defined(WIN64))
//#	include <D3DX10core.h>
#endif

#ifdef PS3
extern NPPU::SFrameProfileRSXData& GetFrameStatsSPUThread();
extern  void		CopyShaderSources();
extern	void		DeleteShaderCache();
#include <IAudioDevice.h>
#include <sys/gpio.h>
GetDIPValue(4)

#endif

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

Crc32Gen g_pRendCrc32Gen;

CCryNameTSCRC CTexture::s_sClassName = CCryNameTSCRC("CTexture");

CCryNameTSCRC CHWShader::m_sClassNameVS = CCryNameTSCRC("CHWShader_VS");
CCryNameTSCRC CHWShader::m_sClassNamePS = CCryNameTSCRC("CHWShader_PS");

CCryNameTSCRC CShader::m_sClassName = CCryNameTSCRC("CShader");

// Included only once per DLL module.
#include <platform_impl.h>

CD3D9Renderer *gcpRendD3D = NULL;

extern CTexture *gTexture;
extern CTexture *gTexture2;

int CD3D9Renderer::CV_d3d9_debugruntime;

int CD3D9Renderer::CV_d3d9_nvperfhud;
int CD3D9Renderer::CV_d3d9_vbpools;
int CD3D9Renderer::CV_d3d9_vbpoolsize;
int CD3D9Renderer::CV_d3d9_ibpools;
int CD3D9Renderer::CV_d3d9_ibpoolsize;
int CD3D9Renderer::CV_d3d9_clipplanes;
int CD3D9Renderer::CV_d3d9_triplebuffering;
int CD3D9Renderer::CV_d3d9_resetdeviceafterloading;
int CD3D9Renderer::CV_d3d9_allowsoftware;
int CD3D9Renderer::CV_d3d9_rb_verts;
int CD3D9Renderer::CV_d3d9_rb_tris;
int CD3D9Renderer::CV_d3d9_null_ref_device;

#if defined (DIRECT3D10)
int CD3D9Renderer::CV_d3d10_CBUpdateStats;
int CD3D9Renderer::CV_d3d10_NumStagingBuffers;
#endif

ICVar *CD3D9Renderer::CV_d3d9_texturefilter;

#if defined(XENON) || defined(PS3)
#	include "FallbackFont.h"
#endif

#ifdef WIN32
IDirectBee *CRenderer::m_pDirectBee=0;		// connection to D3D9 wrapper DLL, 0 if not established
#endif

char *resourceName[] = {
    "UNKNOWN",
    "Surfaces",
    "Volumes",
    "Textures",
    "Volume Textures",
    "Cube Textures",
    "Vertex Buffers",
    "Index Buffers"
};

// Direct 3D console variables
CD3D9Renderer::CD3D9Renderer()
{
	m_fAdaptedSceneScaleLBuffer = 1.0f;
  m_bInitialized = false;
  gcpRendD3D = this;
  gRenDev = this;

	m_pSecondBackBuffer = NULL;
	m_pStereoRenderer = new CD3DStereoRenderer(*this);
	m_profiler = NULL;

  m_LogFile = NULL;

#if defined (DIRECT3D9) || defined (OPENGL)
  m_pD3D              = NULL;
#elif defined (DIRECT3D10)
  m_nCurStateBL = (uint32) -1;
  m_nCurStateRS = (uint32) -1;
  m_nCurStateDP = (uint32) -1;
	m_CurTopology = D3D11_PRIMITIVE_TOPOLOGY_UNDEFINED;
	m_dwPresentStatus = 0;
	m_pd3dDeviceContext = NULL;
#endif

  m_pd3dDevice        = NULL;
  m_hWnd              = NULL;
  m_dwCreateFlags     = 0L;

  m_FenceOcclusionReady = 0L;
  m_numOcclusionDownsampleStages = 1;

	m_vSceneLuminanceInfo = Vec4(1.f, 1.f, 1.f, 1.f);	
	m_fStocopicSceneScale = m_fAdaptedSceneScale = m_fAdaptedSceneScaleLBuffer = 1.0f;

  for (int i=0; i<POOL_MAX; i++)
  {
    m_pVB[i] = NULL;
		m_pVBAr[i][0] = NULL;
		m_pVBAr[i][1] = NULL;
		m_pVBAr[i][2] = NULL;
		m_pVBAr[i][3] = NULL;
  }


  for (int i=0;i<SHAPE_MAX;i++)
  {
    m_pUnitFrustumVB[i] = NULL;
    m_pUnitFrustumIB[i] = NULL;
  }

  m_pUnitSphereVB = NULL;
  m_pUnitSphereIB = NULL;

  m_pUnitBoxVB = NULL;
  m_pUnitBoxIB = NULL;

  //memset(&m_LumGamma, 0, sizeof(m_LumGamma));
  //memset(&m_LumHistogram, 0, sizeof(m_LumHistogram));

	m_pIB = 0;

#ifdef WIN32
	m_pDirectBee=0;
#endif
  m_strDeviceStats[0] = 0;

  m_Features = RFT_DIRECTACCESSTOVIDEOMEMORY | RFT_SUPPORTZBIAS;

  REGISTER_CVAR2("d3d9_debugruntime", &CV_d3d9_debugruntime,0,VF_NULL,"");

  REGISTER_CVAR2("d3d9_NVPerfHUD", &CV_d3d9_nvperfhud, 0,VF_NULL,"");

#if 0
  REGISTER_CVAR2("d3d9_VBPools", &CV_d3d9_vbpools, 0, VF_REQUIRE_APP_RESTART,"");
#else
	REGISTER_CVAR2("d3d9_VBPools", &CV_d3d9_vbpools, 1, VF_REQUIRE_APP_RESTART,"");
#endif
#if defined (XENON) || defined(PS3)
  REGISTER_CVAR2("d3d9_VBPoolSize", &CV_d3d9_vbpoolsize, 128*1024,VF_NULL,"");
#else
  REGISTER_CVAR2("d3d9_VBPoolSize", &CV_d3d9_vbpoolsize, 256*1024,VF_NULL,"");
#endif

#if defined (DIRECT3D9) || defined(XENON)
  REGISTER_CVAR2("d3d9_IBPools", &CV_d3d9_ibpools, 1, VF_REQUIRE_APP_RESTART,"");
#elif defined (DIRECT3D10)
  REGISTER_CVAR2("d3d9_IBPools", &CV_d3d9_ibpools, 0, VF_REQUIRE_APP_RESTART,"");
#endif
  REGISTER_CVAR2("d3d9_IBPoolSize", &CV_d3d9_ibpoolsize, 256*1024,VF_NULL,"");
#if defined (DIRECT3D9) || defined (OPENGL)
  REGISTER_CVAR2("d3d9_ClipPlanes", &CV_d3d9_clipplanes, 1,VF_NULL,"");
#elif defined (DIRECT3D10)
  REGISTER_CVAR2("d3d9_ClipPlanes", &CV_d3d9_clipplanes, 0,VF_NULL,"");
#endif

#if defined (DIRECT3D10)
	REGISTER_CVAR2("d3d10_CBUpdateStats", &CV_d3d10_CBUpdateStats, 0, 0, "Logs constant buffer updates statistics.");
	{
#if defined(PS3)
		CV_d3d10_NumStagingBuffers = 4;
#else
		CV_d3d10_NumStagingBuffers = 16;
#endif
		ICVar* p(REGISTER_INT("d3d10_NumStagingBuffers", CV_d3d10_NumStagingBuffers, VF_REQUIRE_APP_RESTART, "Number of staging buffers to use for mesh updates [1, 512]."));
		if (p)
			CV_d3d10_NumStagingBuffers = clamp_tpl(p->GetIVal(), 1, MAX_STAGING_BUFFERS);
	}
#endif
  REGISTER_CVAR2("d3d9_TripleBuffering", &CV_d3d9_triplebuffering, 0, VF_REQUIRE_APP_RESTART,"");
  REGISTER_CVAR2("d3d9_ResetDeviceAfterLoading", &CV_d3d9_resetdeviceafterloading, 1,VF_NULL,"");
  CV_d3d9_texturefilter = REGISTER_STRING("d3d9_TextureFilter", "TRILINEAR", VF_DUMPTODISK,
    "Specifies D3D specific texture filtering type.\n"
    "Usage: d3d9_TexMipFilter [TRILINEAR/BILINEAR/LINEAR/NEAREST]");
  REGISTER_CVAR2("d3d9_AllowSoftware", &CV_d3d9_allowsoftware, 1, VF_REQUIRE_APP_RESTART,"");

#ifdef PS3
	#define RB_VERTS 8192
#else
	#define RB_VERTS 16384
#endif
  REGISTER_CVAR2("d3d9_rb_Verts", &CV_d3d9_rb_verts, RB_VERTS, VF_REQUIRE_APP_RESTART,"");
	REGISTER_CVAR2("d3d9_rb_Tris", &CV_d3d9_rb_tris, RB_VERTS*2, VF_REQUIRE_APP_RESTART,"");

	#undef RB_VERTS

	REGISTER_CVAR2("d3d9_NullRefDevice", &CV_d3d9_null_ref_device, 0, VF_REQUIRE_APP_RESTART,"");

#if defined(ENABLE_RENDER_AUX_GEOM)
	m_pRenderAuxGeomD3D = CRenderAuxGeomD3D::Create(*this);
#endif
	m_pColorGradingControllerD3D = new CColorGradingControllerD3D(this);

	CV_capture_frames = 0;
	CV_capture_folder = 0;
	CV_capture_file_format = 0;
#if defined (DIRECT3D9) || defined (OPENGL)
	for (int i=0; i<sizeof(m_pCaptureFrameSurf) / sizeof(m_pCaptureFrameSurf[0]); ++i)
		m_pCaptureFrameSurf[i] = 0;
  m_nQueryCount = 0;
#endif

  m_NewViewport.fMinZ = 0;
  m_NewViewport.fMaxZ = 1;

	m_wireframe_mode = R_SOLID_MODE;

#ifdef SHADER_ASYNC_COMPILATION
  uint32 nThreads = CV_r_shadersasyncmaxthreads; //clamp_tpl(CV_r_shadersasyncmaxthreads, 1, 4);
	uint32 nOldThreads	=	m_AsyncShaderTasks.size();
	for(uint32 a=nThreads;a<nOldThreads;a++)
		delete m_AsyncShaderTasks[a];
  m_AsyncShaderTasks.resize(nThreads);
	for(uint32 a=nOldThreads;a<nThreads;a++)
		m_AsyncShaderTasks[a]	=	new	CAsyncShaderTask();
  for(int32 i=0; i<m_AsyncShaderTasks.size(); i++)
  {
    m_AsyncShaderTasks[i]->SetThread(i);
  }
#endif

#ifndef EXCLUDE_SCALEFORM_SDK
	SF_CreateResources();
	assert(m_pSFResD3D);
#endif

	m_pPostProcessMgr = 0;
}

CD3D9Renderer::~CD3D9Renderer()
{
  //FreeResources(FRR_ALL);
  ShutDown();
#ifdef SHADER_ASYNC_COMPILATION
	for(int32 a=0;a<m_AsyncShaderTasks.size();a++)
		delete m_AsyncShaderTasks[a];
#endif
}

void CD3D9Renderer::Reset (void)
{
#if !defined(XENON) && !defined(PS3)
  m_pRT->RC_ResetDevice();
#endif
}
void CD3D9Renderer::RT_Reset (void)
{
 if (CheckDeviceLost())
   return;
#if !defined(XENON) && !defined(PS3)
  if (!CV_d3d9_resetdeviceafterloading)
    return;
  m_bDeviceLost = true;
  //iLog->Log("...Reset");
  RestoreGamma();
#if defined (DIRECT3D9) || defined (OPENGL)
  HRESULT hReturn;
  if(FAILED(hReturn = DXUTReset3DEnvironment9()))
    return;
#endif
  m_bDeviceLost = false;
  m_FSAA = 0;
  CheckFSAAChange();
  if (m_bFullScreen)
    SetGamma(CV_r_gamma+m_fDeltaGamma, CV_r_brightness, CV_r_contrast, false);
#if defined (DIRECT3D9) || defined (OPENGL)
  hReturn = m_pd3dDevice->BeginScene();
#endif

#endif
}

void CD3D9Renderer::ChangeViewport(unsigned int x,unsigned int y,unsigned int width,unsigned int height)
{
  if (m_bDeviceLost)
    return;
  assert(m_CurrContext);
  
#if defined(DIRECT3D10)
#	if !defined(PS3)
	DXGI_FORMAT fmt = gRenDev->IsLinearSpaceShadingEnabled() ? DXGI_FORMAT_R8G8B8A8_UNORM_SRGB : DXGI_FORMAT_R8G8B8A8_UNORM;
#	else
	DXGI_FORMAT fmt = DXGI_FORMAT_R8G8B8A8_UNORM;
#	endif
	if (!m_CurrContext->m_pSwapChain && !m_CurrContext->m_pBackBuffer)
	{
		DXGI_SWAP_CHAIN_DESC scDesc;
		scDesc.BufferDesc.Width = width;
		scDesc.BufferDesc.Height = height;
		scDesc.BufferDesc.RefreshRate.Numerator = 0;
		scDesc.BufferDesc.RefreshRate.Denominator = 1;
		scDesc.BufferDesc.Format = fmt;
		scDesc.BufferDesc.ScanlineOrdering = DXGI_MODE_SCANLINE_ORDER_UNSPECIFIED;
		scDesc.BufferDesc.Scaling = DXGI_MODE_SCALING_UNSPECIFIED;

		scDesc.SampleDesc.Count = 1;
		scDesc.SampleDesc.Quality = 0;

		scDesc.BufferUsage = DXGI_USAGE_RENDER_TARGET_OUTPUT;
		scDesc.BufferCount = 1;
#if defined(PS3)
		scDesc.OutputWindow = (typeof(scDesc.OutputWindow))m_CurrContext->m_hWnd;
#else
		scDesc.OutputWindow = m_CurrContext->m_hWnd;
#endif
		scDesc.Windowed = TRUE;
		scDesc.SwapEffect = DXGI_SWAP_EFFECT_DISCARD;
		scDesc.Flags = 0;				

#ifndef PS3
		HRESULT hr = DXUTGetDXGIFactory()->CreateSwapChain(m_pd3dDevice, &scDesc, &m_CurrContext->m_pSwapChain);
#else
		HRESULT hr = CCryDXPSGIFactory().CreateSwapChain(m_pd3dDevice, &scDesc, &m_CurrContext->m_pSwapChain);
#endif
		assert(SUCCEEDED(hr) && m_CurrContext->m_pSwapChain != 0);

		ID3D11Texture2D* pBackBufferTex(0);
		hr = m_CurrContext->m_pSwapChain->GetBuffer(0, __uuidof(ID3D11Texture2D), (void**) &pBackBufferTex);
		assert(SUCCEEDED(hr) && pBackBufferTex != 0);

		D3D11_RENDER_TARGET_VIEW_DESC rtDesc;
		rtDesc.Format = fmt;
		rtDesc.ViewDimension = D3D11_RTV_DIMENSION_TEXTURE2D;
		rtDesc.Texture2D.MipSlice = 0;
		hr = m_pd3dDevice->CreateRenderTargetView(pBackBufferTex, &rtDesc, &m_CurrContext->m_pBackBuffer);
		assert(SUCCEEDED(hr) && m_CurrContext->m_pBackBuffer != 0);

		SAFE_RELEASE(pBackBufferTex);
	}
	else if (m_CurrContext->m_Width != width || m_CurrContext->m_Height != height)
	{
		assert(m_CurrContext->m_pSwapChain && m_CurrContext->m_pBackBuffer);
		
		SAFE_RELEASE(m_CurrContext->m_pBackBuffer);

		HRESULT hr = m_CurrContext->m_pSwapChain->ResizeBuffers(1, width, height, fmt, 0);

		ID3D11Texture2D* pBackBufferTex(0);
		hr = m_CurrContext->m_pSwapChain->GetBuffer(0, __uuidof(ID3D11Texture2D), (void**) &pBackBufferTex);
		assert(SUCCEEDED(hr) && pBackBufferTex != 0);

		D3D11_RENDER_TARGET_VIEW_DESC rtDesc;
		rtDesc.Format = fmt;
		rtDesc.ViewDimension = D3D11_RTV_DIMENSION_TEXTURE2D;
		rtDesc.Texture2D.MipSlice = 0;
		hr = m_pd3dDevice->CreateRenderTargetView(pBackBufferTex, &rtDesc, &m_CurrContext->m_pBackBuffer);
		assert(SUCCEEDED(hr) && m_CurrContext->m_pBackBuffer != 0);

		SAFE_RELEASE(pBackBufferTex);
	}

	if (m_CurrContext->m_pSwapChain && m_CurrContext->m_pBackBuffer)
	{
		assert(m_nRTStackLevel[0] == 0);		
		m_pBackBuffer = m_CurrContext->m_pBackBuffer;
		FX_SetRenderTarget(0, m_CurrContext->m_pBackBuffer, &m_DepthBufferOrig);
	}
#endif
  m_CurrContext->m_X = x;
  m_CurrContext->m_Y = y;
  m_CurrContext->m_Width = width;
  m_CurrContext->m_Height = height;
	m_width = width;
	m_height = height;
	RT_SetViewport(x, y, width, height);
}
 
void CD3D9Renderer::ChangeLog()
{
#ifdef DO_RENDERLOG
  static bool singleFrame = false;

  if (CV_r_log && !m_LogFile)
  {
    if( CV_r_log < 0 )
    {
      singleFrame = true;
      CV_r_log = abs( CV_r_log );
    }

    if (CV_r_log == 3)
      SetLogFuncs(true);
#ifdef PS3		
    m_LogFile = fopen(SYS_APP_HOME"/Direct3DLog.txt", "w" FILE_IO_WRAPPER_NO_PATH_ADJUSTMENT);		
#else
    m_LogFile = fxopen ("Direct3DLog.txt", "w");
#endif
    if (m_LogFile)
    {
      iLog->Log("Direct3D log file '%s' opened\n", "Direct3DLog.txt");
      char time[128];
      char date[128];

      _strtime( time );
      _strdate( date );

      fprintf(m_LogFile, "\n==========================================\n");
      fprintf(m_LogFile, "Direct3D Log file opened: %s (%s)\n", date, time);
      fprintf(m_LogFile, "==========================================\n");
    }
  }
  else if (m_LogFile && singleFrame)
  {
    CV_r_log = 0;
		singleFrame = false;
  }

  if (!CV_r_log && m_LogFile)
  {
    SetLogFuncs(false);

    char time[128];
    char date[128];
    _strtime( time );
    _strdate( date );

    fprintf(m_LogFile, "\n==========================================\n");
    fprintf(m_LogFile, "Direct3D Log file closed: %s (%s)\n", date, time);
    fprintf(m_LogFile, "==========================================\n");

    fclose(m_LogFile);
    m_LogFile = NULL;
    iLog->Log("Direct3D log file '%s' closed\n", "Direct3DLog.txt");
  }

  if (CV_r_logTexStreaming && !m_LogFileStr)
  {
    m_LogFileStr = fxopen ("Direct3DLogStreaming.txt", "w");
    if (m_LogFileStr)
    {
      iLog->Log("Direct3D texture streaming log file '%s' opened\n", "Direct3DLogStreaming.txt");
      char time[128];
      char date[128];

      _strtime( time );
      _strdate( date );

      fprintf(m_LogFileStr, "\n==========================================\n");
      fprintf(m_LogFileStr, "Direct3D Textures streaming Log file opened: %s (%s)\n", date, time);
      fprintf(m_LogFileStr, "==========================================\n");
    }
  }
  else
  if (!CV_r_logTexStreaming && m_LogFileStr)
  {
    char time[128];
    char date[128];
    _strtime( time );
    _strdate( date );

    fprintf(m_LogFileStr, "\n==========================================\n");
    fprintf(m_LogFileStr, "Direct3D Textures streaming Log file closed: %s (%s)\n", date, time);
    fprintf(m_LogFileStr, "==========================================\n");

    fclose(m_LogFileStr);
    m_LogFileStr = NULL;
    iLog->Log("Direct3D texture streaming log file '%s' closed\n", "Direct3DLogStreaming.txt");
  }

  if (CV_r_logShaders && !m_LogFileSh)
  {
    m_LogFileSh = fxopen ("Direct3DLogShaders.txt", "w");
    if (m_LogFileSh)
    {
      iLog->Log("Direct3D shaders log file '%s' opened\n", "Direct3DLogShaders.txt");
      char time[128];
      char date[128];

      _strtime( time );
      _strdate( date );

      fprintf(m_LogFileSh, "\n==========================================\n");
      fprintf(m_LogFileSh, "Direct3D Shaders Log file opened: %s (%s)\n", date, time);
      fprintf(m_LogFileSh, "==========================================\n");
    }
  }
  else
  if (!CV_r_logShaders && m_LogFileSh)
  {
    char time[128];
    char date[128];
    _strtime( time );
    _strdate( date );

    fprintf(m_LogFileSh, "\n==========================================\n");
    fprintf(m_LogFileSh, "Direct3D Textures streaming Log file closed: %s (%s)\n", date, time);
    fprintf(m_LogFileSh, "==========================================\n");

    fclose(m_LogFileSh);
    m_LogFileSh = NULL;
    iLog->Log("Direct3D Shaders log file '%s' closed\n", "Direct3DLogShaders.txt");
  }
#endif
}

void CD3D9Renderer::PostMeasureOverdraw()
{
#if defined (DIRECT3D9) || defined (OPENGL)
  if (CV_r_measureoverdraw)
  {
		gRenDev->m_cEF.mfRefreshSystemShader("Debug", CShaderMan::m_ShaderDebug);

    int iTmpX, iTmpY, iTempWidth, iTempHeight;
    GetViewport(&iTmpX, &iTmpY, &iTempWidth, &iTempHeight);   
    RT_SetViewport(0, 0, m_width, m_height);   
    Set2DMode(true, 1, 1);

    int nOffs;
    SVF_P3F_C4B_T2F *vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs, POOL_P3F_COL4UB_TEX2F);
    vQuad[0].xyz.x = 0;
    vQuad[0].xyz.y = 0;
    vQuad[0].xyz.z = 1;
    vQuad[0].color.dcolor = (uint32)-1;
    vQuad[0].st = Vec2(0.0f, 0.0f);

    vQuad[1].xyz.x = 1;
    vQuad[1].xyz.y = 0;
    vQuad[1].xyz.z = 1;
    vQuad[1].color.dcolor = (uint32)-1;
    vQuad[1].st = Vec2(1.0f, 0.0f);

    vQuad[2].xyz.x = 1;
    vQuad[2].xyz.y = 1;
    vQuad[2].xyz.z = 1;
    vQuad[2].color.dcolor = (uint32)-1;
    vQuad[2].st = Vec2(1.0f, 1.0f);

    vQuad[3].xyz.x = 0;
    vQuad[3].xyz.y = 1;
    vQuad[3].xyz.z = 1;
    vQuad[3].color.dcolor = (uint32)-1;
    vQuad[3].st = Vec2(0.0f, 1.0f);

    SetCullMode(R_CULL_DISABLE);
    EF_SetState(GS_NODEPTHTEST);
    EnableTMU(true);
    CTexture::s_ptexWhite->Apply();
    UnlockVB(POOL_P3F_COL4UB_TEX2F);
    {
      uint32 nPasses;
      CShader *pSH = m_cEF.m_ShaderDebug;
      pSH->FXSetTechnique("ShowInstructions");
      pSH->FXBegin(&nPasses, FEF_DONTSETTEXTURES | FEF_DONTSETSTATES);
      pSH->FXBeginPass(0);
      STexState TexStateLinear = STexState(FILTER_LINEAR, true);

      if (!FAILED(FX_SetVertexDeclaration(0, eVF_P3F_C4B_T2F)))
      {
        FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));

        STexState TexStatePoint = STexState(FILTER_POINT, true);
        FX_Commit();
        SDynTexture *pRT = new SDynTexture(m_width, m_height, eTF_A8R8G8B8, eTT_2D,  FT_STATE_CLAMP, "TempDebugRT");
        pRT->Update(m_width, m_height);
        CTexture::GetBackBuffer(pRT->m_pTexture, 0);

        pRT->Apply(0, CTexture::GetTexState(TexStatePoint));
        CTexture::s_ptexPaletteDebug->Apply(1, CTexture::GetTexState(TexStateLinear));

        m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLEFAN, nOffs, 2);

        SAFE_DELETE(pRT);
      }
      Set2DMode(false, 1, 1);

      int nX = 800-100+2;
      int nY = 600-100+2;
      int nW = 96;
      int nH = 96;

      Draw2dImage(nX-2, nY-2, nW+4, nH+4, CTexture::s_ptexWhite->GetTextureID());

      Set2DMode(true, 800, 600);

      vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs, POOL_P3F_COL4UB_TEX2F);
      vQuad[0].xyz.x = nX;
      vQuad[0].xyz.y = nY;
      vQuad[0].xyz.z = 1;
      vQuad[0].color.dcolor = (uint32)-1;
      vQuad[0].st = Vec2(0.0f, 0.0f);

      vQuad[1].xyz.x = nX + nW;
      vQuad[1].xyz.y = nY;
      vQuad[1].xyz.z = 1;
      vQuad[1].color.dcolor = (uint32)-1;
      vQuad[1].st = Vec2(1.0f, 0.0f);

      vQuad[2].xyz.x = nX + nW;
      vQuad[2].xyz.y = nY + nH;
      vQuad[2].xyz.z = 1;
      vQuad[2].color.dcolor = (uint32)-1;
      vQuad[2].st = Vec2(1.0f, 1.0f);

      vQuad[3].xyz.x = nX;
      vQuad[3].xyz.y = nY + nH;
      vQuad[3].xyz.z = 1;
      vQuad[3].color.dcolor = (uint32)-1;
      vQuad[3].st = Vec2(0.0f, 1.0f);
			UnlockVB(POOL_P3F_COL4UB_TEX2F);

      pSH->FXSetTechnique("InstructionsGrad");
      pSH->FXBegin(&nPasses, FEF_DONTSETTEXTURES | FEF_DONTSETSTATES);
      pSH->FXBeginPass(0);
      FX_Commit();

      CTexture::s_ptexPaletteDebug->Apply(0, CTexture::GetTexState(TexStateLinear));

      m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLEFAN, nOffs, 2);

      nX = nX * m_width / 800;
      nY = nY * m_height / 600;
      nW = 10 * m_width / 800;
      nH = 10 * m_height / 600;
      float color[4] = {1,1,1,1};
			if (CV_r_measureoverdraw == 1 || CV_r_measureoverdraw == 3)
			{
				Draw2dLabel(nX+nW, nY+nH-30, 1.2f, color, false, CV_r_measureoverdraw==1 ? "Pixel Shader:" : "Vertex Shader:");
				int n = 32 * CV_r_measureoverdrawscale;
				for (int i=0; i<8; i++)
				{
					char str[256];
					sprintf(str, "-- >%d instructions --", n);

					Draw2dLabel(nX+nW, nY+nH*(i+1), 1.2f, color, false,  str);
					n += 32 * CV_r_measureoverdrawscale;
				}
			}
			else
			{
				Draw2dLabel(nX+nW, nY+nH, 1.2f, color, false,  "-- 1 pass --");
				Draw2dLabel(nX+nW, nY+nH*2, 1.2f, color, false,  "-- 2 passes --");
				Draw2dLabel(nX+nW, nY+nH*3, 1.2f, color, false,  "-- 3 passes --");
				Draw2dLabel(nX+nW, nY+nH*4, 1.2f, color, false,  "-- 4 passes --");
				Draw2dLabel(nX+nW, nY+nH*5, 1.2f, color, false,  "-- 5 passes --");
				Draw2dLabel(nX+nW, nY+nH*6, 1.2f, color, false,  "-- 6 passes --");
				Draw2dLabel(nX+nW, nY+nH*7, 1.2f, color, false,  "-- 7 passes --");
				Draw2dLabel(nX+nW, nY+nH*8, 1.2f, color, false,  "-- >8 passes --");
			}
			//WriteXY(nX+10, nY+10, 1, 1,  1,1,1,1, "-- 10 instructions --");
    }
    Set2DMode(false, 1, 1);
		RT_FlushTextMessages();
  }
#endif
}

void CD3D9Renderer::DrawTexelsPerMeterInfo()
{
	if (CV_r_TexelsPerMeter> 0)
	{
		int x = 800-310+2;
		int y = 600-20+2;
		int w = 296;
		int h = 6;

		Draw2dImage(x-2, y-2, w+4, h+4, CTexture::s_ptexWhite->GetTextureID(), 0, 0, 1, 1, 0, 1, 1, 1, 1, 0);
		Draw2dImage(x, y, w, h, CTexture::s_ptexPaletteTexelsPerMeter->GetTextureID(), 0, 0, 1, 1, 0, 1, 1, 1, 1, 0);

		float color[4] = {1, 1, 1, 1};

		x = x * m_width / 800;
		y = y * m_height / 600;
		w = w * m_width / 800;

		Draw2dLabel(x - 100, y - 20, 1.2f, color, false, "r_TexelsPerMeter:");
		Draw2dLabel(x - 2, y - 20, 1.2f, color, false, "0");
		Draw2dLabel(x + w / 2 - 5, y - 20, 1.2f, color, false, "%.0f", CV_r_TexelsPerMeter);
		Draw2dLabel(x + w - 25, y - 20, 1.2f, color, false, ">= %.0f", CV_r_TexelsPerMeter * 2.0f);

		RT_FlushTextMessages();
	}
}

#ifdef XENON
void CD3D9Renderer::ReleaseDevice()
{
  if (m_pd3dDevice)
	  m_pd3dDevice->ReleaseThreadOwnership();
}
void CD3D9Renderer::AcquireDevice()
{
  m_pd3dDevice->AcquireThreadOwnership();
}
#endif

void CD3D9Renderer::BeginFrame()
{
  //////////////////////////////////////////////////////////////////////
  // Set up everything so we can start rendering
  //////////////////////////////////////////////////////////////////////

  assert(m_pd3dDevice);

  FlushRTCommands(false, false);

  g_bProfilerEnabled = gEnv->pFrameProfileSystem->IsProfiling();

  // Switching of MT mode in run-time
  //CV_r_multithreaded = 0;
#if defined(XENON) || defined(PS3)
  bool bCurMT = m_pRT->m_pThread != NULL;
  bool bStatMT = CV_r_multithreaded != 0;
  if (bCurMT != bStatMT)
  {
    if (bCurMT)
    {
      m_pRT->FlushAndWait();
      m_pRT->Quit();
    }
#if !defined(PS3)
		else
			ReleaseDevice();
#endif 
    m_pRT->Init(CV_r_multithreaded);
    m_pRT->Start();
#if defined(ENABLE_RENDER_AUX_GEOM)
		if (CV_r_multithreaded > 0 && m_pRenderAuxGeomD3D)
			m_pRenderAuxGeomD3D->GetRenderThreadAuxGeomCB()->SetThreadID(m_pRT->m_nRenderThread);
#endif
    //ChangeResolution(m_width, m_height, m_cbpp, 75, m_CVFullScreen->GetIVal()!=0, true);    
    if (bStatMT)
      iLog->Log("Enabled render multithreading mode (CPU: %d)", CV_r_multithreaded);
    else
      iLog->Log("Disabled render multithreading mode");
    m_bAquireDeviceThread = true;
  }
#endif

  m_cEF.mfBeginFrame();

  CRendElement::Tick();
  CRenderMesh2::Tick();
  CRenderObject::Tick();

  CREImposter::m_PrevMemPostponed = CREImposter::m_MemPostponed;
  CREImposter::m_PrevMemUpdated = CREImposter::m_MemUpdated;
  CREImposter::m_MemPostponed = 0;
  CREImposter::m_MemUpdated = 0;

  m_RP.m_TI[m_RP.m_nFillThreadID].m_nFrameID++;
  m_RP.m_TI[m_RP.m_nFillThreadID].m_nFrameUpdateID++;
  m_RP.m_TI[m_RP.m_nFillThreadID].m_RealTime = iTimer->GetCurrTime();
  m_RP.m_TI[m_RP.m_nFillThreadID].m_PersFlags &= ~RBPF_HDR;

  CREOcclusionQuery::m_nQueriesPerFrameCounter = 0;
  CREOcclusionQuery::m_nReadResultNowCounter = 0;
  CREOcclusionQuery::m_nReadResultTryCounter = 0;

  if (CV_r_PostProcess)
    m_RP.m_TI[m_RP.m_nFillThreadID].m_PersFlags |= RBPF_POSTPROCESS; // enable post processing

  assert(m_RP.m_TI[m_RP.m_nFillThreadID].m_matView->GetDepth() == 0);
  assert(m_RP.m_TI[m_RP.m_nFillThreadID].m_matProj->GetDepth() == 0);
  g_SelectedTechs.resize(0);
  m_RP.m_SysVertexPool[m_RP.m_nFillThreadID].SetUse(0);
  m_RP.m_SysIndexPool[m_RP.m_nFillThreadID].SetUse(0);
#ifdef DO_RENDERLOG
  if (CRenderer::CV_r_log)
    Logv(0, "******************************* BeginFrame %d ********************************\n", m_RP.m_TI[m_RP.m_nFillThreadID].m_nFrameUpdateID);
#endif
  if (CRenderer::CV_r_logTexStreaming)
    LogStrv(0, "******************************* BeginFrame %d ********************************\n", m_RP.m_TI[m_RP.m_nFillThreadID].m_nFrameUpdateID);

	/*if ((CV_r_usepom != 0) != m_bUsePOM)
	{
		m_bUsePOM = CV_r_usepom != 0;
		m_cEF.mfReloadAllShaders(1, SHGD_HW_ALLOW_POM);
	}*/

  if (CV_r_reloadshaders)
  {
    //exit(0);
    //ShutDown();
    //iConsole->Exit("Test");

#ifdef PS3
		CopyShaderSources();
#endif
    m_cEF.m_Bin.InvalidateCache();
    m_cEF.mfReloadAllShaders(CV_r_reloadshaders, 0);
    CV_r_reloadshaders = 0;
  }

  m_pRT->RC_BeginFrame();
}

void CD3D9Renderer::RT_BeginFrame()
{
	if (CV_r_stats == 7)
	{
		m_profiler->Enable();
	}
	else
	{
		m_profiler->Disable();
	}

	m_profiler->BeginFrame();
  CBaseResource::Tick();
#ifndef _RELEASE
  m_cEF.mfFlushCurPLCombinations(false);
#endif

  //////////////////////////////////////////////////////////////////////
  // Build the matrices
  //////////////////////////////////////////////////////////////////////

  PROFILE_FRAME(Screen_Begin);
	PROFILE_LABEL_PUSH_SKIP_GPU("Frame");

#ifdef XENON
  if (m_bAquireDeviceThread)
  {
    AcquireDevice();
    m_bAquireDeviceThread = false;
  }
#endif

	static ICVar *pCVDebugTexelDensity = gEnv->pConsole->GetCVar("e_texeldensity");

	CV_e_DebugTexelDensity = pCVDebugTexelDensity ? pCVDebugTexelDensity->GetIVal() : 0;

  //CRendElement::Tick();
  //CRenderMesh::Tick();
  //CRenderObject::Tick();

  m_RP.m_TI[m_RP.m_nProcessThreadID].m_matView->LoadIdentity();

  CheckDeviceLost();

	if (!m_bDeviceLost)
	{
		if (CV_r_gamma+m_fDeltaGamma != m_fLastGamma || CV_r_brightness != m_fLastBrightness || CV_r_contrast != m_fLastContrast)
			SetGamma(CV_r_gamma+m_fDeltaGamma, CV_r_brightness, CV_r_contrast, false);
	}

  if (m_bDeviceSupportsATOC)
  {
    m_RP.m_TI[m_RP.m_nProcessThreadID].m_PersFlags2 &= ~RBPF2_ATOC;
   #if defined (DIRECT3D9) || defined(OPENGL)
#if !defined(XENON) && !defined(PS3)
    m_pd3dDevice->SetRenderState(D3DRS_ADAPTIVETESS_Y, 0); 
#endif
   #endif
  }

  CheckFSAAChange();
  if (!m_bDeviceSupportsInstancing)
  {
    if (CV_r_geominstancing)
    {
      iLog->Log("Device doesn't support HW geometry instancing (or it's disabled)");
      _SetVar("r_GeomInstancing", 0);
    }
  }

  if (CV_r_usehwskinning != (int)m_bUseHWSkinning)
  {
    m_bUseHWSkinning = CV_r_usehwskinning != 0;
    CRendElement *pRE = CRendElement::m_RootGlobal.m_NextGlobal;
    for (pRE=CRendElement::m_RootGlobal.m_NextGlobal; pRE!=&CRendElement::m_RootGlobal; pRE=pRE->m_NextGlobal)
    {
      CRendElementBase *pR = (CRendElementBase *)pRE;
      if (pR->mfIsHWSkinned())
        pR->mfReset();
    }
  }

	// Verify if water caustics needed at all
	if( CV_r_watercaustics )
	{
		S3DEngineCommon::SOceanInfo &OceanInfo= gRenDev->m_p3DEngineCommon.m_OceanInfo;
		m_bWaterCaustics = (OceanInfo.m_nOceanRenderFlags & OCR_OCEANVOLUME_VISIBLE) != 0;
	}

	m_drawNearFov = CV_r_drawnearfov;

	I3DEngine* p3DEngine = gEnv->p3DEngine;
	switch (CV_r_FogColorGradientEnforced)
	{
	case 0:
	case 1:
		m_useFogColorGradient = CV_r_FogColorGradientEnforced != 0;
		break;
	default:
		if (p3DEngine)
			m_useFogColorGradient = p3DEngine->GetGlobalParameter(E3DPARAM_FOG_USECOLORGRADIENT) != 0;
		break;
	};

  if (!IsEditorMode())
  {
#if defined (DIRECT3D10)
    if (m_bPendingSetWindow)
    {
      m_bPendingSetWindow = false;
      m_CVFullScreen->Set(0);
    }
#endif
    if (m_CVWidth && m_CVHeight && m_CVFullScreen && m_CVColorBits)
    {
      if (m_CVWidth->GetIVal() != m_width || m_CVHeight->GetIVal() != m_height || m_CVFullScreen->GetIVal() != (int)m_bFullScreen || m_CVColorBits->GetIVal() != m_cbpp)
        ChangeResolution(m_CVWidth->GetIVal(), m_CVHeight->GetIVal(), m_CVColorBits->GetIVal(), 75, m_CVFullScreen->GetIVal()!=0, false);
    }
    if (CV_r_vsync != m_VSync)
      EnableVSync(CV_r_vsync?true:false);
  }

  if (CV_r_wireframe != m_wireframe_mode)
  {
		//assert(CV_r_wireframe == R_WIREFRAME_MODE || CV_r_wireframe == R_SOLID_MODE);
    SetWireframeMode(CV_r_wireframe);
  }

	UpdateRenderingModesInfo();

  m_RP.m_pRNDrawCallsInfo.clear();

  //////////////////////////////////////////////////////////////////////
  // Begin the scene
  //////////////////////////////////////////////////////////////////////

  SetMaterialColor(1,1,1,1);

  if (strcmp(CV_d3d9_texturefilter->GetString(), CTexture::s_GlobalTextureFilter.c_str()) || CV_r_texture_anisotropic_level != CTexture::s_TexStates[CTexture::s_nGlobalDefState].m_nAnisotropy)
    CTexture::SetDefTexFilter(CV_d3d9_texturefilter->GetString());

  ChangeLog ();

  ResetToDefault();

  TArray<CRETempMesh *> *tm = &m_RP.m_TempMeshes[m_RP.m_TI[m_RP.m_nProcessThreadID].m_nFrameID & 1];
  for (uint32 i=0; i<tm->Num(); i++)
  {
    CRETempMesh *re = tm->Get(i);
    if (!re)
      continue;
    if (re->m_pVBuffer)
    {
      m_DevBufMan.ReleaseVBuffer(re->m_pVBuffer);
      re->m_pVBuffer = NULL;
    }
    m_DevBufMan.ReleaseIBuffer(re->m_pIBuffer);
  }
  tm->SetUse(0);
  m_RP.m_CurTempMeshes = tm;
  
  if (!m_SceneRecurseCount)
  {
#if !defined(XENON)
 #if defined (DIRECT3D9) || defined (OPENGL)
    m_pd3dDevice->BeginScene();
 #endif
#else
    m_pd3dDevice->BeginScene();

    if (CV_r_predicatedtiling > 1)
      m_pd3dDevice->SetPredication(CV_r_predicatedtiling-1);

    if (!m_nRTStackLevel[0])
      FX_PushRenderTarget(0, CTexture::s_pBackBuffer, &m_DepthBufferOrig);

    //m_pd3dDevice->GpuOwnVertexShaderConstantF(0, MAX_CONSTANTS_VS);
    //m_pd3dDevice->GpuOwnPixelShaderConstantF(0, MAX_CONSTANTS_PS);
#endif
    m_SceneRecurseCount++;
  }

#if defined(PS3) || defined(XENON)
	if (CV_r_wireframe != 0 || !CV_r_usezpass)
#endif
		EF_ClearBuffers(FRT_CLEAR, NULL);     

  m_nStencilMaskRef = 0;

#ifndef EXCLUDE_CRI_SDK
	CVideoPlayer::ProcessPerFrameUpdates();
#endif

	if (!SRendItem::m_RecurseLevel[m_RP.m_nProcessThreadID])
	{
		memset(&m_RP.m_PS[m_RP.m_nProcessThreadID], 0, sizeof(SPipeStat));
		m_RP.m_RTStats.resize(0);
		m_RP.m_Profile.Free();
	}
#if !defined(PS3)
  m_OcclQueries.SetUse(0);
#endif

  /*extern SDynTexture2 *gDT;
  extern int gnFrame;
  if (gDT)
  {
    static D3DSurface *pSurf = NULL;
    HRESULT hr;
    if (!pSurf)
    {
      hr = m_pd3dDevice->CreateRenderTarget(64, 64, D3DFMT_A8R8G8B8, D3DMULTISAMPLE_NONE, 0, TRUE, &pSurf, NULL);
    }
    int nFrame = m_nFrameSwapID;
    if ((1<<(nFrame&1)) & gnFrame)
    {
      SDynTexture2 *pDT = gDT;
      pDT->Apply(0);
      FX_PushRenderTarget(0, pSurf, &m_DepthBufferOrig);
      EF_SetColorOp(eCO_MODULATE, eCO_MODULATE, DEF_TEXARG0, DEF_TEXARG0);
      DrawFullScreenQuad(m_cEF.m_ShaderTreeSprites, "General_Debug", m_cEF.m_RTRect.x, m_cEF.m_RTRect.y, m_cEF.m_RTRect.x+m_cEF.m_RTRect.z, m_cEF.m_RTRect.y+m_cEF.m_RTRect.w);
      FX_PopRenderTarget(0);
      D3DLOCKED_RECT lr;
      pSurf->LockRect(&lr, NULL, 0);
      UCol *pData = (UCol *)lr.pBits;
      //for (int i=0; i<64*64; i++)
      //{
      UCol d = pData[32*64+32];
      if (d.bcolor[0] == 0xff)
      {
        //assert(0);
        int nnn = 0;
      }
      //}
      pSurf->UnlockRect();
    }
  }*/
}

bool CD3D9Renderer::CheckDeviceLost()
{
#if defined (DIRECT3D9) || defined (OPENGL)
#ifdef WIN32
  HRESULT hReturn;

  // Test the cooperative level to see if it's okay to render
  if (FAILED(hReturn = m_pd3dDevice->TestCooperativeLevel()))
  {
    // If the device was lost, do not render until we get it back
    if (D3DERR_DEVICELOST == hReturn)
    {
      RestoreGamma();
      m_bDeviceLost = true;
      return true;
    }
    // Check if the device needs to be reset.
    if (D3DERR_DEVICENOTRESET == hReturn)
    {
      m_bDeviceLost = true;
      if(FAILED(hReturn = DXUTReset3DEnvironment9()))
        return true;
      m_bDeviceLost = false;
      SetGamma(CV_r_gamma+m_fDeltaGamma, CV_r_brightness, CV_r_contrast, true);
      hReturn = m_pd3dDevice->BeginScene();
      if (m_bEndLevelLoading)
        CTexture::Precache();
    }
  }
#endif //WIN32
#elif defined (DIRECT3D10)
#endif
  return false;
}

void CD3D9Renderer::FlushHardware(bool bIssueBeforeSync)
{
	PROFILE_FRAME(FlushHardware);

	if (CV_d3d9_null_ref_device != 0) // No flush for null device.
		return;

  if (m_bDeviceLost)
    return;

  m_nQueryCount++;
  int nFr = m_RP.m_TI[m_RP.m_nProcessThreadID].m_nFrameUpdateID & 1;
//	if(!CRenderer::IsMultiGPUModeActive())
    nFr = 0;

  HRESULT hr;
  if (CV_r_flush) // == m_nQueryCount)
  {
    m_nQueryCount = 0;
    if (m_pQuery[nFr])
    {
			if (bIssueBeforeSync)
      {
#if defined (DIRECT3D9) || defined (OPENGL)
				m_pQuery[nFr]->Issue(D3DISSUE_END);
#elif defined (DIRECT3D10)
        m_pd3dDeviceContext->End(m_pQuery[nFr]);
#endif
      }

      BOOL bQuery = false;
      float fTime = iTimer->GetAsyncCurTime();
      bool bInfinite = false;
      do
      {
        float fDif = iTimer->GetAsyncCurTime() - fTime;
        if (fDif > 5.0f)
        {
          // 5 seconds in the loop
          bInfinite = true;
          break;
        }
#if defined (XENON)
        hr = m_pQuery[nFr]->GetData((void *)&bQuery, sizeof(BOOL), 0);
#elif defined (DIRECT3D9) || defined (OPENGL)
        hr = m_pQuery[nFr]->GetData((void *)&bQuery, sizeof(BOOL), D3DGETDATA_FLUSH);
#elif defined (DIRECT3D10)
        hr = m_pd3dDeviceContext->GetData(m_pQuery[nFr], (void *)&bQuery, sizeof(BOOL), 0);
#endif
      } while(hr == S_FALSE);

      if (bInfinite)
        iLog->Log("Error: Seems like infinite loop in GPU sync query");

#if defined (DIRECT3D9) && !defined (XENON)
      m_fTimeWaitForGPU[m_RP.m_nProcessThreadID] = iTimer->GetAsyncCurTime() - fTime;
#endif

			if (!bIssueBeforeSync)
      {
#if defined (DIRECT3D9) || defined (OPENGL)
				m_pQuery[nFr]->Issue(D3DISSUE_END);
#elif defined (DIRECT3D10)
        m_pd3dDeviceContext->End(m_pQuery[nFr]);
#endif
      }
    }
#if defined (DIRECT3D9) || defined (OPENGL)
    else
    {
      IDirect3DSurface9 * pTar = GetBackSurface();
      if (pTar)
      {
        D3DLOCKED_RECT lockedRect;
        RECT sourceRect;
        sourceRect.bottom = 1;
        sourceRect.top = 0;
        sourceRect.left = 0;
        sourceRect.right = 4;
        hr = pTar->LockRect(&lockedRect,&sourceRect,D3DLOCK_READONLY);
        if (!FAILED(hr))
        {
          volatile unsigned long a;
          memcpy((void *)&a,(unsigned char*)lockedRect.pBits,sizeof(a));
          hr = pTar->UnlockRect();
        }
      }
    }
#endif
  }
}

bool CD3D9Renderer::CaptureFrameBufferToFile(const char* pFilePath, bool keepIntCaptureBuffer, float scale)
{
#if !defined(PS3)
	assert(pFilePath);
	if (!pFilePath)
		return false;

#if defined (DIRECT3D9) || defined (OPENGL)
	struct SCaptureFormatInfo { const char* pExt;  D3DXIMAGE_FILEFORMAT fmt; };
	const SCaptureFormatInfo c_captureFormats[] = 
		{ {"hdr", D3DXIFF_HDR}, {"jpg", D3DXIFF_JPG}, {"bmp", D3DXIFF_BMP}, {"tga", D3DXIFF_TGA} };
#elif defined(DIRECT3D10)
	struct SCaptureFormatInfo { const char* pExt;  D3DX11_IMAGE_FILE_FORMAT fmt; };
	const SCaptureFormatInfo c_captureFormats[] = 
		{ {"jpg", D3DX11_IFF_JPG}, {"bmp", D3DX11_IFF_BMP}, {"tif", D3DX11_IFF_TIFF} };
#endif

	const char* pReqFileFormatExt(fpGetExtension(pFilePath));

	// resolve file format from file path
	int fmtIdx(-1);
	if (pReqFileFormatExt)
	{
		++pReqFileFormatExt; // skip '.'
		for (int i(0); i < sizeof(c_captureFormats) / sizeof(c_captureFormats[0]); ++i)
		{
			if (!stricmp(pReqFileFormatExt, c_captureFormats[i].pExt))
			{
				fmtIdx = i;
				break;
			}
		}
	}

#if !defined (XENON)
	if (fmtIdx < 0)
#else
	if (fmtIdx != 3) // only TGA for now, ##FMT_CHK##
#endif
	{
		if (iLog)
			iLog->Log("Warning: Captured frame cannot be saved as \"%s\" format is not supported!\n", pReqFileFormatExt);
		return false;
	}	
#else
	int fmtIdx = 3;
#endif

#if defined (DIRECT3D9) || defined (OPENGL)
	// capture regular or HDR frames?
	bool captureHDR(c_captureFormats[fmtIdx].fmt == D3DXIFF_HDR);

	// saves out backbuffer size
	int bbWidth = GetWidth();
	int bbHeight = GetHeight();

	// get access to frame
	D3DSurface* pSrcSurface = 0;
	if (captureHDR)
	{
		if (CTexture::s_ptexHDRTarget)
			pSrcSurface = CTexture::s_ptexHDRTarget->GetSurface(0, 0);
	}
	else
	{
#	if defined(XENON)
		CTexture* pFB = GetS3DRend().GetHighResFrontBuffer() != 0 ? GetS3DRend().GetHighResFrontBuffer() : CTexture::s_FrontBufferTextures[(m_dwCurrentBuffer+1)%2];
		pSrcSurface = pFB->GetSurface(0, 0);

		bbWidth = pFB->GetWidth();
		bbHeight = pFB->GetHeight();
#	else
		if (m_pd3dDevice)
			m_pd3dDevice->GetBackBuffer(0, 0, D3DBACKBUFFER_TYPE_MONO, &pSrcSurface);
#	endif
	}

	RECT dstRect;

	// capture frame
	bool frameCaptureSuccessful(false);
	if (pSrcSurface)
	{
		RECT srcRect;
		srcRect.left = 0;
		srcRect.right = bbWidth;
		srcRect.top = 0; 
		srcRect.bottom = bbHeight;
		dstRect = srcRect;

#	if !defined(XENON)
		if (scale > 1)
		{
			// Set size so that width is equal to "scale" (and size height appropriately)
			dstRect.right = (int) scale; 
			dstRect.bottom = (int) (dstRect.right * (float) bbWidth / (float) bbHeight);
		}
		else if (scale > 0 && scale < 1)
		{
			// Scale proportionately to "scale"
			dstRect.right *= scale; 
			dstRect.bottom = dstRect.right * (float) bbWidth / (float) bbHeight;
		}	

		D3DSURFACE_DESC srcDesc;
		pSrcSurface->GetDesc(&srcDesc);

		if (srcDesc.MultiSampleType == D3DMULTISAMPLE_NONE)
		{
			bool needRealloc(true);
			if (m_pCaptureFrameSurf[0])
			{
				D3DSURFACE_DESC dstDesc;
				m_pCaptureFrameSurf[0]->GetDesc(&dstDesc);
				if (dstDesc.Format == srcDesc.Format && dstDesc.Width == srcDesc.Width && dstDesc.Height == srcDesc.Height)
					needRealloc = false;
			}

			if (needRealloc)
			{
				SAFE_RELEASE(m_pCaptureFrameSurf[0]);
				m_pd3dDevice->CreateOffscreenPlainSurface(srcDesc.Width, srcDesc.Height, srcDesc.Format, D3DPOOL_SYSTEMMEM, &m_pCaptureFrameSurf[0], 0);
			}

			if (scale > 0)
			{
				SAFE_RELEASE(m_pCaptureFrameSurf[0]);
				HRESULT hr = m_pd3dDevice->CreateRenderTarget(dstRect.right, dstRect.bottom, srcDesc.Format, D3DMULTISAMPLE_NONE, 0, TRUE, &m_pCaptureFrameSurf[0], NULL);
				if (m_pCaptureFrameSurf[0] && SUCCEEDED(hr) &&
					SUCCEEDED(m_pd3dDevice->StretchRect(pSrcSurface, &srcRect, m_pCaptureFrameSurf[0], &dstRect, D3DTEXF_NONE)))
					frameCaptureSuccessful = true;
			}
			else
			{
				if (m_pCaptureFrameSurf[0] && SUCCEEDED(m_pd3dDevice->GetRenderTargetData(pSrcSurface, m_pCaptureFrameSurf[0])))
					frameCaptureSuccessful = true;
			}
		}
#	else
#		if 0 
		// D3DXSaveSurfaceToFile is currently broken on Xenon, rely on custom TGA writer below 
		// Once fixed more formats could be supported (in that case remove special format checks in this file, look for ##FMT_CHK##)
		D3DXSaveSurfaceToFile(pFilePath, c_captureFormats[fmtIdx].fmt, pSrcSurface, 0, &dstRect);
		SAFE_RELEASE(pSrcSurface);
		frameCaptureSuccessful = true;
#		else
		D3DSURFACE_DESC srcDesc;
		pSrcSurface->GetDesc(&srcDesc);

		unsigned int* pFinalFrame = new uint32[srcDesc.Width * srcDesc.Height];
		if (pFinalFrame)
		{
			D3DLOCKED_RECT r;
			pSrcSurface->LockRect(&r, 0, D3DLOCK_READONLY);

			ICryPak* pPak(gEnv->pCryPak);
			FILE* f = pPak->FOpen(pFilePath, "wb");
			if (f)
			{
				POINT pt = {0, 0};
				XGUntileSurface(pFinalFrame, srcDesc.Width * 4, &pt, r.pBits, srcDesc.Width, srcDesc.Height, 0, 4);

				unsigned char* pKillAlpha = (unsigned char*) pFinalFrame;
				for (size_t i=0; i<srcDesc.Width * srcDesc.Height; ++i, pKillAlpha += 4)
					pKillAlpha[3] = 0xFF;

				unsigned char id_length(0);
				pPak->FWrite(&id_length, 1, 1, f);

				unsigned char color_map_type(0);
				pPak->FWrite(&color_map_type, 1, 1, f);

				unsigned char type(2);
				pPak->FWrite(&type, 1, 1, f);

				unsigned short cm_index(0);
				pPak->FWrite(&cm_index, 2, 1, f);

				unsigned short cm_length(0);
				pPak->FWrite(&cm_length, 2, 1, f);

				unsigned char cm_entry_size(0);
				pPak->FWrite(&cm_length, 1, 1, f);

				unsigned short x_org(0);
				pPak->FWrite(&x_org, 2, 1, f);

				unsigned short y_org(0);
				pPak->FWrite(&y_org, 2, 1, f);

				unsigned short width(srcDesc.Width);
				SwapEndian(width);
				pPak->FWrite(&width, 2, 1, f);

				unsigned short height(srcDesc.Height);
				SwapEndian(height);
				pPak->FWrite(&height, 2, 1, f);

				unsigned char dest_bits_per_pixel(32);
				pPak->FWrite(&dest_bits_per_pixel, 1, 1, f);

				unsigned char desc(0x20); // origin is upper left
				pPak->FWrite(&desc, 1, 1, f);

				pPak->FWrite(pFinalFrame, 4, srcDesc.Width * srcDesc.Height, f);
				pPak->FClose(f);

				frameCaptureSuccessful = true;
			}
			pSrcSurface->UnlockRect();
			SAFE_DELETE_ARRAY(pFinalFrame);
		}

		SAFE_RELEASE(pSrcSurface);
#		endif
#	endif
	}

#	if !defined(XENON)
	// save captured frame
	if (frameCaptureSuccessful)
		D3DXSaveSurfaceToFile(pFilePath, c_captureFormats[fmtIdx].fmt, m_pCaptureFrameSurf[0], 0, &dstRect);

	// release ref count of src surface
	SAFE_RELEASE(pSrcSurface);

	// release internal capture buffer if requested
	if (!keepIntCaptureBuffer)
		SAFE_RELEASE(m_pCaptureFrameSurf[0]);
#	endif

	return frameCaptureSuccessful;
#elif defined (DIRECT3D10)
	assert(m_pBackBuffer);
	assert(!IsEditorMode() || m_CurrContext->m_pBackBuffer == m_pBackBuffer);

	bool frameCaptureSuccessful(false);
	ID3D11Texture2D* pBackBufferTex(0);

	m_pBackBuffer->GetResource((ID3D11Resource**) &pBackBufferTex);
	if (pBackBufferTex)
	{
#if defined(PS3)
		HRESULT hr(D3DX11SaveTextureToFile(m_pd3dDeviceContext, pBackBufferTex, (D3DX11_IMAGE_FILE_FORMAT)0, pFilePath));
#else
		if (CV_r_useSRGB)
		{
			D3D11_TEXTURE2D_DESC bbDesc;
			pBackBufferTex->GetDesc(&bbDesc);
			if (bbDesc.Format == DXGI_FORMAT_R8G8B8A8_UNORM_SRGB)
			{
				bbDesc.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
				ID3D11Texture2D* pTempCopyTex(0);
				if (SUCCEEDED(m_pd3dDevice->CreateTexture2D(&bbDesc, 0, &pTempCopyTex)))
				{
					m_pd3dDeviceContext->CopyResource(pTempCopyTex, pBackBufferTex);
					pBackBufferTex->Release();
					pBackBufferTex = pTempCopyTex;
				}
			}
		}
		HRESULT hr(D3DX11SaveTextureToFile(m_pd3dDeviceContext, pBackBufferTex, c_captureFormats[fmtIdx].fmt, pFilePath));
#endif
		frameCaptureSuccessful = SUCCEEDED(hr);
	}

	SAFE_RELEASE(pBackBufferTex);

	return frameCaptureSuccessful;
#else
	return false;
#endif
}

#define DEPTH_BUFFER_SCALE 1024.0f

bool CD3D9Renderer::CaptureMiscBuffersToFiles(const char* pFilePath)
{
#if defined (DIRECT3D9) || defined (OPENGL)
	char filename[ICryPak::g_nMaxPath];

	struct SCaptureFormatInfo
	{
		const char* pExt;
		D3DXIMAGE_FILEFORMAT fmt;
	};

	const SCaptureFormatInfo targetformats1[] =
	{
		{".tga", D3DXIFF_TGA},
		{"HDR.hdr", D3DXIFF_HDR},
		{"Z.hdr", D3DXIFF_HDR},
		{"AO.tga", D3DXIFF_TGA},
		{"Shadow0.tga", D3DXIFF_TGA},
		{"Shadow1.tga", D3DXIFF_TGA},
		{"Shadow2.tga", D3DXIFF_TGA},
		{"Shadow3.tga", D3DXIFF_TGA},
		{"Shadow4.tga", D3DXIFF_TGA},
		{"Shadow5.tga", D3DXIFF_TGA},
		{"Shadow6.tga", D3DXIFF_TGA},
		{"Shadow7.tga", D3DXIFF_TGA},
	};

	const SCaptureFormatInfo targetformats2[] =
	{
		{"_L.tga", D3DXIFF_TGA},
		{"_R.tga", D3DXIFF_TGA},
	};

	const SCaptureFormatInfo *targetformats = NULL;
	int bufferCount = 0;
	if (CV_capture_misc_render_buffers == 1)
	{
		targetformats = targetformats1;
		bufferCount = sizeof(m_pCaptureFrameSurf)/sizeof(m_pCaptureFrameSurf[0]);
	}
	else if (CV_capture_misc_render_buffers == 2)
	{
		targetformats = targetformats2;
		bufferCount = min(2, sizeof(m_pCaptureFrameSurf)/sizeof(m_pCaptureFrameSurf[0]));
	}

	for (int i=0; i<bufferCount; ++i)
	{
		D3DSurface* pSrcSurface = NULL;

		if (CV_capture_misc_render_buffers == 1)
		{
			if (0 == i)
				m_pd3dDevice->GetBackBuffer(0, 0, D3DBACKBUFFER_TYPE_MONO, &pSrcSurface);
			else if (1 == i)
				pSrcSurface = CTexture::s_ptexHDRTarget ? CTexture::s_ptexHDRTarget->GetSurface(0, 0) : NULL;
			else if (2 == i)
				pSrcSurface = CTexture::s_ptexZTarget ? CTexture::s_ptexZTarget->GetSurface(0, 0) : NULL;
			else if (4 <= i)
				pSrcSurface = CTexture::s_ptexCurrentScreenShadowMap[i-4] ? CTexture::s_ptexCurrentScreenShadowMap[i-4]->GetSurface(0, 0) : NULL;
		}
		else if (CV_capture_misc_render_buffers == 2)
		{
			if( i == 0 )
				pSrcSurface = CTexture::s_ptexStereoL ? CTexture::s_ptexStereoL->GetSurface(0, 0) : NULL;
			else if (1 == i)
				pSrcSurface = CTexture::s_ptexStereoR ? CTexture::s_ptexStereoR->GetSurface(0, 0) : NULL;
		}

		strcpy_s(filename, pFilePath);
		strcat_s(filename, targetformats[i].pExt);
		bool frameCaptureSuccessful = false;

		if (pSrcSurface)
		{
			D3DSURFACE_DESC srcDesc;
			pSrcSurface->GetDesc(&srcDesc);

			if (srcDesc.MultiSampleType == D3DMULTISAMPLE_NONE)
			{
				bool needRealloc(true);
				if (m_pCaptureFrameSurf[i])
				{
					D3DSURFACE_DESC dstDesc;
					m_pCaptureFrameSurf[i]->GetDesc(&dstDesc);
					if (dstDesc.Format == srcDesc.Format && dstDesc.Width == srcDesc.Width && dstDesc.Height == srcDesc.Height)
						needRealloc = false;
				}

				if (needRealloc)
				{
					SAFE_RELEASE(m_pCaptureFrameSurf[i]);
					m_pd3dDevice->CreateOffscreenPlainSurface(srcDesc.Width, srcDesc.Height, srcDesc.Format, D3DPOOL_SYSTEMMEM, &m_pCaptureFrameSurf[i], 0);
				}

				if (m_pCaptureFrameSurf[i] && SUCCEEDED(m_pd3dDevice->GetRenderTargetData(pSrcSurface, m_pCaptureFrameSurf[i])))
				{
					RECT rect;
					rect.left = 0; 
					rect.right = GetWidth();
					rect.top = 0; 
					rect.bottom = GetHeight();

#ifdef DEPTH_BUFFER_SCALE
					if (1 == CV_capture_misc_render_buffers && 2 == i)
					{
						D3DLOCKED_RECT lockrect;
						m_pCaptureFrameSurf[i]->LockRect(&lockrect, &rect, 0);
						char* ptr = reinterpret_cast<char*>(lockrect.pBits);
						for (int y=0; y<rect.bottom; ++y)
						{
							for (int x=0; x<rect.right; ++x)
								reinterpret_cast<float*>(ptr)[x] = DEPTH_BUFFER_SCALE*reinterpret_cast<float*>(ptr)[x];
							ptr += lockrect.Pitch;
						}
						m_pCaptureFrameSurf[i]->UnlockRect();
					}
#endif

					D3DXSaveSurfaceToFile(filename, targetformats[i].fmt, m_pCaptureFrameSurf[i], 0, &rect);
					frameCaptureSuccessful = true;
				}
				SAFE_RELEASE(pSrcSurface);
			}
			if (!frameCaptureSuccessful)
				return false;
		}
	}

#endif

	return true;
}

void CD3D9Renderer::CaptureFrameBuffer()
{
	// cache console vars
	if (!CV_capture_frames || !CV_capture_folder || !CV_capture_file_format || !CV_capture_frame_once ||
			!CV_capture_use_scale || !CV_capture_image_scale || !CV_capture_file_name || !CV_capture_file_prefix)
	{
		ISystem* pSystem(GetISystem());
		if (!pSystem)
			return;

		IConsole* pConsole(gEnv->pConsole);
		if (!pConsole)
			return;

		CV_capture_frames = !CV_capture_frames ? pConsole->GetCVar("capture_frames") : CV_capture_frames;
		CV_capture_folder = !CV_capture_folder ? pConsole->GetCVar("capture_folder") : CV_capture_folder;
		CV_capture_file_format = !CV_capture_file_format ? pConsole->GetCVar("capture_file_format") : CV_capture_file_format;
		CV_capture_frame_once = !CV_capture_frame_once ? pConsole->GetCVar("capture_frame_once") : CV_capture_frame_once;
		CV_capture_use_scale = !CV_capture_use_scale ? pConsole->GetCVar("capture_use_scale") : CV_capture_use_scale;
		CV_capture_image_scale = !CV_capture_image_scale ? pConsole->GetCVar("capture_image_scale") : CV_capture_image_scale;
		CV_capture_file_name = !CV_capture_file_name ? pConsole->GetCVar("capture_file_name") : CV_capture_file_name;
		CV_capture_file_prefix = !CV_capture_file_prefix ? pConsole->GetCVar("capture_file_prefix") : CV_capture_file_prefix;

		if (!CV_capture_frames || !CV_capture_folder || !CV_capture_file_format || !CV_capture_frame_once ||
			!CV_capture_use_scale || !CV_capture_image_scale || !CV_capture_file_name || !CV_capture_file_prefix)
			return;
	}

	int frameNum(CV_capture_frames->GetIVal());
	if (frameNum > 0)
	{
		char path[ICryPak::g_nMaxPath];
		path[0] = '\0';

		const char* capture_file_name = CV_capture_file_name->GetString();
		if (capture_file_name && capture_file_name[0])
		{
			if (CV_capture_misc_render_buffers)
			{
				char capture_file_name_nopath[ICryPak::g_nMaxPath];
				for (size_t i=0; i < ICryPak::g_nMaxPath; ++i)
				{
					char c = capture_file_name[i];
					if (c == '.')
						c = '\0';
					capture_file_name_nopath[i] = c;
					if (c == '\0')
						break;
				}
				gEnv->pCryPak->AdjustFileName(capture_file_name_nopath, path, ICryPak::FLAGS_PATH_REAL| ICryPak::FLAGS_FOR_WRITING);
			}
			else
				gEnv->pCryPak->AdjustFileName(capture_file_name, path, ICryPak::FLAGS_PATH_REAL| ICryPak::FLAGS_FOR_WRITING);
		}

		if (path[0] == '\0')
		{
			gEnv->pCryPak->AdjustFileName(CV_capture_folder->GetString(), path, ICryPak::FLAGS_PATH_REAL | ICryPak::FLAGS_FOR_WRITING);
			gEnv->pCryPak->MakeDir(path);

			char prefix[64] = "Frame";
			const char* capture_file_prefix = CV_capture_file_prefix->GetString();
			if (capture_file_prefix && capture_file_prefix[0])
			{
				strcpy_s(prefix, capture_file_prefix);
			}

			size_t pathLen = strlen(path);
			if (CV_capture_misc_render_buffers)
				snprintf(&path[pathLen], sizeof(path) - 1 - pathLen, "\\%s%06d", prefix, frameNum - 1);
			else
				snprintf(&path[pathLen], sizeof(path) - 1 - pathLen, "\\%s%06d.%s", prefix, frameNum - 1, CV_capture_file_format->GetString());
		}

		if (CV_capture_frame_once->GetIVal())
		{
			CV_capture_frames->Set(0);
			CV_capture_frame_once->Set(0);
		}
		else
			CV_capture_frames->Set(frameNum + 1);

		float fScale = -1.f;
		if (CV_capture_use_scale->GetIVal())
			fScale = max(0.001f, CV_capture_image_scale->GetFVal());

		if (CV_capture_misc_render_buffers)
		{
			if (!CaptureMiscBuffersToFiles(path))
			{
				if (iLog)
					iLog->Log("Warning: Frame capture failed!\n");
				CV_capture_frames->Set(0); // disable capturing
			}
		}
		else if (!CaptureFrameBufferToFile(path, true, fScale))
		{
			if (iLog)
				iLog->Log("Warning: Frame capture failed!\n");
			CV_capture_frames->Set(0); // disable capturing
		}
	}
#if defined (DIRECT3D9) || defined (OPENGL)
	else
	{
		for (int i=0; i<sizeof(m_pCaptureFrameSurf) / sizeof(m_pCaptureFrameSurf[0]); ++i)
			SAFE_RELEASE(m_pCaptureFrameSurf[i]);
	}
#endif
}

static float LogMap( const float fA )
{
	return logf(fA)/logf(2.0f)+5.5f;		// offset to bring values <0 in viewable range
}

void CD3D9Renderer::DebugDrawRect( float x1,float y1,float x2,float y2,float *fColor )
{
#if defined(PS3)
  float fColorRev[4] = { fColor[3],fColor[2],fColor[1],fColor[0] };
  fColor = fColorRev;
#endif
  SetMaterialColor( fColor[0],fColor[1],fColor[2],fColor[3] );
  int w = GetWidth();
  int h = GetHeight();
  float dx = 1.0f/w;
  float dy = 1.0f/h;
  x1 *= dx; x2 *= dx;
  y1 *= dy; y2 *= dy;

  ColorB col((uint8)(fColor[0]*255.0f),(uint8)(fColor[1]*255.0f),(uint8)(fColor[2]*255.0f),(uint8)(fColor[3]*255.0f));

  IRenderAuxGeom *pAux = GetIRenderAuxGeom();
  SAuxGeomRenderFlags flags = pAux->GetRenderFlags();
  flags.SetMode2D3DFlag(e_Mode2D);
  pAux->SetRenderFlags(flags);
  pAux->DrawLine( Vec3(x1,y1,0),col,Vec3(x2,y1,0),col );
  pAux->DrawLine( Vec3(x1,y2,0),col,Vec3(x2,y2,0),col );
  pAux->DrawLine( Vec3(x1,y1,0),col,Vec3(x1,y2,0),col );
  pAux->DrawLine( Vec3(x2,y1,0),col,Vec3(x2,y2,0),col );
}

void CD3D9Renderer::DebugDrawStats1()
{
  const int nYstep = 10;
  uint32 i;
  int nY = 30; // initial Y pos
  int nX = 50; // initial X pos

  ColorF col = Col_Yellow;
  Draw2dLabel(nX, nY, 2.0f, &col.r, false, "Per-frame stats:");

  col = Col_White;
  nX += 10; nY += 25;
  //DebugDrawRect(nX-2, nY, nX+180, nY+150, &col.r);
  Draw2dLabel(nX, nY, 1.4f, &col.r, false, "Draw-calls:");

#ifdef XENON
  float fFSize = 1.2f;
#else
  float fFSize = 1.2f;
#endif

  nX += 5; nY += 10;
  int nXBars = nX;

  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "General: %d (%d polys, %.3fms)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_GENERAL], m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_GENERAL], (m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPs[EFSLIST_GENERAL] + m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPsZ)*1000.0f);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Decals: %d (%d polys, %.3fms)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_DECAL], m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_DECAL], m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPs[EFSLIST_DECAL]*1000.0f);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Terrain layers: %d (%d polys, %.3fms)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_TERRAINLAYER], m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_TERRAINLAYER], m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPs[EFSLIST_TERRAINLAYER]*1000.0f);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Transparent: %d (%d polys, %.3fms)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_TRANSP], m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_TRANSP], m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPs[EFSLIST_TRANSP]*1000.0f);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Shadow-gen: %d (%d polys, %.3fms)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_SHADOW_GEN], m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_SHADOW_GEN], m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPs[EFSLIST_SHADOW_GEN]*1000.0f);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Shadow-pass: %d (%d polys)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_SHADOW_PASS], m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_SHADOW_PASS]);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Water: %d (%d polys, %.3fms)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_WATER], m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_WATER], m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPs[EFSLIST_WATER_VOLUMES]*1000.0f);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Imposters: %d (Updates: %d)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumCloudImpostersDraw, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumCloudImpostersUpdates);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Sprites: %d (%d dips, %d updates, %d polys)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumSprites, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumSpriteDIPS, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumSpriteUpdates, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumSpritePolys/*, m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPsSprites*1000.0f*/);

  Draw2dLabel(nX-5, nY+20, 1.4f, &col.r, false, "Total: %d (%d polys)", GetCurrentNumberOfDrawCalls(), RT_GetPolyCount());

  col = Col_Yellow;
  nX -= 5; nY += 45;
  //DebugDrawRect(nX-2, nY, nX+180, nY+160, &col.r);
  Draw2dLabel(nX, nY, 1.4f, &col.r, false, "Occlusions: Issued: %d, Occluded: %d, NotReady: %d", m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumQIssued, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumQOccluded, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumQNotReady);

  col = Col_Cyan;
  nX -= 5; nY += 45;
  //DebugDrawRect(nX-2, nY, nX+180, nY+160, &col.r);
  Draw2dLabel(nX, nY, 1.4f, &col.r, false, "Device resource switches:");

  nX += 5; nY += 10;
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "VShaders: %d (%d unique)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumVShadChanges, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumVShaders);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "PShaders: %d (%d unique)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumPShadChanges, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumPShaders);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Textures: %d (%d unique)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumTextChanges, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumTextures);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "RT's: %d (%d unique), cleared: %d times, copied: %d times", m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumRTChanges, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumRTs, m_RP.m_PS[m_RP.m_nProcessThreadID].m_RTCleared, m_RP.m_PS[m_RP.m_nProcessThreadID].m_RTCopied);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "States: %d", m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumStateChanges);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Batches: %d", m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumRendBatches);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Instances: %d", m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumRendInstances);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Light setups: %d", m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumLightSetups);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "HW Instances: DIP's: %d, Instances: %d (polys: %d/%d)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_RendHWInstancesDIPs, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumRendHWInstances, m_RP.m_PS[m_RP.m_nProcessThreadID].m_RendHWInstancesPolysOne, m_RP.m_PS[m_RP.m_nProcessThreadID].m_RendHWInstancesPolysAll);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Skinned instances: %d", m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumRendSkinnedObjects);

  CHWShader_D3D *ps = (CHWShader_D3D *)m_RP.m_PS[m_RP.m_nProcessThreadID].m_pMaxPShader;
  CHWShader_D3D::SHWSInstance *pInst = (CHWShader_D3D::SHWSInstance *)m_RP.m_PS[m_RP.m_nProcessThreadID].m_pMaxPSInstance;
  if (ps)
    Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "MAX PShader: %s (instructions: %d, lights: %d)", ps->GetName(), pInst->m_nInstructions, pInst->m_LightMask & 0xf);
  CHWShader_D3D *vs = (CHWShader_D3D *)m_RP.m_PS[m_RP.m_nProcessThreadID].m_pMaxVShader;
  pInst = (CHWShader_D3D::SHWSInstance *)m_RP.m_PS[m_RP.m_nProcessThreadID].m_pMaxVSInstance;
  if (vs)
    Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "MAX VShader: %s (instructions: %d, lights: %d)", vs->GetName(), pInst->m_nInstructions, pInst->m_LightMask & 0xf);

  col = Col_Green;
  nX -= 5; nY += 35;
  //DebugDrawRect(nX-2, nY, nX+180, nY+160, &col.r);
  Draw2dLabel(nX, nY, 1.4f, &col.r, false, "Device resource sizes:");

  nX += 5; nY += 10;
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Managed textures: %.3f Mb", m_RP.m_PS[m_RP.m_nProcessThreadID].m_ManagedTexturesSize/1024.0f/1024.0f);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "RT textures: Used: %.3f Mb, Updated: %.3f Mb, Cleared: %.3f Mb, Copied: %.3f Mb", m_RP.m_PS[m_RP.m_nProcessThreadID].m_DynTexturesSize/1024.0f/1024.0f, m_RP.m_PS[m_RP.m_nProcessThreadID].m_RTSize/1024.0f/1024.0f, m_RP.m_PS[m_RP.m_nProcessThreadID].m_RTClearedSize/1024.0f/1024.0f, m_RP.m_PS[m_RP.m_nProcessThreadID].m_RTCopiedSize/1024.0f/1024.0f);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Meshes updated: Static: %.3f Mb, Dynamic: %.3f Mb", m_RP.m_PS[m_RP.m_nProcessThreadID].m_MeshUpdateBytes/1024.0f/1024.0f, m_RP.m_PS[m_RP.m_nProcessThreadID].m_DynMeshUpdateBytes/1024.0f/1024.0f);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Cloud textures updated: %.3f Mb", m_RP.m_PS[m_RP.m_nProcessThreadID].m_CloudImpostersSizeUpdate/1024.0f/1024.0f);

  int nYBars = nY;

  nY = 30;  // initial Y pos
  nX = 470; // initial X pos
  col = Col_Yellow;
  Draw2dLabel(nX, nY, 2.0f, &col.r, false, "Global stats:");

  col = Col_YellowGreen;
  nX += 10; nY += 55;
  Draw2dLabel(nX, nY, 1.4f, &col.r, false, "Mesh size:");

  CRenderMesh2 *pRM = CRenderMesh2::m_Root.m_Prev;
  int nMemApp = 0;
  int nMemDevVB = 0;
  int nMemDevIB = 0;
  int nMemDevVBPool = 0;
  int nMemDevIBPool = 0;  
  while (pRM != &CRenderMesh2::m_Root)
  {
    nMemApp += pRM->Size(CRenderMesh2::SIZE_ONLY_SYSTEM);
    nMemDevVB += pRM->Size(CRenderMesh2::SIZE_VB);
    nMemDevIB += pRM->Size(CRenderMesh2::SIZE_IB);
    pRM = pRM->m_Prev;
  }
  for (i=0; i<m_DevBufMan.m_VBPools.size(); i++)
  {
    SDevPool &Pool = m_DevBufMan.m_VBPools[i];
    if (Pool.m_D3DBuf.m_pVB)
      nMemDevVBPool += Pool.m_nPoolSize;
  }
  for (i=0; i<m_DevBufMan.m_IBPools.size(); i++)
  {
    SDevPool &Pool = m_DevBufMan.m_IBPools[i];
    if (Pool.m_D3DBuf.m_pIB)
      nMemDevIBPool += Pool.m_nPoolSize;
  }
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Static: (app: %.3f Mb, dev VB: %.3f Mb, dev IB: %.3f Mb, dev VB pools: %.3f, dev IB pools: %.3f)", nMemApp/1024.0f/1024.0f, nMemDevVB/1024.0f/1024.0f, nMemDevIB/1024.0f/1024.0f, nMemDevVBPool/1024.0f/1024.0f, nMemDevIBPool/1024.0f/1024.0f);

  nMemDevVB = 0;
  nMemDevIB = 0;
  nMemApp = 0;
  int j;
  for (i=0; i<POOL_MAX; i++)
  {
    int nVertSize = 0;
    switch (i)
    {
    case POOL_P3F_COL4UB_TEX2F:
      nVertSize = sizeof(SVF_P3F_C4B_T2F);
      break;
    case POOL_TRP3F_COL4UB_TEX2F:
      nVertSize = sizeof(SVF_TP3F_C4B_T2F);
      break;
    case POOL_TRP3F_TEX2F_TEX3F:
      nVertSize = sizeof(SVF_TP3F_T2F_T3F);
      break;
    case POOL_P3F_TEX3F:
      nVertSize = sizeof(SVF_P3F_T3F);
      break;
    case POOL_P3F_TEX2F_TEX3F:
      nVertSize = sizeof(SVF_P3F_T2F_T3F);
      break;
      default:
        assert(0);
    }
    nMemDevVB += m_nVertsDMesh[i] * nVertSize;
  }
  nMemDevIB += m_nIndsDMesh * sizeof(short);
  nMemApp += m_RP.m_SizeSysArray;
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Dynamic: (app: %.3f Mb, dev VB: %.3f Mb, dev IB: %.3f Mb)", nMemApp/1024.0f/1024.0f, nMemDevVB/1024.0f/1024.0f, nMemDevIB/1024.0f/1024.0f/*, nMemDevVBPool/1024.0f/1024.0f*/);

  CCryNameTSCRC Name;
  SResourceContainer *pRL;
  uint32 n = 0;
  int nSize = 0;
  Name = CShader::mfGetClassName();
  pRL = CBaseResource::GetResourcesForClass(Name);
  if (pRL)
  {
    ResourcesMapItor itor;
    for (itor=pRL->m_RMap.begin(); itor!=pRL->m_RMap.end(); itor++)
    {
      CShader *sh = (CShader *)itor->second;
      if (!sh)
        continue;
      nSize += sh->Size(0);
      n++;
    }
  }
  nY += nYstep;
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "FX Shaders: %d (size: %.3f Mb)", n, nSize/1024.0f/1024.0f);

  nSize = 0;
  n = 0;
  for (i=0; i<(int)CShader::m_ShaderResources_known.Num(); i++)
  {
    SRenderShaderResources *pSR = CShader::m_ShaderResources_known[i];
    if (!pSR)
      continue;
    nSize += pSR->Size();
    n++;
  }
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Shader resources: %d (size: %.3f Mb)", n, nSize/1024.0f/1024.0f);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Shader manager (size: %.3f Mb)", m_cEF.Size()/1024.0f/1024.0f);

  n = 0;
  for (i=0; i<CGParamManager::m_Groups.size(); i++)
  {
    n += CGParamManager::m_Groups[i].nParams;

  }
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Groups: %d, Shader parameters: %d (size: %.3f Mb), in pool: %d (size: %.3f Mb)", i, n, (n*sizeof(SCGParam))/1024.0f/1024.0f, CGParamManager::m_Pools.size(), (CGParamManager::m_Pools.size()*PARAMS_POOL_SIZE*sizeof(SCGParam))/1024.0f/1024.0f);

  int nSharedVSInst = 0;
  int nSharedPSInst = 0;
  int nSharedVSDev = 0;
  int nSharedPSDev = 0;
  TArray<void *> ShadersVS;
  TArray<void *> ShadersPS;
  CHWShader_D3D::InstanceMapItor itInst;
  for (itInst=CHWShader_D3D::m_SharedInsts.begin(); itInst!=CHWShader_D3D::m_SharedInsts.end(); itInst++)
  {
    CHWShader_D3D::SHWSSharedList *pInstSL = itInst->second;
    for (i=0; i<pInstSL->m_SharedInsts.size(); i++)
    {
      CHWShader_D3D::SHWSSharedInstance *pSI = &pInstSL->m_SharedInsts[i];
      for (j=0; j<pSI->m_Insts.size(); j++)
      {
        CHWShader_D3D::SHWSInstance *p = &pSI->m_Insts[j];
        if (p->m_bDeleted)
          continue;
        if (p->m_eClass == eHWSC_Vertex)
        {
          nSharedVSInst++;
          if (p->m_Handle.m_pShader)
          {
            for (n=0; n<ShadersVS.Num(); n++)
            {
              if (ShadersVS[n] == p->m_Handle.m_pShader->m_pHandle)
                break;
            }
            if (n == ShadersVS.Num())
            {
              ShadersVS.AddElem(p->m_Handle.m_pShader->m_pHandle);
            }
          }
        }
        else
        {
          nSharedPSInst++;
          if (p->m_Handle.m_pShader)
          {
            for (n=0; n<ShadersPS.Num(); n++)
            {
              if (ShadersPS[n] == p->m_Handle.m_pShader->m_pHandle)
                break;
            }
            if (n == ShadersPS.Num())
            {
              ShadersPS.AddElem(p->m_Handle.m_pShader->m_pHandle);
            }
          }
        }
      }
    }

  }
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Shared VShader instances: %d, Device VShaders: %d", nSharedVSInst, ShadersVS.Num());
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Shared PShader instances: %d, Device PShaders: %d", nSharedPSInst, ShadersPS.Num());

  nSize = 0;
  n = 0;
  int nInsts = 0;
  ShadersVS.SetUse(0);
  Name = CHWShader::mfGetClassName(eHWSC_Vertex);
  pRL = CBaseResource::GetResourcesForClass(Name);
  if (pRL)
  {
    ResourcesMapItor itor;
    for (itor=pRL->m_RMap.begin(); itor!=pRL->m_RMap.end(); itor++)
    {
      CHWShader *vsh = (CHWShader *)itor->second;
      if (!vsh)
        continue;
      nSize += vsh->Size();
      n++;

      CHWShader_D3D *pD3D = (CHWShader_D3D *)vsh;
      for (i=0; i<pD3D->m_Insts.size(); i++)
      {
        CHWShader_D3D::SHWSInstance *pShInst = &pD3D->m_Insts[i];
        if (pShInst->m_bDeleted)
          continue;
        nInsts++;
        if (pShInst->m_Handle.m_pShader)
        {
          for (j=0; j<(int)ShadersVS.Num(); j++)
          {
            if (ShadersVS[j] == pShInst->m_Handle.m_pShader->m_pHandle)
              break;
          }
          if (j == ShadersVS.Num())
          {
            ShadersVS.AddElem(pShInst->m_Handle.m_pShader->m_pHandle);
          }
        }
      }
    }
  }
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "VShaders: %d (size: %.3f Mb), Instances: %d, Device VShaders: %d (Size: %.3f Mb)", n, nSize/1024.0f/1024.0f, nInsts, ShadersVS.Num(), CHWShader_D3D::m_nDeviceVSDataSize/1024.0f/1024.0f);

  ShadersPS.SetUse(0);
  nInsts = 0;
  Name = CHWShader::mfGetClassName(eHWSC_Pixel);
  pRL = CBaseResource::GetResourcesForClass(Name);
  if (pRL)
  {
    ResourcesMapItor itor;
    for (itor=pRL->m_RMap.begin(); itor!=pRL->m_RMap.end(); itor++)
    {
      CHWShader *psh = (CHWShader *)itor->second;
      if (!psh)
        continue;
      nSize += psh->Size();
      n++;

      CHWShader_D3D *pD3D = (CHWShader_D3D *)psh;
      for (i=0; i<pD3D->m_Insts.size(); i++)
      {
        CHWShader_D3D::SHWSInstance *pShInst = &pD3D->m_Insts[i];
        if (pShInst->m_bDeleted)
          continue;
        nInsts++;
        if (pShInst->m_Handle.m_pShader)
        {
          for (j=0; j<(int)ShadersPS.Num(); j++)
          {
            if (ShadersPS[j] == pShInst->m_Handle.m_pShader->m_pHandle)
              break;
          }
          if (j == ShadersPS.Num())
          {
            ShadersPS.AddElem(pShInst->m_Handle.m_pShader->m_pHandle);
          }
        }
      }
    }
  }
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "PShaders: %d (size: %.3f Mb), Instances: %d, Device PShaders: %d (Size: %.3f Mb)", n, nSize/1024.0f/1024.0f, nInsts, ShadersPS.Num(), CHWShader_D3D::m_nDevicePSDataSize/1024.0f/1024.0f);

  n = 0;
  nSize = 0;
  int nSizeD = 0;
  int nSizeAll = 0;
  for (FXCompressedShadersItor it=CHWShader::m_CompressedShaders.begin(); it!=CHWShader::m_CompressedShaders.end(); ++it)
  {
    SHWActivatedShader *pAS = it->second;
    for (FXCompressedShaderItor itor=pAS->m_CompressedShaders.begin(); itor!=pAS->m_CompressedShaders.end(); ++itor)
    {
      n++;
      SCompressedData& Data = itor->second;
      nSize += Data.m_nSizeCompressedShader;
      nSizeD += Data.m_nSizeDecompressedShader;
    }
  }
  nSizeAll = sizeOfMapP(CHWShader::m_CompressedShaders);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Compressed Shaders in memory: %d (size: %.3f Mb), Decompressed size: %.3f Mb, Overall: %.3f", n, nSize/1024.0f/1024.0f, nSizeD/1024.0f/1024.0f, nSizeAll/1024.0f/1024.0f);

  FXShaderCacheItor FXitor;
  int nCache = 0;
  nSize = 0;
  for (FXitor=CHWShader::m_ShaderCache.begin(); FXitor!=CHWShader::m_ShaderCache.end(); FXitor++)
  {
    SShaderCache *sc = FXitor->second;
    if (!sc)
      continue;
    nCache++;
    nSize += sc->Size();
  }
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Shader Cache: %d (size: %.3f Mb)", nCache, nSize/1024.0f/1024.0f);

  nSize = 0;
  n = 0;
  CRendElement *pRE = CRendElement::m_RootGlobal.m_NextGlobal;
  while (pRE != &CRendElement::m_RootGlobal)
  {
    n++;
    nSize += pRE->Size();
    pRE = pRE->m_NextGlobal;
  }
  nY += nYstep;
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Render elements: %d (size: %.3f Mb)", n, nSize/1024.0f/1024.0f);

  int nSAll = 0;
  int nSOneMip = 0;
  int nSNM = 0;
  int nSRT = 0;
  int nObjSize = 0;
  int nStreamed = 0;
  int nStreamedSys = 0;
  int nStreamedUnload = 0;
  n = 0;
  pRL = CBaseResource::GetResourcesForClass(CTexture::mfGetClassName());
  if (pRL)
  {
    ResourcesMapItor itor;
    for (itor=pRL->m_RMap.begin(); itor!=pRL->m_RMap.end(); itor++)
    {
      CTexture *tp = (CTexture *)itor->second;
      if (!tp || tp->IsNoTexture())
        continue;
      n++;
      nObjSize += tp->GetSize(true);
      int nS = tp->GetDeviceDataSize();
      if (tp->IsStreamed())
      {
        int nSizeSys = tp->GetDataSize();
#ifndef XENON
        if (tp->IsUnloaded())
        {
          assert(nS == 0);
          nStreamedUnload += nSizeSys;
        }
        else
#endif
          nStreamedSys += nSizeSys;
        nStreamed += nS;
      }
      if (!nS)
        continue;
      if (tp->GetFlags() & (FT_USAGE_DYNAMIC | FT_USAGE_RENDERTARGET))
        nSRT += nS;
      else
      {
        if (!tp->IsStreamed())
        {
          int nnn = 0;
        }
        if (tp->GetName()[0] != '$' && tp->GetNumMips() <= 1)
          nSOneMip += nS;
        if (tp->GetFlags() & FT_TEX_NORMAL_MAP)
          nSNM += nS;
        else
          nSAll += nS;
      }
    }
  }
#ifdef XENON
  int nSizeFreePool = 0;
  STexPoolItem *pIT = CTexture::s_FreeTexPoolItems.m_PrevFree;
  while (pIT != &CTexture::s_FreeTexPoolItems)
  {
    assert (!pIT->m_pTex);
    assert (pIT->m_pDevTexture);
    nSizeFreePool += pIT->m_pOwner->m_Size;
    pIT = pIT->m_PrevFree;
  }
#endif

  nY += nYstep;
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "CryName: %d, Size: %.3f Mb...", CCryName::GetNumberOfEntries(), CCryName::GetMemoryUsage()/1024.0f/1024.0f);
  nY += nYstep;
  
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Textures: %d, ObjSize: %.3f Mb...", n, nObjSize/1024.0f/1024.0f);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, " Managed Size: %.3f Mb (Normals: %.3f Mb + Other: %.3f Mb), One mip: %.3f", (nSNM+nSAll)/1024.0f/1024.0f, nSNM/1024.0f/1024.0f, nSAll/1024.0f/1024.0f, nSOneMip/1024.0f/1024.0f);
#ifndef XENON
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, " Streamed Size: Video: %.3f, System: %.3f, Unloaded: %.3f", nStreamed/1024.0f/1024.0f, nStreamedSys/1024.0f/1024.0f, nStreamedUnload/1024.0f/1024.0f);
#else
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, " Streamed Size: Video: %.3f, Loaded percent: %.3f, Free Pools: %.3f", (float)nStreamed/1024.0f/1024.0f, (float)nStreamed/(float)nStreamedSys*100.0f, (float)nSizeFreePool/1024.0f/1024.0f);
#endif

  SDynTexture_Shadow *pTXSH = SDynTexture_Shadow::s_RootShadow.m_NextShadow;
  int nSizeSH = 0;
  while (pTXSH != &SDynTexture_Shadow::s_RootShadow)
  {
    if (pTXSH->m_pTexture)
      nSizeSH += pTXSH->m_pTexture->GetDeviceDataSize();
    pTXSH = pTXSH->m_NextShadow;
  }

  int nSizeAtlasClouds = SDynTexture2::s_nMemoryOccupied[eTP_Clouds];
  int nSizeAtlasSprites = SDynTexture2::s_nMemoryOccupied[eTP_Sprites];
  int nSizeAtlasVoxTerrain = SDynTexture2::s_nMemoryOccupied[eTP_VoxTerrain];
  int nSizeAtlasDynTexSources = SDynTexture2::s_nMemoryOccupied[eTP_DynTexSources];
  int nSizeAtlas = nSizeAtlasClouds + nSizeAtlasSprites + nSizeAtlasVoxTerrain + nSizeAtlasDynTexSources;
  int nSizeManagedDyn = SDynTexture::s_nMemoryOccupied;

  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, " Dynamic DataSize: %.3f Mb (Atlases: %.3f Mb, Managed: %.3f Mb (Shadows: %.3f Mb), Other: %.3f Mb)", nSRT/1024.0f/1024.0f, nSizeAtlas/1024.0f/1024.0f, nSizeManagedDyn/1024.0f/1024.0f, nSizeSH/1024.0f/1024.0f, (nSRT-nSizeManagedDyn-nSizeAtlas)/1024.0f/1024.0f);

  int nSizeZRT = 0;
  int nSizeCRT = 0;

  if (m_DepthBufferOrig.pSurf)
    nSizeZRT += m_DepthBufferOrig.nWidth * m_DepthBufferOrig.nHeight * 4;
  if (m_DepthBufferOrigFSAA.pSurf && m_DepthBufferOrig.pSurf != m_DepthBufferOrigFSAA.pSurf)
    nSizeZRT += m_DepthBufferOrig.nWidth * m_DepthBufferOrig.nHeight * 2 * 4;
#if !defined(XENON) 
  for (i=0; i<(int)m_TempDepths.Num(); i++)
  {
    SD3DSurface *pSrf = m_TempDepths[i];
    if (pSrf->pSurf)
      nSizeZRT += pSrf->nWidth * pSrf->nHeight * 4;
  }
#endif

  nSizeCRT += m_d3dsdBackBuffer.Width * m_d3dsdBackBuffer.Height * 4 * 2;

  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, " Targets DataSize: %.3f Mb (Color Buffer RT's: %.3f Mb, Z-Buffers: %.3f Mb", (nSizeCRT+nSizeZRT)/1024.0f/1024.0f, nSizeCRT/1024.0f/1024.0f, nSizeZRT/1024.0f/1024.0f);

  DebugPerfBars(nXBars, nYBars + 30);

  /*Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "General: %d (%d polys)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_GENERAL], m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_GENERAL]);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Decals: %d (%d polys)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_DECAL], m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_DECAL]);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Terrain layers: %d (%d polys)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_TERRAINLAYER], m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_TERRAINLAYER]);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Transparent: %d (%d polys)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_TRANSP], m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_TRANSP]);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Shadow-gen: %d (%d polys)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_SHADOW_GEN], m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_SHADOW_GEN]);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Shadow-pass: %d (%d polys)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_SHADOW_PASS], m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_SHADOW_PASS]);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Water: %d (%d polys)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_WATER], m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_WATER]);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Imposters: %d (Updates: %d)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumCloudImpostersDraw, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumCloudImpostersUpdates);
  Draw2dLabel(nX, nY+=nYstep, fFSize, &col.r, false, "Sprites: %d (%d dips, %d updates, %d polys)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumSprites, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumSpriteDIPS, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumSpriteUpdates, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumSpritePolys);*/

  //DrawQuad(ScaleCoordX(690),ScaleCoordY(nY+1),ScaleCoordX(690)+ScaleCoordX(fMainLoad),ScaleCoordY(nY+9), Col_Yellow, 1.0f);
  //DrawQuad(ScaleCoordX(690),ScaleCoordY(nY+11),ScaleCoordX(690)+ScaleCoordX(fRenderLoad),ScaleCoordY(nY+19), Col_Green, 1.0f);
  //DrawQuad(ScaleCoordX(690),ScaleCoordY(nY+21),ScaleCoordX(690)+ScaleCoordX(fGPULoad),ScaleCoordY(nY+29), Col_Red, 1.0f);

  /*crend->WriteXY(10, nYpos, 1,1,1,1,1,1, "Unique Render Items=%d (%d)",m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_NumRendItems, m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_NumRendBatches);   
  crend->WriteXY(10, nYpos += nYstep*3, 1,1,1,1,1,1, "Unique CVShaders=%d",m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_NumVShaders);
  crend->WriteXY(10, nYpos += nYstep, 1,1,1,1,1,1, "Unique CPShaders=%d",m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_NumPShaders);
  crend->WriteXY(10, nYpos += nYstep, 1,1,1,1,1,1, "Unique Textures=%d",m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_NumTextures);
  crend->WriteXY(10, nYpos += nYstep, 1,1,1,1,1,1, "PerFrame: ManagedTexturesDeviceSize=%.03f Kb, ManagedTexturesFullSize=%.03f Kb, DynTexturesSize=%.03f Kb",m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_ManagedTexturesSize/1024.0f, m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_ManagedTexturesFullSize/1024.0f, m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_DynTexturesSize/1024.0f);
  crend->WriteXY(10, nYpos += nYstep, 1,1,1,1,1,1, "TexStreamed=%.03f, TexNonStreamed=%.03f, DynTexturesSize=%.03f Kb (Max=%.03f Kb)",CTexture::s_nStatsCurManagedStreamedTexMem/1024.0f, CTexture::m_StatsCurManagedNonStreamedTexMem/1024.0f, CTexture::m_StatsCurDynamicTexMem/1024.0f);
  crend->WriteXY(10, nYpos += nYstep, 1,1,1,1,1,1, "Mesh update=%.03f Kb",m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_MeshUpdateBytes/1024.0f);
  crend->WriteXY(10, nYpos += nYstep, 1,1,1,1,1,1, "Cloud impostors: Update Size=%.03f Kb, #Upd=%d, #Draw=%d",m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_CloudImpostersSizeUpdate/1024.0f, m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_NumCloudImpostersUpdates, m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_NumCloudImpostersDraw);
  crend->WriteXY(10, nYpos += nYstep, 1,1,1,1,1,1, "Impostors: Update Size=%.03f Kb, #Upd=%d, #Draw=%d",m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_ImpostersSizeUpdate/1024.0f, m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_NumImpostersUpdates, m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_NumImpostersDraw);
  {
    CHWShader_D3D *ps = (CHWShader_D3D *)m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_pMaxPShader;
    if (ps)
      crend->WriteXY(10, nYpos += nYstep, 1,1,1,1,1,1, "MAX PShader: %s (instructions: %d, lights: %d)", ps->GetName(), ps->m_Insts[m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_nMaxPSInstance].m_nInstructions, ps->m_Insts[m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_nMaxPSInstance].m_LightMask & 0xf);
    CHWShader_D3D *vs = (CHWShader_D3D *)m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_pMaxVShader;
    if (vs)
      crend->WriteXY(10, nYpos += nYstep, 1,1,1,1,1,1, "MAX VShader: %s (instructions: %d, lights: %d)", vs->GetName(), vs->m_Insts[m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_nMaxVSInstance].m_nInstructions, vs->m_Insts[m_RP.m_PS[rd->m_RP.m_nProcessThreadID].m_nMaxVSInstance].m_LightMask & 0xf);
  }*/
}

void CD3D9Renderer::DebugVidResourcesBars(int nX, int nY)
{
  int i, j;
  int nYst = 15;
  float fFSize = 1.4f;
  ColorF col = Col_Yellow;

  // Draw performance bars
  EF_SetColorOp(eCO_MODULATE, eCO_MODULATE, DEF_TEXARG0, DEF_TEXARG0);
  EF_SetState(GS_NODEPTHTEST);

  float fMaxBar = 200;
  float fOffs = 190.0f;

  ColorF colT = Col_Gray;
  Draw2dLabel(nX+50, nY, 1.6f, &colT.r, false, "Video resources:");
  nY += 20;

  float fMaxTextureMemory = m_MaxTextureMemory * 1024.0f * 1024.0f;

  ColorF colF = Col_Orange;
  Draw2dLabel(nX, nY, fFSize, &colF.r, false, "Total memory: %d Mb", (int)(fMaxTextureMemory / 1024 / 1024));
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+fMaxBar, nY+12, Col_Cyan, 1.0f);
  nY += nYst;

  SDynTexture_Shadow *pTXSH = SDynTexture_Shadow::s_RootShadow.m_NextShadow;
  int nSizeSH = 0;
  while (pTXSH != &SDynTexture_Shadow::s_RootShadow)
  {
    if (pTXSH->m_pTexture)
      nSizeSH += pTXSH->m_pTexture->GetDeviceDataSize();
    pTXSH = pTXSH->m_NextShadow;
  }
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Shadow textures: %.1f Mb", (float)nSizeSH / 1024.0f / 1024.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+(float)nSizeSH/fMaxTextureMemory*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  SDynTexture *pTX = SDynTexture::s_Root.m_Next;
  int nSizeD = 0;
  while (pTX != &SDynTexture::s_Root)
  {
    if (pTX->m_pTexture)
      nSizeD += pTX->m_pTexture->GetDeviceDataSize();
    pTX = pTX->m_Next;
  }
  nSizeD -= nSizeSH;
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Dyn. text.: %.1f Mb", (float)nSizeD / 1024.0f / 1024.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+(float)nSizeD/fMaxTextureMemory*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  int nSizeD2 = 0;
  for (i=0; i<eTP_Max; i++)
  {
    nSizeD2 += SDynTexture2::s_nMemoryOccupied[i];
  }
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Dyn. atlas text.: %.1f Mb", (float)nSizeD2 / 1024.0f / 1024.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+(float)nSizeD2/fMaxTextureMemory*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  int nSizeZRT = 0;
  int nSizeCRT = 0;
  if (m_DepthBufferOrig.pSurf)
    nSizeZRT += m_DepthBufferOrig.nWidth * m_DepthBufferOrig.nHeight * 4;
  if (m_DepthBufferOrigFSAA.pSurf && m_DepthBufferOrig.pSurf != m_DepthBufferOrigFSAA.pSurf)
    nSizeZRT += m_DepthBufferOrig.nWidth * m_DepthBufferOrig.nHeight * 2 * 4;
#if !defined(XENON)
  for (i=0; i<(int)m_TempDepths.Num(); i++)
  {
    SD3DSurface *pSrf = m_TempDepths[i];
    if (pSrf->pSurf)
      nSizeZRT += pSrf->nWidth * pSrf->nHeight * 4;
  }
#endif
  nSizeCRT += m_d3dsdBackBuffer.Width * m_d3dsdBackBuffer.Height * 4 * 2;
  nSizeCRT += nSizeZRT;
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Frame targets: %.1f Mb", (float)nSizeCRT / 1024.0f / 1024.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+(float)nSizeCRT/fMaxTextureMemory*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  int nSAll = 0;
  int nSOneMip = 0;
  int nSNM = 0;
  int nSRT = 0;
  int nObjSize = 0;
  int nStreamed = 0;
  int nStreamedSys = 0;
  int nStreamedUnload = 0;
  i = 0;
  SResourceContainer *pRL = CBaseResource::GetResourcesForClass(CTexture::mfGetClassName());
  if (pRL)
  {
    ResourcesMapItor itor;
    for (itor=pRL->m_RMap.begin(); itor!=pRL->m_RMap.end(); itor++)
    {
      CTexture *tp = (CTexture *)itor->second;
      if (!tp || tp->IsNoTexture())
        continue;
      i++;
      nObjSize += tp->GetSize(true);
      int nS = tp->GetDeviceDataSize();
      if (tp->IsStreamed())
      {
        int nSizeSys = tp->GetDataSize();
#ifndef XENON
        if (tp->IsUnloaded())
        {
          assert(nS == 0);
          nStreamedUnload += nSizeSys;
        }
        else
#endif
          nStreamedSys += nSizeSys;
        nStreamed += nS;
      }
      if (!nS)
        continue;
      if (tp->GetFlags() & (FT_USAGE_DYNAMIC | FT_USAGE_RENDERTARGET))
        nSRT += nS;
      else
      {
        if (!tp->IsStreamed())
        {
          int nnn = 0;
        }
        if (tp->GetName()[0] != '$' && tp->GetNumMips() <= 1)
          nSOneMip += nS;
        if (tp->GetFlags() & FT_TEX_NORMAL_MAP)
          nSNM += nS;
        else
          nSAll += nS;
      }
    }
  }
  nSRT -= (nSizeD + nSizeD2 + nSizeSH);
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Render targets: %.1f Mb", (float)nSRT / 1024.0f / 1024.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+(float)nSRT/fMaxTextureMemory*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Textures: %.1f Mb", (float)nSAll / 1024.0f / 1024.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+(float)nSAll/fMaxTextureMemory*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  int nSizeMeshes = 0;
  CRenderMesh2 *pRM = CRenderMesh2::m_Root.m_Next;
  CRenderMesh2 *pNext;
  for (pRM=CRenderMesh2::m_Root.m_Next; pRM != &CRenderMesh2::m_Root; pRM=pNext)
  {
    pNext = pRM->m_Next;
		nSizeMeshes += pRM->Size(CRenderMesh2::SIZE_VB | CRenderMesh2::SIZE_IB);
  }
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Meshes: %.1f Mb", (float)nSizeMeshes / 1024.0f / 1024.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+(float)nSizeMeshes/fMaxTextureMemory*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  int nSizeDynM = 0;
  for (j=0; j<POOL_MAX; j++)
  {
    for (i=0; i<4; i++)
    {
      _VertBufferSize(m_pVBAr[j][i]);
    }
  }
  for (i=0; i<4; i++)
  {
    nSizeDynM += _IndexBufferSize(m_pIBAr[i]);
  }
  for (j=0; j<MAX_DYNVBS; j++)
  {
    if (m_RP.m_VBs[j].VBPtr_0)
    {
      nSizeDynM += m_RP.m_VBs[j].VBPtr_0->GetSize();
    }
  }
  if (m_RP.m_IndexBuf)
    nSizeDynM += m_RP.m_IndexBuf->GetSize();
  if (m_RP.m_VB_Inst)
    nSizeDynM += m_RP.m_VB_Inst->GetSize();
  //////////////////////////////////////////////////////////////////////////
  for (i=0; i<SHAPE_MAX; i++)
  {
    nSizeDynM += _VertBufferSize(m_pUnitFrustumVB[i]);
    nSizeDynM += _IndexBufferSize(m_pUnitFrustumIB[i]);
  }
  nSizeDynM += _VertBufferSize(m_pUnitSphereVB);
  nSizeDynM += _IndexBufferSize(m_pUnitSphereIB);
  nSizeDynM += _VertBufferSize(m_pUnitBoxVB);
  nSizeDynM += _IndexBufferSize(m_pUnitBoxIB);

#if defined(ENABLE_RENDER_AUX_GEOM)
  if (m_pRenderAuxGeomD3D)
    m_pRenderAuxGeomD3D->GetDeviceDataSize();
#endif

  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Dyn. mesh: %.1f Mb", (float)nSizeDynM / 1024.0f / 1024.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+(float)nSizeDynM/fMaxTextureMemory*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst+4;

#ifdef XENON
  int nSize = nSizeDynM + nSRT + nSizeCRT + nSizeSH + nSizeD + nSizeD2 + nSAll + nSizeMeshes;
  ColorF colO = Col_Blue;
  Draw2dLabel(nX, nY, fFSize, &colO.r, false, "Overall: %.1f Mb", (float)nSize / 1024.0f / 1024.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+(float)nSize/fMaxTextureMemory*fMaxBar, nY+12, Col_White, 1.0f);
  nY += nYst;
#else
  int nSize = nSizeDynM + nSRT + nSizeCRT + nSizeSH + nSizeD + nSizeD2;
  ColorF colO = Col_Blue;
  Draw2dLabel(nX, nY, fFSize, &colO.r, false, "Overall (Pure): %.1f Mb", (float)nSize / 1024.0f / 1024.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+(float)nSize/fMaxTextureMemory*fMaxBar, nY+12, Col_White, 1.0f);
  nY += nYst;
#endif
}

void CD3D9Renderer::DebugPerfBars(int nX, int nY)
{
  int nYst = 15;
  float fFSize = 1.4f;
  ColorF col = Col_Yellow;

  // Draw performance bars
  Set2DMode(true, m_width, m_height);
  EF_SetColorOp(eCO_MODULATE, eCO_MODULATE, DEF_TEXARG0, DEF_TEXARG0);
  EF_SetState(GS_NODEPTHTEST);
  D3DSetCull(eCULL_None);
  FX_SetFPMode();

  static float fTimeDIP[EFSLIST_NUM];
  static float fTimeDIPZ;
  static float fTimeDIPRAIN;
  static float fTimeDIPLayers;
  static float fTimeDIPSprites;
  static float fWaitForGPU;
  static float fFrameTime;

  float fMaxBar = 200;
  float fOffs = 180.0f;

  ColorF colT = Col_Gray;
  Draw2dLabel(nX+50, nY, 1.6f, &colT.r, false, "Performance:");
  nY += 20;

  float fSmooth = 5.0f;
  fFrameTime = (iTimer->GetFrameTime() + fFrameTime*fSmooth) / (fSmooth+1.0f);

  ColorF colF = Col_Orange;
  Draw2dLabel(nX, nY, fFSize, &colF.r, false, "Frame: %.3fms", fFrameTime*1000.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+fMaxBar, nY+12, Col_Cyan, 1.0f);
  nY += nYst;

  fTimeDIPZ = (m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPsZ + fTimeDIPZ*fSmooth) / (fSmooth+1.0f);
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "ZPass: %.3fms", fTimeDIPZ*1000.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+fTimeDIPZ/fFrameTime*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  fTimeDIP[EFSLIST_DEFERRED_PREPROCESS] = (m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPs[EFSLIST_DEFERRED_PREPROCESS] + fTimeDIP[EFSLIST_DEFERRED_PREPROCESS]*fSmooth) / (fSmooth+1.0f);
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Deferred Prepr.: %.3fms", fTimeDIP[EFSLIST_DEFERRED_PREPROCESS]*1000.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+fTimeDIP[EFSLIST_DEFERRED_PREPROCESS]/fFrameTime*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  fTimeDIP[EFSLIST_GENERAL] = (m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPs[EFSLIST_GENERAL] + fTimeDIP[EFSLIST_GENERAL]*fSmooth) / (fSmooth+1.0f);
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "General: %.3fms", fTimeDIP[EFSLIST_GENERAL]*1000.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+fTimeDIP[EFSLIST_GENERAL]/fFrameTime*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  fTimeDIP[EFSLIST_TERRAINLAYER] = (m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPs[EFSLIST_TERRAINLAYER] + fTimeDIP[EFSLIST_TERRAINLAYER]*fSmooth) / (fSmooth+1.0f);
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Terrain Layers: %.3fms", fTimeDIP[EFSLIST_TERRAINLAYER]*1000.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+fTimeDIP[EFSLIST_TERRAINLAYER]/fFrameTime*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  fTimeDIP[EFSLIST_SHADOW_GEN] = (m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPs[EFSLIST_SHADOW_GEN] + fTimeDIP[EFSLIST_SHADOW_GEN]*fSmooth) / (fSmooth+1.0f);
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "ShadowGen: %.3fms", fTimeDIP[EFSLIST_SHADOW_GEN]*1000.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+fTimeDIP[EFSLIST_SHADOW_GEN]/fFrameTime*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  fTimeDIP[EFSLIST_DECAL] = (m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPs[EFSLIST_DECAL] + fTimeDIP[EFSLIST_DECAL]*fSmooth) / (fSmooth+1.0f);
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Decals: %.3fms", fTimeDIP[EFSLIST_DECAL]*1000.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+fTimeDIP[EFSLIST_DECAL]/fFrameTime*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  fTimeDIPRAIN = (m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPsRAIN + fTimeDIPRAIN*fSmooth) / (fSmooth+1.0f);
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Rain: %.3fms", fTimeDIPRAIN*1000.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+fTimeDIPRAIN/fFrameTime*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  fTimeDIPLayers = (m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPsDeferredLayers + fTimeDIPLayers*fSmooth) / (fSmooth+1.0f);
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Deferred Layers: %.3fms", fTimeDIPLayers*1000.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+fTimeDIPLayers/fFrameTime*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  fTimeDIP[EFSLIST_WATER_VOLUMES] = (m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPs[EFSLIST_WATER_VOLUMES] + fTimeDIP[EFSLIST_WATER_VOLUMES]*fSmooth) / (fSmooth+1.0f);
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Water volumes: %.3fms", fTimeDIP[EFSLIST_WATER_VOLUMES]*1000.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+fTimeDIP[EFSLIST_WATER_VOLUMES]/fFrameTime*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  fTimeDIP[EFSLIST_TRANSP] = (m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPs[EFSLIST_TRANSP] + fTimeDIP[EFSLIST_TRANSP]*fSmooth) / (fSmooth+1.0f);
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Transparent: %.3fms", fTimeDIP[EFSLIST_TRANSP]*1000.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+fTimeDIP[EFSLIST_TRANSP]/fFrameTime*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  fTimeDIP[EFSLIST_POSTPROCESS] = (m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPs[EFSLIST_POSTPROCESS] + fTimeDIP[EFSLIST_POSTPROCESS]*fSmooth) / (fSmooth+1.0f);
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Postprocessing: %.3fms", fTimeDIP[EFSLIST_POSTPROCESS]*1000.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+fTimeDIP[EFSLIST_POSTPROCESS]/fFrameTime*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  fTimeDIPSprites = (m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTimeDIPsSprites + fTimeDIPSprites*fSmooth) / (fSmooth+1.0f);
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Sprites: %.3fms", fTimeDIPSprites*1000.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+fTimeDIPSprites/fFrameTime*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  fWaitForGPU = (m_fTimeWaitForGPU[m_RP.m_nProcessThreadID] + fWaitForGPU*fSmooth) / (fSmooth+1.0f);
  Draw2dLabel(nX, nY, fFSize, &col.r, false, "Wait for GPU: %.3fms", fWaitForGPU*1000.0f);
  CTexture::s_ptexWhite->Apply();
  DrawQuad(nX + fOffs, nY+1, nX + fOffs+fWaitForGPU/fFrameTime*fMaxBar, nY+12, Col_Green, 1.0f);
  nY += nYst;

  Set2DMode(false, m_width, m_height);
}

_inline bool CompareTexturesSize( CTexture *a,  CTexture *b)
{
  return (a->GetDeviceDataSize() > b->GetDeviceDataSize());
}

void CD3D9Renderer::VidMemLog()
{
  if( !CV_r_logVidMem )
    return;

  SResourceContainer *pRL = 0;
  
  pRL = CBaseResource::GetResourcesForClass( CTexture::mfGetClassName() );

  DynArray<CTexture *> pRenderTargets;
  DynArray<CTexture *> pDynTextures;
  DynArray<CTexture *> pTextures;

  int nSizeTotalRT = 0;
  int nSizeTotalDynTex = 0;
  int nSizeTotalTex = 0;

  for (uint32 i=0; i<pRL->m_RList.size(); ++i)
  {
    CTexture *pTexResource = (CTexture *) pRL->m_RList[i];
    if( !pTexResource )
      continue;
    
    if( !pTexResource->GetDeviceDataSize() )
      continue;

    if( pTexResource->GetFlags() & FT_USAGE_RENDERTARGET )
    {
      pRenderTargets.push_back( pTexResource );
      nSizeTotalRT += pTexResource->GetDeviceDataSize();
    }
    else
    if( pTexResource->GetFlags() & FT_USAGE_DYNAMIC )
    {
      pDynTextures.push_back( pTexResource );
      nSizeTotalDynTex += pTexResource->GetDeviceDataSize();
    }
    else
    {
      pTextures.push_back( pTexResource );
      nSizeTotalTex += pTexResource->GetDeviceDataSize();
    }
  }
 
  std::sort(pRenderTargets.begin(), pRenderTargets.end(), CompareTexturesSize);
  std::sort(pDynTextures.begin(), pDynTextures.end(), CompareTexturesSize);
  std::sort(pTextures.begin(), pTextures.end(), CompareTexturesSize);

  FILE *fp = fxopen("VidMemLogTest.txt", "w");
  if( fp )
  {
      char time[128];
      char date[128];

      _strtime( time );
      _strdate( date );

      fprintf(fp, "\n==========================================\n");
      fprintf(fp, "VidMem Log file opened: %s (%s)\n", date, time);
      fprintf(fp, "==========================================\n");

      fprintf(fp, "\nTotal Vid mem used for textures: %d MB", (nSizeTotalRT + nSizeTotalDynTex + nSizeTotalTex) /1024/1024 );
      fprintf(fp, "\nRender targets (%d): %d kb, Dynamic textures (%d): %d kb, Textures (%d): %d kb", pRenderTargets.size(), nSizeTotalRT/1024, pDynTextures.size(), nSizeTotalDynTex/1024, pTextures.size(), nSizeTotalTex /1024);      

      fprintf(fp, "\n\n*** Start render targets list *** \n");
      int i = 0;
      for( i = 0 ; i < pRenderTargets.size(); ++i)
      {
        fprintf(fp, "\nName: %s, Format: %s, Width: %d, Height: %d, Size: %d kb", pRenderTargets[i]->GetName(), pRenderTargets[i]->GetFormatName(), pRenderTargets[i]->GetWidth(), 
          pRenderTargets[i]->GetHeight(), pRenderTargets[i]->GetDeviceDataSize()/1024);
      }

      fprintf(fp, "\n\n*** Start dynamic textures list *** \n");
      for( i = 0 ; i < pDynTextures.size(); ++i)
      {
        fprintf(fp, "\nName: %s, Format: %s, Width: %d, Height: %d, Size: %d kb", pDynTextures[i]->GetName(), pDynTextures[i]->GetFormatName(), pDynTextures[i]->GetWidth(), 
          pDynTextures[i]->GetHeight(), pDynTextures[i]->GetDeviceDataSize()/1024);
      }

      fprintf(fp, "\n\n*** Start textures list *** \n");
      for( i = 0 ; i < pTextures.size(); ++i)
      {
        fprintf(fp, "\nName: %s, Format: %s, Width: %d, Height: %d, Size: %d kb", pTextures[i]->GetName(), pTextures[i]->GetFormatName(), pTextures[i]->GetWidth(), 
          pTextures[i]->GetHeight(), pTextures[i]->GetDeviceDataSize()/1024);
      }

      fprintf(fp, "\n\n==========================================\n");
      fprintf(fp, "VidMem Log file closed\n");
      fprintf(fp, "==========================================\n\n");

      fclose(fp);
      fp = NULL;
  }

  CV_r_logVidMem = 0;
}


void CD3D9Renderer::DebugPrintShader(CHWShader_D3D *pSH, void *pI, int nX, int nY, ColorF colSH)
{
  if (!pSH)
    return;
  CHWShader_D3D::SHWSInstance *pInst = (CHWShader_D3D::SHWSInstance *)pI;
  if (!pInst)
    return;

  char str[512];
  pSH->m_pCurInst = pInst;
  strcpy(str, pSH->m_EntryFunc.c_str());
  uint32 nSize = strlen(str);
  pSH->mfGenName(pInst, &str[nSize], 512, 1);

  ColorF col = Col_Green;
  Draw2dLabel(nX, nY, 1.6f, &col.r, false, "Shader: %s (%d instructions)", str, pInst->m_nInstructions);
  nX += 10; nY += 25;

  SD3DShader *pHWS = pInst->m_Handle.m_pShader;
  if (!pHWS || !pHWS->m_pHandle)
    return;
#if defined(DIRECT3D9)
  HRESULT hr = S_OK;
  byte *pData = NULL;
  if (pInst->m_eClass == eHWSC_Vertex)
  {
    IDirect3DVertexShader9 *pVS = (IDirect3DVertexShader9 *)pHWS->m_pHandle;
    hr = pVS->GetFunction(NULL, &nSize);
    if (FAILED(hr))
      return;
    pData = new byte[nSize];
    hr = pVS->GetFunction(pData, &nSize);
  }
  else
  {
    IDirect3DPixelShader9 *pPS = (IDirect3DPixelShader9 *)pHWS->m_pHandle;
    hr = pPS->GetFunction(NULL, &nSize);
    if (FAILED(hr))
      return;
    pData = new byte[nSize];
    hr = pPS->GetFunction(pData, &nSize);
  }
  LPD3DXBUFFER pAsm = NULL;
  hr = D3DXDisassembleShader((DWORD *)pData, FALSE, NULL, &pAsm);
  if (!pAsm)
  {
    SAFE_DELETE_ARRAY(pData);
    return;
  }
  char *szAsm = (char *)pAsm->GetBufferPointer();
#elif defined(DIRECT3D10)
  if (!pInst->m_pShaderData)
    return;
  byte *pData = NULL;
  ID3D10Blob* pAsm = NULL;
  D3DDisassemble((UINT *)pInst->m_pShaderData, pInst->m_nShaderByteCodeSize, 0, NULL, &pAsm);
  if (!pAsm)
    return;
  char *szAsm = (char *)pAsm->GetBufferPointer();
#endif
  int nMaxY = m_height;
  int nM = 0;
  while (szAsm[0])
  {
    fxFillCR(&szAsm, str);
    Draw2dLabel(nX, nY, 1.2f, &colSH.r, false, "%s", str);
    nY += 11;
    if (nY+12 > nMaxY)
    {
      nX += 280;
      nY = 120;
      nM++;
    }
    if (nM == 2)
      break;
  }

  SAFE_RELEASE(pAsm);
  SAFE_DELETE_ARRAY(pData);
}

void CD3D9Renderer::DebugDrawStats2()
{
  const int nYstep = 10;
  int nY = 30; // initial Y pos
  int nX = 20; // initial X pos
  static int snTech = 0;

  if (!g_SelectedTechs.size())
    return;

#if defined(XENON)
  XINPUT_KEYSTROKE keyStroke;
  int result = XInputGetKeystroke(XUSER_INDEX_ANY, XINPUT_FLAG_KEYBOARD, &keyStroke);
  if (result == ERROR_SUCCESS)
  {
    if (!(keyStroke.Flags & XINPUT_KEYSTROKE_REPEAT))
    {
      if (keyStroke.Flags & XINPUT_KEYSTROKE_KEYDOWN)
      {
        if (keyStroke.VirtualKey >= '0' && keyStroke.VirtualKey <= '9')
          snTech = keyStroke.VirtualKey - '0';
      }
    }
  }
#elif defined(PS3)
	if (CryGetAsyncKeyState(CELL_KEYC_0) & 0x1)
		snTech = 0;
	if (CryGetAsyncKeyState(CELL_KEYC_1) & 0x1)
		snTech = 1;
	if (CryGetAsyncKeyState(CELL_KEYC_2) & 0x1)
		snTech = 2;
	if (CryGetAsyncKeyState(CELL_KEYC_3) & 0x1)
		snTech = 3;
	if (CryGetAsyncKeyState(CELL_KEYC_4) & 0x1)
		snTech = 4;
	if (CryGetAsyncKeyState(CELL_KEYC_5) & 0x1)
		snTech = 5;
	if (CryGetAsyncKeyState(CELL_KEYC_6) & 0x1)
		snTech = 6;
	if (CryGetAsyncKeyState(CELL_KEYC_7) & 0x1)
		snTech = 7;
	if (CryGetAsyncKeyState(CELL_KEYC_8) & 0x1)
		snTech = 8;
	if (CryGetAsyncKeyState(CELL_KEYC_9) & 0x1)
		snTech = 9;
#else
	if (CryGetAsyncKeyState('0') & 0x1)
		snTech = 0;
	if (CryGetAsyncKeyState('1') & 0x1)
		snTech = 1;
	if (CryGetAsyncKeyState('2') & 0x1)
		snTech = 2;
	if (CryGetAsyncKeyState('3') & 0x1)
		snTech = 3;
	if (CryGetAsyncKeyState('4') & 0x1)
		snTech = 4;
	if (CryGetAsyncKeyState('5') & 0x1)
		snTech = 5;
	if (CryGetAsyncKeyState('6') & 0x1)
		snTech = 6;
	if (CryGetAsyncKeyState('7') & 0x1)
		snTech = 7;
	if (CryGetAsyncKeyState('8') & 0x1)
		snTech = 8;
	if (CryGetAsyncKeyState('9') & 0x1)
		snTech = 9;
#endif

  TArray<SShaderTechniqueStat *> Techs;
  int i, j;
  for (i=0; i<g_SelectedTechs.size(); i++)
  {
    SShaderTechniqueStat *pTech = &g_SelectedTechs[i];
    for (j=0; j<(int)Techs.Num(); j++)
    {
      if (Techs[j]->pVSInst == pTech->pVSInst && Techs[j]->pPSInst == pTech->pPSInst)
        break;
    }
    if (j == Techs.Num())
      Techs.AddElem(pTech);
  }

  if (snTech >= (int)Techs.Num())
    snTech = Techs.Num()-1;
  SShaderTechniqueStat *pTech = Techs[snTech];

  ColorF col = Col_Yellow;
  Draw2dLabel(nX, nY, 2.0f, &col.r, false, "FX Shader: %s, Technique: %s (%d out of %d), Pass: %d", pTech->pShader->GetName(), pTech->pTech->m_NameStr.c_str(), snTech, Techs.Num(), 0);
  nY += 25;

  CHWShader_D3D *pVS = pTech->pVS;
  CHWShader_D3D *pPS = pTech->pPS;
  DebugPrintShader(pTech->pVS, pTech->pVSInst, nX-10, nY, Col_White);
  DebugPrintShader(pPS, pTech->pPSInst, nX+450, nY, Col_Cyan);
}

void CD3D9Renderer::DebugDrawStats()
{
  //if (!CV_r_stats)
    //return;

	if(CV_r_stats)
	{
		CRenderer *crend=gRenDev;

		CCryNameTSCRC Name;
		switch (CV_r_stats)
		{
		case 1:
			DebugDrawStats1();
			break;
		case 2:
			DebugDrawStats2();
			break;
		case 3:
			DebugPerfBars(40, 50);
			DebugVidResourcesBars(450, 50);
			break;
    case 4:
      DebugPerfBars(40, 50);
      break;
		case 11:
			EF_PrintRTStats("Used Render Targets:");
			break;
		case 12:
			EF_PrintRTStats("Used unique Render Targets:");
			break;
		case 13:
			EF_PrintRTStats("Cleared Render Targets:");
			break;
		case 5:
			{
				const int nYstep = 30;
				int nYpos = 270; // initial Y pos
				crend->WriteXY(10, nYpos+=nYstep, 2,2,1,1,1,1, "CREOcclusionQuery stats:%d",
					CREOcclusionQuery::m_nQueriesPerFrameCounter);   
				crend->WriteXY(10, nYpos+=nYstep, 2,2,1,1,1,1, "CREOcclusionQuery::m_nQueriesPerFrameCounter=%d",
					CREOcclusionQuery::m_nQueriesPerFrameCounter);   
				crend->WriteXY(10, nYpos+=nYstep, 2,2,1,1,1,1, "CREOcclusionQuery::m_nReadResultNowCounter=%d",
					CREOcclusionQuery::m_nReadResultNowCounter);   
				crend->WriteXY(10, nYpos+=nYstep, 2,2,1,1,1,1, "CREOcclusionQuery::m_nReadResultTryCounter=%d",
					CREOcclusionQuery::m_nReadResultTryCounter);   
			}
			break;

		case 6:
			{
				ColorF clrDP = ColorF(0,1,1,1);
				ColorF clrInfo = ColorF(1,1,0,1);

				SRenderPipeline::RNDrawcallsMapItor pEnd = m_RP.m_pRNDrawCallsInfo.end();
				SRenderPipeline::RNDrawcallsMapItor pItor = m_RP.m_pRNDrawCallsInfo.begin();
				for( ; pItor != pEnd; ++ pItor )
				{
					IRenderNode *pRenderNode = pItor->first;
					SDrawCallCountInfo &pInfo = pItor->second;

					uint32 nDrawcalls = pInfo.nShadows + pInfo.nZpass + pInfo.nGeneral + pInfo.nMisc;

					// Display drawcall count per render object
					DrawLabelEx( pInfo.pPos,1.3f,&clrDP.r,true,true,"DP: %d (%d/%d/%d/%d)", 
						nDrawcalls, pInfo.nZpass, pInfo.nGeneral, pInfo.nShadows, pInfo.nMisc); 
				}

				Draw2dLabel( 40.f, 40.f, 1.3f,&clrInfo.r,false,"Instance drawcall count (zpass/general/shadows/misc)"); 
			}
			break;

		case 7:
#if defined(ENABLE_GPU_TIMERS)

			if (m_profiler != 0)
				m_profiler->Draw(*this);
			else
				RenderGpuStats();

#else
			ColorF clr = ColorF(1,0,0,1);
			Draw2dLabel( 40.f, 40.f, 2.f, &clr.r, false, "GPU STATS NOT ENABLED" ); 
#endif
			break;
		}
	}

	if(m_pDebugRenderNode)
	{
		static ICVar* debugDraw = gEnv->pConsole->GetCVar("e_DebugDraw");

		if ( debugDraw && debugDraw->GetIVal()==16 )
		{
			float yellow[4] = {1.f,1.f,0.f,1.f};
			
			SRenderPipeline::RNDrawcallsMapItor pEnd = m_RP.m_pRNDrawCallsInfo.end();
      SRenderPipeline::RNDrawcallsMapItor pItor = m_RP.m_pRNDrawCallsInfo.begin();
      for( ; pItor != pEnd; ++ pItor )
      {
        IRenderNode *pRenderNode = pItor->first;

				//display info for render node under debug gun
				if( pRenderNode==m_pDebugRenderNode )
				{
					SDrawCallCountInfo &pInfo = pItor->second;

					uint32 nDrawcalls = pInfo.nShadows + pInfo.nZpass + pInfo.nGeneral + pInfo.nMisc;

					Draw2dLabel(	970.f, 65.f, 1.5f, yellow, false, "Draw calls: %d \n  zpass: %d\n  general: %d\n  shadows: %d\n  misc: %d\n",
												nDrawcalls, pInfo.nZpass, pInfo.nGeneral, pInfo.nShadows, pInfo.nMisc); 
				}
#if defined(ENABLE_GPU_TIMERS)
				RenderGpuStatsDebugNode();
#endif
      }
		}
	}
}

void CD3D9Renderer::RenderDebug()
{
	m_pRT->RC_RenderDebug();
}

void CD3D9Renderer::RT_RenderDebug()
{
  if (CV_r_showmt)
  {
    static float fWaitForMain;
    static float fWaitForRender;
    static float fWaitForGPU;
    static float fGPUIdlePerc;
    static float fFrameTime;
    static float fRenderTime;
		static float fSpuMainLoad;
		static float fSpuDXPSLoad;
		static bool firstTime = false;
		if(firstTime)
		{
			fWaitForMain = fWaitForRender = fWaitForGPU = fGPUIdlePerc = 
				fFrameTime = fSpuMainLoad = fSpuDXPSLoad = fRenderTime = 0;
			firstTime = false;
		}
    float fSmooth = 8.0f;
    fWaitForMain = (m_fTimeWaitForMain[m_RP.m_nProcessThreadID] + fWaitForMain*fSmooth) / (fSmooth+1.0f);
    fWaitForRender = (m_fTimeWaitForRender[m_RP.m_nProcessThreadID] + fWaitForRender*fSmooth) / (fSmooth+1.0f);
    fWaitForGPU = (m_fTimeWaitForGPU[m_RP.m_nProcessThreadID] + fWaitForGPU*fSmooth) / (fSmooth+1.0f);
    fGPUIdlePerc = (m_fTimeGPUIdlePercent[m_RP.m_nProcessThreadID] + fGPUIdlePerc*fSmooth) / (fSmooth+1.0f);
    fFrameTime = (iTimer->GetFrameTime() + fFrameTime*fSmooth) / (fSmooth+1.0f);
    if (fWaitForGPU < 0.001f)
      fWaitForGPU = 0;

		const uint32 xStartCoord = 695;

    float fMainLoad = min(max((fFrameTime-fWaitForRender)/fFrameTime*100.0f, 0.0f),100.f);
#ifdef PS3
		fRenderTime = (gRenDev->m_fTimeProcessedRT[m_RP.m_nProcessThreadID] + fRenderTime*fSmooth) / (fSmooth+1.0f);
    float fRenderLoad = min(100.f,max(0.f,((min(fRenderTime,fFrameTime)-fWaitForGPU)/fFrameTime*100.0f)));
    float fGPULoad = 100.f - fGPUIdlePerc;
		fGPULoad = min(100.f, fGPULoad * 100.f/98.f);//seems we never scale up to 100 % with current calc scheme
#else
    float fRenderLoad = max((fFrameTime-(fWaitForMain+fWaitForGPU))/fFrameTime*100.0f, 0.0f);
    float fGPULoad = 100.f - fGPUIdlePerc;
#endif

    int nY = 100;

    WriteXY(580,nY,1,1,1,1,0,1,		"Main load:     %d%%", (int)fMainLoad);
    WriteXY(580,nY+10,1,1,0,1,0,1,"Render load:   %d%%", (int)fRenderLoad);
    WriteXY(580,nY+19,1,1,1,0,0,1,"GPU load:      %d%%", (int)fGPULoad);
#ifdef PS3
		float fFmodLoad=0.f,fSpuDXPSLoadCur=0.f,fSpuMainLoadCur=0.f;
		if(IsSPUEnabled())
		{
			//get fmod usage, fDSP in percentage
			float fStream,fUpdate,fTotal;
			if(gEnv->pSoundSystem && gEnv->pSoundSystem->GetIAudioDevice())
				gEnv->pSoundSystem->GetIAudioDevice()->GetCpuUsage(&fFmodLoad, &fStream, 0, &fUpdate, &fTotal);
			//get spu dxps usage
			const float cConvFactor = 1.f/1000.f;
			const NPPU::SFrameProfileRSXData& crProfData = GetFrameStatsSPUThread();
			fSpuDXPSLoadCur = (float)crProfData.frameTime * cConvFactor;//in ms
			if(fFrameTime > 0)
				fSpuDXPSLoadCur = fSpuDXPSLoadCur * 100.f / (fFrameTime*1000.f);//in percentage
			else
				fSpuDXPSLoadCur = 0;
			const uint32 cMaxSPU = GetIJobManSPU()->GetSPUsAllowed()+1;
			NPPU::SSPUFrameStats spuStats;
			GetIJobManSPU()->GetAndResetSPUFrameStats(spuStats, !gEnv->bProfilerEnabled);
			for(uint32 i=1; i<cMaxSPU-1; ++i)
				fSpuMainLoadCur = max(fSpuMainLoadCur, spuStats.spuStatsPerc[i]);
			fSpuMainLoad = (fSpuMainLoadCur + fSpuMainLoad*fSmooth) / (fSmooth+1.0f);
			fSpuDXPSLoad = min(100.f,(fSpuDXPSLoadCur + fSpuDXPSLoad*fSmooth) / (fSmooth+1.0f));
	    WriteXY(580,nY+28,1,1,0.2,0.2,1,1,"SPU DXPS load: %d%%", (int)fSpuDXPSLoad);
		  WriteXY(580,nY+37,1,1,0,1,1,1,"SPU Main load: %d%%", (int)fSpuMainLoad);
			WriteXY(580,nY+46,1,1,1,1,1,1,"FMod load:     %d%%", (int)fFmodLoad);
		}
#else
    WriteXY(580,nY+28,1,1,1,1,1,1,"CPU waits for GPU: %.3f ms", fWaitForGPU*1000.0f);
    WriteXY(580,nY+40,1,1,0,1,0,1,"Main load time (CPU): %.3f ms", (fFrameTime-fWaitForRender) * 1000.0f);
    WriteXY(580,nY+52,1,1,0,1,0,1,"Render scene time (CPU): %.3f ms", m_RP.m_PS[m_RP.m_nProcessThreadID].m_fRenderTime * 1000.0f);
#ifdef XENON
    //WriteXY(580,nY+64,1,1,0,1,0,1,"GPU scene time: %.3f ms", fGPULoad * fFrameTime * 10.0f);
#endif
    WriteXY(500,nY+82,1,1,0,1,0,1,"Occlusions: Issued: %d, Occluded: %d, NotReady: %d", m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumQIssued, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumQOccluded, m_RP.m_PS[m_RP.m_nProcessThreadID].m_NumQNotReady);
#endif
    SetColorOp(eCO_MODULATE, eCO_MODULATE, DEF_TEXARG0, DEF_TEXARG0);
    SetState(GS_NODEPTHTEST);
    CTexture::s_ptexWhite->Apply();
    DrawQuad(ScaleCoordX(xStartCoord),ScaleCoordY(nY+1),ScaleCoordX(xStartCoord)+ScaleCoordX(fMainLoad),ScaleCoordY(nY+9), Col_Yellow, 1.0f);
    DrawQuad(ScaleCoordX(xStartCoord),ScaleCoordY(nY+11),ScaleCoordX(xStartCoord)+ScaleCoordX(fRenderLoad),ScaleCoordY(nY+19), Col_Green, 1.0f);
#ifndef XENON
    DrawQuad(ScaleCoordX(xStartCoord),ScaleCoordY(nY+20),ScaleCoordX(xStartCoord)+ScaleCoordX(fGPULoad),ScaleCoordY(nY+28), Col_Red, 1.0f);
#endif
#ifdef PS3
		if(IsSPUEnabled())
		{
	    DrawQuad(ScaleCoordX(xStartCoord),ScaleCoordY(nY+29),ScaleCoordX(xStartCoord)+ScaleCoordX(fSpuDXPSLoad),ScaleCoordY(nY+37), Col_Blue, 1.0f);
		  DrawQuad(ScaleCoordX(xStartCoord),ScaleCoordY(nY+38),ScaleCoordX(xStartCoord)+ScaleCoordX(fSpuMainLoad),ScaleCoordY(nY+46), Col_Cyan, 1.0f);
			DrawQuad(ScaleCoordX(xStartCoord),ScaleCoordY(nY+47),ScaleCoordX(xStartCoord)+ScaleCoordX(fFmodLoad),ScaleCoordY(nY+55), Col_White, 1.0f);
			//draw wait for gpu percentage behind render thread load quad
			const float fWaitGPUPerc = fWaitForGPU/fFrameTime*100.0f;
			DrawQuad(ScaleCoordX(xStartCoord)+ScaleCoordX(fRenderLoad),ScaleCoordY(nY+11),ScaleCoordX(xStartCoord)+ScaleCoordX(fRenderLoad)+ScaleCoordX(fWaitGPUPerc),ScaleCoordY(nY+19), ColorF (1.f, 0.5f, 0.1f), 1.0f);
		}
#endif
  }

	
#ifndef EXCLUDE_DOCUMENTATION_PURPOSE
	if(CV_r_DebugFontRendering)
	{
		const float fPixelPerfectScale = 16.0f/UIDRAW_TEXTSIZEFACTOR * 2.0f;		// we have to compensate  vSize.x/16.0f; and pFont->SetCharWidthScale(0.5f);
		const int line=10;

		float y = 0;
		SDrawTextInfo ti;
		ti.flags = eDrawText_2D | eDrawText_FixedSize | eDrawText_Monospace;

		ti.color[2] = 0.0f;
		DrawTextQueued(Vec3(0,y+=line,0),ti,"Colors (black,white,blue,..): { $00$11$22$33$44$55$66$77$88$99$$$o } ()_!+*/# ?");
		ti.color[2] = 1.0f;
		DrawTextQueued(Vec3(0,y+=line,0),ti,"Colors (black,white,blue,..): { $00$11$22$33$44$55$66$77$88$99$$$o } ()_!+*/# ?");

		for(int iPass=0;iPass<3;++iPass)			// left, center, right
		{
			ti.xscale = ti.yscale = fPixelPerfectScale*0.5f;
			float x = 0;

			y = 3*line;

			int passflags = eDrawText_2D;

			if(iPass==1)
			{
				passflags |= eDrawText_Center;
				x=(float)GetWidth()*0.5f;
			}
			else if(iPass==2)
			{
				x=(float)GetWidth();
				passflags |= eDrawText_Right;
			}

			ti.color[3] = 0.5f;
			ti.flags = passflags | eDrawText_FixedSize | eDrawText_Monospace;
			DrawTextQueued(Vec3(x,y+=line,0),ti,"0");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"AbcW !.....!");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"AbcW !MMMMM!");

			ti.color[0] = 0.0f;
			ti.color[3] = 1.0f;
			ti.flags = passflags | eDrawText_FixedSize;
			DrawTextQueued(Vec3(x,y+=line,0),ti,"1");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"AbcW !.....!");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"AbcW !MMMMM!");
/*
			ti.flags = passflags | eDrawText_Monospace;
			DrawTextQueued(Vec3(x,y+=line,0),ti,"2");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"AbcW !.....!");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"AbcW !MMMMM!");

			ti.flags = passflags;
			DrawTextQueued(Vec3(x,y+=line,0),ti,"3");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"AbcW !.....!");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"AbcW !MMMMM!");
*/			
			ti.color[1] = 0.0f;
			ti.flags = passflags | eDrawText_800x600 | eDrawText_FixedSize | eDrawText_Monospace;
			DrawTextQueued(Vec3(x,y+=line,0),ti,"4");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"AbcW !.....!");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"AbcW !MMMMM!");

			ti.color[0] = 1.0f;
			ti.color[1] = 1.0f;
			ti.flags = passflags | eDrawText_800x600 | eDrawText_FixedSize;
			DrawTextQueued(Vec3(x,y+=line,0),ti,"5");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"AbcW !.....!");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"AbcW !MMMMM!");
		
/*
			ti.flags = passflags | eDrawText_800x600 | eDrawText_Monospace;
			DrawTextQueued(Vec3(x,y+=line,0),ti,"6");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"Halfsize");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"AbcW !MMMMM!");

			ti.flags = passflags | eDrawText_800x600;
			DrawTextQueued(Vec3(x,y+=line,0),ti,"7");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"AbcW !.....!");
			DrawTextQueued(Vec3(x,y+=line,0),ti,"AbcW !MMMMM!");
*/
			// Pixel Perfect (1:1 mapping of the texels to the pixels on the screeen)
			
			ti.flags = passflags | eDrawText_FixedSize | eDrawText_Monospace;
			ti.xscale = ti.yscale = fPixelPerfectScale;
			DrawTextQueued(Vec3(x,y+=line*2,0),ti,"8");
			DrawTextQueued(Vec3(x,y+=line*2,0),ti,"AbcW !.....!");
			DrawTextQueued(Vec3(x,y+=line*2,0),ti,"AbcW !MMMMM!");

			ti.flags = passflags | eDrawText_FixedSize;
			ti.xscale = ti.yscale = fPixelPerfectScale;
			DrawTextQueued(Vec3(x,y+=line*2,0),ti,"9");
			DrawTextQueued(Vec3(x,y+=line*2,0),ti,"AbcW !.....!");
			DrawTextQueued(Vec3(x,y+=line*2,0),ti,"AbcW !MMMMM!");
		}

	}
#endif // EXCLUDE_DOCUMENTATION_PURPOSE


#ifdef DO_RENDERSTATS
	static std::vector<IStreamEngine::SStatistics::SAsset> vecStreamingProblematicAssets;

	if (CV_r_showtimegraph)
	{
		static byte *fg;
		static float fPrevTime = iTimer->GetCurrTime();
		static int sPrevWidth = 0;
		static int sPrevHeight = 0;
		static int nC;

		float fCurTime = iTimer->GetCurrTime();
		float frametime = fCurTime - fPrevTime;
		fPrevTime = fCurTime;
		int wdt = m_width;
		int hgt = m_height;

		if (sPrevHeight != hgt || sPrevWidth != wdt)
		{
			if (fg)
			{
				delete [] fg;
				fg = NULL;
			}
			sPrevWidth = wdt;
			sPrevHeight = hgt;
		}

		if (!fg)
		{
			fg = new byte[wdt];
			memset(fg, -1, wdt);
      nC = 0;
		}

		int type = CV_r_showtimegraph;
		float f;
		float fScale;
		if (type > 1)
		{
			type = 1;
			fScale = (float)CV_r_showtimegraph / 1000.0f;
		}
		else
			fScale = 0.1f;
		f = frametime / fScale;
		f = 255.0f - CLAMP(f*255.0f, 0, 255.0f);
		if (fg)
		{
			fg[nC] = (byte)f;
			ColorF c = Col_Green;
			Graph(fg, 0, hgt-280, wdt, 256, nC, type, "Frame Time", c, fScale);
		}
		nC++;
		if (nC >= wdt)
			nC = 0;
	}
	else
	if (CV_profileStreaming)
	{
		static byte *fgUpl;
		static byte *fgStreamSync;
		static byte *fgTimeUpl;
		static byte *fgDistFact;
		static byte *fgTotalMem;
		static byte *fgCurMem;
		static byte *fgStreamSystem;

		static float fScaleUpl = 10;  // in Mb
		static float fScaleStreamSync = 10;  // in Mb
		static float fScaleTimeUpl = 75;  // in Ms
		static float fScaleDistFact = 4;  // Ratio
		static FLOAT fScaleTotalMem = 0;  // in Mb
		static float fScaleCurMem = 80;   // in Mb
		static float fScaleStreaming = 1;   // in Mb

		static ColorF ColUpl = Col_White;
		static ColorF ColStreamSync = Col_Cyan;
		static ColorF ColTimeUpl = Col_SeaGreen;
		static ColorF ColDistFact = Col_Orchid;
		static ColorF ColTotalMem = Col_Red;
		static ColorF ColCurMem = Col_Yellow;
		static ColorF ColCurStream = Col_BlueViolet;

		static int sMask = -1;

		fScaleTotalMem = (float)CRenderer::CV_r_texturesstreampoolsize - 1;

		static float fPrevTime = iTimer->GetCurrTime();
		static int sPrevWidth = 0;
		static int sPrevHeight = 0;
		static int nC;

		int wdt = m_width;
		int hgt = m_height;
		int type = 2;

		if (sPrevHeight != hgt || sPrevWidth != wdt)
		{
			SAFE_DELETE_ARRAY(fgUpl);
			SAFE_DELETE_ARRAY(fgStreamSync);
			SAFE_DELETE_ARRAY(fgTimeUpl);
			SAFE_DELETE_ARRAY(fgDistFact);
			SAFE_DELETE_ARRAY(fgTotalMem);
			SAFE_DELETE_ARRAY(fgCurMem);
			SAFE_DELETE_ARRAY(fgStreamSystem);
			sPrevWidth = wdt;
			sPrevHeight = hgt;
		}

		if (!fgUpl)
		{
			fgUpl = new byte[wdt];
			memset(fgUpl, -1, wdt);
			fgStreamSync = new byte[wdt];
			memset(fgStreamSync, -1, wdt);
			fgTimeUpl = new byte[wdt];
			memset(fgTimeUpl, -1, wdt);
			fgDistFact = new byte[wdt];
			memset(fgDistFact, -1, wdt);
			fgTotalMem = new byte[wdt];
			memset(fgTotalMem, -1, wdt);
			fgCurMem = new byte[wdt];
			memset(fgCurMem, -1, wdt);
			fgStreamSystem = new byte[wdt];
			memset(fgStreamSystem, -1, wdt);
		}

		Set2DMode(true, m_width, m_height);
		ColorF col = Col_White;
		int num = CTexture::s_ptexWhite->GetID();
		DrawImage((float)nC, (float)(hgt-280), 1, 256, num, 0, 0, 1, 1, col.r, col.g, col.b, col.a);
		Set2DMode(false, m_width, m_height);

		// disable some statistics
		sMask &= ~(1|2|4|8|64);

		float f;
		if (sMask & 1)
		{
			f = (CTexture::s_nTexturesDataBytesUploaded/1024.0f/1024.0f) / fScaleUpl;
			f = 255.0f - CLAMP(f*255.0f, 0, 255.0f);
			fgUpl[nC] = (byte)f;
			Graph(fgUpl, 0, hgt-280, wdt, 256, nC, type, NULL, ColUpl, fScaleUpl);
			col = ColUpl;
			WriteXY(4,hgt-280, 1,1,col.r,col.g,col.b,1, "UploadMB (%d-%d)", (int)(CTexture::s_nTexturesDataBytesUploaded/1024.0f/1024.0f), (int)fScaleUpl);
		}

		if (sMask & 2)
		{
			f = m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTexUploadTime / fScaleTimeUpl;
			f = 255.0f - CLAMP(f*255.0f, 0, 255.0f);
			fgTimeUpl[nC] = (byte)f;
			Graph(fgTimeUpl, 0, hgt-280, wdt, 256, nC, type, NULL, ColTimeUpl, fScaleTimeUpl);
			col = ColTimeUpl;
			WriteXY(4,hgt-280+16, 1,1,col.r,col.g,col.b,1, "Upload Time (%.3fMs - %.3fMs)", m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTexUploadTime, fScaleTimeUpl);
		}

		if (sMask & 4)
		{
			f = (CTexture::s_nTexturesDataBytesLoaded/1024.0f/1024.0f) / fScaleStreamSync;
			f = 255.0f - CLAMP(f*255.0f, 0, 255.0f);
			fgStreamSync[nC] = (byte)f;
			Graph(fgStreamSync, 0, hgt-280, wdt, 256, nC, type, NULL, ColStreamSync, fScaleStreamSync);
			col = ColStreamSync;
			WriteXY(4,hgt-280+16*2, 1,1,col.r,col.g,col.b,1, "StreamMB (%d-%d)", (int)(CTexture::s_nTexturesDataBytesLoaded/1024.0f/1024.0f), (int)fScaleStreamSync);
		}

		if (sMask & 8)
		{
			f = CTexture::s_fAdaptiveStreamDistRatio / fScaleDistFact;
			f = 255.0f - CLAMP(f*255.0f, 0, 255.0f);
			fgDistFact[nC] = (byte)f;
			Graph(fgDistFact, 0, hgt-280, wdt, 256, nC, type, NULL, ColDistFact, fScaleDistFact);
			col = ColDistFact;
			WriteXY(4,hgt-280+16*3, 1,1,col.r,col.g,col.b,1, "Adaptive Dist. ratio (Upload) (%.3f-%d)", CTexture::s_fAdaptiveStreamDistRatio, (int)fScaleDistFact);
		}

		if (sMask & 32)
		{
			f = ((float)CTexture::s_nStatsCurManagedStreamedTexMem/1024.0f/1024.0f) / fScaleTotalMem;
			f = 255.0f - CLAMP(f*255.0f, 0, 255.0f);
			fgTotalMem[nC] = (byte)f;
			Graph(fgTotalMem, 0, hgt-280, wdt, 256, nC, type, NULL, ColTotalMem, fScaleTotalMem);
			col = ColTotalMem;
			WriteXY(4,hgt-280+16*5, 1,1,col.r,col.g,col.b,1, "Streaming textures pool used (Mb) (%d of %d)", (int)((float)CTexture::s_nStatsCurManagedStreamedTexMem/1024.0f/1024.0f), (int)fScaleTotalMem);
		}
		if (sMask & 64)
		{
			f = ((m_RP.m_PS[m_RP.m_nProcessThreadID].m_ManagedTexturesSize+m_RP.m_PS[m_RP.m_nProcessThreadID].m_DynTexturesSize)/1024.0f/1024.0f) / fScaleCurMem;
			f = 255.0f - CLAMP(f*255.0f, 0, 255.0f);
			fgCurMem[nC] = (byte)f;
			Graph(fgCurMem, 0, hgt-280, wdt, 256, nC, type, NULL, ColCurMem, fScaleCurMem);
			col = ColCurMem;
			WriteXY(4,hgt-280+16*6, 1,1,col.r,col.g,col.b,1, "Cur Scene Size: Dyn. + Stat. (Mb) (%d-%d)", (int)((m_RP.m_PS[m_RP.m_nProcessThreadID].m_ManagedTexturesSize+m_RP.m_PS[m_RP.m_nProcessThreadID].m_DynTexturesSize)/1024.0f/1024.0f), (int)fScaleCurMem);
		}
		if (sMask & 128)		// streaming stat
		{
			int nLineStep = 12;
			static float thp = 0.f;

			IStreamEngine::SStatistics stats;
			gEnv->pSystem->GetStreamEngine()->GetStreamingStatistics(stats);

			float dt = max(stats.m_fDeltaTime / 1000, .00001f);

			float newThp = (float)stats.m_nBytesRead / 1024 / dt;
			thp = (thp + min(1.f, dt/5) * (newThp - thp));	// lerp

			f = thp / (fScaleStreaming * 1024);
			if(f > 1.f && !stats.vecHeavyAssets.empty())
			{
				for(int i=stats.vecHeavyAssets.size()-1;i>=0;--i)
				{
					IStreamEngine::SStatistics::SAsset asset = stats.vecHeavyAssets[i];

					bool bPart = false;
					// remove texture mips extensions
					if(asset.m_sName.size() > 2 && asset.m_sName[asset.m_sName.size()-2]=='.' &&
						asset.m_sName[asset.m_sName.size()-1] >= '0' && asset.m_sName[asset.m_sName.size()-1] <= '9')
					{
						asset.m_sName = asset.m_sName.substr(0, asset.m_sName.size()-2);
						bPart = true;
					}

					// check for unique name
					uint32 j=0;
					for(;j<vecStreamingProblematicAssets.size();++j)
						if(vecStreamingProblematicAssets[j].m_sName.compareNoCase(asset.m_sName) == 0)
							break;
					if(j == vecStreamingProblematicAssets.size())
						vecStreamingProblematicAssets.insert(vecStreamingProblematicAssets.begin(), asset);
					else if(bPart)
						vecStreamingProblematicAssets[j].m_nSize = max(vecStreamingProblematicAssets[j].m_nSize, asset.m_nSize);	// else adding size to existing asset
				}
				if(vecStreamingProblematicAssets.size() > 20)
					vecStreamingProblematicAssets.resize(20);
				std::sort(vecStreamingProblematicAssets.begin(), vecStreamingProblematicAssets.end());	// sort by descending
			}
			f = 255.0f - CLAMP(f*255.0f, 0, 255.0f);
			fgStreamSystem[nC] = (byte)f;
			Graph(fgStreamSystem, 0, hgt-280, wdt, 256, nC, type, NULL, ColCurStream, fScaleStreaming);
			col = ColCurStream;
			WriteXY(4,hgt-280+14*7, 1,1,col.r,col.g,col.b,1, "Streaming throughput (Kb/s) (%d of %d)", (int)thp, (int)fScaleStreaming * 1024);

			// output assets
			if(!vecStreamingProblematicAssets.empty())
			{
				int top = vecStreamingProblematicAssets.size() * nLineStep + 320;
				WriteXY(4,hgt-top-nLineStep, 1,1,col.r,col.g,col.b,1, "Problematic assets:");
				for(int i=vecStreamingProblematicAssets.size()-1;i>=0;--i)
					WriteXY(4,hgt-top+nLineStep*i, 1,1,col.r,col.g,col.b,1, "[%dKB] '%s'", vecStreamingProblematicAssets[i].m_nSize/1024, vecStreamingProblematicAssets[i].m_sName.c_str());
			}
		}
		nC++;
		if (nC == wdt)
			nC = 0;
	}
	else
		vecStreamingProblematicAssets.clear();

  PostMeasureOverdraw();

	DrawTexelsPerMeterInfo();

	if (m_pColorGradingControllerD3D)
		m_pColorGradingControllerD3D->DrawDebugInfo();

	double time = 0;
	ticks(time);

  DebugDrawStats();

  VidMemLog();

	if (CV_r_profileshaders)
		EF_PrintProfileInfo();

  { // print shadow maps on the screen
    static ICVar *pVar = iConsole->GetCVar("e_ShadowsDebug");
    if(pVar && pVar->GetIVal()>=1 && pVar->GetIVal()<=2)
      DrawAllShadowsOnTheScreen();
  }

  //if( CV_r_deferredshadingdebug == 4 )
  //{
  //  EF_SetState(GS_NODEPTHTEST);
  //  int iTmpX, iTmpY, iTempWidth, iTempHeight;
  //  GetViewport(&iTmpX, &iTmpY, &iTempWidth, &iTempHeight);
  //  EF_SetColorOp(eCO_MODULATE, eCO_MODULATE, DEF_TEXARG0, DEF_TEXARG0);
  //  Set2DMode(true, 1, 1);

  //  RT_SetViewport(0, 0, m_width/2, m_height/2);
  //  DrawImage(0, 0, 1, 1, CTexture::s_ptexZTarget->GetID(), 0, 1, 1, 0, 1,1,1,1);

  //  RT_SetViewport(m_width/2, 0, m_width/2  , m_height/2);
  //  DrawImage(0, 0, 1, 1, CTexture::s_ptexSceneNormalsMap->GetID(), 0, 1, 1, 0, 1,1,1,1);

  //  RT_SetViewport(0, m_height/2, m_width/2  , m_height/2);
  //  DrawImage(0, 0, 1, 1, CTexture::s_ptexCurrentSceneDiffuseAccMap->GetID(), 0, 1, 1, 0, 1,1,1,1);
  // 
  //  RT_SetViewport(m_width/2, m_height/2, m_width/2, m_height/2);
  //  DrawImage(0, 0, 1, 1, CDeferredShading::Instance().GetLightsCount()?CTexture::s_ptexSceneSpecularAccMap->GetID():CTexture::s_ptexBlack->GetID(), 0, 1, 1, 0, 1,1,1,1);

  //  RT_SetViewport(iTmpX, iTmpY, iTempWidth, iTempHeight);

  //  Set2DMode(false, 1, 1);
  //}

	if(CV_r_ShowRenderTarget)
	{
    PROFILE_LABEL_PUSH( "SHOW_RENDERTARGET" );

		SetState(GS_NODEPTHTEST);
		int iTmpX, iTmpY, iTempWidth, iTempHeight;
		GetViewport(&iTmpX, &iTmpY, &iTempWidth, &iTempHeight);
		SetColorOp(eCO_MODULATE, eCO_MODULATE, DEF_TEXARG0, DEF_TEXARG0);
		Set2DMode(true, 1, 1);

		//SEnvTexture *pEnvTex = &CTexture::s_CustomRT_2D[0];
		//CTexture *pTex = CTexture::s_ptexScreenShadowMap; // pEnvTex->m_pTex;
		//CTexture *pTex = CTexture::s_ptexHDRTarget; //CTexture::s_ptexSceneTarget;

		CTexture *pTex = NULL;
		if(CV_r_ShowRenderTarget == 1)
			pTex = CTexture::s_ptexZTarget;
		else
		if(CV_r_ShowRenderTarget == 2)
			pTex = CTexture::s_ptexHDRTarget;
		else
		if(CV_r_ShowRenderTarget == 3)
			pTex = CTexture::s_ptexCurrentScreenShadowMap[0];
		else
		if(CV_r_ShowRenderTarget == 4)
			pTex = CTexture::s_ptexScreenShadowMap[1];
		else
		if(CV_r_ShowRenderTarget == 5)
			pTex = CTexture::s_ptexScreenShadowMap[2];
		else
		if(CV_r_ShowRenderTarget == 6)
			pTex = gTexture;
		else
		if(CV_r_ShowRenderTarget == 7)
			pTex = gTexture2;
		else
		if(CV_r_ShowRenderTarget == 8)
			pTex = CTexture::s_ptexScatterLayer;
		else
		if(CV_r_ShowRenderTarget == 9) //CUSTOMTEXTURE
		{
			if (CTexture::s_CustomRT_2D.size() > 4)
			{
				SEnvTexture *pEnvTex = &CTexture::s_CustomRT_2D[4];
				pTex = pEnvTex->m_pTex->m_pTexture;
			}
		}
		else
		if (CV_r_ShowRenderTarget == 10)
			pTex = CTexture::s_ptexLightInfo[0];
		else
			if(CV_r_ShowRenderTarget == 12)
				pTex = CTexture::s_ptexBackBufferScaled[0];
		else
			if(CV_r_ShowRenderTarget == 13)
				pTex = CTexture::s_ptexBackBufferScaled[1];
		else
			if(CV_r_ShowRenderTarget == 14)
				pTex = CTexture::s_ptexBackBufferScaled[2];
    else
      if(CV_r_ShowRenderTarget == 15)
      {
        int nCustomRT = (int)CTexture::s_CustomRT_2D.Num() ;
        if ( nCustomRT && CTexture::s_CustomRT_2D[0].m_pTex)
          pTex = CTexture::s_CustomRT_2D[0].m_pTex->m_pTexture;
        else
          pTex = CTexture::s_ptexWhite;
      }
    else
    if(CV_r_ShowRenderTarget == 16)
      pTex = CTexture::s_ptexZTargetScaled;
    else
    if(CV_r_ShowRenderTarget == 17)
      pTex = CTexture::s_ptexSceneNormalsMap;
    else
    if(CV_r_ShowRenderTarget == 19)
      pTex = CTexture::s_ptexSceneTarget;   
		else
		if(CV_r_ShowRenderTarget == 20)
			pTex = CTexture::s_ptexIrrVolumeRTDebug;   
    else
    if(CV_r_ShowRenderTarget == 21)
      pTex = CTexture::s_ptexBackBufferTemp;   
    else
    if(CV_r_ShowRenderTarget == 22)
      pTex = CTexture::s_ptexCurrentSceneDiffuseAccMap;   
		else
		if(CV_r_ShowRenderTarget == 23)
			pTex = CTexture::s_ptexSceneSpecularAccMap;   
		else
		if(CV_r_ShowRenderTarget == 24)
			pTex = CTexture::s_ptexSceneTexturesMap;   
		else
		if(CV_r_ShowRenderTarget == 25)
			pTex = CTexture::s_ptexSSGITarget;   
		else
		if(CV_r_ShowRenderTarget == 26)
			pTex = CTexture::s_ptexStereoL; 
    else
    if(CV_r_ShowRenderTarget == 27)
      pTex = CTexture::s_ptexDeferredDecalTarget; 
    if(CV_r_ShowRenderTarget == 28)
      pTex = CTexture::s_ptexRT_ShadowPool;

		if (pTex)
		{
			int x, y, width, height;

			if(CV_r_ShowRenderTarget_FullScreen)
			{
				x = y = 0;
				width = m_width; height = m_height;
			}
			else
			{
				x = 10; y = m_height - m_height/3 - 10;
				width = m_width / 3;
				height = m_height / 3;
			}

			float u = 0, v = 0;

#if HALF_PIXEL_SHIFT_NEEDED
			u = -0.5f / width;
			v = -0.5f / height;
#endif

  		// Specific showrendertarget mode for stereo
			if( CV_r_ShowRenderTarget == 26 )
			{
        GetS3DRend().ResolveStereoBuffers();

        SetViewport(x, y, width, height);
        DrawImage(u, v, 1, 1, pTex->GetID(), 0, 1, 1, 0, 1,1,1,1);

				x = 10 + width + 10; 
				SetViewport(x, y, width, height);
				pTex = CTexture::s_ptexStereoR;
				DrawImage(u, v, 1, 1, pTex->GetID(), 0, 1, 1, 0, 1,1,1,1);
			}
      else
      {
        SetViewport(x, y, width, height);
        DrawImage(u, v, 1, 1, pTex->GetID(), 0, 1, 1, 0, 1,1,1,1);
      }

			SetViewport(iTmpX, iTmpY, iTempWidth, iTempHeight);
		}

		Set2DMode(false, 1, 1);

    PROFILE_LABEL_POP( "SHOW_RENDERTARGET" );
	}

	// show custom texture
	{
		if(CV_r_ShowTexture && strlen(CV_r_ShowTexture->GetString()) > 2)
		{
			SetState(GS_NODEPTHTEST);
			int iTmpX, iTmpY, iTempWidth, iTempHeight;
			GetViewport(&iTmpX, &iTmpY, &iTempWidth, &iTempHeight);
			SetColorOp(eCO_MODULATE, eCO_MODULATE, DEF_TEXARG0, DEF_TEXARG0);
			Set2DMode(true, 1, 1);

			CTexture* pTexToShow = CTexture::GetByName(CV_r_ShowTexture->GetString());

			if (pTexToShow)
			{
				if(CV_r_ShowRenderTarget_FullScreen)
					SetViewport(0, 0, m_width, m_height);
				else
					SetViewport(m_width-m_width/3-10, m_height-m_height/3-10, m_width/3, m_height/3);
				DrawImage(0, 0, 1, 1, pTexToShow->GetID(), 0, 1, 1, 0, 1,1,1,1);
				WriteXY(10, 10, 1,1,1,1,1,1, "Name: %s", pTexToShow->GetSourceName());
				WriteXY(10, 25, 1,1,1,1,1,1, "Fmt: %s", pTexToShow->GetFormatName());
				WriteXY(10, 40, 1,1,1,1,1,1, "Size: %dx%d", pTexToShow->GetWidth(), pTexToShow->GetHeight());
				SetViewport(iTmpX, iTmpY, iTempWidth, iTempHeight);
			}

			Set2DMode(false, 1, 1);
		}
	}

  // print dyn. textures
  { 
    static bool bWasOn=false;

    if (CV_r_showdyntextures)
    {
      DrawAllDynTextures(CV_r_ShowDynTexturesFilter->GetString(),!bWasOn,CV_r_showdyntextures==2);
      bWasOn=true;
    }
    else
      bWasOn=false;
  }
#endif
}

void CD3D9Renderer::TryFlush()
{
	FUNCTION_PROFILER_FAST(GetISystem(), PROFILE_RENDERER, g_bProfilerEnabled);

	//////////////////////////////////////////////////////////////////////
	// End the scene and update
	//////////////////////////////////////////////////////////////////////

	// Check for the presence of a D3D device
	assert(m_pd3dDevice);

	m_pRT->RC_TryFlush();
}

void CD3D9Renderer::EndFrame()
{
  FUNCTION_PROFILER_FAST(GetISystem(), PROFILE_RENDERER, g_bProfilerEnabled);

  //////////////////////////////////////////////////////////////////////
  // End the scene and update
  //////////////////////////////////////////////////////////////////////

  // Check for the presence of a D3D device
  assert(m_pd3dDevice);

  m_pRT->RC_EndFrame(!m_bStartLevelLoading);
}

void CD3D9Renderer::RT_EndFrame()
{
  FUNCTION_PROFILER_FAST(GetISystem(), PROFILE_RENDERER, g_bProfilerEnabled);

  if (!m_SceneRecurseCount)
  {
    iLog->Log("EndScene without BeginScene\n");
    return;
  }

	CRenderMesh2::TickRT();//will only do something for PS3

  float fTime = 0; //iTimer->GetAsyncCurTimePrec();
  HRESULT hReturn;

  CTexture::Update();

  if (m_CVDisplayInfo && m_CVDisplayInfo->GetIVal() && iSystem && iSystem->IsDevMode())
  {
    static const int nIconSize = 32;
		int nIconIndex = 0;

    EF_SetState(GS_NODEPTHTEST);

    if (SShaderAsyncInfo::s_nPendingAsyncShaders > 0 && CV_r_shadersasynccompiling > 0 && CTexture::s_ptexIconShaderCompiling)
    {
      Draw2dImage(nIconSize*nIconIndex, 0, nIconSize, nIconSize, CTexture::s_ptexIconShaderCompiling->GetID(), 0, 1, 1, 0);
    }

		++nIconIndex;

    if (CTexture::s_bStreamingShow && CTexture::s_ptexIconStreaming)
    {
      CTexture::s_bStreamingShow = false;
      Draw2dImage(nIconSize*nIconIndex, 0, nIconSize, nIconSize, CTexture::s_ptexIconStreaming->GetID(), 0, 1, 1, 0);
    }

		++nIconIndex;

    // indicate terrain texture streaming activity
    if (gEnv->p3DEngine && CTexture::s_ptexIconStreamingTerrainTexture)
      if(ITerrain * pTerrain = gEnv->p3DEngine->GetITerrain())
        if(pTerrain->GetNotReadyTextureNodesCount())
          Draw2dImage(nIconSize*nIconIndex, 0, nIconSize, nIconSize, CTexture::s_ptexIconStreamingTerrainTexture->GetID(), 0, 1, 1, 0);

		++nIconIndex;

		// indicate Dummy SoundSystem is active
//		if (gEnv->pSoundSystem->IsNullImplementation())
	//		Draw2dImage(nIconSize*nIconIndex, 0, nIconSize, nIconSize, CTexture::s_ptexIconNullSoundSystem->GetID(), 0, 1, 1, 0);

/*
// disable the Dummy MusicSystem icon for GDC because it distracts a bit. Dummy SoundSystem icon is enough
		++nIconIndex;

		// indicate Dummy MusicSystem is active
		if (gEnv->pMusicSystem->IsNullImplementation())
			Draw2dImage(nIconSize*nIconIndex, 0, nIconSize, nIconSize, CTexture::s_ptexIconNullMusicSystem->GetID(), 0, 1, 1, 0);
*/

	
	}

  m_prevCamera = m_RP.m_TI[m_RP.m_nProcessThreadID].m_cam;

	//////////////////////////////////////////////////////////////////////////

#if defined(ENABLE_RENDER_AUX_GEOM)
	assert(1 == m_SceneRecurseCount);
	// in case of MT rendering flush render thread CB (main thread CB gets flushed in SRenderThread::FlushFrame()),
	// otherwise flush main thread CB (render thread CB should be empty)
	bool isMT(m_pRT->IsMultithreaded());
	CAuxGeomCB* pAuxGeomCB(isMT ? m_pRenderAuxGeomD3D->GetRenderThreadAuxGeomCB() : m_pRenderAuxGeomD3D->GetMainThreadAuxGeomCB());
	pAuxGeomCB->Flush();
	pAuxGeomCB->Toggle(!isMT);
#endif

	//////////////////////////////////////////////////////////////////////////

  // draw debug bboxes and lines
  std :: vector<BBoxInfo>::iterator itBBox = m_arrBoxesToDraw.begin(), itBBoxEnd = m_arrBoxesToDraw.end();
  for( ; itBBox != itBBoxEnd; ++itBBox)
  {
    BBoxInfo& rBBox = *itBBox;
    SetMaterialColor( rBBox.fColor[0], rBBox.fColor[1],
      rBBox.fColor[2], rBBox.fColor[3] );

    // set blend for transparent objects
    if(rBBox.fColor[3]!=1.f)
      EF_SetState(GS_NODEPTHTEST | GS_BLSRC_SRCALPHA | GS_BLDST_ONEMINUSSRCALPHA);

    switch(rBBox.nPrimType)
    {
    case DPRIM_LINE:
      DrawLine(rBBox.vMins, rBBox.vMaxs);
      break;

    case DPRIM_WIRE_BOX:
      Flush3dBBox(rBBox.vMins, rBBox.vMaxs, false);
      break;

    case DPRIM_SOLID_BOX:
      Flush3dBBox(rBBox.vMins, rBBox.vMaxs, true);
      break;

    case DPRIM_SOLID_SPHERE:
      {
        Vec3 vPos = (rBBox.vMins+rBBox.vMaxs)*0.5f;
        float fRadius = (rBBox.vMins-rBBox.vMaxs).GetLength();
        ColorF col = ColorF(rBBox.fColor[0], rBBox.fColor[1], rBBox.fColor[2], rBBox.fColor[3]);
        GetIRenderAuxGeom()->DrawSphere(vPos, fRadius, ColorB(col), false);
      }
      break;
    }
  }

	EF_RemoveParticlesFromScene();

  EF_SetState(GS_NODEPTHTEST);

  m_arrBoxesToDraw.clear();

  //char str[1024];
  //sprintf(str, "Frame: %d", m_RP.m_TI[m_RP.m_nProcessThreadID].m_nFrameUpdateID);
  //PrintToScreen(5,50, 16, str);

	if(SRendItem::m_RecurseLevel[m_RP.m_nProcessThreadID] == 0) 
	{
		if (gEnv->pConsole)
		{
			PROFILE_LABEL_PUSH_SKIP_GPU("Text");
			RT_FlushTextMessages();
			PROFILE_LABEL_POP_SKIP_GPU("Text");
		}
	}

	gcpRendD3D->GetS3DRend().DisplayStereo();
	
	PROFILE_LABEL_POP_SKIP_GPU("Frame");

	#ifndef WIN32
		if(gEnv && gEnv->pHardwareMouse)
			gEnv->pHardwareMouse->Render();
	#endif

  fTime = iTimer->GetAsyncCurTime();
  m_profiler->EndFrame();

#ifdef DO_RENDERLOG
  if (CRenderer::CV_r_log)
    Logv(0, "******************************* EndFrame ********************************\n");
#endif
  // End the scene
#ifdef XENON

//////////////////////////////////////////////////////////////////////////
  // Draw resolve buffer back to the screen.
#if XENON_SRGB_BACKBUF
  /*FX_PopRenderTarget(0);
  D3DSurface* pResolveRT;
  FX_GetTargetSurfaces(CTexture::s_pBackBuffer, pResolveRT, NULL, 0, 0, false);
  m_pd3dDevice->SetRenderTarget(0, pResolveRT);
  {
    static CCryNameTSCRC TechName("TextureToTexture");
    SPostEffectsUtils::ShBeginPass(CShaderMan::m_shPostEffects, TechName, FEF_DONTSETTEXTURES | FEF_DONTSETSTATES);
    EF_SetState(GS_NODEPTHTEST);
    SPostEffectsUtils::SetTexture(CTexture::s_pBackBuffer, 0, FILTER_LINEAR);    
    SPostEffectsUtils::DrawFullScreenQuad(CTexture::s_pBackBuffer->GetWidth(), CTexture::s_pBackBuffer->GetHeight());
    SPostEffectsUtils::ShEndPass();
  }

  m_pd3dDevice->SetRenderTarget(0, pResolveRT);

  //resolve to front buffer
  D3DTexture *pTex = (D3DTexture *)CTexture::s_FrontBufferTextures[0].GetDeviceTexture();
  m_pd3dDevice->Resolve( D3DRESOLVE_RENDERTARGET0, NULL, pTex, NULL, 0, 0, NULL, 1.0, 0, NULL );

  m_pd3dDevice->SetRenderTarget(0, NULL);
  SAFE_RELEASE(pResolveRT);*/
#endif
//////////////////////////////////////////////////////////////////////////

  m_pd3dDevice->EndScene();
#else
 #if defined (DIRECT3D9) || defined (OPENGL)
  m_pd3dDevice->EndScene();
 #endif
#endif
  m_SceneRecurseCount--;

#if defined (DIRECT3D9) || defined (OPENGL)
#if !defined(XENON) && !defined(PS3)
  if (CV_r_ShowVideoMemoryStats)
  {
    HRESULT hr;
    CV_r_ShowVideoMemoryStats = FALSE;
    IDirect3DQuery9 *resourceQuery;
    BOOL timeOut;

    D3DDEVINFO_RESOURCEMANAGER resourceStats;
    hr = m_pd3dDevice->CreateQuery(D3DQUERYTYPE_RESOURCEMANAGER, &resourceQuery);
    if (hr == D3D_OK)
    {
      resourceQuery->Issue(D3DISSUE_END);
    	float timeoutTime = iTimer->GetCurrTime() + 2.0f;
      timeOut = FALSE;
      // D3DGETDATA_FLUSH
      while (resourceQuery->GetData((void *)&resourceStats, sizeof(D3DDEVINFO_RESOURCEMANAGER), 0) != S_OK)
      {
        if (iTimer->GetCurrTime() < timeoutTime)
        {
          timeOut = TRUE;
          break;
        }
      }
      resourceQuery->Release();

      // make sure succeeded
      if (!timeOut)
      {
        for (int i=0; i<D3DRTYPECOUNT; i++)
        {
          iLog->Log("%s - Thrashing = %s, Approx Bytes Downloaded %d, Number Evictions %d",
              resourceName[i], resourceStats.stats[i].bThrashing ? "TRUE" : "FALSE",
              resourceStats.stats[i].ApproxBytesDownloaded, resourceStats.stats[i].NumEvicts);
              iLog->Log("    Number Video Creates %d, Last Priority %d",
                resourceStats.stats[i].NumVidCreates, resourceStats.stats[i].LastPri);
              iLog->Log("    Number set to Device %d, Number used In Vid mem %d",
                resourceStats.stats[i].NumUsed, resourceStats.stats[i].NumUsedInVidMem);

          iLog->Log("%s - %d object(s) with %d bytes in video memory.\n",
            resourceName[i], resourceStats.stats[i].WorkingSet, resourceStats.stats[i].WorkingSetBytes);
          iLog->Log("%s - %d object(s) with %d bytes in managed memory.\n",
            resourceName[i], resourceStats.stats[i].TotalManaged, resourceStats.stats[i].TotalBytes);
        }
      }
    }
  }
#endif
#endif

  //assert (m_nRTStackLevel[0] == 0 && m_nRTStackLevel[1] == 0 && m_nRTStackLevel[2] == 0 && m_nRTStackLevel[3] == 0);
  FX_Commit();

    // Get the present params from the swap chain
    /*IDirect3DSurface9* pBackBuffer = NULL;
    HRESULT hr = m_pd3dDevice->GetBackBuffer( 0, 0, D3DBACKBUFFER_TYPE_MONO, &pBackBuffer );
    if( SUCCEEDED(hr) )
    {
        IDirect3DSwapChain9* pSwapChain = NULL;
        hr = pBackBuffer->GetContainer( IID_IDirect3DSwapChain9, (void**) &pSwapChain );
        if( SUCCEEDED(hr) )
        {
          D3DPRESENT_PARAMETERS PresentationParameters;
            pSwapChain->GetPresentParameters( &PresentationParameters );
            SAFE_RELEASE( pSwapChain );
        }

        SAFE_RELEASE( pBackBuffer );
    }*/

  /*extern SDynTexture2 *gDT;
  extern int gnFrame;
  if (gDT)
  {
    static D3DSurface *pSurf = NULL;
    HRESULT hr;
    if (!pSurf)
    {
      hr = m_pd3dDevice->CreateRenderTarget(64, 64, D3DFMT_A8R8G8B8, D3DMULTISAMPLE_NONE, 0, TRUE, &pSurf, NULL);
    }
    int nFrame = m_nFrameSwapID;
    if ((1<<(nFrame&1)) & gnFrame)
    {
      SDynTexture2 *pDT = gDT;
      pDT->Apply(0);
      FX_PushRenderTarget(0, pSurf, &m_DepthBufferOrig);
      EF_SetColorOp(eCO_MODULATE, eCO_MODULATE, DEF_TEXARG0, DEF_TEXARG0);
      DrawFullScreenQuad(m_cEF.m_ShaderTreeSprites, "General_Debug", m_cEF.m_RTRect.x, m_cEF.m_RTRect.y, m_cEF.m_RTRect.x+m_cEF.m_RTRect.z, m_cEF.m_RTRect.y+m_cEF.m_RTRect.w);
      FX_PopRenderTarget(0);
      D3DLOCKED_RECT lr;
      pSurf->LockRect(&lr, NULL, 0);
      UCol *pData = (UCol *)lr.pBits;
      //for (int i=0; i<64*64; i++)
      //{
      UCol d = pData[32*64+32];
      if (d.bcolor[0] == 0xff)
      {
        //assert(0);
        int nnn = 0;
      }
      //}
      pSurf->UnlockRect();
    }
  }*/

  // Flip the back buffer to the front
  if(m_bSwapBuffers)
	{
		CaptureFrameBuffer();
		
		if (!IsEditorMode())
    {
#ifdef XENON


#if defined(XENON)						
			const uint32 pTrilinearThresholds[4] = 
			{
				D3DTRILINEAR_IMMEDIATE,
				D3DTRILINEAR_ONESIXTH,
				D3DTRILINEAR_ONEFOURTH,
				D3DTRILINEAR_THREEEIGHTHS 
			};			
			
			CRenderer::CV_r_SamplTrilinearThreshold = min( CRenderer::CV_r_SamplTrilinearThreshold, 3);
			for( int s=0; s<m_numtmus; s++ )
				m_pd3dDevice->SetSamplerState(s, D3DSAMP_TRILINEARTHRESHOLD, pTrilinearThresholds[CRenderer::CV_r_SamplTrilinearThreshold]);
#endif

  #if XENON_SRGB_BACKBUF
      //scenario for sRGB resolves
      //////////////////////////////////////////////////////////////////////////
      m_pd3dDevice->SynchronizeToPresentationInterval();
      m_pd3dDevice->Swap(pTex, NULL);
      //////////////////////////////////////////////////////////////////////////
  #else
			PROFILE_LABEL_PUSH("PRESENT");

			// Swap to the current front buffer, so we can see it on screen.
			m_pd3dDevice->SynchronizeToPresentationInterval();

      FX_PopRenderTarget(0);					// Resolve to FrontBuffer

      //reset GPR allocation
      XE_SetGPRState(0);
      XE_CommitGPRState();

      CTexture *frontBuffer = CTexture::s_FrontBufferTextures[m_dwCurrentBuffer];
			if( IsStereoEnabled() && GetS3DRend().GetHighResFrontBuffer() )
				frontBuffer = GetS3DRend().GetHighResFrontBuffer();
      
			D3DVIDEO_SCALER_PARAMETERS scalerParams = m_d3dpp.VideoScalerParameters;
			scalerParams.ScalerSourceRect.x2 = frontBuffer->GetWidth();
			scalerParams.ScalerSourceRect.y2 = frontBuffer->GetHeight();
			m_pd3dDevice->Swap(frontBuffer->GetDevTexture()->Get2DTexture(), &scalerParams);

			// Swap buffer usage
			m_dwCurrentBuffer = m_dwCurrentBuffer ? 0L : 1L;
			CTexture::s_pBackBuffer = CTexture::s_FrontBufferTextures[m_dwCurrentBuffer];

			PROFILE_LABEL_POP("PRESENT");

#endif

			assert(!m_nRTStackLevel[0]);
			if (!m_nRTStackLevel[0])
			{
				FX_PushRenderTarget(0, CTexture::s_pBackBuffer, &m_DepthBufferOrig, true);				
			}

#elif defined (DIRECT3D9) || defined (OPENGL)
			hReturn = m_pd3dDevice->Present(NULL, NULL, NULL, NULL);
#elif defined(PS3)

			//FallbackTextOut(m_pSwapChain, "This is a test...\n\tSeems to be working!", 100, 100);
     

			hReturn = m_pSwapChain->Present( 0, 0 );
#elif defined (DIRECT3D10)
			const DXUTD3D11DeviceSettings& d3d10Settings(DXUTGetCurrentDeviceSettings()->d3d11);
			DWORD syncInterval = d3d10Settings.SyncInterval;
			DWORD presentFlags = d3d10Settings.PresentFlags;
			if (m_dwPresentStatus & (epsOccluded|epsNonExclusive))
			{
				syncInterval = 0;
				presentFlags = DXGI_PRESENT_TEST;
			}
			hReturn = m_pSwapChain->Present(syncInterval, presentFlags);
      if (DXGI_ERROR_NONEXCLUSIVE == hReturn)
        m_dwPresentStatus |= epsNonExclusive;
      else
      if (DXGI_STATUS_OCCLUDED == hReturn)
				m_dwPresentStatus |= epsOccluded;
      else
      if (DXGI_ERROR_DEVICE_RESET == hReturn)
      {
        HRESULT hr;
        if (FAILED(hr = DXUTReset3DEnvironment11()))
        {
          if (hr == DXUTERR_RESETTINGDEVICEOBJECTS)
          {
            assert(0);
          }
          else
          {
            DXUTDeviceSettings *pDeviceSettings = DXUTGetCurrentDeviceSettings();
            if (FAILED(DXUTChangeDevice(pDeviceSettings, NULL, NULL, true, false)))
            {
              DXUTShutdown();
              return;
            }
          }
        }
      }
      else
      if (DXGI_ERROR_DEVICE_REMOVED == hReturn)
      {
        if (FAILED(DXUTHandleDeviceRemoved()))
        {
          assert(0);
        }
      }
      else
      if (SUCCEEDED(hReturn))
      {
        m_dwPresentStatus = 0;
      }
#endif
    }
		else
		{
#if defined (DIRECT3D9) || defined (OPENGL)
			RECT ClientRect;
			ClientRect.top		= 0;
			ClientRect.left		= 0;
      ClientRect.right	= m_CurrContext->m_Width;
      ClientRect.bottom	= m_CurrContext->m_Height;
      hReturn = m_pd3dDevice->Present(&ClientRect, &ClientRect, m_CurrContext->m_hWnd, NULL);
#elif defined(PS3)
			CRY_ASSERT_MESSAGE(0,"Case in EndFrame() not implemented yet");
#elif defined (DIRECT3D10)
      DWORD dwFlags = 0;
      if(m_dwPresentStatus & (epsOccluded|epsNonExclusive) )
        dwFlags = DXGI_PRESENT_TEST;
      else
        dwFlags = DXUTGetCurrentDeviceSettings()->d3d11.PresentFlags;
      RECT ClientRect;
      ClientRect.top		= 0;
      ClientRect.left		= 0;
      ClientRect.right	= m_CurrContext->m_Width;
      ClientRect.bottom	= m_CurrContext->m_Height;
      //hReturn = m_pSwapChain->Present(0, dwFlags);
			if (m_CurrContext->m_pSwapChain)
				hReturn = m_CurrContext->m_pSwapChain->Present(0, dwFlags);
      if (hReturn == DXGI_ERROR_INVALID_CALL)
      {
        assert(0);
      }
      else
      if (DXGI_ERROR_NONEXCLUSIVE == hReturn)
        m_dwPresentStatus |= epsNonExclusive;
      else
      if (DXGI_STATUS_OCCLUDED == hReturn)
        m_dwPresentStatus |= epsOccluded;
      else
      if (DXGI_ERROR_DEVICE_RESET == hReturn)
      {
        assert(0);
      }
      else
      if (DXGI_ERROR_DEVICE_REMOVED == hReturn)
      {
        assert(0);
      }
      else
      if(SUCCEEDED(hReturn))
      {
        // Now that we're no longer occluded and the other app has gone non-exclusive
        // allow us to render again
        m_dwPresentStatus = 0;
      }
#endif
		}
    m_nFrameSwapID++;
	}

  /*bool sPause = false;
  if (CryGetAsyncKeyState('0') & 0x1)
    sPause = 1;
  while(sPause)
  {
    if (CryGetAsyncKeyState('9') & 0x1)
      break;
  }*/

#if defined (DIRECT3D9) || defined (OPENGL)
  hReturn = m_pd3dDevice->BeginScene();
 #ifdef XENON
  //m_pd3dDevice->GpuOwnVertexShaderConstantF(0, MAX_CONSTANTS_VS);
  //m_pd3dDevice->GpuOwnPixelShaderConstantF(0, MAX_CONSTANTS_PS);
 #endif
#endif

	CheckDeviceLost();

  if (CV_r_GetScreenShot)
  {
    ScreenShot();
    CV_r_GetScreenShot = 0;
  }
  
  if(m_wireframe_mode != m_wireframe_mode_prev)
  {
    if(m_wireframe_mode > R_SOLID_MODE)  // disable zpass in wireframe mode
    {
      if (m_wireframe_mode_prev == R_SOLID_MODE)
      {
        m_bUseZpass = CV_r_usezpass != 0;
        CV_r_usezpass = 0;
      }
    }
    else
    {
      CV_r_usezpass = m_bUseZpass;
    }
  }

  if (CRenderer::CV_r_logTexStreaming)
  {
    LogStrv(0, "******************************* EndFrame ********************************\n");
    LogStrv(0, "Loaded: %.3f Kb, UpLoaded: %.3f Kb, UploadTime: %.3fMs\n\n", CTexture::s_nTexturesDataBytesLoaded/1024.0f, CTexture::s_nTexturesDataBytesUploaded/1024.0f, m_RP.m_PS[m_RP.m_nProcessThreadID].m_fTexUploadTime);
  }

  /*if (CTexture::s_nTexturesDataBytesLoaded > 3.0f*1024.0f*1024.0f)
    CTexture::m_fStreamDistFactor = min(2048.0f, CTexture::m_fStreamDistFactor*1.2f);
  else
    CTexture::m_fStreamDistFactor = max(1.0f, CTexture::m_fStreamDistFactor/1.2f);*/
  CTexture::s_nTexturesDataBytesUploaded = 0;
  CTexture::s_nTexturesDataBytesLoaded = 0;

#if defined (XENON) || defined (PS3)
  m_fTimeWaitForGPU[m_RP.m_nProcessThreadID] = iTimer->GetAsyncCurTime() - fTime;
#endif

#if defined(PS3)
  m_fTimeGPUIdlePercent[m_RP.m_nProcessThreadID]	= tdLayer0::Sync().IdleTime();
	m_fTimeWaitForGPU[m_RP.m_nProcessThreadID]			= tdLayer0::Sync().StallTime();
	
#elif defined(XENON)
  m_fTimeGPUIdlePercent[m_RP.m_nProcessThreadID] = m_pd3dDevice->GetCounter(D3DCOUNTER_FRAME_GPU_IDLE_PERCENT);
#endif

  m_wireframe_mode_prev = m_wireframe_mode;

  m_SceneRecurseCount++;

#if defined(ENABLE_GPU_TIMERS)
	SwapGpuTimers();
#endif

  /*{
    char *str = (char *)EF_Query(EFQ_GetShaderCombinations);
    if (str)
    {
      EF_Query(EFQ_SetShaderCombinations, (INT_PTR)str);
      EF_Query(EFQ_DeleteMemoryArrayPtr, (INT_PTR)str);
    }
  }*/

#if defined(CRY_DXPS_RASTERTHREAD)
	HandleDIPValueInt(CV_r_PS3SoftwareRasterizer,4);
#endif
}

//////////////////////////////////////////////////////////////////////////
bool CD3D9Renderer::ScreenShot(const char *filename, int iPreWidth)
{
	if (m_pRT && !m_pRT->IsRenderThread())
		m_pRT->FlushAndWait();

	if (!gEnv || !gEnv->pSystem || gEnv->pSystem->IsQuitting() || gEnv->bIsOutOfMemory)
	{
		return false;
	}

  bool bRet = true;
	char path[ICryPak::g_nMaxPath];
#if !defined(PS3)
	//for PS3: the screenshot goes straight to the working directory on the remote PC, all handled inside CryDXPS
	path[sizeof(path) - 1] = 0;
	gEnv->pCryPak->AdjustFileName(filename != 0 ? filename : "%USER%/ScreenShots", path, ICryPak::FLAGS_PATH_REAL | ICryPak::FLAGS_FOR_WRITING);

	if (!filename)
	{
		size_t pathLen = strlen(path);
		const char* pSlash = (!pathLen || path[pathLen - 1] == '/' || path[pathLen - 1] == '\\') ? "" : "\\";

		int i = 0;
		for (; i<10000; i++)
		{
#if !defined (XENON)
			snprintf(&path[pathLen], sizeof(path) - 1 - pathLen, "%sScreenShot%04d.jpg", pSlash, i);	
#else
			snprintf(&path[pathLen], sizeof(path) - 1 - pathLen, "%sScreenShot%04d.tga", pSlash, i);	// only TGA for now, ##FMT_CHK##
#endif

			FILE* fp = fxopen(path, "rb");
			if (!fp)
				break; // file doesn't exist

			fclose(fp);
		}

		if (i == 10000)
		{
			iLog->Log("Cannot save screen shot! Too many files.");
			return false;
		}
	}

	if (!gEnv->pCryPak->MakeDir(PathUtil::GetParentDirectory(path)))
	{
		iLog->Log("Cannot save screen shot! Failed to create directory \"%s\".", path);
		return false;
	}

	iLog->LogWithType(ILog::eInputResponse," ");
	iLog->LogWithType(ILog::eInputResponse,"Screenshot: %s", path);
	gEnv->pConsole->ExecuteString("goto");	// output position and angle, can be used with "goto" command from console

	iLog->LogWithType(ILog::eInputResponse," ");
	iLog->LogWithType(ILog::eInputResponse,"$5Drawcalls: %d", gEnv->pRenderer->GetCurrentNumberOfDrawCalls());
	iLog->LogWithType(ILog::eInputResponse,"$5FPS: %.1f (%.1f ms)", gEnv->pTimer->GetFrameRate(), gEnv->pTimer->GetFrameTime()*1000.0f);

	int nPolygons, nShadowVolPolys;
	GetPolyCount(nPolygons,nShadowVolPolys);
	iLog->LogWithType(ILog::eInputResponse,"Tris: %2d,%03d", nPolygons/1000, nPolygons%1000);

	int nStreamCgfPoolSize = -1;
	ICVar* pVar = gEnv->pConsole->GetCVar("e_StreamCgfPoolSize");
	if(pVar)
		nStreamCgfPoolSize = pVar->GetIVal();

	if (gEnv->p3DEngine)
	{
		I3DEngine::SObjectsStreamingStatus objectsStreamingStatus;
		gEnv->p3DEngine->GetObjectsStreamingStatus(objectsStreamingStatus);
		iLog->LogWithType(ILog::eInputResponse,"CGF streaming: Loaded:%d InProg:%d All:%d Act:%d MemUsed:%2.2f MemReq:%2.2f PoolSize:%d", 
			objectsStreamingStatus.nReady, objectsStreamingStatus.nInProgress, objectsStreamingStatus.nTotal, objectsStreamingStatus.nActive, float(objectsStreamingStatus.nAllocatedBytes)/1024/1024, float(objectsStreamingStatus.nMemRequired)/1024/1024, nStreamCgfPoolSize);
	}

	STextureStreamingStats stats;
	EF_Query(EFQ_GetTexStreamingInfo, (INT_PTR)&stats);
	const int iPercentage = int((float)stats.nCurrentPoolSize / stats.nMaxPoolSize * 100.f);
	iLog->LogWithType(ILog::eInputResponse,"TexStreaming: MemUsed:%.2fMB(%d%%%%) PoolSize:%dMB Trghput:%dKB/s", (float)stats.nCurrentPoolSize / 1024 / 1024, iPercentage, stats.nMaxPoolSize / 1024 / 1024, stats.nThroughput / 1024);

	gEnv->pConsole->ExecuteString("sys_RestoreSpec test*");		// to get useful debugging information about current spec settings to the log file
	iLog->LogWithType(ILog::eInputResponse," ");

	const char *pExt = fpGetExtension(path);

	if (!pExt)
	{
#if !defined (XENON)
		// no extension -> use jpg
		strcpy(&path[strlen(path)],".jpg");
		pExt = fpGetExtension(path);
#else
		// no extension -> use tga
		strcpy(&path[strlen(path)],".tga"); // only TGA for now, ##FMT_CHK##
		pExt = fpGetExtension(path);
#endif
	}
#endif
#if (defined(WIN32) || defined(WIN64)) && (defined(DIRECT3D9) || defined(OPENGL))
#ifdef WIN64																						// we don't have JPEG lib for WIN64 so we call DirectX (currently less quality)
	if(stricmp(pExt,".jpg")==0)
	{
	  iLog->LogWarning("JPEG quality on WIN64 might be less than WIN32 (different library)\n");
		return CaptureFrameBufferToFile(path, false);
	}
#endif

	if(stricmp(pExt,".bmp")==0)
		return CaptureFrameBufferToFile(path, false);		// used for automated screenshot comparisons
	bool bTGA=false;
	if(stricmp(pExt,".tga")==0)
		bTGA=true;
/*
#ifdef WIN64
	bTGA=true;	  //TODO: we need a lib for AMD64 to create JPEG-files
#endif
*/
  LPDIRECT3DSURFACE9 pSysDeskSurf;
  D3DLOCKED_RECT d3dlrSys;
  int wdt = m_deskwidth;
  int hgt = m_deskheight;
  if (m_bFullScreen)
  {
    wdt = m_width;
    hgt = m_height;
  }
  HRESULT h = m_pd3dDevice->CreateOffscreenPlainSurface(wdt, hgt, D3DFMT_A8R8G8B8, D3DPOOL_SYSTEMMEM, &pSysDeskSurf, NULL);
  if (FAILED(h))
    return false;

  h = m_pd3dDevice->GetFrontBufferData(0, pSysDeskSurf);
  if (FAILED(h))
    return false;

	POINT WndP;
  WndP.x = 0;
  WndP.y = 0;
  ClientToScreen(m_CurrContext->m_hWnd, &WndP);
  h = pSysDeskSurf->LockRect(&d3dlrSys, NULL, D3DLOCK_READONLY);
  if (FAILED(h))
    return false;

  byte *src = (byte *)d3dlrSys.pBits;
	int height = m_height;
	int width = m_width;

	if (WndP.y < 0)
  {
    height += WndP.y;
    WndP.y = 0;
  }
  if (WndP.x < 0)
  {
    width += WndP.x;
    WndP.x = 0;
  }
  if (width+WndP.x >= wdt)
    width = wdt-WndP.x;
  if (height+WndP.y >= hgt)
    height = hgt-WndP.y;

  if(width <= 0 || height <= 0)
	{
		iLog->Log("Error making screenshot (can be due to secondary monitor)!\n\twdt: %d, hgt: %d, width: %d, height: %d, WndP.x: %d, WndP.y: %d", wdt, hgt, width, height, WndP.x, WndP.y);
		return false;
	}

  if(width*height*4 > 16777216)
  {
    iLog->LogWarning("Invalid screenshot dimensions: %dx%d", width, height);
    return false;
  }

	unsigned char *pic=new unsigned char [width*height*4];
  byte *dst = pic;

	if(bTGA)
	{
		// upside down
		src += (height+WndP.y-1)* d3dlrSys.Pitch;
		for (int i=0; i<height; i++)
		{
			for (int j=0; j<width; j++)
				*(uint32 *)&dst[j*4] = *(uint32 *)&src[(WndP.x+j)*4];
			dst += width*4;
			src -= d3dlrSys.Pitch;
		}
	}
	else
	{
		src += WndP.y * d3dlrSys.Pitch;
		// flip Red with Blue
		for (int i=0; i<height; i++)
		{
			for (int j=0; j<width; j++)
			{
				*(uint32 *)&dst[j*4] = *(uint32 *)&src[(WndP.x+j)*4];
				Exchange(dst[j*4+0], dst[j*4+2]);
			}
			dst += width*4;
			src += d3dlrSys.Pitch;
		}
	}
	int iPreHeight = (height * iPreWidth) / width;
	
	CryLogAlways("iPreWidth=%d",iPreWidth);
	CryLogAlways("iPreHeight=%d",iPreHeight);

	unsigned char *tmppic=new unsigned char [iPreWidth*iPreHeight*4];
	byte *tmp = tmppic;
	byte *tmpsrc = pic;

	if(iPreWidth>0 && iPreHeight>0)
	{
		int ilastyscale = 0;
		for (int i=0; i<iPreHeight; i++) 
		{
			for (int j=0; j<iPreWidth; j++)
			{
				int xscale = j*(width/iPreWidth);
				*(uint32 *)&tmp[j*4] = *(uint32 *)&tmpsrc[xscale*4];
			}
			int yscale = i*(height/iPreHeight);
			tmp += iPreWidth*4;
			tmpsrc += (yscale-ilastyscale)*width*4;
			ilastyscale = yscale;
		}
		width=iPreWidth;
		height=iPreHeight;
		pic = tmppic;
	}



  pSysDeskSurf->UnlockRect();
  SAFE_RELEASE(pSysDeskSurf);

	if(bTGA)
		bRet=::WriteTGA(pic, width, height, path, 32, 32);
	 else
		bRet=::WriteJPG(pic, width, height, path, 32);

  delete [] pic;

#elif defined(DIRECT3D10) || defined(XENON)
	return CaptureFrameBufferToFile(path, false);
#endif

	return bRet;
}

int CD3D9Renderer::CreateRenderTarget (int nWidth, int nHeight, ETEX_Format eTF)
{
  // check if parameters are valid
  if(!nWidth || !nHeight)
    return -1;

#ifdef XENON
  if (nWidth > 512)
    nWidth = 512;
  if (nHeight > 512)
    nHeight = 512;
#endif

  if (!m_RTargets.Num())
  {
    m_RTargets.AddIndex(1);
  }

  int n = m_RTargets.Num();
  for (uint32 i=1; i<m_RTargets.Num(); i++)
  {
    if (!m_RTargets[i])
    {
      n = i;
      break;
    }
  }

  if(n == m_RTargets.Num())
  {
    m_RTargets.AddIndex(1);
  }
	
	char pName[128];
	sprintf(pName, "$RenderTarget_%d", n);
	m_RTargets[n] = CTexture::CreateRenderTarget(pName, nWidth, nHeight, eTT_2D, FT_NOMIPS, eTF);
 
  return m_RTargets[n]->GetID();
}

bool CD3D9Renderer::DestroyRenderTarget (int nHandle)
{
  CTexture *pTex=CTexture::GetByID(nHandle);  
  SAFE_RELEASE(pTex);
  return true;
}

bool CD3D9Renderer::SetRenderTarget (int nHandle, int nFlags)
{
 if (nHandle == 0)
 {
	  // Check: Restore not working
    FX_PopRenderTarget(0);
    return true;
  }

  CTexture *pTex=CTexture::GetByID(nHandle);
  gTexture2 = pTex;
  if(!pTex)
  {
    return false;
  }
  bool bScreenVP = (nFlags & SRF_SCREENTARGET) != 0;
#ifdef XENON
  //bool bRes = FX_PushRenderTarget(0, pTex, &CTexture::m_DepthBufferOrig, false);
  SD3DSurface *pDepthSurf = NULL;
  if (nFlags & SRF_USE_ORIG_DEPTHBUF)
    pDepthSurf = &m_DepthBufferOrig;
  else
  if (nFlags & SRF_USE_ORIG_DEPTHBUF_FSAA)
    pDepthSurf = &m_DepthBufferOrigFSAA;
  else
    pDepthSurf = FX_GetDepthSurface(pTex->GetWidth(), pTex->GetHeight(), false);
  bool bRes = FX_PushRenderTarget(0, pTex, pDepthSurf, false);
#else
  SD3DSurface *pDepthSurf = NULL;
  if (nFlags & SRF_USE_ORIG_DEPTHBUF)
    pDepthSurf = &m_DepthBufferOrig;
  else
  if (nFlags & SRF_USE_ORIG_DEPTHBUF_FSAA)
    pDepthSurf = &m_DepthBufferOrigFSAA;
  else
    pDepthSurf = FX_GetDepthSurface(pTex->GetWidth(), pTex->GetHeight(), false);

  bool bRes = FX_PushRenderTarget(0, pTex, pDepthSurf, false, -1, bScreenVP);
#endif

  return bRes;
}

void CD3D9Renderer::ReadFrameBuffer(unsigned char * pRGB, int nImageX, int nSizeX, int nSizeY, ERB_Type eRBType, bool bRGBA, int nScaledX, int nScaledY)
{
  m_pRT->RC_ReadFrameBuffer(pRGB, nImageX, nSizeX, nSizeY, eRBType, bRGBA, nScaledX, nScaledY);
}

void CD3D9Renderer::RT_ReadFrameBuffer(unsigned char * pRGB, int nImageX, int nSizeX, int nSizeY, ERB_Type eRBType, bool bRGBA, int nScaledX, int nScaledY)
{
  //return;
#if defined (DIRECT3D9) || defined (OPENGL)
  int i;

  LPDIRECT3DSURFACE9 pSysSurf = NULL;
	LPDIRECT3DSURFACE9 pTmpSurface = NULL;
  D3DLOCKED_RECT d3dlrSys;
	D3DSURFACE_DESC desc;
  HRESULT hr;
  if (eRBType == eRB_BackBuffer || eRBType == eRB_ShadowBuffer)
  {
    LPDIRECT3DSURFACE9 pSurf;
    if (eRBType == eRB_BackBuffer)
      pSurf = m_RTStack[0][0].m_pTarget;
    else
    {
      CTexture *pTex = CTexture::s_ptexBackBuffer;
      CDeviceTexture *pDevTexture = pTex->GetDevTexture();
      hr = pDevTexture->Get2DTexture()->GetSurfaceLevel(0, &pSurf);
    }
    if (!pSurf)
      return;
	  hr = pSurf->GetDesc(&desc);
	  if (FAILED(hr))
      return;
    POINT WndP;
    WndP.x = 0;
    WndP.y = 0;
    //if (IsEditorMode())
    //  ClientToScreen(m_hWnd, &WndP);
    RECT srcRect, dstRect;
    srcRect.left = WndP.x;
    srcRect.right = nSizeX;
    srcRect.top = WndP.y;
    srcRect.bottom = nSizeY;
    if (nScaledX <= 0)
    {
      nScaledX = nSizeX;
      nScaledY = nSizeY;
    }
    dstRect.left = 0;
    dstRect.right = nScaledX;
    dstRect.top = 0;
    dstRect.bottom = nScaledY;
		hr = m_pd3dDevice->CreateRenderTarget(nScaledX, nScaledY, desc.Format, D3DMULTISAMPLE_NONE, 0, TRUE, &pTmpSurface, NULL);
		if ( FAILED(hr) )
      return;

    gcpRendD3D->m_RP.m_PS[gcpRendD3D->m_RP.m_nProcessThreadID].m_RTCopied++;
    gcpRendD3D->m_RP.m_PS[gcpRendD3D->m_RP.m_nProcessThreadID].m_RTCopiedSize += nScaledX * nScaledY * 4;
		hr = m_pd3dDevice->StretchRect(pSurf, &srcRect, pTmpSurface, &dstRect, D3DTEXF_LINEAR);
		if ( FAILED(hr) )
			return;
    if (desc.Format != D3DFMT_X8R8G8B8 && desc.Format != D3DFMT_A8R8G8B8)
    {
  	  // Create a buffer the same size and format
	    hr = m_pd3dDevice->CreateOffscreenPlainSurface(nScaledX, nScaledY, desc.Format, D3DPOOL_SYSTEMMEM, &pSysSurf, NULL);
      D3DXLoadSurfaceFromSurface(pSysSurf, NULL, NULL, pTmpSurface, NULL, NULL, D3DX_FILTER_NONE, 0);
      hr = pSysSurf->LockRect(&d3dlrSys, NULL, 0);
    }
    else
      hr = pTmpSurface->LockRect(&d3dlrSys, NULL, 0);
    byte *src = (byte *)d3dlrSys.pBits;
    byte *dst = pRGB;
		if (src && dst)
		{
			if (bRGBA)
			{
				for (i=0; i<nScaledY; i++)
				{
					int ni0 = (nScaledY-i-1)*nImageX*4;
					int ni1 = i * d3dlrSys.Pitch;
					for (int j=0; j<nScaledX; j++)
					{
						dst[ni0+j*4+0] = src[ni1+j*4+0];
						dst[ni0+j*4+1] = src[ni1+j*4+1];
						dst[ni0+j*4+2] = src[ni1+j*4+2];
						dst[ni0+j*4+3] = 255;
					}
				}
			}
			else
			{
				for (i=0; i<nScaledY; i++)
				{
					int ni0 = (nScaledY-i-1)*nImageX*3;
					int ni1 = i * d3dlrSys.Pitch;
					for (int j=0; j<nScaledX; j++)
					{
						dst[ni0+j*3+0] = src[ni1+j*4+0];
						dst[ni0+j*3+1] = src[ni1+j*4+1];
						dst[ni0+j*3+2] = src[ni1+j*4+2];
					}
				}
			}
    }
    if (pSysSurf)
      pSysSurf->UnlockRect();
    else
    if (pTmpSurface)
      pTmpSurface->UnlockRect();
    if (pSurf != m_RTStack[0][0].m_pTarget)
    {
      SAFE_RELEASE(pSurf);
    }
  }
  else
  {
    hr = m_pd3dDevice->CreateOffscreenPlainSurface(m_deskwidth, m_deskheight, D3DFMT_A8R8G8B8, D3DPOOL_SYSTEMMEM, &pSysSurf, NULL);
    hr = m_pd3dDevice->GetFrontBufferData(0, pSysSurf);
    POINT WndP;
    WndP.x = 0;
    WndP.y = 0;

#ifdef WIN32
    ClientToScreen(m_hWnd, &WndP);
#endif

    hr = pSysSurf->LockRect(&d3dlrSys, NULL, 0);
    byte *src = (byte *)d3dlrSys.pBits;
    byte *dst = pRGB;
    for (i=0; i<nSizeY; i++)
    {
      int ni0 = (nSizeY-i-1)*nImageX*4;
      for (int j=0; j<nSizeX; j++)
      {
        *(uint32 *)&dst[ni0+j*4] = *(uint32 *)&src[WndP.y*d3dlrSys.Pitch+(WndP.x+j)*4];
        Exchange(dst[ni0+j*4+0], dst[ni0+j*4+2]);
      }
      src += d3dlrSys.Pitch;
    }
    pSysSurf->UnlockRect();
  }
  SAFE_RELEASE(pTmpSurface);
  SAFE_RELEASE(pSysSurf);
#elif defined (DIRECT3D10) && (defined (WIN32) || defined(WIN64))
	if (!pRGB || nImageX <= 0 || nSizeX <= 0 || nSizeY <= 0 || eRBType != eRB_BackBuffer)
		return;

	assert(m_pBackBuffer);
	assert(!IsEditorMode() || m_CurrContext->m_pBackBuffer == m_pBackBuffer);

	ID3D11Texture2D* pBackBufferTex(0);

	D3D11_RENDER_TARGET_VIEW_DESC bbDesc;
	m_pBackBuffer->GetDesc(&bbDesc);
	if (bbDesc.ViewDimension == D3D11_RTV_DIMENSION_TEXTURE2DMS)
	{
		// TODO: resolve
	}

	m_pBackBuffer->GetResource((ID3D11Resource**) &pBackBufferTex);
	if (pBackBufferTex)
	{
		D3D11_TEXTURE2D_DESC dstDesc;
		dstDesc.Width = nScaledX <= 0 ? nSizeX : nScaledX;
		dstDesc.Height = nScaledY <= 0 ? nSizeY : nScaledY;
		dstDesc.MipLevels = 1;
		dstDesc.ArraySize = 1;
		dstDesc.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
		dstDesc.SampleDesc.Count = 1;
		dstDesc.SampleDesc.Quality = 0;
		dstDesc.Usage = D3D11_USAGE_STAGING;
		dstDesc.BindFlags = 0;
		dstDesc.CPUAccessFlags = D3D11_CPU_ACCESS_READ/* | D3D11_CPU_ACCESS_WRITE*/;
		dstDesc.MiscFlags = 0;

		ID3D11Texture2D* pDstTex(0);
		if (SUCCEEDED(m_pd3dDevice->CreateTexture2D(&dstDesc, 0, &pDstTex)))
		{			
			D3D11_BOX srcBox;
			srcBox.left = 0; srcBox.right = nSizeX;
			srcBox.top = 0; srcBox.bottom = nSizeY;
			srcBox.front = 0; srcBox.back = 1;

			D3D11_BOX dstBox;
			dstBox.left = 0; dstBox.right = dstDesc.Width;
			dstBox.top = 0; dstBox.bottom = dstDesc.Height;
			dstBox.front = 0; dstBox.back = 1;

			D3DX11_TEXTURE_LOAD_INFO loadInfo;
			loadInfo.pSrcBox = &srcBox;
			loadInfo.pDstBox = &dstBox;
			loadInfo.SrcFirstMip = 0;
			loadInfo.DstFirstMip = 0;
			loadInfo.NumMips = 1;
			loadInfo.SrcFirstElement = D3D11CalcSubresource(0, 0, 1);
			loadInfo.DstFirstElement = D3D11CalcSubresource(0, 0, 1);
			loadInfo.NumElements  = 0;
			loadInfo.Filter = D3DX11_FILTER_LINEAR;
			loadInfo.MipFilter = D3DX11_FILTER_LINEAR;

			if (SUCCEEDED(D3DX11LoadTextureFromTexture(m_pd3dDeviceContext, pBackBufferTex, &loadInfo, pDstTex)))
			{
				D3D11_MAPPED_SUBRESOURCE mappedTex;
				STALL_PROFILER("lock/read texture")
				if (SUCCEEDED(m_pd3dDeviceContext->Map(pDstTex, 0, D3D11_MAP_READ, 0, &mappedTex)))
				{
					if (bRGBA)
					{
						for (unsigned int i=0; i<dstDesc.Height; ++i)
						{
							uint8* pSrc((uint8*) mappedTex.pData + i * mappedTex.RowPitch);
							uint8* pDst((uint8*) pRGB + (dstDesc.Height - 1 - i) * nImageX * 4);
							for (unsigned int j=0; j<dstDesc.Width; ++j, pSrc += 4, pDst += 4)
							{
								pDst[0] = pSrc[2];
								pDst[1] = pSrc[1];
								pDst[2] = pSrc[0];
								pDst[3] = 255;
							}
						}
					}
					else
					{
						for (unsigned int i=0; i<dstDesc.Height; ++i)
						{
							uint8* pSrc((uint8*) mappedTex.pData + i * mappedTex.RowPitch);
							uint8* pDst((uint8*) pRGB + (dstDesc.Height - 1 - i) * nImageX * 3);
							for (unsigned int j=0; j<dstDesc.Width; ++j, pSrc += 4, pDst += 3)
							{
								pDst[0] = pSrc[2];
								pDst[1] = pSrc[1];
								pDst[2] = pSrc[0];
							}
						}
					}
					m_pd3dDeviceContext->Unmap(pDstTex, 0);
				}
			}
		}
		SAFE_RELEASE(pDstTex);
	}
	SAFE_RELEASE(pBackBufferTex);
#endif
}

void CD3D9Renderer::ReadFrameBufferFast(uint32* pDstARGBA8, int dstWidth, int dstHeight)
{
	if (!pDstARGBA8 || dstWidth <=0 || dstHeight <= 0)
		return;

#if defined(DIRECT3D9) || defined(OPENGL)
	IDirect3DSurface9* pSrcSurface(0);
	m_pd3dDevice->GetBackBuffer(0, 0, D3DBACKBUFFER_TYPE_MONO, &pSrcSurface);
	if (pSrcSurface)
	{
		D3DSURFACE_DESC srcDesc;
		pSrcSurface->GetDesc(&srcDesc);

		if (srcDesc.MultiSampleType == D3DMULTISAMPLE_NONE)
		{
			IDirect3DSurface9* pDstSurface(0);
			if (SUCCEEDED(m_pd3dDevice->CreateOffscreenPlainSurface(srcDesc.Width, srcDesc.Height, srcDesc.Format, D3DPOOL_SYSTEMMEM, &pDstSurface, 0)))
			{
				if (SUCCEEDED(m_pd3dDevice->GetRenderTargetData(pSrcSurface, pDstSurface)))
				{
					D3DLOCKED_RECT lrect;
					if (SUCCEEDED(pDstSurface->LockRect(&lrect, 0, 0 )))
					{
						int width(dstWidth > GetWidth() ? GetWidth() : dstWidth);
						int height(dstHeight > GetHeight() ? GetHeight() : dstHeight);
						
						for( int y(0); y < height; ++y )
						{
							uint32* pSrcData((uint32*)((byte*)lrect.pBits + y * lrect.Pitch));
							uint32* pDstData(&pDstARGBA8[y * dstWidth]);
							for( int x(0); x < width; ++x )
								pDstData[x] = pSrcData[x];
						}

						pDstSurface->UnlockRect();
					}
				}
			}
			SAFE_RELEASE(pDstSurface);
		}
	}
	SAFE_RELEASE(pSrcSurface);
#elif defined (DIRECT3D10) && (defined (WIN32) || defined(WIN64))

	assert(m_pBackBuffer);
	assert(!IsEditorMode() || m_CurrContext->m_pBackBuffer == m_pBackBuffer);

	D3D11_RENDER_TARGET_VIEW_DESC bbDesc;
	m_pBackBuffer->GetDesc(&bbDesc);
	if (bbDesc.ViewDimension == D3D11_RTV_DIMENSION_TEXTURE2DMS)
		return;

	ID3D11Texture2D* pBackBufferTex(0);
	m_pBackBuffer->GetResource((ID3D11Resource**) &pBackBufferTex);
	if (pBackBufferTex)
	{
		D3D11_TEXTURE2D_DESC dstDesc;
		dstDesc.Width = dstWidth > GetWidth() ? GetWidth() : dstWidth;
		dstDesc.Height = dstHeight > GetHeight() ? GetHeight() : dstHeight;
		dstDesc.MipLevels = 1;
		dstDesc.ArraySize = 1;
		dstDesc.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
		dstDesc.SampleDesc.Count = 1;
		dstDesc.SampleDesc.Quality = 0;
		dstDesc.Usage = D3D11_USAGE_STAGING;
		dstDesc.BindFlags = 0;
		dstDesc.CPUAccessFlags = D3D11_CPU_ACCESS_READ/* | D3D11_CPU_ACCESS_WRITE*/;
		dstDesc.MiscFlags = 0;

		ID3D11Texture2D* pDstTex(0);
		if (SUCCEEDED(m_pd3dDevice->CreateTexture2D(&dstDesc, 0, &pDstTex)))
		{
			D3D11_TEXTURE2D_DESC srcDesc;
			pBackBufferTex->GetDesc(&srcDesc);

			D3D11_BOX srcBox;
			srcBox.left = 0; srcBox.right = dstDesc.Width;
			srcBox.top = 0; srcBox.bottom = dstDesc.Height;
			srcBox.front = 0; srcBox.back = 1;
			m_pd3dDeviceContext->CopySubresourceRegion(pDstTex, 0, 0, 0, 0, pBackBufferTex, 0, &srcBox);

			D3D11_MAPPED_SUBRESOURCE mappedTex;
			STALL_PROFILER("lock/read texture")
			if (SUCCEEDED(m_pd3dDeviceContext->Map(pDstTex, 0, D3D11_MAP_READ, 0, &mappedTex)))
			{
				for (unsigned int i=0; i<dstDesc.Height; ++i)
				{
					uint8* pSrc((uint8*) mappedTex.pData + i * mappedTex.RowPitch);
					uint8* pDst((uint8*) pDstARGBA8 + i * dstWidth * 4);
					for (unsigned int j=0; j<dstDesc.Width; ++j, pSrc += 4, pDst += 4)
					{
						pDst[0] = pSrc[2];
						pDst[1] = pSrc[1];
						pDst[2] = pSrc[0];
						pDst[3] = 255;
					}
				}
				m_pd3dDeviceContext->Unmap(pDstTex, 0);
			}
		}
		SAFE_RELEASE(pDstTex);
	}
	SAFE_RELEASE(pBackBufferTex);
#endif
}

int CD3D9Renderer::ScreenToTexture(int nTexID)
{
  CTexture *pTex = CTexture::GetByID(nTexID);
  if (!pTex)
    return -1;

  int iTempX, iTempY, iWidth, iHeight;
  GetViewport(&iTempX, &iTempY, &iWidth, &iHeight);

#if defined (DIRECT3D9) || defined(XENON)
  RECT pSrcRect = { 0, 0, iWidth, iHeight };
  RECT pDstRect = { 0, 0, pTex->GetWidth(), pTex->GetHeight() };

  D3DSurface *pBackSurface = GetBackSurface();
  D3DSurface *pTexSurf = (D3DSurface *)pTex->GetSurface(-1, 0);
  m_pd3dDevice->StretchRect(pBackSurface, &pSrcRect, pTexSurf, &pDstRect, D3DTEXF_NONE); 

  SAFE_RELEASE(pTexSurf);
#endif

  return 0;
}

void	CD3D9Renderer::Draw2dImage(float xpos,float ypos,float w,float h,int textureid,float s0,float t0,float s1,float t1,float angle,float r,float g,float b,float a,float z)
{
  if (m_bDeviceLost)
    return;

  //////////////////////////////////////////////////////////////////////
  // Draw a textured quad, texture is assumed to be in video memory
  //////////////////////////////////////////////////////////////////////

  // Check for the presence of a D3D device
  assert(m_pd3dDevice);

  PROFILE_FRAME(Draw_2DImage);

  m_pRT->RC_Draw2dImage(xpos,ypos,w,h,textureid,s0,t0,s1,t1,angle,r,g,b,a,z);
}

void	CD3D9Renderer::DrawImage(float xpos,float ypos,float w,float h,int texture_id,float s0,float t0,float s1,float t1,float r,float g,float b,float a)
{
	float s[4],t[4];

	s[0]=s0;	t[0]=1.0f-t0;
	s[1]=s1;	t[1]=1.0f-t0;
	s[2]=s1;	t[2]=1.0f-t1;
	s[3]=s0;	t[3]=1.0f-t1;

	DrawImageWithUV(xpos,ypos,0,w,h,texture_id,s,t,r,g,b,a);
}


void	CD3D9Renderer::DrawImageWithUV(float xpos,float ypos,float z,float w,float h,int texture_id,float *s,float *t,float r,float g,float b,float a)
{
	assert(s);
	assert(t);

	if (m_bDeviceLost)
    return;

  m_pRT->RC_DrawImageWithUV(xpos,ypos,z,w,h,texture_id,s,t,r,g,b,a);
}

void	CD3D9Renderer::RT_DrawImageWithUV(float xpos,float ypos,float z,float w,float h,int texture_id,float s[4],float t[4],DWORD col)
{
	if (GetS3DRend().IsStereoEnabled())
	{
		GetS3DRend().BeginRenderingTo(LEFT_EYE);
		RT_DrawImageWithUVInternal(xpos, ypos, z, w, h, texture_id, s, t, col);
		GetS3DRend().EndRenderingTo(LEFT_EYE);

		GetS3DRend().BeginRenderingTo(RIGHT_EYE);
		RT_DrawImageWithUVInternal(xpos, ypos, z, w, h, texture_id, s, t, col);
		GetS3DRend().EndRenderingTo(RIGHT_EYE);
	}
	else
	{
		RT_DrawImageWithUVInternal(xpos, ypos, z, w, h, texture_id, s, t, col);
	}
}

void CD3D9Renderer::RT_DrawImageWithUVInternal(float xpos,float ypos,float z,float w,float h,int texture_id,float s[4],float t[4],DWORD col)
{
  //////////////////////////////////////////////////////////////////////
  // Draw a textured quad, texture is assumed to be in video memory
  //////////////////////////////////////////////////////////////////////

  // Check for the presence of a D3D device
  assert(m_pd3dDevice);

  PROFILE_FRAME(Draw_2DImage);

  HRESULT hReturn = S_OK;

  float fx = xpos;
  float fy = ypos;
  float fw = w;
  float fh = h;


  //if (!pID3DTexture)
  //  D3DXCreateTextureFromFile(m_pd3dDevice, "d:\\Textures\\Console\\DefaultConsole.tga", &pID3DTexture);

  SetCullMode(R_CULL_DISABLE);
  EnableTMU(true);
  EF_SetColorOp(eCO_MODULATE, eCO_MODULATE, DEF_TEXARG0, DEF_TEXARG0);

  // Lock the entire buffer and obtain a pointer to the location where we have to
  // write the vertex data. Note that we specify zero here to lock the entire
  // buffer.
  int nOffs;
  SVF_P3F_C4B_T2F *vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs);

  // Now that we have write access to the buffer, we can copy our vertices
  // into it

  // Define the quad
#if !defined(OPENGL)
  vQuad[0].xyz.x = xpos;
  vQuad[0].xyz.y = ypos;
	vQuad[0].xyz.z = z;

  vQuad[1].xyz.x = xpos + w;
  vQuad[1].xyz.y = ypos;
	vQuad[1].xyz.z = z;

  vQuad[2].xyz.x = xpos + w;
  vQuad[2].xyz.y = ypos + h;
	vQuad[2].xyz.z = z;

  vQuad[3].xyz.x = xpos;
  vQuad[3].xyz.y = ypos + h;
	vQuad[3].xyz.z = z;
#else
  vQuad[0].xyz.x = xpos;
  vQuad[0].xyz.y = ypos + h;
	vQuad[0].xyz.z = z;

  vQuad[1].xyz.x = xpos + w;
  vQuad[1].xyz.y = ypos + h;
	vQuad[1].xyz.z = z;

  vQuad[2].xyz.x = xpos + w;
  vQuad[2].xyz.y = ypos;
	vQuad[2].xyz.z = z;

  vQuad[3].xyz.x = xpos;
  vQuad[3].xyz.y = ypos;
	vQuad[3].xyz.z = z;
#endif

	for(uint32 dwI=0;dwI<4;++dwI)
	{
		vQuad[dwI].color.dcolor = col;

		vQuad[dwI].st = Vec2(s[dwI], t[dwI]);
	}

  std::swap(vQuad[2], vQuad[3]);

  // We are finished with accessing the vertex buffer
  UnlockVB();

  // Activate the image texture
  //SetTexture(texture_id);
  STexState TS;
  TS.SetFilterMode(FILTER_LINEAR);//POINT);        
  TS.SetClampMode(1, 1, 1);
  CTexture::ApplyForID(texture_id, CTexture::GetTexState(TS)); 

  FX_SetFPMode();

  // Bind our vertex as the first data stream of our device
  FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
  if (FAILED(FX_SetVertexDeclaration(0, eVF_P3F_C4B_T2F)))
    return;

  // Render the two triangles from the data stream
#if defined (DIRECT3D9) || defined (OPENGL)
  hReturn = m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP, nOffs, 2);
#elif defined (DIRECT3D10)
  SetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
  m_pd3dDeviceContext->Draw(4, nOffs);
#endif

  if (FAILED(hReturn))
  {
    assert(hReturn);
    return;
  }
}

void CD3D9Renderer::DrawLines(Vec3 v[], int nump, ColorF& col, int flags, float fGround)
{
  if (m_bDeviceLost)
    return;
  if (nump <= 1)
    return;

  int i;
  int st;
  HRESULT hr = S_OK;

  EF_SetColorOp(eCO_MODULATE, eCO_MODULATE, eCA_Texture | (eCA_Diffuse<<3), eCA_Texture | (eCA_Diffuse<<3));
  st = GS_NODEPTHTEST;
  if (flags & 1)
    st |= GS_BLSRC_SRCALPHA | GS_BLDST_ONEMINUSSRCALPHA;
  EF_SetState(st);
  CTexture::s_ptexWhite->Apply();

  DWORD c = D3DRGBA(col.r, col.g, col.b, col.a);
  int nOffs;

  if (fGround >= 0)
  {
    SVF_P3F_C4B_T2F *vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(nump*2, nOffs);

    for (i=0; i<nump; i++)
    {
      vQuad[i*2+0].xyz.x = v[i][0]; vQuad[i*2+0].xyz.y = fGround; vQuad[i*2+0].xyz.z = 0;
      vQuad[i*2+0].color.dcolor = c;
      vQuad[i*2+0].st = Vec2(0.0f, 0.0f);
      vQuad[i*2+1].xyz = v[i];
      vQuad[i*2+1].color.dcolor = c;
      vQuad[i*2+1].st = Vec2(0.0f, 0.0f);
    }
    // We are finished with accessing the vertex buffer
    UnlockVB();

    // Bind our vertex as the first data stream of our device
    FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
    FX_SetFPMode();
    if (!FAILED(FX_SetVertexDeclaration(0, eVF_P3F_C4B_T2F)))
    {
  #if defined (DIRECT3D9) || defined (OPENGL)
      hr = m_pd3dDevice->DrawPrimitive(D3DPT_LINELIST, nOffs, nump);
  #elif defined (DIRECT3D10)
		  SetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_LINELIST);
		  m_pd3dDeviceContext->Draw(nump, nOffs);
  #endif
    }
    if (FAILED(hr))
    {
      assert(hr);
      return;
    }
  }
  else
  {
    SVF_P3F_C4B_T2F *vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(nump, nOffs);

    for (i=0; i<nump; i++)
    {
      vQuad[i].xyz = v[i];
      vQuad[i].color.dcolor = c;
      vQuad[i].st = Vec2(0, 0);
    }
    // We are finished with accessing the vertex buffer
    UnlockVB();

    // Bind our vertex as the first data stream of our device
    FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
    FX_SetFPMode();
    if (!FAILED(FX_SetVertexDeclaration(0, eVF_P3F_C4B_T2F)))
    {
  #if defined (DIRECT3D9) || defined (OPENGL)
      hr = m_pd3dDevice->DrawPrimitive(D3DPT_LINESTRIP, nOffs, nump-1);
  #elif defined (DIRECT3D10)
		  SetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP);
		  m_pd3dDeviceContext->Draw(nump, nOffs);
  #endif
    }
    if (FAILED(hr))
    {
      assert(hr);
      return;
    }
  }
}

void CD3D9Renderer::DrawLine(const Vec3 & vPos1, const Vec3 & vPos2)
{
  if (m_bDeviceLost)
    return;

  HRESULT hr = S_OK;

  SetCullMode(R_CULL_DISABLE);
  EnableTMU(true);
  CTexture::s_ptexWhite->Apply();

  // Lock the entire buffer and obtain a pointer to the location where we have to
  // write the vertex data. Note that we specify zero here to lock the entire
  // buffer.
  int nOffs;
  SVF_P3F_C4B_T2F *vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(2, nOffs);

  // Define the line
  vQuad[0].xyz = vPos1;
  vQuad[0].color.dcolor = 0xffffffff;

  vQuad[1].xyz = vPos2;
  vQuad[1].color.dcolor = 0xffffffff;

  // We are finished with accessing the vertex buffer
  UnlockVB();

  // Bind our vertex as the first data stream of our device
  FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
  FX_SetFPMode();
  if (!FAILED(FX_SetVertexDeclaration(0, eVF_P3F_C4B_T2F)))
  {
  #if defined (DIRECT3D9) || defined (OPENGL)
    hr = m_pd3dDevice->DrawPrimitive(D3DPT_LINELIST, nOffs, 1);
  #elif defined (DIRECT3D10)
	  SetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_LINELIST);
	  m_pd3dDeviceContext->Draw(2, nOffs);
  #endif
  }
  if (FAILED(hr))
  {
    assert(hr);
    return;
  }

}

void CD3D9Renderer::Graph(byte *g, int x, int y, int wdt, int hgt, int nC, int type, char *text, ColorF& color, float fScale)
{
  ColorF col;
  Vec3* vp = (Vec3*) alloca(wdt * sizeof(Vec3));
  int i;

  Set2DMode(true, m_width, m_height);
  SetState(GS_NODEPTHTEST);
#if defined(PS3)
  col = ColorF(0.0f, 0.7f, 0.0f, 0.0f);
#else
  col = Col_Blue;
#endif
  int num = CTexture::s_ptexWhite->GetTextureID();

  float fy = (float)y;
  float fx = (float)x;
  float fwdt = (float)wdt;
  float fhgt = (float)hgt;

  DrawImage(fx, fy, fwdt, 2, num, 0, 0, 1, 1, col.r, col.g, col.b, col.a);
  DrawImage(fx, fy+fhgt, fwdt, 2, num, 0, 0, 1, 1, col.r, col.g, col.b, col.a);
  DrawImage(fx, fy, 2, fhgt, num, 0, 0, 1, 1, col.r, col.g, col.b, col.a);
  DrawImage(fx+fwdt-2, fy, 2, fhgt, num, 0, 0, 1, 1, col.r, col.g, col.b, col.a);

  float fGround = CV_r_graphstyle ? fy+fhgt : -1;

  for (i=0; i<wdt; i++)
  {
    vp[i][0] = (float)i+fx;
    vp[i][1] = fy + (float)(g[i])*fhgt/255.0f;
    vp[i][2] = 0;
  }
  if (type == 1)
  {
    col = color;
    DrawLines(&vp[0], nC, col, 3, fGround);
    col = ColorF(1.0f) - col;
    col[3] = 1;
    DrawLines(&vp[nC], wdt-nC, col, 3, fGround);
  }
  else
  if (type == 2)
  {
    col = color;
    DrawLines(&vp[0], wdt, col, 3, fGround);
  }

  if (text)
  {
    WriteXY(4,y-18, 0.5f,1,1,1,1,1, text);
    WriteXY(wdt-260,y-18, 0.5f,1,1,1,1,1, "%d ms", (int)(1000.0f*fScale));
  }

  Set2DMode(false, 0, 0);
}


void CD3D9Renderer::DrawLineColor(const Vec3 & vPos1, const ColorF & vColor1, const Vec3 & vPos2, const ColorF & vColor2)
{
  if (m_bDeviceLost)
    return;

  HRESULT hr = S_OK;

  //hr = D3DXCreateLine(m_pd3dDevice, &m_pLine);

  EnableTMU(true);
  CTexture::s_ptexWhite->Apply();
  EF_SetColorOp(eCO_MODULATE, eCO_MODULATE, DEF_TEXARG0, DEF_TEXARG0);

  // tiago - fixed, it wasn't passing alpha parameter...
  DWORD col1 = D3DRGBA(vColor1[0],vColor1[1],vColor1[2], vColor1[3]);
  DWORD col2 = D3DRGBA(vColor2[0],vColor2[1],vColor2[2], vColor1[3]);

  int nOffs;
  SVF_P3F_C4B_T2F *vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(2, nOffs);
  if (!vQuad)
    return;

  // Define the line
  vQuad[0].xyz = vPos1;
  vQuad[0].color.dcolor = col1;

  vQuad[1].xyz = vPos2;
  vQuad[1].color.dcolor = col2;

  // We are finished with accessing the vertex buffer
  UnlockVB();

  // Bind our vertex as the first data stream of our device
  FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
  FX_SetFPMode();
  if (!FAILED(FX_SetVertexDeclaration(0, eVF_P3F_C4B_T2F)))
  {
  #if defined (DIRECT3D9) || defined (OPENGL)
    hr = m_pd3dDevice->DrawPrimitive(D3DPT_LINELIST, nOffs, 1);
  #elif defined (DIRECT3D10)
	  SetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_LINELIST);
	  m_pd3dDeviceContext->Draw(2, nOffs);
  #endif
  }
  if (FAILED(hr))
  {
    assert(hr);
    return;
  }
}

//*********************************************************************

void CD3D9Renderer::GetModelViewMatrix(float * mat)
{
  int nThreadID = m_pRT->GetThreadList();
  *(Matrix44 *)mat = *m_RP.m_TI[nThreadID].m_matView->GetTop();
}

void CD3D9Renderer::GetProjectionMatrix(float * mat)
{
  int nThreadID = m_pRT->GetThreadList();
  *(Matrix44 *)mat = *m_RP.m_TI[nThreadID].m_matProj->GetTop();
}

void CD3D9Renderer::SetMatrices(float *pProjMat, float *pViewMat)
{
  int nThreadID = m_pRT->GetThreadList();
  m_RP.m_TI[nThreadID].m_matProj->LoadMatrix((Matrix44 *)pProjMat);
  m_RP.m_TI[nThreadID].m_matView->LoadMatrix((Matrix44 *)pViewMat);
}

///////////////////////////////////////////
void CD3D9Renderer::PushMatrix()
{
  assert(m_pd3dDevice);

  EF_PushMatrix();
}

///////////////////////////////////////////
void CD3D9Renderer::PopMatrix()
{
  assert(m_pd3dDevice);

  EF_PopMatrix();
}

void CD3D9Renderer::SetPerspective(const CCamera &cam)
{
  int nThreadID = m_pRT->GetThreadList();
  Matrix44A *m = m_RP.m_TI[nThreadID].m_matProj->GetTop();
	mathMatrixPerspectiveFov(m, cam.GetFov(), cam.GetProjRatio(), cam.GetNearPlane(), cam.GetFarPlane());
  EF_DirtyMatrix();
}


//-----------------------------------------------------------------------------
// coded by ivo:
// calculate parameter for an off-center projection matrix.
// the projection matrix itself is calculated by D3D9.
//-----------------------------------------------------------------------------
D3DXMATRIXA16 OffCenterProjection(const CCamera& cam, const Vec3& nv, unsigned short max, unsigned short win_width,  unsigned short win_height) {

  int nThreadID = gRenDev->m_pRT->GetThreadList();

  //get the size of near plane
  float l=+nv.x;
  float r=-nv.x;
  float b=-nv.z;
  float t=+nv.z;

  //---------------------------------------------------

  float max_x=(float)max;
  float max_z=(float)max;

  float win_x=(float)win_width;
  float win_z=(float)win_height;

  if ((win_x<max_x) && (win_z<max_z) ) {
    //calculate parameters for off-center projection-matrix
    float ext_x=-nv.x*2;
    float ext_z=+nv.z*2;
    l=+nv.x+(ext_x/max_x)*win_x;
    r=+nv.x+(ext_x/max_x)*(win_x+1);
    t=+nv.z-(ext_z/max_z)*win_z;
    b=+nv.z-(ext_z/max_z)*(win_z+1);
  }

  D3DXMATRIXA16 m;
  mathMatrixPerspectiveOffCenter((Matrix44A*)&m, l,r,b,t, cam.GetNearPlane(), cam.GetFarPlane());
  return m;
}

void CD3D9Renderer::SetRCamera(const CRenderCamera &cam)
{
  int nThreadID = m_pRT->GetThreadList();
  m_RP.m_TI[nThreadID].m_rcam = cam;
  D3DXMATRIXA16 *m = (D3DXMATRIXA16*)m_RP.m_TI[nThreadID].m_matView->GetTop();
  cam.GetModelviewMatrix(*m);
  if (m_RP.m_TI[nThreadID].m_PersFlags & RBPF_MIRRORCAMERA)
    m_RP.m_TI[nThreadID].m_matView->Scale(1,-1,1);
  m = (D3DXMATRIXA16*)m_RP.m_TI[nThreadID].m_matProj->GetTop();
  //cam.GetProjectionMatrix(*m);
  mathMatrixPerspectiveOffCenter((Matrix44A*)m, cam.wL, cam.wR, cam.wB, cam.wT, cam.Near, cam.Far);
  EF_DirtyMatrix();
}

void CD3D9Renderer::SetCamera(const CCamera &cam)
{
  int nThreadID = m_pRT->GetThreadList();

  assert(m_pd3dDevice);

  const Matrix34& m34 = cam.GetMatrix();

  CRenderCamera c;
  //float fov=cam.GetFov(); //*cam.GetProjRatio();
  //c.Perspective(fov, cam.GetProjRatio(), cam.GetNearPlane(), cam.GetFarPlane());
  // Asymmetric frustum
  float Near = cam.GetNearPlane(), Far = cam.GetFarPlane();
  float wT = tanf(cam.GetFov()*0.5f)*Near, wB = -wT;
  float wR = wT * cam.GetProjRatio(), wL = -wR;
  c.Frustum( wL + cam.GetAsymL(), wR + cam.GetAsymR(), wB + cam.GetAsymB(), wT + cam.GetAsymT(), Near, Far );

  Vec3 vEye = cam.GetPosition();
  Vec3 vAt = vEye + Vec3(m34(0,1), m34(1,1), m34(2,1));
  Vec3 vUp = Vec3(m34(0,2), m34(1,2), m34(2,2));
  c.LookAt(vEye, vAt, vUp);
  SetRCamera(c);

  Matrix44A *m = m_RP.m_TI[nThreadID].m_matProj->GetTop();
  //mathMatrixPerspectiveFov(m, fov, cam.GetProjRatio(), cam.GetNearPlane(), cam.GetFarPlane());
	//D3DXMatrixPerspectiveFovRH(m, fov, cam.GetProjRatio(), cam.GetNearPlane(), cam.GetFarPlane());

	if( SRendItem::m_RecurseLevel[nThreadID] <= 1 && (m_RenderTileInfo.nGridSizeX > 1.f || m_RenderTileInfo.nGridSizeY > 1.f))
	{ // shift and scale viewport
		(*m).m00 *= m_RenderTileInfo.nGridSizeX;
		(*m).m11 *= m_RenderTileInfo.nGridSizeY;
		(*m).m20 =   (m_RenderTileInfo.nGridSizeX-1)-m_RenderTileInfo.nPosX*2.0f;
		(*m).m21 = -((m_RenderTileInfo.nGridSizeY-1)-m_RenderTileInfo.nPosY*2.0f);
	}

  Matrix44A mat = GetTransposed44(Matrix44A(Matrix33::CreateRotationX(-gf_PI/2) * cam.GetMatrix().GetInverted()));
  m = m_RP.m_TI[nThreadID].m_matView->GetTop();
  m_RP.m_TI[nThreadID].m_matView->LoadMatrix(&mat);

  mat = cam.GetMatrix();
  mat(0, 3) = 0;
  mat(1, 3) = 0;
  mat(2, 3) = 0;
  m_CameraZeroMatrix[nThreadID].Transpose(Matrix44A(Matrix33::CreateRotationX(-gf_PI/2) * Matrix34A(mat.GetInverted())));

  if (m_RP.m_TI[nThreadID].m_PersFlags & RBPF_MIRRORCAMERA)
    m_RP.m_TI[nThreadID].m_matView->Scale(1,-1,1);

  m_RP.m_TI[nThreadID].m_PersFlags |= RBPF_FP_MATRIXDIRTY;

  m_RP.m_TI[nThreadID].m_cam = cam;
  //m_RP.m_TI[nThreadID].m_cam.SetFrustum(m_width, m_height, cam.GetFov(), cam.GetNearPlane(), cam.GetFarPlane());

  EF_SetCameraInfo();
}

void CD3D9Renderer::SetRenderTile(f32 nTilesPosX, f32 nTilesPosY, f32 nTilesGridSizeX, f32 nTilesGridSizeY)
{
	m_RenderTileInfo.nPosX = nTilesPosX;
	m_RenderTileInfo.nPosY = nTilesPosY;
	m_RenderTileInfo.nGridSizeX = nTilesGridSizeX;
	m_RenderTileInfo.nGridSizeY = nTilesGridSizeY;
}

void CD3D9Renderer::SetViewport(int x, int y, int width, int height)
{
  ASSERT_IS_MAIN_THREAD(m_pRT)
  m_MainRTViewport.nX = x;
  m_MainRTViewport.nY = y;
  m_MainRTViewport.nWidth = width;
  m_MainRTViewport.nHeight = height;
  m_pRT->RC_SetViewport(x, y, width, height);
}

void CD3D9Renderer::RT_SetViewport(int x, int y, int width, int height)
{
  assert(m_pRT->IsRenderThread());
  m_NewViewport.nX = x;
  m_NewViewport.nY = y;
  m_NewViewport.nWidth = width;
  m_NewViewport.nHeight = height;
  m_RP.m_TI[m_RP.m_nProcessThreadID].m_PersFlags2 |= RBPF2_COMMIT_PF;
  m_bViewportDirty = true;
}

void CD3D9Renderer::GetViewport(int *x, int *y, int *width, int *height)
{
  SViewport& vp = m_pRT->IsRenderThread() ? m_NewViewport : m_MainRTViewport;
  *x = vp.nX;
  *y = vp.nY;
  *width = vp.nWidth;
  *height = vp.nHeight;
}

void CD3D9Renderer::SetScissor(int x, int y, int width, int height)
{
  if (!x && !y && !width && !height)
    EF_Scissor(false, x, y, width, height);
  else
    EF_Scissor(true, x, y, width, height);
}

void CD3D9Renderer::Flush3dBBox(const Vec3 &mins,const Vec3 &maxs,const bool bSolid)
{
  SetCullMode(R_CULL_DISABLE);
  EnableTMU(true);
  CTexture::s_ptexWhite->Apply();

  FX_Commit();

  HRESULT hr;

  int nOffs;
  SVF_P3F_C4B_T2F *vQuad;
  if(bSolid)
  {
    if (!FAILED(FX_SetVertexDeclaration(0, eVF_P3F_C4B_T2F)))
    {
      vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs);
      hr = FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
      vQuad[0].xyz.x = maxs.x; vQuad[0].xyz.y = mins.y; vQuad[0].xyz.z = mins.z; //3
      vQuad[1].xyz.x = maxs.x; vQuad[1].xyz.y = mins.y; vQuad[1].xyz.z = maxs.z; //2
      vQuad[2].xyz.x = mins.x; vQuad[2].xyz.y = mins.y; vQuad[2].xyz.z = maxs.z; //1
      vQuad[3].xyz.x = mins.x; vQuad[3].xyz.y = mins.y; vQuad[3].xyz.z = mins.z; //0
      UnlockVB();
  #if defined (DIRECT3D9) || defined (OPENGL)
      m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLEFAN, nOffs, 2);
  #elif defined (DIRECT3D10)
      assert(0);
  #endif

      vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs);
      hr = FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
      vQuad[0].xyz.x = mins.x; vQuad[0].xyz.y = mins.y; vQuad[0].xyz.z = mins.z; //0
      vQuad[1].xyz.x = mins.x; vQuad[1].xyz.y = mins.y; vQuad[1].xyz.z = maxs.z; //1
      vQuad[2].xyz.x = mins.x; vQuad[2].xyz.y = maxs.y; vQuad[2].xyz.z = maxs.z; //6
      vQuad[3].xyz.x = mins.x; vQuad[3].xyz.y = maxs.y; vQuad[3].xyz.z = mins.z; //4
      UnlockVB();
  #if defined (DIRECT3D9) || defined (OPENGL)
      m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLEFAN, nOffs, 2);
  #elif defined (DIRECT3D10)
      assert(0);
  #endif

      vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs);
      hr = FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
      vQuad[0].xyz.x = mins.x; vQuad[0].xyz.y = maxs.y; vQuad[0].xyz.z = mins.z; //4
      vQuad[1].xyz.x = mins.x; vQuad[1].xyz.y = maxs.y; vQuad[1].xyz.z = maxs.z; //6
      vQuad[2].xyz.x = maxs.x; vQuad[2].xyz.y = maxs.y; vQuad[2].xyz.z = maxs.z; //7
      vQuad[3].xyz.x = maxs.x; vQuad[3].xyz.y = maxs.y; vQuad[3].xyz.z = mins.z; //5
      UnlockVB();
  #if defined (DIRECT3D9) || defined (OPENGL)
      m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLEFAN, nOffs, 2);
  #elif defined (DIRECT3D10)
      assert(0);
  #endif

      vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs);
      hr = FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
      vQuad[0].xyz.x = maxs.x; vQuad[0].xyz.y = maxs.y; vQuad[0].xyz.z = mins.z; //54
      vQuad[1].xyz.x = maxs.x; vQuad[1].xyz.y = maxs.y; vQuad[1].xyz.z = maxs.z; //73
      vQuad[2].xyz.x = maxs.x; vQuad[2].xyz.y = mins.y; vQuad[2].xyz.z = maxs.z; //22
      vQuad[3].xyz.x = maxs.x; vQuad[3].xyz.y = mins.y; vQuad[3].xyz.z = mins.z; //31
      UnlockVB();
  #if defined (DIRECT3D9) || defined (OPENGL)
      m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLEFAN, nOffs, 2);
  #elif defined (DIRECT3D10)
      assert(0);
  #endif

      // top
      vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs);
      hr = FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
      vQuad[0].xyz.x = maxs.x; vQuad[0].xyz.z = maxs.z; vQuad[0].xyz.y = mins.y; //3
      vQuad[1].xyz.x = maxs.x; vQuad[1].xyz.z = maxs.z; vQuad[1].xyz.y = maxs.y; //2
      vQuad[2].xyz.x = mins.x; vQuad[2].xyz.z = maxs.z; vQuad[2].xyz.y = maxs.y; //1
      vQuad[3].xyz.x = mins.x; vQuad[3].xyz.z = maxs.z; vQuad[3].xyz.y = mins.y; //0
      UnlockVB();
  #if defined (DIRECT3D9) || defined (OPENGL)
      m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLEFAN, nOffs, 2);
  #elif defined (DIRECT3D10)
      assert(0);
  #endif

      // bottom
      vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs);
      hr = FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
      vQuad[0].xyz.x = maxs.x; vQuad[0].xyz.z = mins.z; vQuad[0].xyz.y = mins.y; //3
      vQuad[1].xyz.x = maxs.x; vQuad[1].xyz.z = mins.z; vQuad[1].xyz.y = maxs.y; //2
      vQuad[2].xyz.x = mins.x; vQuad[2].xyz.z = mins.z; vQuad[2].xyz.y = maxs.y; //1
      vQuad[3].xyz.x = mins.x; vQuad[3].xyz.z = mins.z; vQuad[3].xyz.y = mins.y; //0
      UnlockVB();
  #if defined (DIRECT3D9) || defined (OPENGL)
      m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLEFAN, nOffs, 2);
  #elif defined (DIRECT3D10)
      assert(0);
  #endif
    }
  }
  else
  {
    if (!FAILED(FX_SetVertexDeclaration(0, eVF_P3F_C4B_T2F)))
    {
      vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs);
      hr = FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
      vQuad[0].xyz.x = maxs.x; vQuad[0].xyz.y = mins.y; vQuad[0].xyz.z = mins.z; //3
      vQuad[1].xyz.x = maxs.x; vQuad[1].xyz.y = mins.y; vQuad[1].xyz.z = maxs.z; //2
      vQuad[2].xyz.x = mins.x; vQuad[2].xyz.y = mins.y; vQuad[2].xyz.z = maxs.z; //1
      vQuad[3].xyz.x = mins.x; vQuad[3].xyz.y = mins.y; vQuad[3].xyz.z = mins.z; //0
      UnlockVB();
  #if defined (DIRECT3D9) || defined (OPENGL)
      m_pd3dDevice->DrawPrimitive(D3DPT_LINELIST, nOffs, 2);
  #elif defined (DIRECT3D10)
      assert(0);
  #endif

      vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs);
      hr = FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
      vQuad[0].xyz.x = mins.x; vQuad[0].xyz.y = mins.y; vQuad[0].xyz.z = mins.z; //0
      vQuad[1].xyz.x = mins.x; vQuad[1].xyz.y = mins.y; vQuad[1].xyz.z = maxs.z; //1
      vQuad[2].xyz.x = mins.x; vQuad[2].xyz.y = maxs.y; vQuad[2].xyz.z = maxs.z; //6
      vQuad[3].xyz.x = mins.x; vQuad[3].xyz.y = maxs.y; vQuad[3].xyz.z = mins.z; //4
      UnlockVB();
  #if defined (DIRECT3D9) || defined (OPENGL)
      m_pd3dDevice->DrawPrimitive(D3DPT_LINELIST, nOffs, 2);
  #elif defined (DIRECT3D10)
      assert(0);
  #endif

      vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs);
      hr = FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
      vQuad[0].xyz.x = mins.x; vQuad[0].xyz.y = maxs.y; vQuad[0].xyz.z = mins.z; //4
      vQuad[1].xyz.x = mins.x; vQuad[1].xyz.y = maxs.y; vQuad[1].xyz.z = maxs.z; //6
      vQuad[2].xyz.x = maxs.x; vQuad[2].xyz.y = maxs.y; vQuad[2].xyz.z = maxs.z; //7
      vQuad[3].xyz.x = maxs.x; vQuad[3].xyz.y = maxs.y; vQuad[3].xyz.z = mins.z; //5
      UnlockVB();
  #if defined (DIRECT3D9) || defined (OPENGL)
      m_pd3dDevice->DrawPrimitive(D3DPT_LINELIST, nOffs, 2);
  #elif defined (DIRECT3D10)
      assert(0);
  #endif

      vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs);
      hr = FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
      vQuad[0].xyz.x = maxs.x; vQuad[0].xyz.y = mins.y; vQuad[0].xyz.z = mins.z; //54
      vQuad[1].xyz.x = maxs.x; vQuad[1].xyz.y = mins.y; vQuad[1].xyz.z = maxs.z; //73
      vQuad[2].xyz.x = maxs.x; vQuad[2].xyz.y = maxs.y; vQuad[2].xyz.z = maxs.z; //22
      vQuad[3].xyz.x = maxs.x; vQuad[3].xyz.y = maxs.y; vQuad[3].xyz.z = mins.z; //31
      UnlockVB();
  #if defined (DIRECT3D9) || defined (OPENGL)
      m_pd3dDevice->DrawPrimitive(D3DPT_LINELIST, nOffs, 2);
  #elif defined (DIRECT3D10)
      assert(0);
  #endif

      // top
      vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(5, nOffs);
      hr = FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
      vQuad[0].xyz.x = maxs.x; vQuad[0].xyz.z = maxs.z; vQuad[0].xyz.y = mins.y; //3
      vQuad[1].xyz.x = maxs.x; vQuad[1].xyz.z = maxs.z; vQuad[1].xyz.y = maxs.y; //2
      vQuad[2].xyz.x = mins.x; vQuad[2].xyz.z = maxs.z; vQuad[2].xyz.y = maxs.y; //1
      vQuad[3].xyz.x = mins.x; vQuad[3].xyz.z = maxs.z; vQuad[3].xyz.y = mins.y; //0
      vQuad[4].xyz.x = maxs.x; vQuad[4].xyz.z = maxs.z; vQuad[4].xyz.y = mins.y; //3
      UnlockVB();
  #if defined (DIRECT3D9) || defined (OPENGL)
      m_pd3dDevice->DrawPrimitive(D3DPT_LINELIST, nOffs, 2);
  #elif defined (DIRECT3D10)
      assert(0);
  #endif

      // bottom
      vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(5, nOffs);
      hr = FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
      vQuad[0].xyz.x = maxs.x; vQuad[0].xyz.z = mins.z; vQuad[0].xyz.y = mins.y; //3
      vQuad[1].xyz.x = maxs.x; vQuad[1].xyz.z = mins.z; vQuad[1].xyz.y = maxs.y; //2
      vQuad[2].xyz.x = mins.x; vQuad[2].xyz.z = mins.z; vQuad[2].xyz.y = maxs.y; //1
      vQuad[3].xyz.x = mins.x; vQuad[3].xyz.z = mins.z; vQuad[3].xyz.y = mins.y; //0
      vQuad[4].xyz.x = maxs.x; vQuad[4].xyz.z = mins.z; vQuad[4].xyz.y = mins.y; //3
      UnlockVB();
  #if defined (DIRECT3D9) || defined (OPENGL)
      m_pd3dDevice->DrawPrimitive(D3DPT_LINELIST, nOffs, 2);
  #elif defined (DIRECT3D10)
      assert(0);
  #endif
    }
  }
}

void CD3D9Renderer::Draw3dBBox(const Vec3 &mins,const Vec3 &maxs, int nPrimType)
{
  Draw3dPrim(mins, maxs, nPrimType);
}

void CD3D9Renderer::Draw3dPrim(const Vec3 &mins,const Vec3 &maxs, int nPrimType, const float* pRGBA)
{
  BBoxInfo info;
  info.vMins = mins;
  info.vMaxs = maxs;
  info.nPrimType = nPrimType;
  if (pRGBA)
  {
    for (int i = 0; i < 4; ++i)
      info.fColor[i] = pRGBA[i];
  }
  else
  {
    info.fColor[0] = m_RP.m_CurGlobalColor[0];
    info.fColor[1] = m_RP.m_CurGlobalColor[1];
    info.fColor[2] = m_RP.m_CurGlobalColor[2];
    info.fColor[3] = m_RP.m_CurGlobalColor[3];
  }
  m_arrBoxesToDraw.push_back(info);
}


void CD3D9Renderer::SetCullMode(int mode)
{
  m_pRT->RC_SetCull(mode);
}

void CD3D9Renderer::RT_SetCull(int mode)
{
  //////////////////////////////////////////////////////////////////////
  // Change the culling mode
  //////////////////////////////////////////////////////////////////////

  assert(m_pd3dDevice);

  switch (mode)
  {
    case R_CULL_DISABLE:
      D3DSetCull(eCULL_None);
      break;
    case R_CULL_BACK:
      D3DSetCull(eCULL_Back);
      break;
    case R_CULL_FRONT:
      D3DSetCull(eCULL_Front);
      break;
  }
}

void CD3D9Renderer::PushProfileMarker(char* label)
{
	m_pRT->RC_PushProfileMarker(label);
}

void CD3D9Renderer::PopProfileMarker(char* label)
{
	m_pRT->RC_PopProfileMarker(label);
}

void CD3D9Renderer::SetFog(float density, float fogstart, float fogend, const float *color, int fogmode)
{
  //////////////////////////////////////////////////////////////////////
  // Configure the fog settings
  //////////////////////////////////////////////////////////////////////

  assert(m_pd3dDevice);

  int nThreadID = m_pRT->GetThreadList();
  m_RP.m_TI[nThreadID].m_FS.m_FogDensity = density;
  m_RP.m_TI[nThreadID].m_FS.m_FogStart = fogstart;
  m_RP.m_TI[nThreadID].m_FS.m_FogEnd = fogend;
  m_RP.m_TI[nThreadID].m_FS.m_nFogMode = fogmode;
  m_RP.m_TI[nThreadID].m_FS.m_nCurFogMode = fogmode;
  ColorF col = ColorF(color[0], color[1], color[2], 1.0f);
  m_RP.m_TI[nThreadID].m_FS.m_FogColor = col;

  // Fog color
  EF_SetFogColor(m_RP.m_TI[nThreadID].m_FS.m_FogColor);
}

void CD3D9Renderer::SetFogColor(float * color)
{
  int nThreadID = m_pRT->GetThreadList();
  m_RP.m_TI[nThreadID].m_FS.m_FogColor = ColorF(color[0],color[1],color[2],color[3]	);

  // Fog color
  EF_SetFogColor(m_RP.m_TI[nThreadID].m_FS.m_FogColor);
}

bool CD3D9Renderer::EnableFog(bool enable)
{
  //////////////////////////////////////////////////////////////////////
  // Enable or disable fog
  //////////////////////////////////////////////////////////////////////

  assert(m_pd3dDevice);

  int nThreadID = m_pRT->GetThreadList();

  bool bPrevFog = m_RP.m_TI[nThreadID].m_FS.m_bEnable; // remember fog value

  m_RP.m_TI[nThreadID].m_FS.m_bEnable = enable;

  return bPrevFog;
}

void CD3D9Renderer::SelectTMU(int tnum)
{
  if (!m_pRT->IsRenderThread())
    return;

  EF_SelectTMU(tnum);
}

void CD3D9Renderer::EnableTMU(bool enable)
{
  assert(m_pd3dDevice);

  if (!m_pRT->IsRenderThread())
    return;

  byte eCO = (enable ? eCO_MODULATE : eCO_REPLACE);
  EF_SetColorOp(eCO, eCO, 255, 255);
  if (!enable)
  {
#if defined (DIRECT3D9) || defined (OPENGL)
    m_pd3dDevice->SetTexture(CTexture::s_CurStage, NULL);
#elif defined (DIRECT3D10)
#endif
    CTexture::s_TexStages[CTexture::s_CurStage].m_Texture = NULL;
    if ((m_RP.m_TI[m_RP.m_nProcessThreadID].m_eCurColorArg[CTexture::s_CurStage]&7) == eCA_Texture)
    {
      m_RP.m_TI[m_RP.m_nProcessThreadID].m_eCurColorArg[CTexture::s_CurStage] = (m_RP.m_TI[m_RP.m_nProcessThreadID].m_eCurColorArg[CTexture::s_CurStage] & ~7) | eCA_Diffuse;
      m_RP.m_TI[m_RP.m_nProcessThreadID].m_PersFlags |= RBPF_FP_DIRTY;
    }
    if ((m_RP.m_TI[m_RP.m_nProcessThreadID].m_eCurAlphaArg[CTexture::s_CurStage]&7) == eCA_Texture)
    {
      m_RP.m_TI[m_RP.m_nProcessThreadID].m_eCurAlphaArg[CTexture::s_CurStage] = (m_RP.m_TI[m_RP.m_nProcessThreadID].m_eCurAlphaArg[CTexture::s_CurStage] & ~7) | eCA_Diffuse;
      m_RP.m_TI[m_RP.m_nProcessThreadID].m_PersFlags |= RBPF_FP_DIRTY;
    }
  }
}

///////////////////////////////////////////
void CD3D9Renderer::CheckError(const char *comment)
{
}

///////////////////////////////////////////
int CD3D9Renderer::SetWireframeMode(int mode)
{
	assert(mode == R_WIREFRAME_MODE || mode == R_SOLID_MODE || mode == R_POINT_MODE);

	if(m_wireframe_mode == mode)
		return m_wireframe_mode;

  int prev_mode = m_wireframe_mode;
  m_wireframe_mode = mode;

	int nState = m_RP.m_CurState;
	//nState	&=	~(GS_WIREFRAME|GS_POINTRENDERING);
 // if (m_wireframe_mode == R_WIREFRAME_MODE)
 //   nState |= GS_WIREFRAME;
 // else
	//if(m_wireframe_mode == R_POINT_MODE)
 //   nState |= GS_POINTRENDERING;
	SetState(nState);

  return prev_mode;
}

///////////////////////////////////////////
void CD3D9Renderer::EnableVSync(bool enable)
{
  ChangeResolution(m_CVWidth->GetIVal(), m_CVHeight->GetIVal(), m_CVColorBits->GetIVal(), 75, m_CVFullScreen->GetIVal()!=0, false);
}

void CD3D9Renderer::DrawQuad(const Vec3 &right, const Vec3 &up, const Vec3 &origin,int nFlipMode/*=0*/)
{
  PROFILE_FRAME(Draw_2DImage);

  SVF_P3F_C4B_T2F Verts[4];

  Vec3 curr;
  curr=origin+(-right-up);
  Verts[0].xyz = curr;
  Verts[0].st = Vec2(-1.0f, 0.0f);

  curr=origin+(right-up);
  Verts[1].xyz = curr;
  Verts[1].st = Vec2(0, 0);

  curr=origin+(right+up);
  Verts[2].xyz = curr;
  Verts[2].st = Vec2(0, 1.0f);

  curr=origin+(-right+up);
  Verts[3].xyz = curr;
  Verts[3].st = Vec2(-1.0f, 1.0f);

  int nOffs;
  SVF_P3F_C4B_T2F *vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs);
  memcpy(vQuad, Verts, 4*sizeof(SVF_P3F_C4B_T2F));

  UnlockVB();

  FX_Commit();

  FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
  FX_SetVertexDeclaration(0, eVF_P3F_C4B_T2F);
	FX_SetFPMode();
#if defined (DIRECT3D9) || defined (OPENGL)
  m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLEFAN, nOffs, 2);
#elif defined (DIRECT3D10)
  assert(0);
#endif
  m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_GENERAL] += 2;
  m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_GENERAL]++;
}

void CD3D9Renderer::DrawQuad(float dy,float dx, float dz, float x, float y, float z)
{
  PROFILE_FRAME(Draw_2DImage);

  SVF_P3F_C4B_T2F Verts[4];

  Verts[0].xyz = Vec3(-dx+x, dy+y, -dz+z);
  Verts[0].st = Vec2(0, 0);

  Verts[1].xyz = Vec3(dx+x, -dy+y, -dz+z);
  Verts[1].st = Vec2(1.0f, 0.0f);

  Verts[2].xyz = Vec3(dx+x, -dy+y, dz+z);
  Verts[2].st = Vec2(1.0f, 1.0f);

  Verts[3].xyz = Vec3(-dx+x, dy+y, dz+z);
  Verts[3].st = Vec2(0, 1.0f);

  int nOffs;
  SVF_P3F_C4B_T2F *vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs);
  memcpy(vQuad, Verts, 4*sizeof(SVF_P3F_C4B_T2F));

  UnlockVB();

  FX_Commit();

  FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
  FX_SetFPMode();
  if (!FAILED(FX_SetVertexDeclaration(0, eVF_P3F_C4B_T2F)))
  {
  #if defined (DIRECT3D9) || defined (OPENGL)
    m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLEFAN, nOffs, 2);
  #elif defined (DIRECT3D10)
    assert(0);
  #endif

    m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_GENERAL] += 2;
    m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_GENERAL]++;
  }
}

void CD3D9Renderer::DrawQuad(float x0, float y0, float x1, float y1, const ColorF & color, float z, float s0, float t0, float s1, float t1)
{
  PROFILE_FRAME(Draw_2DImage);

  ColorF c = color;
  c.NormalizeCol(c);
  DWORD col = D3DRGBA(c.r, c.g, c.b, c.a);

  int nOffs;
  SVF_P3F_C4B_T2F *vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs, POOL_P3F_COL4UB_TEX2F);

  float ftx0 = s0;
  float fty0 = t0;
  float ftx1 = s1;
  float fty1 = t1;

#ifdef XENON
  SVF_P3F_C4B_T2F Quad[4];
  SVF_P3F_C4B_T2F *pDst = vQuad;
  vQuad = Quad;
#endif

  // Define the quad
  vQuad[0].xyz = Vec3(x0, y0, z);
  vQuad[0].color.dcolor = col;
  vQuad[0].st = Vec2(ftx0, fty0);

  vQuad[1].xyz = Vec3(x1, y0, z);
  vQuad[1].color.dcolor = col;
  vQuad[1].st = Vec2(ftx1, fty0);

  vQuad[3].xyz = Vec3(x1, y1, z);
  vQuad[3].color.dcolor = col;
  vQuad[3].st = Vec2(ftx1, fty1);

  vQuad[2].xyz = Vec3(x0, y1, z);
  vQuad[2].color.dcolor = col;
  vQuad[2].st = Vec2(ftx0, fty1);

#ifdef XENON
  memcpy(pDst, Quad, 4*sizeof(SVF_P3F_C4B_T2F));
#endif

  UnlockVB(POOL_P3F_COL4UB_TEX2F);

  FX_Commit();

  FX_SetVStream(0, m_pVB[POOL_P3F_COL4UB_TEX2F], 0, sizeof(SVF_P3F_C4B_T2F));
  if (!FAILED(FX_SetVertexDeclaration(0, eVF_P3F_C4B_T2F)))
  {
  #if defined (DIRECT3D9) || defined (OPENGL)
    m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP, nOffs, 2);
  #elif defined (DIRECT3D10)
    SetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
    m_pd3dDeviceContext->Draw(4, nOffs);
  #endif

    m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_GENERAL] += 2;
    m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_GENERAL]++;
  }
}

void CD3D9Renderer::DrawFullScreenQuad(CShader *pSH, const CCryNameTSCRC& TechName, float s0, float t0, float s1, float t1, uint32 nState)
{
  uint32 nPasses;
  pSH->FXSetTechnique(TechName);
  pSH->FXBegin(&nPasses, FEF_DONTSETTEXTURES | FEF_DONTSETSTATES);
  pSH->FXBeginPass(0);

  float fWidth5 = (float)m_NewViewport.nWidth-0.5f;
  float fHeight5 = (float)m_NewViewport.nHeight-0.5f;

  int nOffs;
  SVF_TP3F_C4B_T2F *Verts = (SVF_TP3F_C4B_T2F *)GetVBPtr(4, nOffs, POOL_TRP3F_COL4UB_TEX2F);
  if( Verts )
  {
#if defined (DIRECT3D10) || defined (XENON)
    std::swap(t0, t1);
#endif
#ifdef XENON
    SVF_TP3F_C4B_T2F SysVB[4];
    SVF_TP3F_C4B_T2F *pDst = Verts;
    Verts = &SysVB[0];
#endif
    Verts->pos = Vec4(-0.5f, -0.5f, 0.0f, 1.0f);
    Verts->st = Vec2(s0, t0);
    Verts->color.dcolor = (uint32)-1;
    Verts++;

    Verts->pos = Vec4(fWidth5, -0.5f, 0.0f, 1.0f);
    Verts->st = Vec2(s1, t0);
    Verts->color.dcolor = (uint32)-1;
    Verts++;

    Verts->pos = Vec4(-0.5f, fHeight5, 0.0f, 1.0f);
    Verts->st = Vec2(s0, t1);
    Verts->color.dcolor = (uint32)-1;
    Verts++;

    Verts->pos = Vec4(fWidth5, fHeight5, 0.0f, 1.0f);
    Verts->st = Vec2(s1, t1);
    Verts->color.dcolor = (uint32)-1;
#ifdef XENON
    memcpy(pDst, SysVB, sizeof(SVF_TP3F_C4B_T2F)*4);
#endif
  }
  UnlockVB(POOL_TRP3F_COL4UB_TEX2F);

  FX_Commit();

  // Draw a fullscreen quad to sample the RT
  EF_SetState(nState);
  if (!FAILED(FX_SetVertexDeclaration(0, eVF_TP3F_C4B_T2F)))
  {
    FX_SetVStream(0, m_pVB[POOL_TRP3F_COL4UB_TEX2F], 0, sizeof(SVF_TP3F_C4B_T2F));

  #if defined (DIRECT3D9) || defined(OPENGL)
    m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP, nOffs, 2);
  #elif defined (DIRECT3D10)
    SetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
    m_pd3dDeviceContext->Draw(4, nOffs);
  #endif
  }
  pSH->FXEndPass();

  EF_SelectTMU(0);

  m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_GENERAL] += 2;
  m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_GENERAL]++;
}

void CD3D9Renderer::DrawQuad3D(const Vec3& v0, const Vec3& v1, const Vec3& v2, const Vec3& v3,
                               const ColorF & color, float ftx0,  float fty0,  float ftx1,  float fty1)
{
  assert(color.r>=0.0f && color.r<=1.0f);
  assert(color.g>=0.0f && color.g<=1.0f);
  assert(color.b>=0.0f && color.b<=1.0f);
  assert(color.a>=0.0f && color.a<=1.0f);

  DWORD col = D3DRGBA(color.r, color.g, color.b, color.a);

  int nOffs;
  SVF_P3F_C4B_T2F *vQuad = (SVF_P3F_C4B_T2F *)GetVBPtr(4, nOffs);

  // Define the quad
  vQuad[0].xyz = v0;
  vQuad[0].color.dcolor = col;
  vQuad[0].st = Vec2(ftx0, fty0);

  vQuad[1].xyz = v1;
  vQuad[1].color.dcolor = col;
  vQuad[1].st = Vec2(ftx1, fty0);

  vQuad[3].xyz = v2;
  vQuad[3].color.dcolor = col;
  vQuad[3].st = Vec2(ftx1, fty1);

  vQuad[2].xyz = v3;
  vQuad[2].color.dcolor = col;
  vQuad[2].st = Vec2(ftx0, fty1);

  UnlockVB();

  FX_Commit();
  FX_SetVStream(0, m_pVB[0], 0, sizeof(SVF_P3F_C4B_T2F));
  if (!FAILED(FX_SetVertexDeclaration(0, eVF_P3F_C4B_T2F)))
  {
  #if defined (DIRECT3D9) || defined (OPENGL)
    m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP, nOffs, 2);
  #elif defined (DIRECT3D10)
    SetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
    m_pd3dDeviceContext->Draw(4, nOffs);
  #endif

    m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_GENERAL] += 2;
    m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_GENERAL]++;
  }
}

///////////////////////////////////////////
void CD3D9Renderer::DrawBuffer(CVertexBuffer *pVBuf, CIndexBuffer *pIBuf, int nNumIndices, int nOffsIndex, int nPrmode, int nVertStart, int nVertStop)
{
  if (m_bDeviceLost || !pVBuf || !pIBuf)
    return;

  //if (CV_d3d9_forcesoftware)
  //  return;

  int nIBOffset = 0;
  int nVBOffset = 0;
  D3DIndexBuffer *pIB = m_DevBufMan.GetD3DIB(pIBuf->m_VS.m_nDevID, &nIBOffset);
  D3DVertexBuffer *pVB = m_DevBufMan.GetD3DVB(pVBuf->m_VS.m_nDevID, &nVBOffset);

  if (!pIB || !pVB)
    return;

  PROFILE_FRAME(Draw_IndexMesh);

  int sizeIB = nNumIndices * sizeof(short);
  nIBOffset = (nIBOffset >> 1) + nOffsIndex;

  HRESULT h = FX_SetVertexDeclaration(0, pVBuf->m_eVF);
  if (!FAILED(h))
  {
    h = FX_SetVStream(0, pVB, nVBOffset,  CRenderMesh2::m_cSizeVF[pVBuf->m_eVF]);
    h = FX_SetIStream(pIB);
    FX_Commit();

    int NumVerts = 0;
    if (nVertStop)
      NumVerts = nVertStop;
    else
    {
      assert(0);
    }


#if defined (DIRECT3D9) || defined(OPENGL)
    switch(nPrmode)
    {
    case R_PRIMV_LINES:
      h = m_pd3dDevice->DrawIndexedPrimitive(D3DPT_LINELIST, 0, 0, NumVerts, nIBOffset, nNumIndices/2);
      //m_nPolygons+=numindices/2;
      break;

    case R_PRIMV_TRIANGLES:
      h = m_pd3dDevice->DrawIndexedPrimitive(D3DPT_TRIANGLELIST, 0, 0, NumVerts, nIBOffset, nNumIndices/3);
      m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_GENERAL] += nNumIndices/3;
      m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_GENERAL]++;
      break;

    case R_PRIMV_TRIANGLE_STRIP:
      h = m_pd3dDevice->DrawIndexedPrimitive(D3DPT_TRIANGLESTRIP, 0, 0, NumVerts, nIBOffset, nNumIndices-2);
      m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_GENERAL] += nNumIndices-2;
      m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_GENERAL]++;
      break;
    }
#elif defined (DIRECT3D10)
    switch(nPrmode)
    {
    case R_PRIMV_LINES:
      SetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_LINELIST);
      m_pd3dDeviceContext->DrawIndexed(nNumIndices, nIBOffset, 0);
      //m_nPolygons+=numindices/2;
      break;

    case R_PRIMV_TRIANGLES:
      SetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST);
      m_pd3dDeviceContext->DrawIndexed(nNumIndices, nIBOffset, 0);
      m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_GENERAL]+=nNumIndices/3;
      break;

    case R_PRIMV_TRIANGLE_STRIP:
      SetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
      m_pd3dDeviceContext->DrawIndexed(nNumIndices, nIBOffset, 0);
      m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_GENERAL]+=nNumIndices-2;
      break;
    }
#endif
  }
}


///////////////////////////////////////////
void CD3D9Renderer::DrawPrimitives(CVertexBuffer *src, int vert_num, int prim_type /*= R_PRIMV_TRIANGLE_STRIP*/)
{
  FX_Commit();

	// Assume failure, unless proven otherwise
  HRESULT h = E_FAIL;

  if (FAILED(FX_SetVertexDeclaration(0, src->m_eVF)))
	{
		//assert(0);
		return;
	}
  //FX_SetFPMode();

  // Stupid D3D debug runtime
  FX_SetVStream(3, NULL, 0, 0);
  
	int nOffs;
	switch (src->m_eVF)
  {
#ifdef FP16_MESH
  case eVF_P3S_C4B_T2S:
    {
      assert(false);
    }
    break;
#endif
  case eVF_P3F_C4B_T2F:
    {
      SVF_P3F_C4B_T2F *dt = (SVF_P3F_C4B_T2F *)src->m_VS.m_pLocalData;
      EF_SetVertColor();
      SVF_P3F_C4B_T2F *Verts = (SVF_P3F_C4B_T2F *)GetVBPtr(vert_num, nOffs);
			assert(Verts);

#if defined(DIRECT3D9) && (defined(WIN32) || defined(WIN64))
			if (Verts)
#endif
			{
				memcpy(Verts, dt, vert_num*sizeof(SVF_P3F_C4B_T2F));
				UnlockVB(POOL_P3F_COL4UB_TEX2F);
				h = FX_SetVStream(0, m_pVB[POOL_P3F_COL4UB_TEX2F], 0, sizeof(SVF_P3F_C4B_T2F));
			}
    }
    break;
  case eVF_TP3F_C4B_T2F:
    {
      SVF_TP3F_C4B_T2F *dt = (SVF_TP3F_C4B_T2F *)src->m_VS.m_pLocalData;
      EF_SetVertColor();
      SVF_TP3F_C4B_T2F *Verts = (SVF_TP3F_C4B_T2F *)GetVBPtr(vert_num, nOffs, POOL_TRP3F_COL4UB_TEX2F);
			assert(Verts);

#if defined(DIRECT3D9) && (defined(WIN32) || defined(WIN64))
			if (Verts)
#endif
			{
				memcpy(Verts, dt, vert_num*sizeof(SVF_TP3F_C4B_T2F));
				UnlockVB(POOL_TRP3F_COL4UB_TEX2F);
				h = FX_SetVStream(0, m_pVB[POOL_TRP3F_COL4UB_TEX2F], 0, sizeof(SVF_TP3F_C4B_T2F));
			}
    }
    break;
  case eVF_P3F_T3F:
    {
      SVF_P3F_T3F *dt = (SVF_P3F_T3F *)src->m_VS.m_pLocalData;
      SVF_P3F_T3F *Verts = (SVF_P3F_T3F *)GetVBPtr(vert_num, nOffs, POOL_P3F_TEX3F);
			assert(Verts);

#if defined(DIRECT3D9) && (defined(WIN32) || defined(WIN64))
			if (Verts)
#endif
			{
				memcpy(Verts, dt, vert_num*sizeof(SVF_P3F_T3F));
				UnlockVB(POOL_P3F_TEX3F);
				h = FX_SetVStream(0, m_pVB[POOL_P3F_TEX3F], 0, sizeof(SVF_P3F_T3F));
			}
    }
    break;
  case eVF_P3F_T2F_T3F:
    {
      SVF_P3F_T2F_T3F *dt = (SVF_P3F_T2F_T3F *)src->m_VS.m_pLocalData;
      SVF_P3F_T2F_T3F *Verts = (SVF_P3F_T2F_T3F *)GetVBPtr(vert_num, nOffs, POOL_P3F_TEX2F_TEX3F);
			assert(Verts);

#if defined(DIRECT3D9) && (defined(WIN32) || defined(WIN64))
			if (Verts)
#endif
			{
				memcpy(Verts, dt, vert_num*sizeof(SVF_P3F_T2F_T3F));
				UnlockVB(POOL_P3F_TEX2F_TEX3F);
				h = FX_SetVStream(0, m_pVB[POOL_P3F_TEX2F_TEX3F], 0, sizeof(SVF_P3F_T2F_T3F));
			}
    }
    break;

  default:
    assert(0);
    return;
  }

	assert(SUCCEEDED(h));

#if defined(DIRECT3D9) && (defined(WIN32) || defined(WIN64))
	if (FAILED(h))
		return;
#endif

	switch(prim_type)
	{
	case R_PRIMV_TRIANGLES:
#if defined (DIRECT3D9) || defined (OPENGL)
		h = m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLELIST, nOffs, vert_num / 3);
		assert(SUCCEEDED(h));
#elif defined (DIRECT3D10)
		SetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST);
		m_pd3dDeviceContext->Draw(vert_num, nOffs);
#endif
		m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_GENERAL] += vert_num / 3;
		break;

	case R_PRIMV_TRIANGLE_STRIP:
#if defined (DIRECT3D9) || defined (OPENGL)
		h = m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP, nOffs, vert_num-2);
		assert(SUCCEEDED(h));
#elif defined (DIRECT3D10)
		SetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
		m_pd3dDeviceContext->Draw(vert_num, nOffs);
#endif
		m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_GENERAL] += vert_num-2;
		break;

	case R_PRIMV_POINTS:
#if defined (DIRECT3D9) || defined (OPENGL)
		h = m_pd3dDevice->DrawPrimitive(D3DPT_POINTLIST, nOffs, vert_num);
		assert(SUCCEEDED(h));
#elif defined (DIRECT3D10)
		SetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_POINTLIST);
		m_pd3dDeviceContext->Draw(vert_num, nOffs);
#endif
		m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_GENERAL] += vert_num;
		break;

#if defined (XENON)
  case R_PRIMV_RECTLIST:
    h = m_pd3dDevice->DrawPrimitive(D3DPT_RECTLIST, nOffs, vert_num/3);
    assert(SUCCEEDED(h));
    m_RP.m_PS[m_RP.m_nProcessThreadID].m_nPolygons[EFSLIST_GENERAL] += vert_num/3;
    break;
#endif

	default:
		assert(0);
		return;
	}
	m_RP.m_PS[m_RP.m_nProcessThreadID].m_nDIPs[EFSLIST_GENERAL]++;
}

void CD3D9Renderer::SetProfileMarker(const char* label, ESPM mode)
{
	if (mode == ESPM_PUSH)
	{
		PROFILE_LABEL_PUSH(label)
	}
	else
	{
		PROFILE_LABEL_POP(label)
	}
};

///////////////////////////////////////////
void CD3D9Renderer::ResetToDefault()
{
  assert(m_pRT->IsRenderThread());

  if (m_LogFile)
    Logv(SRendItem::m_RecurseLevel[m_RP.m_nProcessThreadID], ".... ResetToDefault ....\n");

  m_RP.m_TI[m_RP.m_nProcessThreadID].m_PersFlags |= RBPF_FP_DIRTY;

  EF_Scissor(false, 0, 0, 0, 0);

  for (int i=0; i<m_numtmus; i++)
  {
    EF_SelectTMU(i);

    if (!i)
    {
      EnableTMU(true);
    }
    else
    {
      EnableTMU(false);
    }
  }
  EF_SelectTMU(0);

  CTexture::BindNULLFrom();

#if defined (DIRECT3D10)
  SStateDepth DS;
  SStateBlend BS;
	SStateRaster RS;
  DS.Desc.DepthEnable = TRUE;
  DS.Desc.DepthWriteMask = D3D11_DEPTH_WRITE_MASK_ALL;
  DS.Desc.DepthFunc = D3D11_COMPARISON_LESS_EQUAL;
  DS.Desc.StencilEnable = FALSE;
  SetDepthState(&DS, 0);

	RS.Desc.CullMode = (m_nCurStateRS != (uint32) -1) ? m_StatesRS[m_nCurStateRS].Desc.CullMode : D3D11_CULL_BACK;
//#if defined(PS3)
//		RS.Desc.FillMode = (m_RP.m_CurState & GS_WIREFRAME) ? D3D11_FILL_WIREFRAME : (m_RP.m_CurState & GS_POINTRENDERING)?D3D11_FILL_POINTPS3:D3D11_FILL_SOLID;
//#else
//	RS.Desc.FillMode = (m_RP.m_CurState & GS_WIREFRAME) ? D3D11_FILL_WIREFRAME : D3D11_FILL_SOLID;
//#endif
  RS.Desc.FillMode = D3D11_FILL_SOLID;
  SetRasterState(&RS);

  BS.Desc.RenderTarget[0].BlendEnable = FALSE;
  BS.Desc.RenderTarget[1].BlendEnable = FALSE;
  BS.Desc.RenderTarget[2].BlendEnable = FALSE;
  BS.Desc.RenderTarget[3].BlendEnable = FALSE;
  BS.Desc.RenderTarget[0].RenderTargetWriteMask = D3D11_COLOR_WRITE_ENABLE_ALL;
  BS.Desc.RenderTarget[1].RenderTargetWriteMask = D3D11_COLOR_WRITE_ENABLE_ALL;
  BS.Desc.RenderTarget[2].RenderTargetWriteMask = D3D11_COLOR_WRITE_ENABLE_ALL;
  BS.Desc.RenderTarget[3].RenderTargetWriteMask = D3D11_COLOR_WRITE_ENABLE_ALL;
  SetBlendState(&BS);
  m_pd3dDeviceContext->GSSetShader(NULL, NULL, 0);

#elif defined (DIRECT3D9) || defined (OPENGL)
  //m_pd3dDevice->SetRenderState(D3DRS_FILLMODE, D3DFILL_SOLID);
  //m_pd3dDevice->SetRenderState(D3DRS_ZENABLE, TRUE);

  //m_pd3dDevice->SetRenderState(D3DRS_ALPHATESTENABLE, FALSE);
  //m_pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);
  //m_pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);
  //m_pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, TRUE);

  EF_SetState(GS_DEPTHWRITE, -1, -1);

#if !defined (XENON) && !defined(PS3)
  //m_pd3dDevice->SetRenderState(D3DRS_SRGBWRITEENABLE, CV_r_useSRGB!=0);
#endif

  //m_pd3dDevice->SetRenderState(D3DRS_MULTISAMPLEANTIALIAS, FALSE);

  if (m_pd3dCaps->RasterCaps & (D3DPRASTERCAPS_DEPTHBIAS | D3DPRASTERCAPS_SLOPESCALEDEPTHBIAS))
    m_pd3dDevice->SetRenderState(D3DRS_DEPTHBIAS, 0);
  
  m_pd3dDevice->SetRenderState(D3DRS_COLORWRITEENABLE,  0xf);
  EF_SetVertColor();

#endif

#if defined(XENON)
  m_RP.m_CurGPRAllocState = 0;
  m_RP.m_CurGPRAllocStateCommit = 0;
  m_pd3dDevice->SetShaderGPRAllocation(0, 0, 0);

  //m_RP.m_CurHiZState &= ~GS_HIZENABLE;
  m_RP.m_CurHiZState = GS_HIZENABLE;
  m_RP.m_CurHiZState |= GS_NODEPTHTEST; 
  //m_RP.m_CurHiZState &= ~GS_DEPTHWRITE; 

  m_pd3dDevice->SetRenderState(D3DRS_HIZENABLE, D3DHIZ_DISABLE);
  m_pd3dDevice->SetRenderState(D3DRS_HIZWRITEENABLE, D3DHIZ_DISABLE);
#endif

  m_RP.m_CurState = GS_DEPTHWRITE;

  FX_ResetPipe();

  m_RP.m_TI[m_RP.m_nProcessThreadID].m_PersFlags &= ~RBPF_WASWORLDSPACE;
  m_RP.m_TI[m_RP.m_nProcessThreadID].m_PersFlags2 &= ~RBPF2_LIGHTSTENCILCULL;

  m_RP.m_TI[m_RP.m_nProcessThreadID].m_FS.m_nCurFogMode = m_RP.m_TI[m_RP.m_nProcessThreadID].m_FS.m_nFogMode;
#ifdef DO_RENDERLOG
  if (m_LogFile && CV_r_log == 3)
    Logv(SRendItem::m_RecurseLevel[m_RP.m_nProcessThreadID], ".... End ResetToDefault ....\n");
#endif
}


///////////////////////////////////////////
void CD3D9Renderer::SetMaterialColor(float r, float g, float b, float a)
{
  EF_SetGlobalColor(r, g, b, a);
}

///////////////////////////////////////////
char * CD3D9Renderer::GetStatusText(ERendStats type)
{
  return "No status yet";
}

void sLogTexture (char *name, int Size);

void CD3D9Renderer::ProjectToScreen(float ptx, float pty, float ptz,float *sx, float *sy, float *sz )
{
  int nThreadID = m_pRT->GetThreadList();
  SViewport& vp = m_pRT->IsRenderThread() ? m_NewViewport : m_MainRTViewport;

  D3DXVECTOR3 vOut, vIn;
  vIn.x = ptx;
  vIn.y = pty;
  vIn.z = ptz;

	int32 v[4];
	v[0] = vp.nX;
	v[1] = vp.nY;
	v[2] = vp.nWidth;
	v[3] = vp.nHeight;

  Matrix44A mIdent;
	mIdent.SetIdentity();
  mathVec3Project((Vec3*)&vOut, (Vec3*)&vIn, v, m_RP.m_TI[nThreadID].m_matProj->GetTop(), m_RP.m_TI[nThreadID].m_matView->GetTop(), &mIdent);
  *sx = vOut.x * 100/vp.nWidth;
  *sy = vOut.y * 100/vp.nHeight;
  *sz = vOut.z;
}

/*
* Transform a point (column vector) by a 4x4 matrix.  I.e.  out = m * in
* Input:  m - the 4x4 matrix
*         in - the 4x1 vector
* Output:  out - the resulting 4x1 vector.
*/
static void transform_point(float out[4], const float m[16], const float in[4])
{
#define M(row,col)  m[col*4+row]
  out[0] = M(0, 0) * in[0] + M(0, 1) * in[1] + M(0, 2) * in[2] + M(0, 3) * in[3];
  out[1] = M(1, 0) * in[0] + M(1, 1) * in[1] + M(1, 2) * in[2] + M(1, 3) * in[3];
  out[2] = M(2, 0) * in[0] + M(2, 1) * in[1] + M(2, 2) * in[2] + M(2, 3) * in[3];
  out[3] = M(3, 0) * in[0] + M(3, 1) * in[1] + M(3, 2) * in[2] + M(3, 3) * in[3];
#undef M
}

static int sUnProject(float winx, float winy, float winz, const float model[16], const float proj[16], const int viewport[4], float * objx, float * objy, float * objz)
{
  /* matrice de transformation */
  float m[16], A[16];
  float in[4], out[4];
  /* transformation coordonnees normalisees entre -1 et 1 */
  in[0] = (winx - viewport[0]) * 2 / viewport[2] - 1.0f;
  in[1] = (winy - viewport[1]) * 2 / viewport[3] - 1.0f;
  in[2] = winz;//2.0f * winz - 1.0f;
  in[3] = 1.0;
  /* calcul transformation inverse */
  matmul4(A, proj, model);
  QQinvertMatrixf(m, A);
  /* d'ou les coordonnees objets */
  transform_point(out, m, in);
  if (out[3] == 0.0)
    return false;
  *objx = out[0] / out[3];
  *objy = out[1] / out[3];
  *objz = out[2] / out[3];
  return true;
}

int CD3D9Renderer::UnProject(float sx, float sy, float sz, float *px, float *py, float *pz, const float modelMatrix[16], const float projMatrix[16], const int viewport[4])
{
  return sUnProject(sx, sy, sz, modelMatrix, projMatrix, viewport, px, py, pz);
}

int CD3D9Renderer::UnProjectFromScreen( float sx, float sy, float sz, float *px, float *py, float *pz)
{
  float modelMatrix[16];
  float projMatrix[16];
  int viewport[4];

  GetModelViewMatrix(modelMatrix);
  GetProjectionMatrix(projMatrix);
  GetViewport(&viewport[0], &viewport[1], &viewport[2], &viewport[3]);
  return sUnProject(sx, sy, sz, modelMatrix, projMatrix, viewport, px, py, pz);
}

//////////////////////////////////////////////////////////////////////

void CD3D9Renderer::ClearBuffer(uint32 nFlags, ColorF *vColor, float depth)
{
  if (nFlags & FRT_CLEAR_IMMEDIATE)
    m_pRT->RC_ClearBuffers(nFlags, vColor, depth);
  else
    EF_ClearBuffers(nFlags, vColor, depth);
}

void CD3D9Renderer::EnableAALines(bool bEnable)
{
  assert(0);
}

int s_In2DMode[RT_COMMAND_BUF_COUNT];

void CD3D9Renderer::Set2DMode(bool enable, int ortox, int ortoy,float znear,float zfar )
{
  Matrix44A* m;
  int nThreadID = m_pRT->GetThreadList();
  if (enable)
  {
    assert(s_In2DMode[nThreadID] >= 0);
    s_In2DMode[nThreadID]++;
    m_RP.m_TI[nThreadID].m_matProj->Push();
    m = m_RP.m_TI[nThreadID].m_matProj->GetTop();
    if (ortox && ortoy && znear != zfar)
		  mathMatrixOrthoOffCenterLH(m, 0.0, (float)ortox, (float)ortoy, 0.0, znear,zfar );
#if defined(ENABLE_RENDER_AUX_GEOM)
		m_pRenderAuxGeomD3D->SetOrthoMode(true, m);
#endif
    EF_PushMatrix();
    m = m_RP.m_TI[nThreadID].m_matView->GetTop();
    m_RP.m_TI[nThreadID].m_matView->LoadIdentity();
  }
  else
  {
    assert(s_In2DMode[nThreadID] > 0);
    s_In2DMode[nThreadID]--;
#if defined(ENABLE_RENDER_AUX_GEOM)
		m_pRenderAuxGeomD3D->SetOrthoMode(false);
#endif
    m_RP.m_TI[nThreadID].m_matProj->Pop();
    EF_PopMatrix();
  }
  EF_SetCameraInfo();
}

void CD3D9Renderer::RemoveTexture(unsigned int TextureId)
{
  if(!TextureId)
    return;

  CTexture *tp = CTexture::GetByID(TextureId);
  if(!tp)
    return;

  bool bShadow = false;

  //if(!tp->IsAsyncDevTexCreation())
  //{
  //  SDynTexture_Shadow *pTX, *pNext;
  //  for (pTX=SDynTexture_Shadow::s_RootShadow.m_NextShadow; pTX != &SDynTexture_Shadow::s_RootShadow; pTX=pNext)
  //  {
  //    pNext = pTX->m_NextShadow;
  //    if (pTX->m_pTexture && pTX->m_pTexture->GetID() == TextureId)
  //    {
  //      delete pTX;
  //      bShadow = true;
  //    }
  //  }
  //}

  if (!bShadow)
  {
    if(tp->IsAsyncDevTexCreation())
    {
      SResourceAsync * pInfo = new SResourceAsync();
      pInfo->eClassName = eRCN_Texture;
      pInfo->pResource = tp;
      gRenDev->ReleaseResourceAsync(pInfo);
    }
    else
      SAFE_RELEASE(tp);
  }
}

void CD3D9Renderer::UpdateTextureInVideoMemory(uint32 tnum, unsigned char *newdata,int posx,int posy,int w,int h,ETEX_Format eTFSrc)
{
  if (m_bDeviceLost)
    return;

  CTexture *pTex = CTexture::GetByID(tnum);
  pTex->UpdateTextureRegion(newdata, posx, posy, w, h, eTFSrc);
}

bool CD3D9Renderer::EF_PrecacheResource( ITexture *pTP, float fMipFactor, float fTimeToReady, int Flags, int nUpdateId )
{
  FUNCTION_PROFILER_FAST( GetISystem(),PROFILE_RENDERER,g_bProfilerEnabled );

	// Check for the presence of a D3D device
	assert(m_pd3dDevice);

	m_pRT->RC_PrecacheResource(pTP, fMipFactor, fTimeToReady, Flags, nUpdateId);

	return true;
}


void CD3D9Renderer::CreateResourceAsync(SResourceAsync* pResource)
{
  m_pRT->RC_CreateResource(pResource);
}
void CD3D9Renderer::ReleaseResourceAsync(SResourceAsync* pResource)
{
  m_pRT->RC_ReleaseResource(pResource);
}

unsigned int CD3D9Renderer::DownLoadToVideoMemory(unsigned char *data,int w, int h, ETEX_Format eTFSrc, ETEX_Format eTFDst, int nummipmap, bool repeat, int filter, int Id, const char *szCacheName, int flags, EEndian eEndian, RectI * pRegion, bool bAsyncDevTexCreation )
{
  FUNCTION_PROFILER_FAST(GetISystem(), PROFILE_RENDERER, g_bProfilerEnabled);

  char name[128];
  if (!szCacheName)
    sprintf(name, "$AutoDownload_%d", m_TexGenID++);
  else
    strcpy(name, szCacheName);
  if (!nummipmap)
  {
    if (filter != FILTER_BILINEAR && filter != FILTER_TRILINEAR)
      flags |= FT_NOMIPS;
    nummipmap = 1;
  }
  else
  if (nummipmap < 0)
    nummipmap = CTexture::CalcNumMips(w, h);

  if (!repeat)
    flags |= FT_STATE_CLAMP;
  if (!szCacheName)
    flags |= FT_DONT_STREAM;
  flags |=  FT_DONT_RESIZE;

	
#ifdef XENON
  if(data)
  {
    int nSize = CTexture::TextureDataSize(w, h, 1, nummipmap, eTFSrc);
    switch (eTFSrc)
    {
      case eTF_DXT1:
        SwapEndian((int16 *)data, nSize/2, eEndian);
        break;
      case eTF_DXT5:
      case eTF_DXT3:
        SwapEndian((int16 *)data, nSize/2, eEndian);
        break;
      case eTF_A4R4G4B4:
        SwapEndian((int16 *)data, nSize/2, eEndian);
        break;
      case eTF_A8R8G8B8:
        SwapEndian((int32 *)data, nSize/4, eEndian);
        break;
    }
  }
#endif
	

  if (Id > 0)
  {
    CTexture *pTex = CTexture::GetByID(Id);
    if (pTex)
    {
      if(pRegion)
        pTex->UpdateTextureRegion(data, pRegion->x, pRegion->y, pRegion->w, pRegion->h, eTFSrc);
      else
        pTex->UpdateTextureRegion(data, 0, 0, w, h, eTFSrc);

      return Id;
    }
    else
      return 0;
  }
  else
  {
    CTexture *tp = 0;

    if(bAsyncDevTexCreation && gRenDev->EF_Query(EFQ_RenderMultithreaded))
    { // make texture without device texture and request it async creation
      SResourceAsync * pInfo = new SResourceAsync();
      int nImgSize = CTexture::TextureDataSize(w, h, 1, nummipmap, eTFSrc);
      pInfo->pData = new byte[nImgSize];
      memcpy(pInfo->pData, data, nImgSize);
      pInfo->eClassName = eRCN_Texture;
      pInfo->nWidth = w;
      pInfo->nHeight = h;
      pInfo->nMips = nummipmap;
      pInfo->nTexFlags = flags;
      pInfo->nFormat = eTFDst;
      tp = CTexture::Create2DTexture(name, w, h, nummipmap, flags, NULL, eTFSrc, eTFDst, -1, bAsyncDevTexCreation);
      pInfo->nTexId = tp->GetID();
      gRenDev->CreateResourceAsync(pInfo);
    }
    else
      tp = CTexture::Create2DTexture(name, w, h, nummipmap, flags, data, eTFSrc, eTFDst);

    return tp->GetID();
  }
}

void CD3D9Renderer::Hint_DontSync( CTexture &rTex )
{
	if(!m_bNVLibInitialized)
		return;
/* 
	// commented as NVAPI needs a fix before the code becomes useful

	NVDX_ObjectHandle g_RTHandle = NVDX_OBJECT_NONE; 

	IDirect3DDevice9 *pDev = (IDirect3DDevice9 *)gGet_D3DDevice();

	DWORD dwHintValue = 0; 

	IDirect3DTexture9 *pTex = (IDirect3DTexture9 *)rTex.GetDeviceTexture();

	// test
//	D3DSURFACE_DESC desc;
//	pTex->GetLevelDesc(0,&desc);

	LPDIRECT3DSURFACE9 pTexSurf=0;
	HRESULT hRes = pTex->GetSurfaceLevel(0, &pTexSurf);

	if(!FAILED(hRes))
	{
		D3DSURFACE_DESC desc2;

		pTexSurf->GetDesc(&desc2);

		// get nvapi handle 
//		NvAPI_Status hr = NvAPI_D3D9_GetSurfaceHandle(pTexSurf, &g_RTHandle); 
		LPDIRECT3DSURFACE9 help=0;
		hRes = pDev->GetRenderTarget(0,&help);			assert(!FAILED(hRes));
		hRes = pDev->SetRenderTarget(0,pTexSurf);		assert(!FAILED(hRes));
		NvAPI_Status hr = NvAPI_D3D9_GetCurrentRenderTargetHandle(pDev, &g_RTHandle); 
		hRes = pDev->SetRenderTarget(0,help);	assert(!FAILED(hRes));
		
		if(help)
			help->Release();

		if(hr)
			iLog->LogError("NvAPI_D3D9_GetSurfaceHandle failed (%d)",hr);
		else
		{
			// send the hint to the driver. If the gpu  buffers were rendered just one frame apart we 
			// allow to skip sync 
			dwHintValue = 1; 
			hr = NvAPI_D3D9_SetResourceHint( 
				pDev, 
				g_RTHandle, 
				NvApiHints_Sli, 
				NvApiHints_Sli_InterfarameAwareForTexturing, 
				&dwHintValue); 

			if(hr)
				iLog->LogError("NvAPI_D3D9_SetResourceHint failed (%d)",hr);
//			else
//				iLog->Log("NvAPI_D3D9_SetResourceHint succeed");
		}

		SAFE_RELEASE(pTexSurf);
	}
*/
}

float CD3D9Renderer::GetGPUFrameTime()
{
	if(m_profiler->GetEnabled())
	{
		CGPUProfiler::Stats stats;
		m_profiler->GetStats(&stats);
		return stats.GPUFrameTime / 1000.0f;
	}
	else
	{
		return CRenderer::GetGPUFrameTime();
	}
}

void CD3D9Renderer::GetRenderTimes(SRenderTimes &outTimes)
{
	CRenderer::GetRenderTimes(outTimes);
}

const char *sStreamNames[] = {
	"VSF_GENERAL",
	"VSF_TANGENTS",
	"VSF_QTANGENTS",
	"VSF_HWSKIN_INFO",
	"VSF_SH_INFO",
	"VSF_HWSKIN_SHAPEDEFORM_INFO",
	"VSF_HWSKIN_MORPHTARGET_INFO",
};

void CD3D9Renderer::GetLogVBuffers()
{
	CRenderMesh2 *pRM = CRenderMesh2::m_Root.m_Next;
	int nNums = 0;
	while (pRM != &CRenderMesh2::m_Root)
	{
		//pRM->GetMemoryUsage(Sizer,IRenderMesh::MEM_USAGE_ONLY_SYSTEM);
		int nTotal = 0;
		string final; 
		char tmp[128];
		//CryLog("%s. ", pRM->m_sSource);

		for (int i=0; i<VSF_NUM; i++)
		{
			int nSize = pRM->GetStreamStride(i);

			sprintf(tmp, "| %s | %d ", sStreamNames[i], nSize);
			final += tmp;
			nTotal += nSize;
		}
		if (nTotal)
			CryLog("%s | Total | %d %s",pRM->m_sSource, nTotal, final.c_str());
		pRM = pRM->m_Next;
		nNums++;
	}
}

void CD3D9Renderer::GetMemoryUsage(ICrySizer* Sizer)
{
  assert(Sizer);

	{
		SIZER_COMPONENT_NAME(Sizer,"CRenderer");

		CRenderer::GetMemoryUsage(Sizer);
		Sizer->AddObject( CRenderObject::m_pPermObjData, sizeof(SRenderObjData)*MAX_PERM_OBJECTS );
		for(int i=0; i<RT_COMMAND_BUF_COUNT; ++i)
			Sizer->AddObject( CRenderObject::m_sObjData[i] );		
	}
	

  uint32 i, j, nSize;

#ifndef _LIB // Only when compiling as dynamic library
	{
		//SIZER_COMPONENT_NAME(pSizer,"Strings");
		//pSizer->AddObject( (this+1),string::_usedMemory(0) );
	}
	{
		SIZER_COMPONENT_NAME(Sizer,"STL Allocator Waste");
		CryModuleMemoryInfo meminfo;
		ZeroStruct(meminfo);
		CryGetMemoryInfoForModule( &meminfo );
		Sizer->AddObject( (this+2),meminfo.STL_wasted );
	}
#endif

  //SIZER_COMPONENT_NAME(Sizer, "GLRenderer");
  {
    SIZER_COMPONENT_NAME(Sizer, "Renderer static");
    for (j=0; j<MAX_LIST_ORDER; j++)
    {
      for (i=0; i<EFSLIST_NUM; i++)
      {
				for (int r=0; r<RT_COMMAND_BUF_COUNT; r++)
					Sizer->AddObject( SRendItem::RendItems(r,j,i) );
      }
    }
    
  }
  {
    SIZER_COMPONENT_NAME(Sizer, "Renderer dynamic");

    Sizer->AddObject(this, sizeof(CD3D9Renderer));

		GetMemoryUsageParticleREs( Sizer );
    for (j=0; j<RT_COMMAND_BUF_COUNT; j++)
      for (i=0; i<MAX_REND_RECURSION_LEVELS; i++)
        Sizer->AddObject( CREClientPoly::m_PolysStorage[i][j] );
    Sizer->AddObject( m_RP.m_Sprites );
    Sizer->AddObject( m_RP.m_Polygons );
    nSize = 0;
    nSize += m_RP.m_TempMeshes[0].GetMemoryUsage();
    nSize += m_RP.m_TempMeshes[1].GetMemoryUsage();
    Sizer->AddObject(&m_RP.m_TempMeshes, nSize);
  }
#if defined(ENABLE_RENDER_AUX_GEOM)
	{
		SIZER_COMPONENT_NAME(Sizer, "Renderer Aux Geometries");
		Sizer->AddObject(m_pRenderAuxGeomD3D);		
	}
#endif
	{
    SIZER_COMPONENT_NAME(Sizer, "Renderer CryName");
    static CCryName sName;
    Sizer->AddObject(&sName, CCryName::GetMemoryUsage());
  }


  {
    SIZER_COMPONENT_NAME(Sizer, "Shaders");   
    CCryNameTSCRC Name = CShader::mfGetClassName();
		SResourceContainer *pRL = NULL;
    {
      SIZER_COMPONENT_NAME(Sizer, "Shader manager");
			Sizer->AddObject(m_cEF);
    }
    {
      SIZER_COMPONENT_NAME(Sizer, "Shader resources");
      Sizer->AddObject(CShader::m_ShaderResources_known);
    }
		{
			SIZER_COMPONENT_NAME(Sizer,"ShaderCache");						
			Sizer->AddObject(CHWShader::m_ShaderCache);		
		}
    {
      SIZER_COMPONENT_NAME(Sizer, "HW Shaders");

      Name = CHWShader::mfGetClassName(eHWSC_Vertex);
      pRL = CBaseResource::GetResourcesForClass(Name);
			Sizer->AddObject(pRL);      

      Name = CHWShader::mfGetClassName(eHWSC_Pixel);
      pRL = CBaseResource::GetResourcesForClass(Name);
			Sizer->AddObject(pRL);   
    }

    {
      SIZER_COMPONENT_NAME(Sizer, "Shared HW Shaders");      
      Sizer->AddObject(CHWShader_D3D::m_SharedInsts );
    }

    {
      SIZER_COMPONENT_NAME(Sizer, "Shared Shader Parameters");      
      Sizer->AddObject(CGParamManager::m_Groups);      
      Sizer->AddObject(CGParamManager::m_Pools);
    }
    {
      SIZER_COMPONENT_NAME(Sizer, "Light styles");      
      Sizer->AddObject(CLightStyle::m_LStyles);			
    }
		{
			SIZER_COMPONENT_NAME(Sizer, "SResourceContainer");   			
			Name = CShader::mfGetClassName();
			pRL = CBaseResource::GetResourcesForClass(Name);
			Sizer->AddObject(pRL);
		}
  }
  {
    SIZER_COMPONENT_NAME(Sizer, "Mesh");
    CRenderMesh2 *pRM = CRenderMesh2::m_Root.m_Next;
    while (pRM != &CRenderMesh2::m_Root)
    {
      AUTO_LOCK(pRM->m_sResLock);
			pRM->GetMemoryUsage(Sizer);
			if(pRM->_GetVertexContainer() != pRM)
				pRM->_GetVertexContainer()->GetMemoryUsage(Sizer);
      pRM = pRM->m_Next;
    }
  }
  {
    SIZER_COMPONENT_NAME(Sizer, "Render elements");

    AUTO_LOCK(m_sREResLock);
    CRendElement *pRE = CRendElement::m_RootGlobal.m_NextGlobal;
    while (pRE != &CRendElement::m_RootGlobal)
    {
			Sizer->AddObject(pRE);      
      pRE = pRE->m_NextGlobal;
    }
  }
  {
    SIZER_COMPONENT_NAME(Sizer, "Texture Objects");
    SResourceContainer *pRL = CBaseResource::GetResourcesForClass(CTexture::mfGetClassName());
    if (pRL)
    {
      ResourcesMapItor itor;
      for (itor=pRL->m_RMap.begin(); itor!=pRL->m_RMap.end(); itor++)
      {
        CTexture *tp = (CTexture *)itor->second;
        if (!tp || tp->IsNoTexture())
          continue;
#ifdef XENON
				if ((tp->s_nStreamingEnabled & 1) && tp->IsStreamed())
					continue;
#endif
				tp->GetMemoryUsage(Sizer);
      }
    }
#if defined(XENON)
    if (CV_r_texturesstreaming!=0)
    {
      SIZER_COMPONENT_NAME(Sizer, "Textures stream pool size");
      Sizer->AddObject(&CV_r_texturesstreampoolsize, CV_r_texturesstreampoolsize*1024*1024);
    }
#endif
    
  }
  {
    SIZER_COMPONENT_NAME(Sizer, "Texture Pools");
		Sizer->AddObject(CTexture::s_TexturesPools);		
  }
#ifndef EXCLUDE_CRI_SDK
	{
		SIZER_COMPONENT_NAME(Sizer, "Movie playback");
		CVideoPlayer::GetMemoryUsage(Sizer);
	}
#endif
#if defined(PS3)
	tdLayer0::Size(Sizer);
#endif
}

bool CD3D9Renderer::IsStereoEnabled() const
{
	return GetS3DRend().IsStereoEnabled();
}

#if defined(XENON)
void CD3D9Renderer::FallbackTextOut(D3DTexture* pBackbuffer, const char* msg, int x, int y)
{
	if (!msg || !*msg)
		return;

	D3DLOCKED_RECT rect;
	pBackbuffer->LockRect(0, &rect, 0, 0);

	POINT pt;
	pt.x = x;
	pt.y = y;

	RECT srcRect;
	srcRect.left = 0;
	srcRect.right = FallbackFontData::glyphWidth;
	srcRect.top = 0;
	srcRect.bottom = FallbackFontData::glyphHeight;

	XGTEXTURE_DESC bbDesc;
	XGGetTextureDesc(pBackbuffer, 0, &bbDesc);
	uint32 flags = 0;
	if (!XGIsPackedTexture(pBackbuffer))
		flags |= XGTILE_NONPACKED;
	if (XGIsBorderTexture(pBackbuffer))
		flags |= XGTILE_BORDER;

	while (*msg)
	{
		unsigned char c = *msg;
		if (c > ' ' && c <= '~')
		{
			if (pt.x >= 0 && pt.x < (int)bbDesc.Width - (int)FallbackFontData::glyphWidth && pt.y >= 0 && pt.y < (int)bbDesc.Height - (int)FallbackFontData::glyphHeight)
			{
				const unsigned char* glyph = &FallbackFontData::data[c - ' '][0];
				unsigned int data[FallbackFontData::glyphWidth * FallbackFontData::glyphHeight];
				for (int py=0, offs=0; py<FallbackFontData::glyphHeight; ++py)
				{
					for (int px=0; px<FallbackFontData::glyphWidth; ++px, ++offs)
					{
						unsigned char p = glyph[offs];
						data[offs] = (p << 24) + (p << 16) + (p << 8);
					}
				}
				XGTileTextureLevel(bbDesc.Width, bbDesc.Height, 0, XGGetGpuFormat(bbDesc.Format), flags, rect.pBits, &pt, &data, FallbackFontData::glyphWidth * sizeof(unsigned int), &srcRect);
			}
			pt.x += FallbackFontData::glyphWidth;
		}
		else
		{
			if (c == '\n')
			{
				pt.x = x;
				pt.y += FallbackFontData::glyphHeight;
			}
			else if(c == '\t')
				pt.x += 2 * FallbackFontData::glyphWidth;
			else
				pt.x += FallbackFontData::glyphWidth;
		}
		
		++msg;
	}

	pBackbuffer->UnlockRect(0);
}
#elif defined(PS3)
void CD3D9Renderer::FallbackTextOut(IDXGISwapChain* pSwapChain, const char* msg, int x, int y)
{
	D3D11_TEXTURE2D_DESC glyphDesc;
	memset(&glyphDesc, 0, sizeof(glyphDesc));
	glyphDesc.Width = 100;
	glyphDesc.Height = 100;
	glyphDesc.MipLevels = 1;
	glyphDesc.ArraySize = 1;
	glyphDesc.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
	glyphDesc.BindFlags = D3D11_BIND_SHADER_RESOURCE;
	glyphDesc.CPUAccessFlags = D3D11_CPU_ACCESS_WRITE;

	ID3D11Texture2D* pGlyphTex(0);
	if (SUCCEEDED(m_pd3dDevice->CreateTexture2D(&glyphDesc, 0, &pGlyphTex)))
	{
		D3D11_MAPPED_SUBRESOURCE rect;
		STALL_PROFILER("update texture")
		if (SUCCEEDED(m_pd3dDeviceContext->Map(pGlyphTex, 0, D3D11_MAP_WRITE, 0, &rect)))
		{
			for (int i=0; i<100; ++i)
			{
				memset((char*) rect.pData + i * rect.RowPitch, 255, 100 * 4);
			}
			m_pd3dDeviceContext->Unmap(pGlyphTex, 0);
		}

		ID3D11Texture2D* pBackBufferTex(0);
		HRESULT hr = pSwapChain->GetBuffer(0, __uuidof(ID3D11Texture2D), (void**) &pBackBufferTex);
		assert(SUCCEEDED(hr) && pBackBufferTex != 0);

		D3D11_BOX box;
		box.left = box.top = box.front = 0;
		box.right = 100;
		box.bottom = 100;
		box.back = 1;
		m_pd3dDeviceContext->CopySubresourceRegion(pBackBufferTex, 0, 0, 0, 0, pGlyphTex, 0, &box);

		SAFE_RELEASE(pBackBufferTex);
	}

	SAFE_RELEASE(pGlyphTex);
}
#endif


void CD3D9Renderer::PostLevelLoading()
{
  if (gRenDev)
  {
    m_bStartLevelLoading = false;
    if (m_pRT->IsMultithreaded())
    {
      iLog->Log("-- Render thread was idle during level loading: %.3f secs", gRenDev->m_pRT->m_fTimeIdleDuringLoading);
      iLog->Log("-- Render thread was busy during level loading: %.3f secs", gRenDev->m_pRT->m_fTimeBusyDuringLoading);
    }

    if (!IsEditorMode() && !CheckDeviceLost())
      Reset();
    //STLALLOCATOR_CLEANUP
    m_bTemporaryDisabledSFX = false;
		m_pRT->RC_PostLoadLevel();
    m_cEF.mfSortResources();
#ifdef PS3
    NVirtualMem::SwitchToSystemCache();
#endif
  }

  {
    LOADING_TIME_PROFILE_SECTION(iSystem);
    CTexture::Precache();
  }
}

//====================================================================

ILog     *iLog;
IConsole *iConsole;
ITimer   *iTimer;
ISystem  *iSystem;


//////////////////////////////////////////////////////////////////////////
struct CSystemEventListner_Render : public ISystemEventListener
{
public:
	virtual void OnSystemEvent( ESystemEvent event,UINT_PTR wparam,UINT_PTR lparam )
	{
    static bool bInside = false;
    if (bInside)
      return;
    bInside = true;
		switch (event)
		{
    case ESYSTEM_EVENT_LEVEL_LOAD_START:
      {
        if (gRenDev)
        {
#ifdef PS3
					NVirtualMem::SwitchToSystemFull();
#endif
          gRenDev->m_cEF.m_bActivated = false;
          gRenDev->m_bEndLevelLoading = false;
          gRenDev->m_bStartLevelLoading = true;
          if (gRenDev->m_pRT)
          {
            gRenDev->m_pRT->m_fTimeIdleDuringLoading = 0;
            gRenDev->m_pRT->m_fTimeBusyDuringLoading = 0;
          }
#ifndef _RELEASE
          gRenDev->m_cEF.mfFlushFullPLCombinations();
#endif
          const char *szLevel = iSystem->GetI3DEngine()->GetLevelFilePath("");
          if (!szLevel || strnicmp(szLevel, "levels", 6))
            gRenDev->m_cEF.m_ShadersLevelName = "";
          else
            gRenDev->m_cEF.m_ShadersLevelName = szLevel;
        }
        STLALLOCATOR_CLEANUP
        if (CRenderer::CV_r_texpostponeloading)
          CTexture::s_bPrecachePhase = true;
#ifndef PS3
        CResFile::m_nMaxOpenResFiles = MAX_OPEN_RESFILES*2;
        SShaderBin::m_nMaxFXBinCache = MAX_FXBIN_CACHE*2;
#endif
      }
      break;
    case ESYSTEM_EVENT_LEVEL_LOAD_END:
      {
        gRenDev->m_bStartLevelLoading = false;
        gRenDev->m_bEndLevelLoading = true;
        gRenDev->m_nFrameLoad++;
        //STLALLOCATOR_CLEANUP
      }
      {
        const char *szLevel = iSystem->GetI3DEngine()->GetLevelFilePath("");
        if (!szLevel || strnicmp(szLevel, "levels", 6))
          gRenDev->m_cEF.m_ShadersLevelName = "";
        else
        {
          gRenDev->m_cEF.m_ShadersLevelName = szLevel;
          gRenDev->m_cEF.m_nFrameSubmit++;
          gRenDev->m_cEF.m_nFrameLastSubmitted = gRenDev->m_nFrameSwapID;
        }

				gRenDev->RefreshSystemShaders();

				// make sure all commands have been properly processes before leaving the level loading
				if (gRenDev->m_pRT) 
					gRenDev->m_pRT->FlushAndWait();
      }
      break;
    case ESYSTEM_EVENT_LEVEL_PRECACHE_START:
     break;
		case ESYSTEM_EVENT_LEVEL_POST_UNLOAD:
			{
				CTexture::FlushAllStreamingTasks(true);
        gRenDev->m_cEF.m_ShadersLevelName = "";
				STLALLOCATOR_CLEANUP;
				break;
			}
    case ESYSTEM_EVENT_CHANGE_FOCUS:
      {
#ifndef EXCLUDE_CRI_SDK
				CVideoPlayer::OnAppFocusChanged(wparam == TRUE);
#endif
      }
      break;

		}
    bInside = false;
	}
};

static CSystemEventListner_Render g_system_event_listener_render;

extern "C" DLL_EXPORT IRenderer* CreateCryRenderInterface(ISystem *pSystem)
{
	ModuleInitISystem(pSystem, "CryRenderer");

	gbRgb = false;

	iConsole	= gEnv->pConsole;
	iLog			= gEnv->pLog;
	iTimer		= gEnv->pTimer;
	iSystem		= gEnv->pSystem;

	gRenDev = new CD3D9Renderer();

	srand((uint32) GetTickCount());

	g_CpuFlags = iSystem->GetCPUFlags();

	iSystem->GetISystemEventDispatcher()->RegisterListener(&g_system_event_listener_render);
	return gRenDev;
}

class CEngineModule_CryRenderer : public IEngineModule
{
	CRYINTERFACE_SIMPLE(IEngineModule)
	CRYGENERATE_SINGLETONCLASS(CEngineModule_CryRenderer, "EngineModule_CryRenderer", 0x540c91a7338e41d3, 0xaceeac9d55614450)

	virtual const char* GetName() {return "CryRenderer";}
	virtual const char* GetCategory() {return "CryEngine";}

	virtual bool Initialize(SSystemGlobalEnvironment& env, const SSystemInitParams& initParams)
	{
		ISystem* pSystem = env.pSystem;
		env.pRenderer = CreateCryRenderInterface(pSystem);
		return env.pRenderer != 0;
	}
};

CRYREGISTER_CLASS(CEngineModule_CryRenderer)

CEngineModule_CryRenderer::CEngineModule_CryRenderer()
{
};

CEngineModule_CryRenderer::~CEngineModule_CryRenderer()
{
};

void *gGet_D3DDevice()
{
  return (void *)gcpRendD3D->m_pd3dDevice;
}
void *gGet_glReadPixels()
{
  return NULL;
}

void AddPhysicalD3DBlock(long size) {
#ifdef XENON	// Added statistics for XENON
	// round to 4KB page alignment
	static const long ALIGN = 4096 - 1;
	long sign = 1;
	if (size < 0) {
		size = -size;
		sign = -1;
	}
	if( size & ALIGN )
	{
		size += ALIGN;	// advance size over next aligned page size
		size &= ~ALIGN;	// align size to this page size
	}
#	ifndef _LIB
	_CryMemoryManagerPoolHelper::FakeAllocation( size*sign );
#	else
	GetISystem()->GetIMemoryManager()->FakeAllocation( size );
	//_CryMemoryManagerPoolHelper::FakeAllocation( size,eCryModule );
#	endif
#endif // PS3
}
//=========================================================================================
