#include "StdAfx.h"


#ifdef XENON

#include "GCMemoryManager.h"



#include <stdlib.h>
#include <assert.h>
#include <map>


#define MAX_ALIGN_SIZE 1
#define MAX_BALANCED_SIZE 1024

namespace {
	CryCriticalSection g_MMCriticalSection;
};



GCMemoryManager::GCMemoryManager(void)
{
	//m_firstFreeBlock.m_pNextFreeBlock = 0;
	//m_pLastFreePointer = &m_firstFreeBlock;
	m_iFreeBlocksCounter = 0;
	m_pLastFreePointer = 0;
	m_pFreeBlockInfoPointer = 0;
	m_pFreePointersList = 0;
	m_iAllocationsCount = 0;
	m_iAllocationsCount = 0;
	m_pFreeAllocationInfo = 0;
	m_pAllocationInfoList = 0;
	m_nMemoryAllocated = 0;
	m_pAllocationInfo = 0;
}

GCMemoryManager::~GCMemoryManager(void)
{

}

#define INFO_BLOCKS 128

void GCMemoryManager::AllocateFreeBlocks()
{

	void * pBlock = malloc( sizeof(FreeBlockInfo) * INFO_BLOCKS + sizeof(FreeBlockListInfo));
	FreeBlockInfo * pNewBlock =(FreeBlockInfo *)((char*)pBlock + sizeof(FreeBlockListInfo));
	FreeBlockListInfo  * pListInfo = (FreeBlockListInfo*)pBlock;
	pListInfo->m_pNext = 0;


	if (!m_pFreeBlockInfoPointer) 
		m_pFreeBlockInfoPointer = pListInfo;
	else 
	{
		while(m_pFreeBlockInfoPointer->m_pNext)
			m_pFreeBlockInfoPointer = m_pFreeBlockInfoPointer->m_pNext;

		m_pFreeBlockInfoPointer->m_pNext = pListInfo;
	}

	for (int i = 0; i < INFO_BLOCKS - 1; ++i) {
		pNewBlock[i].m_iFreePlaceSize = -1; // that means free block!!!
		pNewBlock[i].m_pPointer = 0;
		pNewBlock[i].m_pNextFreeBlock = &pNewBlock[i+1];
	}

	pNewBlock[INFO_BLOCKS - 1].m_iFreePlaceSize = -1; // that means free block!!!
	pNewBlock[INFO_BLOCKS - 1].m_pPointer = 0;
	pNewBlock[INFO_BLOCKS - 1].m_pNextFreeBlock = 0;

	m_iFreeBlocksCounter += INFO_BLOCKS;

	m_pFreePointersList = pNewBlock;
}


void GCMemoryManager::SetRelativeFreeBlockPointer(/*void * pBase,*/ void * pData, void *& pSwappedPointer) 
{

	if (!m_pFreePointersList) {
		// allocated free pointers block
		AllocateFreeBlocks();

	}

	FreeBlockInfo * pNewFreeBlock =  (FreeBlockInfo*)m_pFreePointersList;//(FreeBlockInfo*)((char*)pBase - sizeof(FreeBlockInfo));

	m_pFreePointersList = m_pFreePointersList->m_pNextFreeBlock;
	pNewFreeBlock->m_iFreePlaceSize = 0;
	pNewFreeBlock->m_pNextFreeBlock = (FreeBlockInfo*)pSwappedPointer;
	pNewFreeBlock->m_pPointer = pData;
	pSwappedPointer = pNewFreeBlock;

}

void GCMemoryManager::SetRelativeFreeBlockPointerInside(/*void * pBase,*/ void * pData, void *& pSwappedPointer, size_t size) 
{
	if (!m_pFreePointersList) {
		// allocated free pointers block
		AllocateFreeBlocks();

	}

	// CAS!!!
	FreeBlockInfo * pNewFreeBlock =  (FreeBlockInfo*)m_pFreePointersList;//(FreeBlockInfo*)((char*)pBase - sizeof(FreeBlockInfo));
	m_pFreePointersList = m_pFreePointersList->m_pNextFreeBlock;

	pNewFreeBlock->m_iFreePlaceSize = size;
	pNewFreeBlock->m_pNextFreeBlock = ((FreeBlockInfo*)pSwappedPointer)->m_pNextFreeBlock;
	pNewFreeBlock->m_pPointer = pData;

	//m_pLastFreePointer->m_pNextFreeBlock = (FreeBlockInfo*)m_pLastFreePointer;
	((FreeBlockInfo*)pSwappedPointer)->m_pNextFreeBlock = pNewFreeBlock;

}


void GCMemoryManager::AllocateBigBlock(size_t size)
{
#ifdef _DEBUG_MEMEORY_MANAGER
	m_pConstantBigBlock = malloc(size);
#else
	m_pConstantBigBlock = XPhysicalAlloc( size, MAXULONG_PTR, 0, PAGE_READWRITE | PAGE_WRITECOMBINE );
#endif
	SetRelativeFreeBlockPointer(/*(char*)m_pConstantBigBlock + size,*/ m_pConstantBigBlock, (void*&)m_pLastFreePointer);
	m_pLastFreePointer->m_iFreePlaceSize  = size;
}

bool GCMemoryManager::ReallocateBigBlock(size_t size)
{
	m_pConstantBigBlock = realloc(m_pConstantBigBlock, size);

	return true;
}


void GCMemoryManager::DeallocateBigBlock()
{
#ifdef _DEBUG_MEMEORY_MANAGER
	free(m_pConstantBigBlock);
#else
	XPhysicalFree(m_pConstantBigBlock);
#endif

}

size_t GCMemoryManager::FindAlignedOffset(size_t alignment, void *pPointer)
{
	size_t offset = (size_t)(alignment - ((size_t)pPointer & (alignment - 1)));
	if (offset >= alignment)
		offset -= alignment;
	//char * pointer = (char*)pPointer;
	//size_t mask = (alignment - 1);
	//size_t offset1 = (char*)((size_t)pointer & mask) - pointer;
	return offset;
}

void * GCMemoryManager::FindProperFreeBlock(size_t size,size_t alignment) {

	size_t minAppropriate = -1;
	FreeBlockInfo * pLastAppropriate = 0; 
	FreeBlockInfo * pFreeBlock = (FreeBlockInfo *)m_pLastFreePointer; // remove volatile qualifier for optimization reasons
	FreeBlockInfo * pFreeBlockPrevAppropriate = (FreeBlockInfo *)m_pLastFreePointer;
	FreeBlockInfo * pFreeBlockPrevAppropriate2 = 0;// remove volatile qualifier for optimization reasons

#ifdef _DEBUG
	{
		FreeBlockInfo * pFreeBlock = (FreeBlockInfo *)m_pLastFreePointer;
		char * pPointer = 0;
		while (pFreeBlock) {
			if (pFreeBlock->m_pPointer < pPointer)
				__debugbreak();

			pPointer = (char*)pFreeBlock->m_pPointer;
			pFreeBlock = pFreeBlock->m_pNextFreeBlock;
		}
	}
#endif

	size_t lastOffset = 0;
	while(pFreeBlock) {
		size_t offset = 0;
		offset = FindAlignedOffset(alignment, pFreeBlock->m_pPointer);
		size_t currSize= pFreeBlock->m_iFreePlaceSize;
		//(char*)pFreeBlock->m_pNextFreeBlock->m_pPointer - (char*)pFreeBlock->m_pPointer;
		if (currSize >= size + offset && currSize < minAppropriate) {
			minAppropriate = currSize;
			pLastAppropriate = pFreeBlock;
			pFreeBlockPrevAppropriate2 = pFreeBlockPrevAppropriate;
			lastOffset = offset;
		} 
		pFreeBlockPrevAppropriate = pFreeBlock;
		pFreeBlock = pFreeBlock->m_pNextFreeBlock;
	}

	void * pRealPointer = 0;
	if (pLastAppropriate) 
	{
		if (lastOffset) 
		{

			size_t odlSize = pLastAppropriate->m_iFreePlaceSize;

			pRealPointer = (char*)pLastAppropriate->m_pPointer + lastOffset;
			//pLastAppropriate->m_pPointer = pRealPointer;
			pLastAppropriate->m_iFreePlaceSize = lastOffset;

			SetRelativeFreeBlockPointerInside((char*)pRealPointer + size , (void*&)pLastAppropriate, odlSize - size - lastOffset);

		} 
		else 
		{
			pRealPointer = (char*)pLastAppropriate->m_pPointer + lastOffset;

			pLastAppropriate->m_pPointer = (void*)((char*)pRealPointer + size);
			//if (size > pLastAppropriate->m_iFreePlaceSize)
			//{
			//	pLastAppropriate->m_iFreePlaceSize = 0;
			//	if (pFreeBlockPrevAppropriate)
			//		pFreeBlockPrevAppropriate->m_pNextFreeBlock = pLastAppropriate->m_pNextFreeBlock;

			//	pLastAppropriate->m_pNextFreeBlock = m_pFreePointersList->m_pNextFreeBlock;
			//	m_pFreePointersList = pLastAppropriate;
			//} else
			pLastAppropriate->m_iFreePlaceSize -= size;

			if (pLastAppropriate->m_iFreePlaceSize == 0) 
			{
				if (/*pFreeBlockPrevAppropriate2 == m_pLastFreePointer || */m_pLastFreePointer == pLastAppropriate) 
				{

					FreeBlockInfo * pTmp = (FreeBlockInfo *)m_pLastFreePointer; 
					m_pLastFreePointer = m_pLastFreePointer->m_pNextFreeBlock;

					pTmp->m_pNextFreeBlock = (FreeBlockInfo *)m_pFreePointersList;
					m_pFreePointersList = pTmp;

				} 
				else  
					if (pFreeBlockPrevAppropriate2/* && pFreeBlockPrevAppropriate2 != m_pLastFreePointer*/) 
						{

							pFreeBlockPrevAppropriate2->m_pNextFreeBlock = pLastAppropriate->m_pNextFreeBlock;


							pLastAppropriate->m_pNextFreeBlock = (FreeBlockInfo *)m_pFreePointersList;
							m_pFreePointersList = pLastAppropriate;
						}
					}

			} 
		}
	else 
	{
		pRealPointer = 0;	
	}

#ifdef _DEBUG
	{
		FreeBlockInfo * pFreeBlock = (FreeBlockInfo *)m_pLastFreePointer;
		char * pPointer = 0;
		while (pFreeBlock) {
			if (pFreeBlock->m_pPointer < pPointer || pFreeBlock->m_iFreePlaceSize == 0 )
				__debugbreak();

			pPointer = (char*)pFreeBlock->m_pPointer;
			pFreeBlock = pFreeBlock->m_pNextFreeBlock;
		}
	}
#endif
	return pRealPointer;
}

void * GCMemoryManager::AllocateInBigBlock(size_t size, size_t alignment)
{
	return FindProperFreeBlock(size, alignment);
}

void * GCMemoryManager::Alloc(size_t size, size_t alignment, AutoPointer * pOwner)
{
	AUTO_LOCK(g_MMCriticalSection);

	void * pPointer = AllocateInBigBlock(size, alignment);

	if (pPointer) {
		//m_pObjectOwners[pPointer] = AllocationInfo(pOwner, (short int)alignment);
		if (!m_pFreeAllocationInfo) {
			AllocateAllocationInfo();
		}

		m_pFreeAllocationInfo->m_iAlignment = (short int)alignment;
		m_pFreeAllocationInfo->m_iSize = size;
		m_pFreeAllocationInfo->m_pBaseAddress = pPointer;
		m_pFreeAllocationInfo->m_pOwner = pOwner;
		m_nMemoryAllocated += size;

		AllocationInfo * tmp = m_pFreeAllocationInfo;
		AllocationInfo * tmp1 = m_pAllocationInfo;
		m_pFreeAllocationInfo = m_pFreeAllocationInfo->m_pNext;
		tmp->m_pNext = m_pAllocationInfo;
		//tmp->m_pPrev = 0;
		//if (m_pAllocationInfo)
		//	m_pAllocationInfo->m_pPrev = tmp;

		m_pAllocationInfo = tmp;

//#ifdef _DEBUG
//	if (m_pAllocationInfo->m_pNext == m_pAllocationInfo )
//		__debugbreak();
//#endif
	}

	return pPointer;
	//return AllocateInSmallBlock(size, alignment);
}

void GCMemoryManager::ConcatenateFreeBlocks(FreeBlockInfo * pFreeBlock) {

	if (pFreeBlock->m_pNextFreeBlock)
		if ((char*)pFreeBlock->m_pPointer + pFreeBlock->m_iFreePlaceSize == pFreeBlock->m_pNextFreeBlock->m_pPointer) {
			pFreeBlock->m_iFreePlaceSize += pFreeBlock->m_pNextFreeBlock->m_iFreePlaceSize;

			FreeBlockInfo * pNewHead = pFreeBlock->m_pNextFreeBlock;

			pFreeBlock->m_pNextFreeBlock = pFreeBlock->m_pNextFreeBlock->m_pNextFreeBlock;

			pNewHead->m_pNextFreeBlock = (FreeBlockInfo *)m_pFreePointersList;
			m_pFreePointersList = pNewHead;

			ConcatenateFreeBlocks(pFreeBlock);
		}
}

void GCMemoryManager::AllocateAllocationInfo()
{

	void * pBlock = malloc( sizeof(AllocationInfo) * INFO_BLOCKS + sizeof(AllocationInfoListInfo));
	AllocationInfo * pNewBlock =(AllocationInfo *)((char*)pBlock + sizeof(AllocationInfoListInfo));
	AllocationInfoListInfo  * pListInfo = (AllocationInfoListInfo*)pBlock;
	AllocationInfoListInfo  * pListInfo1 = m_pAllocationInfoList;
	pListInfo->m_pNext = 0;


	if (!m_pAllocationInfoList) 
		m_pAllocationInfoList = pListInfo;
	else 
	{
		while(pListInfo1->m_pNext)
			pListInfo1 = pListInfo1->m_pNext;

		pListInfo1->m_pNext = pListInfo;
	}

	for (int i = 0; i < INFO_BLOCKS - 1; ++i) {
		pNewBlock[i].m_pNext = &pNewBlock[i+1];
	}

	pNewBlock[INFO_BLOCKS - 1].m_pNext = 0;

	m_iAllocationsCount += INFO_BLOCKS;

	m_pFreeAllocationInfo = pNewBlock;
}



void GCMemoryManager::RemoveAllocationInfo( void * ptr )
{
	AllocationInfo * pInfo = m_pAllocationInfo;
	AllocationInfo * pPrev = 0;

	int c = 0;
	while(pInfo) {
		if (pInfo->m_pBaseAddress == ptr) {

			AllocationInfo * next = pInfo->m_pNext;

			if (pPrev)
				pPrev->m_pNext = next;
			else 
				m_pAllocationInfo = next;


			AllocationInfo * pTmp =  m_pFreeAllocationInfo;
			m_pFreeAllocationInfo = pInfo;
			m_pFreeAllocationInfo->m_pNext = pTmp;
			m_pFreeAllocationInfo->m_iAlignment = -1;
			m_pFreeAllocationInfo->m_iSize = -1;
			m_pFreeAllocationInfo->m_pOwner = 0;


			if (!pInfo)
				m_pAllocationInfo = 0;
			//m_pFreeAllocationInfo->m_pPrev = 0;

			//				m_pAllocationInfo = m_pAllocationInfo->m_pNext;
			return;
		}
		pPrev = pInfo;
		pInfo = pInfo->m_pNext;
#ifdef _DEBUG
		if (c++ > 100000)
			__debugbreak();
#endif
	}

	//		assert(false);
}

void GCMemoryManager::Dealloc(void * ptr, size_t size)
{
	if (ptr && size) {
		AUTO_LOCK(g_MMCriticalSection);
		FreeBlockInfo * pLastAppropriate = 0; 
		FreeBlockInfo * pFreeBlock = (FreeBlockInfo *)m_pLastFreePointer; // remove volatile qualifier for optimization reasons
		FreeBlockInfo * pFreeBlockPrevAppropriate = 0;
		FreeBlockInfo * pFreeBlockPrevAppropriate2 = (FreeBlockInfo *)m_pLastFreePointer;// remove volatile qualifier for optimization reasons

		bool bSwapped = false;
		while(pFreeBlock->m_pNextFreeBlock) {

			if (pFreeBlock->m_pPointer == ptr || pFreeBlock->m_pNextFreeBlock->m_pPointer == ptr)
				int A = 0;

			if ((char*)pFreeBlock->m_pNextFreeBlock->m_pPointer > ptr &&  (char*)pFreeBlock->m_pPointer < ptr) {
				// right place
				if ((char*)pFreeBlock->m_pPointer + pFreeBlock->m_iFreePlaceSize == ptr) {
					pFreeBlock->m_iFreePlaceSize += size;
					ConcatenateFreeBlocks(pFreeBlock);
					//RemoveAllocationInfo(ptr);
					//return; /// !!!!!!!!!!!!
				} else 
					if ((char*)ptr + size == pFreeBlock->m_pNextFreeBlock->m_pPointer) {
						pFreeBlock->m_pNextFreeBlock->m_pPointer = ptr;
						pFreeBlock->m_pNextFreeBlock->m_iFreePlaceSize += size;
						ConcatenateFreeBlocks(pFreeBlock);
					} else 
					{
						SetRelativeFreeBlockPointerInside(/*(void*)m_pLastFreePointer,*/ ptr, (void*&)pFreeBlock, size);
						ConcatenateFreeBlocks(pFreeBlock->m_pNextFreeBlock);
					}

					bSwapped = true;
					break;
			} else
				if ((char*) ptr + size == pFreeBlock->m_pPointer)
				{
					pFreeBlock->m_pPointer = ptr;
					pFreeBlock->m_iFreePlaceSize += size;
					ConcatenateFreeBlocks(pFreeBlock);
					bSwapped = true;
					break;

				} 

				if ((char*)pFreeBlock->m_pPointer < ptr)
					pFreeBlockPrevAppropriate2 = pFreeBlock;

				pFreeBlockPrevAppropriate = pFreeBlock;
				pFreeBlock = pFreeBlock->m_pNextFreeBlock;
		}

		if (!bSwapped) {
			if (pFreeBlockPrevAppropriate2 && pFreeBlockPrevAppropriate2!=m_pLastFreePointer ) {
				SetRelativeFreeBlockPointer(ptr, (void*&)pFreeBlockPrevAppropriate2);
				ConcatenateFreeBlocks(pFreeBlockPrevAppropriate2->m_pNextFreeBlock);
				m_pLastFreePointer->m_iFreePlaceSize += size;
			}
			else {
				SetRelativeFreeBlockPointer(/*(void*)m_pLastFreePointer,*/ ptr, /*pFreeBlockPrevAppropriate2*/(void*&)m_pLastFreePointer);
				m_pLastFreePointer->m_iFreePlaceSize += size;
			}
			//ConcatenateFreeBlocks((FreeBlockInfo *)m_pLastFreePointer);
		}


		// remove allocationinfo 

		m_nMemoryAllocated -= size;
		RemoveAllocationInfo(ptr);
		return;

	}
}


FreeBlockInfo * GCMemoryManager::FindSuitableAllocationBefore(AllocationInfo * pInfo )
{

	return 0;
}

void * GCMemoryManager::AllocateInSmallBlock(size_t size, size_t alignment)
{

	return 0;
}

void 	GCMemoryManager::CollectGarbage()
{
	// Pack from the end
	AllocationInfo * pInfo = m_pAllocationInfo;

	FreeBlockInfo * pFreeBlock = FindSuitableAllocationBefore(pInfo);

	if (pFreeBlock) {
		pInfo->m_pOwner->Relocated(pInfo);
	}
}

void GCMemoryManager::IncrementalCollectGarbage()
{

}

GCMemoryManager * GCMemoryManager::GetManager() {
	static GCMemoryManager g_TexturesMemoryManager;
	return &g_TexturesMemoryManager;
}

#endif
