#pragma once


#ifdef XENON
struct AutoPointer {

	virtual void Relocated(void * internalData ) {

	};

	virtual void Copy(void * newPlace, void * oldPlace) {
		//	memcpy(newPlace, oldPlace);
	}

	virtual void FreeOldPointer() {

	}
	size_t m_nAllocatedSize;
};

struct AllocationInfo {
	AllocationInfo() {}
	AllocationInfo(AutoPointer * pOwner, short int alignment) {
		m_pOwner = pOwner;
		m_iAlignment = alignment;
	}

	AutoPointer * m_pOwner;
	void * m_pBaseAddress;
	AllocationInfo * m_pNext;
//	AllocationInfo * m_pPrev;
	size_t m_iSize;
	short int m_iAlignment;
};


struct AllocationInfoListInfo {
	AllocationInfoListInfo * m_pNext;

};


struct FreeBlockInfo {
	FreeBlockInfo * m_pNextFreeBlock;
	void * m_pPointer;
	size_t m_iFreePlaceSize;
}; 

struct FreeBlockListInfo {
	FreeBlockListInfo * m_pNext;

};

struct GCMemoryManager
{
public:
	GCMemoryManager(void);
	~GCMemoryManager(void);


	static GCMemoryManager * GetManager(); 
	void * Alloc(size_t size, size_t alignment, AutoPointer * pOwner);
	void Dealloc(void * ptr, size_t size);

	void AllocateBigBlock(size_t size);
	bool ReallocateBigBlock(size_t size);
	void DeallocateBigBlock();

	void RemoveAllocationInfo( void * ptr );
	//private:

	void * AllocateInBigBlock(size_t size, size_t alignment);
	void * AllocateInSmallBlock(size_t size, size_t alignment);
	//	void Dealloc(void * ptr, size_t alignment);

	void SetRelativeFreeBlockPointer(/*void * pBase, */void * pData, void *& pSwappedPointer);
	void SetRelativeFreeBlockPointerInside(/*void * pBase, */void * pData, void *& pSwappedPointer, size_t size);

	void * GCMemoryManager::FindProperFreeBlock(size_t, size_t alignment);
	void ConcatenateFreeBlocks(FreeBlockInfo * pFreeBlock);
	size_t FindAlignedOffset(size_t alignment, void *pPointer);

	void AddAllocationInfo(AllocationInfo * pInfo);
	void AllocateFreeBlocks();
	void AllocateAllocationInfo();

	void 	CollectGarbage();
	void IncrementalCollectGarbage();

	FreeBlockInfo * FindSuitableAllocationBefore(AllocationInfo * pInfo );

	//! Real allocated memory
	void * m_pConstantBigBlock;


	volatile FreeBlockInfo * m_pLastFreePointer;

	volatile FreeBlockInfo * m_pFreePointersList;
	volatile FreeBlockListInfo * m_pFreeBlockInfoPointer; // Free allocated FreeBlockInfo list

	AllocationInfo * m_pAllocationInfo;
	AllocationInfo * m_pFreeAllocationInfo;
	AllocationInfoListInfo * m_pAllocationInfoList;

	//volatile size_t m_iMemoryLeft;

	//	FreeBlockInfo m_firstFreeBlock;


	size_t m_iFreeBlocksCounter;

	size_t m_iAllocationsCount;

	size_t m_nMemoryAllocated;

	//std::map<void *, AllocationInfo> m_pObjectOwners;

	//volatile void * m_pAllocationTable;

};

extern GCMemoryManager g_pTexturesMemoryManager;

#endif