/*=============================================================================
PostProcessWater : water related post processing
Copyright (c) 2001 Crytek Studios. All Rights Reserved.

Revision history:
* 23/02/2005: Re-factored/Converted to CryEngine 2.0 by Tiago Sousa
* Created by Tiago Sousa

=============================================================================*/

#include "StdAfx.h"
#include "DriverD3D.h"
#include "I3DEngine.h"
#include "D3DPostProcess.h"

#pragma warning(disable: 4244)

#if defined(PS3) && !defined(__SPU__) && !defined(__CRYCG__)
	DECLARE_SPU_CLASS_JOB("WaterUpdate", TPostWaterJob, CWater)
//	static volatile NSPU::NDriver::SExtJobState g_JobState;
	#define USE_SPU
#endif

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

void CUnderwaterGodRays::Render()
{
  PROFILE_LABEL_PUSH( "GODRAYS" );

  PROFILE_SHADER_START

    // Get current viewport
    int iTempX, iTempY, iWidth, iHeight;
  gcpRendD3D->GetViewport(&iTempX, &iTempY, &iWidth, &iHeight);

  gcpRendD3D->Set2DMode(false, 1, 1);       

  float fAmount = m_pAmount->GetParam();
  float fWatLevel = SPostEffectsUtils::m_fWaterLevel;

  static CCryNameTSCRC pTechName("UnderwaterGodRays");
  static CCryName pParam0Name("PI_GodRaysParamsVS");
  static CCryName pParam1Name("PI_GodRaysParamsPS");

  //////////////////////////////////////////////////////////////////////////////////////////////////
  // Render god-rays into low-res render target for less fillrate hit

  gcpRendD3D->FX_PushRenderTarget(0,  CTexture::s_ptexBackBufferScaled[1], GetUtils().m_pCurDepthSurface); 
  gcpRendD3D->RT_SetViewport(0, 0, CTexture::s_ptexBackBufferScaled[1]->GetWidth(), CTexture::s_ptexBackBufferScaled[1]->GetHeight());        

  ColorF clearColor(0, 0, 0, 0);
  gcpRendD3D->EF_ClearBuffers(FRT_CLEAR_COLOR|FRT_CLEAR_IMMEDIATE, &clearColor);

  //  GetUtils().ShBeginPass(CShaderMan::m_shPostEffects, pTechName, FEF_DONTSETSTATES);   
  uint32 nPasses;
  CShaderMan::m_shPostEffects->FXSetTechnique(pTechName);
  CShaderMan::m_shPostEffects->FXBegin(&nPasses, FEF_DONTSETSTATES);

  int nSlicesCount = 10;   
  bool bInVisarea = (gRenDev->m_p3DEngineCommon.m_pCamVisAreaInfo.nFlags & S3DEngineCommon::VAF_EXISTS_FOR_POSITION);
  Vec3 vSunDir = bInVisarea? Vec3(0.5f,0.5f,1.0f) :  -gEnv->p3DEngine->GetSunDirNormalized();

  for( int r(0); r < nSlicesCount; ++r)   
  {
    // !force updating constants per-pass!
    CShaderMan::m_shPostEffects->FXBeginPass(0);

    // Set per instance params  
    Vec4 pParams= Vec4(fWatLevel, fAmount, r, 1.0f / (float) nSlicesCount);
    CShaderMan::m_shPostEffects->FXSetVSFloat(pParam0Name, &pParams, 1);

    CShaderMan::m_shPostEffects->FXSetPSFloat(pParam1Name, &pParams, 1);

    gcpRendD3D->SetCullMode( R_CULL_NONE );
    gcpRendD3D->EF_SetState(GS_BLSRC_ONE | GS_BLDST_ONE | GS_NODEPTHTEST);

    GetUtils().DrawFullScreenQuad(CTexture::s_ptexBackBuffer->GetWidth(), CTexture::s_ptexBackBuffer->GetHeight()); 

    CShaderMan::m_shPostEffects->FXEndPass();
  }


  CShaderMan::m_shPostEffects->FXEnd(); 

  //  GetUtils().ShEndPass(); 

  gcpRendD3D->Set2DMode(true, 1, 1);       

  // Restore previous viewport
  gcpRendD3D->FX_PopRenderTarget(0);
  gcpRendD3D->RT_SetViewport(iTempX, iTempY, iWidth, iHeight);        

  //////////////////////////////////////////////////////////////////////////////////////////////////
  // Display god-rays

  CCryNameTSCRC pTechName0("UnderwaterGodRaysFinal");

  GetUtils().ShBeginPass(CShaderMan::m_shPostEffects, pTechName0, FEF_DONTSETSTATES);   
  gcpRendD3D->EF_SetState(GS_NODEPTHTEST);

  GetUtils().DrawFullScreenQuad(CTexture::s_ptexBackBuffer->GetWidth(), CTexture::s_ptexBackBuffer->GetHeight()); 
  GetUtils().ShEndPass(); 

  gcpRendD3D->FX_Flush();
  PROFILE_SHADER_END  

    PROFILE_LABEL_POP( "GODRAYS" );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

void CWaterDroplets::Render()
{
  gRenDev->m_cEF.mfRefreshSystemShader("PostEffectsGame", CShaderMan::m_shPostEffectsGame);

  static CCryNameTSCRC pTechName("WaterDroplets");
  GetUtils().ShBeginPass(CShaderMan::m_shPostEffectsGame, pTechName, FEF_DONTSETSTATES);   

  gcpRendD3D->EF_SetState(GS_NODEPTHTEST);   

  float fUserAmount = m_pAmount->GetParam();

  float fAtten = clamp_tpl<float>(fabs( gRenDev->GetRCamera().Orig.z - SPostEffectsUtils::m_fWaterLevel ), 0.0f, 1.0f);
  Vec4 vParams=Vec4(1, 1, 1, min(fUserAmount + (1.0f - clamp_tpl<float>(m_fCurrLifeTime, 0.0f, 1.0f)), 1.0f) * fAtten);    
  static CCryName pParamName("waterDropletsParams");
  CShaderMan::m_shPostEffectsGame->FXSetPSFloat(pParamName, &vParams, 1);

  GetUtils().DrawFullScreenQuad(CTexture::s_ptexBackBuffer->GetWidth(), CTexture::s_ptexBackBuffer->GetHeight());

  GetUtils().ShEndPass();   
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

void CWaterFlow::Render()
{
	gRenDev->m_cEF.mfRefreshSystemShader("PostEffectsGame", CShaderMan::m_shPostEffectsGame);

  float fAmount = m_pAmount->GetParam();

  static CCryNameTSCRC pTechName("WaterFlow");
  GetUtils().ShBeginPass(CShaderMan::m_shPostEffectsGame, pTechName, FEF_DONTSETSTATES);   

  gcpRendD3D->EF_SetState(GS_NODEPTHTEST);   

  Vec4 vParams=Vec4(1, 1, 1, fAmount);    
  static CCryName pParamName("waterFlowParams");
  CShaderMan::m_shPostEffectsGame->FXSetPSFloat(pParamName, &vParams, 1);

  GetUtils().DrawFullScreenQuad(CTexture::s_ptexBackBuffer->GetWidth(), CTexture::s_ptexBackBuffer->GetHeight());

  GetUtils().ShEndPass();   
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

void CWaterPuddles::Render()
{
  PROFILE_LABEL_PUSH( "WATER PUDDLES" );
	gRenDev->m_cEF.mfRefreshSystemShader("PostEffectsGame", CShaderMan::m_shPostEffectsGame);

  m_nCurrPuddleID++;
  m_nCurrPuddleID = m_nCurrPuddleID &1;
  CTexture *pPrevPuddle = CTexture::s_ptexWaterPuddles[m_nCurrPuddleID^1];
  CTexture *pCurrPuddle = CTexture::s_ptexWaterPuddles[m_nCurrPuddleID];

	CTexture::s_ptexWaterPuddlesDDN->SetRenderTargetTile(1);
	pCurrPuddle->SetRenderTargetTile(1);

  // Get current viewport
  int iTempX, iTempY, iWidth, iHeight;
  gcpRendD3D->GetViewport(&iTempX, &iTempY, &iWidth, &iHeight);

  float fCurrentTime = gEnv->pTimer->GetCurrTime();
  float fTimeDif = fCurrentTime - m_fLastSpawnTime;
  Vec4 vParams = Vec4(0.0f, 0.0f, 0.0f, 0.0f);    
  if( fTimeDif > 0.125f )
  {
    m_fLastSpawnTime = fCurrentTime;
    vParams=Vec4(GetUtils().randf(), GetUtils().randf(), GetUtils().randf(), 1);//GetUtils().randf()>0.25f);    
  }

  {
    // spawn particles into effects accumulation buffer
    gcpRendD3D->FX_PushRenderTarget(0, CTexture::s_ptexWaterPuddlesDDN, GetUtils().m_pCurDepthSurface); 
    gcpRendD3D->RT_SetViewport(0, 0, pCurrPuddle->GetWidth(), pCurrPuddle->GetHeight()); 

    ColorF clearColor(0, 0, 0, 0);
    //gcpRendD3D->EF_ClearBuffers(FRT_CLEAR_COLOR|FRT_CLEAR_IMMEDIATE, &clearColor);

    // compute wave propagation
    static CCryNameTSCRC pTechName("WaterPuddlesGen");
    GetUtils().ShBeginPass(CShaderMan::m_shPostEffects, pTechName, FEF_DONTSETSTATES|FEF_DONTSETTEXTURES);   
    gcpRendD3D->EF_SetState(GS_NODEPTHTEST);      

    static CCryName pParamName("waterPuddlesParams");
    CShaderMan::m_shPostEffectsGame->FXSetPSFloat(pParamName, &vParams, 1);

    GetUtils().SetTexture(pPrevPuddle, 0, FILTER_POINT, 0);   
    GetUtils().SetTexture(pCurrPuddle, 1, FILTER_POINT, 0);   
    GetUtils().DrawFullScreenQuad(pCurrPuddle->GetWidth(), pCurrPuddle->GetHeight());

    GetUtils().ShEndPass(); 

    //GetUtils().CopyScreenToTexture(pCurrPuddle);     

    gcpRendD3D->FX_PopRenderTarget(0);    

    // Update current puddle
    GetUtils().StretchRect(CTexture::s_ptexWaterPuddlesDDN, pCurrPuddle);     

    gcpRendD3D->RT_SetViewport(0, 0, iWidth, iHeight);        
  }

  // make final normal map
  gcpRendD3D->FX_PushRenderTarget(0, CTexture::s_ptexWaterPuddlesDDN, GetUtils().m_pCurDepthSurface); 
  gcpRendD3D->RT_SetViewport(0, 0, CTexture::s_ptexWaterPuddlesDDN->GetWidth(), CTexture::s_ptexWaterPuddlesDDN->GetHeight()); 

  static CCryNameTSCRC pTechName("WaterPuddlesDisplay");
  GetUtils().ShBeginPass(CShaderMan::m_shPostEffects, pTechName, FEF_DONTSETSTATES|FEF_DONTSETTEXTURES);   
  gcpRendD3D->EF_SetState(GS_NODEPTHTEST);   

  static CCryName pParamName("waterPuddlesParams");
  vParams.w = 256.0f;
  CShaderMan::m_shPostEffects->FXSetPSFloat(pParamName, &vParams, 1);

  GetUtils().SetTexture(pCurrPuddle, 0, FILTER_LINEAR, 0);   
  GetUtils().DrawFullScreenQuad(CTexture::s_ptexBackBuffer->GetWidth(), CTexture::s_ptexBackBuffer->GetHeight());

  GetUtils().ShEndPass(); 

  gcpRendD3D->FX_PopRenderTarget(0);    
  gcpRendD3D->RT_SetViewport(0, 0, iWidth, iHeight);      

  // disable processing
  m_pAmount->SetParam(0.0f);

	CTexture::s_ptexWaterPuddlesDDN->SetRenderTargetTile(0);
	pCurrPuddle->SetRenderTargetTile(0);

  PROFILE_LABEL_POP( "WATER PUDDLES" );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

namespace WaterVolumeStaticData
{
	CWater *pWaterSim = 0;
	void GetMemoryUsage( ICrySizer *pSizer )
	{
		if( pWaterSim )
			pWaterSim->GetMemoryUsage(pSizer);
	}
}

void CWaterVolume::Render()
{
	gRenDev->m_cEF.mfRefreshSystemShader("PostEffectsGame", CShaderMan::m_shPostEffectsGame);

  {
    static int nFrameID = 0;
    static bool bInitialize = true;
    static CWater pWaterSim;

		// remember ptr of WaterSim to access it with CrySizer
		WaterVolumeStaticData::pWaterSim = &pWaterSim;

    const int nGridSize = 64;

    int nCurFrameID = gRenDev->m_RP.m_TI[gRenDev->m_RP.m_nProcessThreadID].m_nFrameID;
    if( nFrameID != nCurFrameID )
    {
      static Vec4 pParams0(0, 0, 0, 0), pParams1(0, 0, 0, 0);
      Vec4 pCurrParams0, pCurrParams1;
      gEnv->p3DEngine->GetOceanAnimationParams(pCurrParams0, pCurrParams1);

      // Update sim settings
      if( bInitialize || pCurrParams0.x != pParams0.x || pCurrParams0.y != pParams0.y ||
        pCurrParams0.z != pParams0.z || pCurrParams0.w != pParams0.w || pCurrParams1.x != pParams1.x || 
        pCurrParams1.y != pParams1.y || pCurrParams1.z != pParams1.z || pCurrParams1.w != pParams1.w )
      {
        pParams0 = pCurrParams0;
        pParams1 = pCurrParams1;
        pWaterSim.Create( 1.0, pParams0.x, pParams0.z, 1.0f, 1.0f);
        bInitialize = false;
      }

      // Create texture if required
      if (!CTexture::IsTextureExist(CTexture::s_ptexWaterVolumeTemp))
      {
        if(!CTexture::s_ptexWaterVolumeTemp->Create2DTexture(64, 64, 1, 
          FT_DONT_RELEASE | FT_NOMIPS |  FT_USAGE_DYNAMIC, 
          0, eTF_A32B32G32R32F, eTF_A32B32G32R32F))
					return;
        CTexture::s_ptexWaterVolumeTemp->Fill(ColorF(0, 0, 0, 0));
      }

			CTexture *pTexture = CTexture::s_ptexWaterVolumeTemp;

      // Copy data..
      if (CTexture::IsTextureExist(pTexture))
      {
				const float fUpdateTime = 2.f*0.125f*gEnv->pTimer->GetCurrTime();
#if defined(USE_SPU)
				if(InvokeJobOnSPU("WaterUpdate"))
				{
					void* pRawPtr = ((CCryDXPSTexture2D*)pTexture->GetDevTexture()->Get2DTexture())->RawPointer();
					TPostWaterJob job( nCurFrameID, fUpdateTime, true, pRawPtr );
					job.SetClassInstance(pWaterSim);
//					job.RegisterJobState(&g_JobState);
					job.SetCacheMode(NPPU::eCM_32);
					job.Run();
				}
				else
				{
#endif
        pWaterSim.Update( nCurFrameID, fUpdateTime, true );

        Vec4 *pDispGrid = pWaterSim.GetDisplaceGrid();

        uint32 pitch = 4 * sizeof( float )*nGridSize; 
        uint32 width = nGridSize; 
        uint32 height = nGridSize;

#if defined (XENON)
        CDeviceTexture* pDevTex = pTexture->GetDevTexture();
        assert(pDevTex);
				// todo: write directly to texture address from water update thread

				// Note: We can skip texture locking on consoles and write directly to memory (might be out of sync sometimes, but on this case is mostly a noise texture)
				DWORD dwBaseAddress = pDevTex->Get2DTexture()->Format.BaseAddress << GPU_TEXTURE_ADDRESS_SHIFT;
				uint32 nFlags = 0;
				if(FALSE == XGIsPackedTexture(pDevTex->Get2DTexture()))
					nFlags |= XGTILE_NONPACKED;
				if(TRUE  == XGIsBorderTexture(pDevTex->Get2DTexture()))
					nFlags |= XGTILE_BORDER;
				XGTileTextureLevel(width, height, 0, XGGetGpuFormat(D3DFMT_A32B32G32R32F), nFlags, (void*)dwBaseAddress, 0, pDispGrid, sizeof(f32) * width * 4, 0);

#else

        STALL_PROFILER("update subresource")

        CDeviceTexture* pDevTex = pTexture->GetDevTexture();
        assert(pDevTex);
        STexLock rect;
        if (SUCCEEDED(pDevTex->LockRect(0, rect, LF_DISCARD))) //
        {
          cryMemcpy(rect.pData, pDispGrid, 4 * width * height* sizeof(f32) );
          pDevTex->UnlockRect(0);
        }
#endif
#if defined(USE_SPU)
				}
#endif
      }
      nFrameID = nCurFrameID;
    }
  }
  // Get current viewport
  int iTempX, iTempY, iWidth, iHeight;
  gcpRendD3D->GetViewport(&iTempX, &iTempY, &iWidth, &iHeight);

#ifdef XENON
	CTexture::s_ptexWaterVolumeDDN->SetRenderTargetTile(1);
#endif

  // make final normal map
  gcpRendD3D->FX_PushRenderTarget(0, CTexture::s_ptexWaterVolumeDDN, GetUtils().m_pCurDepthSurface); 
  gcpRendD3D->RT_SetViewport(0, 0, CTexture::s_ptexWaterVolumeDDN->GetWidth(), CTexture::s_ptexWaterVolumeDDN->GetHeight()); 

  static CCryNameTSCRC pTechName("WaterVolumesNormalGen");
  GetUtils().ShBeginPass(CShaderMan::m_shPostEffectsGame, pTechName, FEF_DONTSETSTATES|FEF_DONTSETTEXTURES);   
  gcpRendD3D->EF_SetState(GS_NODEPTHTEST);   

  static CCryName pParamName("waterVolumesParams");
  Vec4 vParams = Vec4(64.0f, 64.0f, 64.0f, 64.0f);    
  CShaderMan::m_shPostEffectsGame->FXSetPSFloat(pParamName, &vParams, 1);

  int32 nFilter = FILTER_LINEAR;
#if defined(XENON) || defined(PS3)
  nFilter = FILTER_POINT;
#endif
  
  GetUtils().SetTexture(CTexture::s_ptexWaterVolumeTemp, 0, nFilter, 0);   
  GetUtils().DrawFullScreenQuad(CTexture::s_ptexBackBuffer->GetWidth(), CTexture::s_ptexBackBuffer->GetHeight());

  GetUtils().ShEndPass(); 

  gcpRendD3D->FX_PopRenderTarget(0);    
  gcpRendD3D->RT_SetViewport(0, 0, iWidth, iHeight);      

#ifdef XENON
  	CTexture::s_ptexWaterVolumeDDN->SetRenderTargetTile(0);
#endif

	// HACK (re-set back-buffer): due to lazy RT updates/setting there's strong possibility we run into problems on x360 when we try to resolve from edram with no RT set
	gcpRendD3D->FX_SetActiveRenderTargets();

  // disable processing
  m_pAmount->SetParam(0.0f);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

void CWaterRipples::Render()
{

  // for this frame, fetch all water volumes hits

  // render each hit in screen space

  // 1st test, we need 1 heightmap texture with following channel mapping:
  //		R= camera pos (current frame), G= camera pos( previous frame)
  //		B= next camera pos (current frame), A= next camera pos( previous frame)

  // after heightmap processed, we need to compute normal and store it in another texture
  // if only one camera position used, we could store normal in heigh.ba channels

}