/*=============================================================================
Copyright (c) 2010 Crytek Studios. All Rights Reserved.

Revision history:
* Created by Francesco Carucci

=============================================================================*/

#include "StdAfx.h"
#include "PerfCounters.h"

#ifdef XENON

//=============================================================================

void CPerfCounters::Enable(LPDIRECT3DDEVICE9 device)
{
#ifdef ENABLE_FRAME_PROFILER
	device->EnablePerfCounters(TRUE);
	SetGeneralEvents(device);
#endif
}

void CPerfCounters::Disable(LPDIRECT3DDEVICE9 device)
{
#ifdef ENABLE_FRAME_PROFILER
	device->EnablePerfCounters(FALSE);
	SetGeneralEvents(device);
#endif
}


CPerfCounters::CPerfCounters(LPDIRECT3DDEVICE9 device) 
	: m_device(device)
	, m_GPUCycles(0)
{
#ifdef ENABLE_FRAME_PROFILER
	m_device->CreatePerfCounters(&m_perfCountersStart, 1);
	m_device->CreatePerfCounters(&m_perfCountersStop, 1);
#endif
//	m_device->CreatePerfCounters(&m_perfPixelCountersStart, 1);
//	m_device->CreatePerfCounters(&m_perfPixelCountersStop, 1);

	Clear();
}

void CPerfCounters::Clear()
{
	m_GPUCycles = 0;
	m_VertexVectorsSubmitted = 0;
	m_PixelVectorsSubmitted = 0;
	m_VertexShaderCycles = 0;
	m_PixelShaderCycles = 0;
	m_vertexCacheHitRatio = 0.0f;
	m_textureCacheHitRatio = 0.0f;
}

void CPerfCounters::Start()
{
#ifdef ENABLE_FRAME_PROFILER
	m_device->QueryPerfCounters(m_perfCountersStart, 0);
#endif
}

void CPerfCounters::Stop()
{
#ifdef ENABLE_FRAME_PROFILER
	m_device->QueryPerfCounters(m_perfCountersStop, 0);
	GetValues();
#endif
}

void CPerfCounters::GetValues()
{
#ifdef ENABLE_FRAME_PROFILER
	D3DPERFCOUNTER_VALUES start;
	m_perfCountersStart->GetValues(&start, 0, 0);
	D3DPERFCOUNTER_VALUES stop;
	m_perfCountersStop->GetValues(&stop, 0, 0);

	D3DPERFCOUNTER_VALUES results;

	// Subtract start values from end values.
	UINT64* startValues = ( UINT64* )&start;
	UINT64* endValues = ( UINT64* )&stop;
	UINT64* resultValues = ( UINT64* )&results;

	const DWORD dwCount = sizeof( D3DPERFCOUNTER_VALUES ) / sizeof( UINT64 );

	for( DWORD i = 0; i < dwCount; ++i )
	{
		resultValues[i] = endValues[i] - startValues[i];
	}

	m_GPUCycles = results.RBBM[1].QuadPart;

	float vertexCacheHits = (float) results.VC[0].QuadPart;
	float vertexCacheMisses = (float) results.VC[1].QuadPart;

	if (vertexCacheHits + vertexCacheMisses > 0.0f)
		m_vertexCacheHitRatio = vertexCacheHits / (vertexCacheHits + vertexCacheMisses);

	float textureCacheHits = (float) results.TCF[0].QuadPart;
	float textureCacheMisses = (float) results.TCF[1].QuadPart;

	if (textureCacheHits + textureCacheMisses > 0.0f)
		m_textureCacheHitRatio = textureCacheHits / (textureCacheHits + vertexCacheMisses);
#endif
}

void CPerfCounters::SetGeneralEvents( LPDIRECT3DDEVICE9 device )
{
#ifdef ENABLE_FRAME_PROFILER
	D3DPERFCOUNTER_EVENTS perfEvents;
	ZeroMemory( &perfEvents, sizeof( D3DPERFCOUNTER_EVENTS ) );
	// CP clock cycles.
	perfEvents.CP[0] = GPUPE_CP_COUNT;
	// NRT busy cycles.
	perfEvents.RBBM[0] = GPUPE_RBBM_COUNT;
	perfEvents.RBBM[1] = GPUPE_RBBM_NRT_BUSY;
	// Texture and vertex cache reads from system memory.
	perfEvents.MH[0] = GPUPE_TC0_READ;
	perfEvents.MH[1] = GPUPE_TC1_READ;
	perfEvents.MH[2] = GPUPE_VC0_READ_MEMORY;

	// Vertex and Pixel shaders vectors
	//	perfEvents.SQ[0] = GPUPE_SQ_VERTEX_VECTORS_SUB;
	//	perfEvents.SQ[1] = GPUPE_SQ_PIXEL_VECTORS_SUB;

//	perfEvents.SQ[0] = GPUPE_SQ_ALU0_ACTIVE_VTX_SIMD0;
//	perfEvents.SQ[1] = GPUPE_SQ_ALU1_ACTIVE_VTX_SIMD0;
//	perfEvents.SQ[2] = GPUPE_SQ_ALU0_ACTIVE_VTX_SIMD1;
//	perfEvents.SQ[3] = GPUPE_SQ_ALU1_ACTIVE_VTX_SIMD1;

	/*
	perfEvents.SQ[2] = GPUPE_SQ_ALU0_ACTIVE_VTX_SIMD0;
	perfEvents.SQ[3] = GPUPE_SQ_ALU1_ACTIVE_VTX_SIMD0;
	perfEvents.SQ[4] = GPUPE_SQ_ALU0_ACTIVE_PIX_SIMD0;
	perfEvents.SQ[5] = GPUPE_SQ_ALU1_ACTIVE_PIX_SIMD0;
	perfEvents.SQ[6] = GPUPE_SQ_ALU0_ACTIVE_VTX_SIMD1;
	perfEvents.SQ[7] = GPUPE_SQ_ALU1_ACTIVE_VTX_SIMD1;
	perfEvents.SQ[8] = GPUPE_SQ_ALU0_ACTIVE_PIX_SIMD1;
	perfEvents.SQ[9] = GPUPE_SQ_ALU1_ACTIVE_PIX_SIMD1;
	*/

	// Vertex cache performance.
	perfEvents.VC[0] = GPUPE_CC_HITS;
	perfEvents.VC[1] = GPUPE_CC_MISSES;
	// Texture cache performance.
	perfEvents.TCF[0] = GPUPE_TAG_HITS;
	perfEvents.TCF[1] = GPUPE_TAG_MISSES;
	// SQ stuff.
	//	perfEvents.SQ[0] = GPUPE_SQ_CONSTANTS_SENT_SP_SIMD0;
	//	perfEvents.SQ[1] = GPUPE_SQ_CONSTANTS_USED_SIMD0;
	device->SetPerfCounterEvents( &perfEvents, 0 );
#endif
}

#endif
