/*=============================================================================
Copyright (c) 2010 Crytek Studios. All Rights Reserved.

Revision history:
* Created by Francesco Carucci

=============================================================================*/

#pragma once 

#ifndef PERF_COUNTERS_H
#define PERF_COUNTERS_H

#ifdef XENON

struct IRenderer;

//=============================================================================

class CPerfCounters
{
public:
	static void Enable(LPDIRECT3DDEVICE9 device);
	static void Disable(LPDIRECT3DDEVICE9 device);

	static float ConvertToMilliseconds(ULONGLONG cycles) { return cycles / (500.0f * 1000.0f); }
	static ULONGLONG ConvertToCycles(float milliseconds) { return (ULONGLONG) (milliseconds * (500.0f * 1000.0f)); }

	CPerfCounters(LPDIRECT3DDEVICE9 device);

	void Clear();

	void Start();
	void Stop();
	void GetValues();

	ULONGLONG GetGPUCycles() const { return m_GPUCycles; }

	float GetVertexCacheHitRatio() const { return m_vertexCacheHitRatio; }
	float GetTextureCacheHitRatio() const { return m_textureCacheHitRatio; }

//	ULONGLONG GetVertexShaderCycles() const { return m_VertexVectorsSubmitted; }
//	ULONGLONG GetPixelShaderCycles() const { return m_PixelVectorsSubmitted; }

	LPDIRECT3DDEVICE9 GetDevice() const { return m_device; }

private:
	LPDIRECT3DDEVICE9 m_device;

	IDirect3DPerfCounters9* m_perfCountersStart;
	IDirect3DPerfCounters9* m_perfCountersStop;

	IDirect3DPerfCounters9* m_perfPixelCountersStart;
	IDirect3DPerfCounters9* m_perfPixelCountersStop;

	ULONGLONG m_GPUCycles;
	ULONGLONG m_VertexVectorsSubmitted;
	ULONGLONG m_PixelVectorsSubmitted;
	ULONGLONG m_VertexShaderCycles;
	ULONGLONG m_PixelShaderCycles;

	float m_vertexCacheHitRatio;
	float m_textureCacheHitRatio;

	static void SetGeneralEvents(LPDIRECT3DDEVICE9 device);
};


#else

typedef LPDIRECT3DDEVICE9 DEVICE_PTR;

#if defined(PS3) // PS3 doesn't define ULONGLONG
typedef uint64 ULONGLONG;
#endif

class CPerfCounters
{
public:
	static void Enable(LPDIRECT3DDEVICE9 device) {}
	static void Disable(LPDIRECT3DDEVICE9 device) {}
	static float ConvertToMilliseconds(ULONGLONG cycles) { return cycles / (500.0f * 1000.0f); }
	static ULONGLONG ConvertToCycles(float milliseconds) { return (ULONGLONG) (milliseconds * (500.0f * 1000.0f)); }

	CPerfCounters(LPDIRECT3DDEVICE9 device) {}

	void Clear() {}

	void Start() {}
	void Stop() {}
	void GetValues() {}

	ULONGLONG GetGPUCycles() const { return 0; }

	float GetVertexCacheHitRatio() const { return 0.0f; }
	float GetTextureCacheHitRatio() const { return 0.0f; }

	DEVICE_PTR GetDevice() const { return 0; }
};

#endif

#endif